<?php
/**
 * @package ACF
 * @author  WP Engine
 *
 * © 2026 Advanced Custom Fields (ACF®). All rights reserved.
 * "ACF" is a trademark of WP Engine.
 * Licensed under the GNU General Public License v2 or later.
 * https://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Generated schema.org type and property data
 *
 * This file is auto-generated by tools/generate-schema.js
 * DO NOT EDIT MANUALLY - Run 'npm run generate-schema' to regenerate
 *
 * Generated: 2026-01-06
 * Source: https://schema.org/version/latest/schemaorg-current-https.jsonld
 *
 * @package ACF\AI\GEO
 */

namespace ACF\AI\GEO;

/**
 * Class SchemaData
 *
 * Contains static schema.org vocabulary data for type and property validation.
 */
class SchemaData {

	/**
	 * Type hierarchy mapping
	 *
	 * Maps each type to its parent type in the schema.org hierarchy.
	 * For example: 'Recipe' => 'HowTo'
	 *
	 * @var array
	 */
	public static $type_hierarchy = array(
		'Conversation'                          => 'CreativeWork',
		'TheaterEvent'                          => 'Event',
		'WatchAction'                           => 'ConsumeAction',
		'AnalysisNewsArticle'                   => 'NewsArticle',
		'Room'                                  => 'Accommodation',
		'WearableSizeGroupEnumeration'          => 'SizeGroupEnumeration',
		'FoodEstablishment'                     => 'LocalBusiness',
		'CriticReview'                          => 'Review',
		'CompleteDataFeed'                      => 'DataFeed',
		'JewelryStore'                          => 'Store',
		'IPTCDigitalSourceEnumeration'          => 'MediaEnumeration',
		'LeaveAction'                           => 'InteractAction',
		'BoatReservation'                       => 'Reservation',
		'WholesaleStore'                        => 'Store',
		'MedicalRiskFactor'                     => 'MedicalEntity',
		'Continent'                             => 'Landform',
		'VideoObjectSnapshot'                   => 'VideoObject',
		'MusicRecording'                        => 'CreativeWork',
		'3DModel'                               => 'MediaObject',
		'SchoolDistrict'                        => 'AdministrativeArea',
		'AggregateOffer'                        => 'Offer',
		'Distillery'                            => 'FoodEstablishment',
		'BroadcastFrequencySpecification'       => 'Intangible',
		'Manuscript'                            => 'CreativeWork',
		'GovernmentPermit'                      => 'Permit',
		'GolfCourse'                            => 'SportsActivityLocation',
		'EmploymentAgency'                      => 'LocalBusiness',
		'UserTweets'                            => 'UserInteraction',
		'QAPage'                                => 'WebPage',
		'ParkingFacility'                       => 'CivicStructure',
		'CampingPitch'                          => 'Accommodation',
		'MapCategoryType'                       => 'Enumeration',
		'TextObject'                            => 'MediaObject',
		'Map'                                   => 'CreativeWork',
		'SiteNavigationElement'                 => 'WebPageElement',
		'OnlineStore'                           => 'OnlineBusiness',
		'AssignAction'                          => 'AllocateAction',
		'FastFoodRestaurant'                    => 'FoodEstablishment',
		'QuantitativeValueDistribution'         => 'StructuredValue',
		'NGO'                                   => 'Organization',
		'RealEstateListing'                     => 'WebPage',
		'DigitalDocumentPermission'             => 'Intangible',
		'SomeProducts'                          => 'Product',
		'DiscoverAction'                        => 'FindAction',
		'ScholarlyArticle'                      => 'Article',
		'TaxiReservation'                       => 'Reservation',
		'Event'                                 => 'Thing',
		'RuntimePlatform'                       => 'SoftwareApplication',
		'AdministrativeArea'                    => 'Place',
		'Permit'                                => 'Intangible',
		'TattooParlor'                          => 'HealthAndBeautyBusiness',
		'PlayAction'                            => 'Action',
		'Protein'                               => 'BioChemEntity',
		'MotorizedBicycle'                      => 'Vehicle',
		'MedicalIndication'                     => 'MedicalEntity',
		'BusinessAudience'                      => 'Audience',
		'Guide'                                 => 'CreativeWork',
		'TheaterGroup'                          => 'PerformingGroup',
		'Playground'                            => 'CivicStructure',
		'Apartment'                             => 'Accommodation',
		'CheckAction'                           => 'FindAction',
		'Quotation'                             => 'CreativeWork',
		'Taxon'                                 => 'Thing',
		'AchieveAction'                         => 'Action',
		'ShortStory'                            => 'CreativeWork',
		'WPHeader'                              => 'WebPageElement',
		'MedicalSignOrSymptom'                  => 'MedicalCondition',
		'Audience'                              => 'Intangible',
		'MusicRelease'                          => 'MusicPlaylist',
		'Episode'                               => 'CreativeWork',
		'PhysiciansOffice'                      => 'Physician',
		'AutoRepair'                            => 'AutomotiveBusiness',
		'GardenStore'                           => 'Store',
		'SocialMediaPosting'                    => 'Article',
		'TVClip'                                => 'Clip',
		'MediaReviewItem'                       => 'CreativeWork',
		'ResetPasswordAction'                   => 'ControlAction',
		'PlanAction'                            => 'OrganizeAction',
		'Place'                                 => 'Thing',
		'BedDetails'                            => 'Intangible',
		'MediaGallery'                          => 'CollectionPage',
		'Demand'                                => 'Intangible',
		'MedicalConditionStage'                 => 'MedicalIntangible',
		'PublicationVolume'                     => 'CreativeWork',
		'ImageObjectSnapshot'                   => 'ImageObject',
		'GovernmentOrganization'                => 'Organization',
		'Person'                                => 'Thing',
		'PeopleAudience'                        => 'Audience',
		'Integer'                               => 'Number',
		'PerformanceRole'                       => 'Role',
		'SoftwareApplication'                   => 'CreativeWork',
		'MenuSection'                           => 'CreativeWork',
		'Occupation'                            => 'Intangible',
		'FurnitureStore'                        => 'Store',
		'ReserveAction'                         => 'PlanAction',
		'MedicalAudienceType'                   => 'MedicalEnumeration',
		'DrugClass'                             => 'MedicalEntity',
		'WebPage'                               => 'CreativeWork',
		'MedicalObservationalStudy'             => 'MedicalStudy',
		'BusTrip'                               => 'Trip',
		'MerchantReturnEnumeration'             => 'Enumeration',
		'Organization'                          => 'Thing',
		'InfectiousDisease'                     => 'MedicalCondition',
		'Product'                               => 'Thing',
		'ContactPointOption'                    => 'Enumeration',
		'RentAction'                            => 'TradeAction',
		'TouristDestination'                    => 'Place',
		'PreventionIndication'                  => 'MedicalIndication',
		'AppendAction'                          => 'InsertAction',
		'BookStore'                             => 'Store',
		'BloodTest'                             => 'MedicalTest',
		'PhysicalActivity'                      => 'LifestyleModification',
		'SuperficialAnatomy'                    => 'MedicalEntity',
		'Comment'                               => 'CreativeWork',
		'GeoShape'                              => 'StructuredValue',
		'GeoCoordinates'                        => 'StructuredValue',
		'Hackathon'                             => 'Event',
		'Winery'                                => 'FoodEstablishment',
		'PaymentMethodType'                     => 'Enumeration',
		'MedicalStudy'                          => 'MedicalEntity',
		'Photograph'                            => 'CreativeWork',
		'FoodEstablishmentReservation'          => 'Reservation',
		'Language'                              => 'Intangible',
		'FundingScheme'                         => 'Organization',
		'Artery'                                => 'Vessel',
		'FundingAgency'                         => 'Project',
		'MusicComposition'                      => 'CreativeWork',
		'InvestmentOrDeposit'                   => 'FinancialProduct',
		'PriceSpecification'                    => 'StructuredValue',
		'PublicSwimmingPool'                    => 'SportsActivityLocation',
		'GameServerStatus'                      => 'StatusEnumeration',
		'CollegeOrUniversity'                   => 'EducationalOrganization',
		'ItemListOrderType'                     => 'Enumeration',
		'Corporation'                           => 'Organization',
		'OfferForPurchase'                      => 'Offer',
		'LegalValueLevel'                       => 'Enumeration',
		'DrugStrength'                          => 'MedicalIntangible',
		'MedicalTestPanel'                      => 'MedicalTest',
		'OpeningHoursSpecification'             => 'StructuredValue',
		'BuddhistTemple'                        => 'PlaceOfWorship',
		'BedAndBreakfast'                       => 'LodgingBusiness',
		'DrugLegalStatus'                       => 'MedicalIntangible',
		'SeekToAction'                          => 'Action',
		'FloorPlan'                             => 'Intangible',
		'SizeSpecification'                     => 'QualitativeValue',
		'Courthouse'                            => 'GovernmentBuilding',
		'VirtualLocation'                       => 'Intangible',
		'RadioSeries'                           => 'CreativeWorkSeries',
		'PaintAction'                           => 'CreateAction',
		'DrugCost'                              => 'MedicalEntity',
		'MediaObject'                           => 'CreativeWork',
		'Painting'                              => 'CreativeWork',
		'MedicineSystem'                        => 'MedicalEnumeration',
		'ReplaceAction'                         => 'UpdateAction',
		'HealthPlanNetwork'                     => 'Intangible',
		'City'                                  => 'AdministrativeArea',
		'ApplyAction'                           => 'OrganizeAction',
		'SpreadsheetDigitalDocument'            => 'DigitalDocument',
		'SportsOrganization'                    => 'Organization',
		'MoneyTransfer'                         => 'TransferAction',
		'Car'                                   => 'Vehicle',
		'MedicalIntangible'                     => 'MedicalEntity',
		'DryCleaningOrLaundry'                  => 'LocalBusiness',
		'AuthenticateAction'                    => 'ControlAction',
		'ControlAction'                         => 'Action',
		'Recipe'                                => 'HowTo',
		'BookmarkAction'                        => 'OrganizeAction',
		'InsuranceAgency'                       => 'FinancialService',
		'TakeAction'                            => 'TransferAction',
		'SubwayStation'                         => 'CivicStructure',
		'PoliticalParty'                        => 'Organization',
		'RadioClip'                             => 'Clip',
		'TouristInformationCenter'              => 'LocalBusiness',
		'SeaBodyOfWater'                        => 'BodyOfWater',
		'Service'                               => 'Intangible',
		'OnlineBusiness'                        => 'Organization',
		'CivicStructure'                        => 'Place',
		'Duration'                              => 'Quantity',
		'Grant'                                 => 'Intangible',
		'LegalForceStatus'                      => 'StatusEnumeration',
		'HealthPlanFormulary'                   => 'Intangible',
		'SportsTeam'                            => 'SportsOrganization',
		'PlayGameAction'                        => 'ConsumeAction',
		'ShippingDeliveryTime'                  => 'StructuredValue',
		'ContactPage'                           => 'WebPage',
		'DanceGroup'                            => 'PerformingGroup',
		'Sculpture'                             => 'CreativeWork',
		'RecyclingCenter'                       => 'LocalBusiness',
		'SuspendAction'                         => 'ControlAction',
		'MediaSubscription'                     => 'Intangible',
		'NutritionInformation'                  => 'StructuredValue',
		'SportsActivityLocation'                => 'LocalBusiness',
		'Intangible'                            => 'Thing',
		'MedicalStudyStatus'                    => 'MedicalEnumeration',
		'Resort'                                => 'LodgingBusiness',
		'NLNonprofitType'                       => 'NonprofitType',
		'Atlas'                                 => 'CreativeWork',
		'SportsClub'                            => 'SportsActivityLocation',
		'MediaEnumeration'                      => 'Enumeration',
		'PriceTypeEnumeration'                  => 'Enumeration',
		'ReturnFeesEnumeration'                 => 'Enumeration',
		'UnitPriceSpecification'                => 'PriceSpecification',
		'RadioSeason'                           => 'CreativeWorkSeason',
		'ReturnAction'                          => 'TransferAction',
		'HealthAndBeautyBusiness'               => 'LocalBusiness',
		'OfferShippingDetails'                  => 'StructuredValue',
		'PresentationDigitalDocument'           => 'DigitalDocument',
		'Drawing'                               => 'CreativeWork',
		'BefriendAction'                        => 'InteractAction',
		'AgreeAction'                           => 'ReactAction',
		'RoofingContractor'                     => 'HomeAndConstructionBusiness',
		'OceanBodyOfWater'                      => 'BodyOfWater',
		'RiverBodyOfWater'                      => 'BodyOfWater',
		'MedicalScholarlyArticle'               => 'ScholarlyArticle',
		'ConfirmAction'                         => 'InformAction',
		'GasStation'                            => 'AutomotiveBusiness',
		'WantAction'                            => 'ReactAction',
		'WPSideBar'                             => 'WebPageElement',
		'Library'                               => 'LocalBusiness',
		'TrainStation'                          => 'CivicStructure',
		'PerformAction'                         => 'PlayAction',
		'Class'                                 => 'Intangible',
		'AboutPage'                             => 'WebPage',
		'MathSolver'                            => 'CreativeWork',
		'EndorseAction'                         => 'ReactAction',
		'PrependAction'                         => 'InsertAction',
		'FilmAction'                            => 'CreateAction',
		'SolveMathAction'                       => 'Action',
		'EducationEvent'                        => 'Event',
		'ArriveAction'                          => 'MoveAction',
		'EmployeeRole'                          => 'OrganizationRole',
		'ExchangeRateSpecification'             => 'StructuredValue',
		'BusStop'                               => 'CivicStructure',
		'SoftwareSourceCode'                    => 'CreativeWork',
		'EmployerAggregateRating'               => 'AggregateRating',
		'EducationalOccupationalProgram'        => 'Intangible',
		'IncentiveQualifiedExpenseType'         => 'Enumeration',
		'Seat'                                  => 'Intangible',
		'LocationFeatureSpecification'          => 'PropertyValue',
		'AnimalShelter'                         => 'LocalBusiness',
		'MerchantReturnPolicySeasonalOverride'  => 'Intangible',
		'UserComments'                          => 'UserInteraction',
		'Volcano'                               => 'Landform',
		'InteractAction'                        => 'Action',
		'LearningResource'                      => 'CreativeWork',
		'Book'                                  => 'CreativeWork',
		'BuyAction'                             => 'TradeAction',
		'PriceComponentTypeEnumeration'         => 'Enumeration',
		'ShippingConditions'                    => 'StructuredValue',
		'HealthInsurancePlan'                   => 'Intangible',
		'BroadcastEvent'                        => 'PublicationEvent',
		'LoginAction'                           => 'ControlAction',
		'QuantitativeValue'                     => 'StructuredValue',
		'ReportedDoseSchedule'                  => 'DoseSchedule',
		'WPFooter'                              => 'WebPageElement',
		'CancelAction'                          => 'PlanAction',
		'CatholicChurch'                        => 'Church',
		'LoanOrCredit'                          => 'FinancialProduct',
		'PaymentStatusType'                     => 'StatusEnumeration',
		'OnDemandEvent'                         => 'PublicationEvent',
		'SearchRescueOrganization'              => 'Organization',
		'EntertainmentBusiness'                 => 'LocalBusiness',
		'MenuItem'                              => 'Intangible',
		'TireShop'                              => 'Store',
		'ExerciseAction'                        => 'PlayAction',
		'MonetaryGrant'                         => 'Grant',
		'BrokerageAccount'                      => 'InvestmentOrDeposit',
		'BowlingAlley'                          => 'SportsActivityLocation',
		'EventVenue'                            => 'CivicStructure',
		'DiagnosticProcedure'                   => 'MedicalProcedure',
		'HealthPlanCostSharingSpecification'    => 'Intangible',
		'TravelAction'                          => 'MoveAction',
		'MedicalObservationalStudyDesign'       => 'MedicalEnumeration',
		'ReservationStatusType'                 => 'StatusEnumeration',
		'Taxi'                                  => 'Service',
		'Airport'                               => 'CivicStructure',
		'DeactivateAction'                      => 'ControlAction',
		'CookAction'                            => 'CreateAction',
		'MovieSeries'                           => 'CreativeWorkSeries',
		'ClothingStore'                         => 'Store',
		'FMRadioChannel'                        => 'RadioChannel',
		'ChemicalSubstance'                     => 'BioChemEntity',
		'USNonprofitType'                       => 'NonprofitType',
		'ComicIssue'                            => 'PublicationIssue',
		'Reservoir'                             => 'BodyOfWater',
		'CategoryCode'                          => 'DefinedTerm',
		'TextDigitalDocument'                   => 'DigitalDocument',
		'GenderType'                            => 'Enumeration',
		'APIReference'                          => 'TechArticle',
		'AutoBodyShop'                          => 'AutomotiveBusiness',
		'EnergyStarEnergyEfficiencyEnumeration' => 'EnergyEfficiencyEnumeration',
		'Quiz'                                  => 'LearningResource',
		'Embassy'                               => 'GovernmentBuilding',
		'Vein'                                  => 'Vessel',
		'RadioEpisode'                          => 'Episode',
		'ProfilePage'                           => 'WebPage',
		'Legislation'                           => 'CreativeWork',
		'VacationRental'                        => 'LodgingBusiness',
		'HotelRoom'                             => 'Room',
		'AcceptAction'                          => 'AllocateAction',
		'DeliveryEvent'                         => 'Event',
		'ListItem'                              => 'Intangible',
		'Joint'                                 => 'AnatomicalStructure',
		'DeleteAction'                          => 'UpdateAction',
		'ActionStatusType'                      => 'StatusEnumeration',
		'ConferenceEvent'                       => 'Event',
		'ConvenienceStore'                      => 'Store',
		'Flight'                                => 'Trip',
		'ScreeningEvent'                        => 'Event',
		'Game'                                  => 'CreativeWork',
		'ScheduleAction'                        => 'PlanAction',
		'MiddleSchool'                          => 'EducationalOrganization',
		'MedicalImagingTechnique'               => 'MedicalEnumeration',
		'ReadAction'                            => 'ConsumeAction',
		'CurrencyConversionService'             => 'FinancialProduct',
		'DrawAction'                            => 'CreateAction',
		'MensClothingStore'                     => 'Store',
		'ShareAction'                           => 'CommunicateAction',
		'MedicalSign'                           => 'MedicalSignOrSymptom',
		'Cemetery'                              => 'CivicStructure',
		'LakeBodyOfWater'                       => 'BodyOfWater',
		'Locksmith'                             => 'HomeAndConstructionBusiness',
		'CollectionPage'                        => 'WebPage',
		'ServicePeriod'                         => 'StructuredValue',
		'OrderAction'                           => 'TradeAction',
		'ComedyEvent'                           => 'Event',
		'CoverArt'                              => 'VisualArtwork',
		'Chapter'                               => 'CreativeWork',
		'PerformingArtsEvent'                   => 'Event',
		'RsvpResponseType'                      => 'Enumeration',
		'EndorsementRating'                     => 'Rating',
		'LifestyleModification'                 => 'MedicalEntity',
		'NonprofitType'                         => 'Enumeration',
		'MedicalWebPage'                        => 'WebPage',
		'OfferItemCondition'                    => 'Enumeration',
		'PostalCodeRangeSpecification'          => 'StructuredValue',
		'HowTo'                                 => 'CreativeWork',
		'TaxiService'                           => 'Service',
		'SocialEvent'                           => 'Event',
		'BusinessEvent'                         => 'Event',
		'DiagnosticLab'                         => 'MedicalOrganization',
		'BedType'                               => 'QualitativeValue',
		'GiveAction'                            => 'TransferAction',
		'EnergyEfficiencyEnumeration'           => 'Enumeration',
		'TreatmentIndication'                   => 'MedicalIndication',
		'AmusementPark'                         => 'EntertainmentBusiness',
		'DeliveryChargeSpecification'           => 'PriceSpecification',
		'ListenAction'                          => 'ConsumeAction',
		'TravelAgency'                          => 'LocalBusiness',
		'BoatTerminal'                          => 'CivicStructure',
		'BookSeries'                            => 'CreativeWorkSeries',
		'MovingCompany'                         => 'HomeAndConstructionBusiness',
		'ComputerStore'                         => 'Store',
		'EnergyConsumptionDetails'              => 'Intangible',
		'HyperToc'                              => 'CreativeWork',
		'ComicStory'                            => 'CreativeWork',
		'LiveBlogPosting'                       => 'BlogPosting',
		'MedicalEntity'                         => 'Thing',
		'Table'                                 => 'WebPageElement',
		'SingleFamilyResidence'                 => 'House',
		'CommentAction'                         => 'CommunicateAction',
		'UserPageVisits'                        => 'UserInteraction',
		'AggregateRating'                       => 'Rating',
		'ItemAvailability'                      => 'Enumeration',
		'TelevisionStation'                     => 'LocalBusiness',
		'MedicalGuidelineRecommendation'        => 'MedicalGuideline',
		'ItemList'                              => 'Intangible',
		'LymphaticVessel'                       => 'Vessel',
		'PublicationIssue'                      => 'CreativeWork',
		'CertificationStatusEnumeration'        => 'Enumeration',
		'UpdateAction'                          => 'Action',
		'House'                                 => 'Accommodation',
		'MeasurementTypeEnumeration'            => 'Enumeration',
		'SpeakableSpecification'                => 'Intangible',
		'NightClub'                             => 'EntertainmentBusiness',
		'ExhibitionEvent'                       => 'Event',
		'NoteDigitalDocument'                   => 'DigitalDocument',
		'AutoWash'                              => 'AutomotiveBusiness',
		'RegisterAction'                        => 'InteractAction',
		'DefenceEstablishment'                  => 'GovernmentBuilding',
		'MedicalTrial'                          => 'MedicalStudy',
		'GameServer'                            => 'Intangible',
		'IncentiveStatus'                       => 'Enumeration',
		'CreativeWork'                          => 'Thing',
		'Bone'                                  => 'AnatomicalStructure',
		'SubscribeAction'                       => 'InteractAction',
		'QualitativeValue'                      => 'Enumeration',
		'DataDownload'                          => 'MediaObject',
		'PaymentMethod'                         => 'Intangible',
		'DiscussionForumPosting'                => 'SocialMediaPosting',
		'InviteAction'                          => 'CommunicateAction',
		'OrganizationRole'                      => 'Role',
		'DDxElement'                            => 'MedicalIntangible',
		'Ligament'                              => 'AnatomicalStructure',
		'ComicSeries'                           => 'Periodical',
		'Store'                                 => 'LocalBusiness',
		'EmployerReview'                        => 'Review',
		'GatedResidenceCommunity'               => 'Residence',
		'BusReservation'                        => 'Reservation',
		'Season'                                => 'CreativeWork',
		'BroadcastService'                      => 'Service',
		'AllocateAction'                        => 'OrganizeAction',
		'SpecialAnnouncement'                   => 'CreativeWork',
		'MedicalGuideline'                      => 'MedicalEntity',
		'Plumber'                               => 'HomeAndConstructionBusiness',
		'Cooperative'                           => 'Organization',
		'Consortium'                            => 'Organization',
		'BrainStructure'                        => 'AnatomicalStructure',
		'Series'                                => 'Intangible',
		'RVPark'                                => 'CivicStructure',
		'RadioStation'                          => 'LocalBusiness',
		'MedicalRiskScore'                      => 'MedicalRiskEstimator',
		'TaxiStand'                             => 'CivicStructure',
		'FinancialProduct'                      => 'Service',
		'AddAction'                             => 'UpdateAction',
		'StructuredValue'                       => 'Intangible',
		'MemberProgramTier'                     => 'Intangible',
		'TypeAndQuantityNode'                   => 'StructuredValue',
		'MortgageLoan'                          => 'LoanOrCredit',
		'Airline'                               => 'Organization',
		'Reservation'                           => 'Intangible',
		'JobPosting'                            => 'Intangible',
		'DrugPrescriptionStatus'                => 'MedicalEnumeration',
		'ReactAction'                           => 'AssessAction',
		'WebApplication'                        => 'SoftwareApplication',
		'WorkBasedProgram'                      => 'EducationalOccupationalProgram',
		'BreadcrumbList'                        => 'ItemList',
		'SelfStorage'                           => 'LocalBusiness',
		'PodcastSeries'                         => 'CreativeWorkSeries',
		'AudioObject'                           => 'MediaObject',
		'ProductModel'                          => 'Product',
		'MedicalCondition'                      => 'MedicalEntity',
		'EventAttendanceModeEnumeration'        => 'Enumeration',
		'IndividualProduct'                     => 'Product',
		'IceCreamShop'                          => 'FoodEstablishment',
		'VisualArtwork'                         => 'CreativeWork',
		'Florist'                               => 'Store',
		'LodgingBusiness'                       => 'LocalBusiness',
		'DigitalPlatformEnumeration'            => 'Enumeration',
		'FinancialService'                      => 'LocalBusiness',
		'FlightReservation'                     => 'Reservation',
		'Movie'                                 => 'CreativeWork',
		'Researcher'                            => 'Audience',
		'DefinedTerm'                           => 'Intangible',
		'Code'                                  => 'CreativeWork',
		'Beach'                                 => 'CivicStructure',
		'MovieClip'                             => 'Clip',
		'OnlineMarketplace'                     => 'OnlineStore',
		'ShippingService'                       => 'StructuredValue',
		'Question'                              => 'Comment',
		'HowToTool'                             => 'HowToItem',
		'PerformingArtsTheater'                 => 'CivicStructure',
		'CovidTestingFacility'                  => 'MedicalClinic',
		'NewsMediaOrganization'                 => 'Organization',
		'PreOrderAction'                        => 'TradeAction',
		'CafeOrCoffeeShop'                      => 'FoodEstablishment',
		'URL'                                   => 'Text',
		'AutomatedTeller'                       => 'FinancialService',
		'InternetCafe'                          => 'LocalBusiness',
		'Action'                                => 'Thing',
		'PetStore'                              => 'Store',
		'InstantaneousEvent'                    => 'StructuredValue',
		'OfficeEquipmentStore'                  => 'Store',
		'XPathType'                             => 'Text',
		'DeliveryMethod'                        => 'Enumeration',
		'Motel'                                 => 'LodgingBusiness',
		'OccupationalExperienceRequirements'    => 'Intangible',
		'AssessAction'                          => 'Action',
		'MoveAction'                            => 'Action',
		'EmergencyService'                      => 'LocalBusiness',
		'BioChemEntity'                         => 'Thing',
		'PublicToilet'                          => 'CivicStructure',
		'SteeringPositionValue'                 => 'QualitativeValue',
		'AuthorizeAction'                       => 'AllocateAction',
		'TradeAction'                           => 'Action',
		'BroadcastChannel'                      => 'Intangible',
		'Trip'                                  => 'Intangible',
		'TieAction'                             => 'AchieveAction',
		'GamePlayMode'                          => 'Enumeration',
		'DisagreeAction'                        => 'ReactAction',
		'Enumeration'                           => 'Intangible',
		'Collection'                            => 'CreativeWork',
		'ReturnMethodEnumeration'               => 'Enumeration',
		'ArtGallery'                            => 'EntertainmentBusiness',
		'OrderItem'                             => 'StructuredValue',
		'EducationalOccupationalCredential'     => 'CreativeWork',
		'UserBlocks'                            => 'UserInteraction',
		'NewsArticle'                           => 'Article',
		'MediaReview'                           => 'Review',
		'RadioBroadcastService'                 => 'BroadcastService',
		'UseAction'                             => 'ConsumeAction',
		'SurgicalProcedure'                     => 'MedicalProcedure',
		'GovernmentService'                     => 'Service',
		'Optician'                              => 'MedicalBusiness',
		'SheetMusic'                            => 'CreativeWork',
		'LiquorStore'                           => 'Store',
		'ChooseAction'                          => 'AssessAction',
		'RestrictedDiet'                        => 'Enumeration',
		'Project'                               => 'Organization',
		'HealthTopicContent'                    => 'WebContent',
		'Bakery'                                => 'FoodEstablishment',
		'Answer'                                => 'Comment',
		'ShippingRateSettings'                  => 'StructuredValue',
		'ItemPage'                              => 'WebPage',
		'ChildCare'                             => 'LocalBusiness',
		'CssSelectorType'                       => 'Text',
		'SizeSystemEnumeration'                 => 'Enumeration',
		'Bridge'                                => 'CivicStructure',
		'BusStation'                            => 'CivicStructure',
		'RejectAction'                          => 'AllocateAction',
		'Aquarium'                              => 'CivicStructure',
		'AdvertiserContentArticle'              => 'Article',
		'CompoundPriceSpecification'            => 'PriceSpecification',
		'TrainTrip'                             => 'Trip',
		'DepartAction'                          => 'MoveAction',
		'ProgramMembership'                     => 'Intangible',
		'Brewery'                               => 'FoodEstablishment',
		'Ticket'                                => 'Intangible',
		'UserInteraction'                       => 'Event',
		'HousePainter'                          => 'HomeAndConstructionBusiness',
		'Report'                                => 'Article',
		'DataFeed'                              => 'Dataset',
		'PlaceOfWorship'                        => 'CivicStructure',
		'Notary'                                => 'LegalService',
		'WebSite'                               => 'CreativeWork',
		'LibrarySystem'                         => 'Organization',
		'CreativeWorkSeason'                    => 'CreativeWork',
		'IncentiveType'                         => 'Enumeration',
		'AutomotiveBusiness'                    => 'LocalBusiness',
		'Vessel'                                => 'AnatomicalStructure',
		'DonateAction'                          => 'TransferAction',
		'LoseAction'                            => 'AchieveAction',
		'OrganizeAction'                        => 'Action',
		'PayAction'                             => 'TradeAction',
		'WearableMeasurementTypeEnumeration'    => 'MeasurementTypeEnumeration',
		'PodcastEpisode'                        => 'Episode',
		'Energy'                                => 'Quantity',
		'Schedule'                              => 'Intangible',
		'Hotel'                                 => 'LodgingBusiness',
		'FinancialIncentive'                    => 'Intangible',
		'Claim'                                 => 'CreativeWork',
		'ParentAudience'                        => 'PeopleAudience',
		'Clip'                                  => 'CreativeWork',
		'HowToItem'                             => 'ListItem',
		'HomeAndConstructionBusiness'           => 'LocalBusiness',
		'InformAction'                          => 'CommunicateAction',
		'CityHall'                              => 'GovernmentBuilding',
		'VideoGallery'                          => 'MediaGallery',
		'MusicVideoObject'                      => 'MediaObject',
		'TierBenefitEnumeration'                => 'Enumeration',
		'BikeStore'                             => 'Store',
		'MemberProgram'                         => 'Intangible',
		'CorrectionComment'                     => 'Comment',
		'TrainReservation'                      => 'Reservation',
		'MusicReleaseFormatType'                => 'Enumeration',
		'MusicVenue'                            => 'CivicStructure',
		'LendAction'                            => 'TransferAction',
		'MusicAlbum'                            => 'MusicPlaylist',
		'Vehicle'                               => 'Product',
		'HyperTocEntry'                         => 'CreativeWork',
		'Newspaper'                             => 'Periodical',
		'MedicalOrganization'                   => 'Organization',
		'Accommodation'                         => 'Place',
		'MedicalTrialDesign'                    => 'MedicalEnumeration',
		'AlignmentObject'                       => 'Intangible',
		'DepartmentStore'                       => 'Store',
		'WebPageElement'                        => 'CreativeWork',
		'MusicAlbumProductionType'              => 'Enumeration',
		'WebAPI'                                => 'Service',
		'DislikeAction'                         => 'ReactAction',
		'SportsEvent'                           => 'Event',
		'AutoRental'                            => 'AutomotiveBusiness',
		'Electrician'                           => 'HomeAndConstructionBusiness',
		'Mosque'                                => 'PlaceOfWorship',
		'MedicalProcedureType'                  => 'MedicalEnumeration',
		'RealEstateAgent'                       => 'LocalBusiness',
		'ImageObject'                           => 'MediaObject',
		'Offer'                                 => 'Intangible',
		'MotorcycleRepair'                      => 'AutomotiveBusiness',
		'MedicalEnumeration'                    => 'Enumeration',
		'HowToSupply'                           => 'HowToItem',
		'HairSalon'                             => 'HealthAndBeautyBusiness',
		'CategoryCodeSet'                       => 'DefinedTermSet',
		'ArchiveComponent'                      => 'CreativeWork',
		'Waterfall'                             => 'BodyOfWater',
		'LegislativeBuilding'                   => 'GovernmentBuilding',
		'SatiricalArticle'                      => 'Article',
		'ViewAction'                            => 'ConsumeAction',
		'EUEnergyEfficiencyEnumeration'         => 'EnergyEfficiencyEnumeration',
		'FollowAction'                          => 'InteractAction',
		'AnatomicalStructure'                   => 'MedicalEntity',
		'TransferAction'                        => 'Action',
		'PawnShop'                              => 'Store',
		'AskAction'                             => 'CommunicateAction',
		'ImagingTest'                           => 'MedicalTest',
		'AdultEntertainment'                    => 'EntertainmentBusiness',
		'GeospatialGeometry'                    => 'Intangible',
		'ReviewAction'                          => 'AssessAction',
		'WebContent'                            => 'CreativeWork',
		'Barcode'                               => 'ImageObject',
		'ReceiveAction'                         => 'TransferAction',
		'Attorney'                              => 'LegalService',
		'ElementarySchool'                      => 'EducationalOrganization',
		'DrinkAction'                           => 'ConsumeAction',
		'WPAdBlock'                             => 'WebPageElement',
		'MonetaryAmountDistribution'            => 'QuantitativeValueDistribution',
		'ReportageNewsArticle'                  => 'NewsArticle',
		'StatisticalPopulation'                 => 'Intangible',
		'SizeGroupEnumeration'                  => 'Enumeration',
		'Canal'                                 => 'BodyOfWater',
		'ShoppingCenter'                        => 'LocalBusiness',
		'BoardingPolicyType'                    => 'Enumeration',
		'PropertyValue'                         => 'StructuredValue',
		'HVACBusiness'                          => 'HomeAndConstructionBusiness',
		'DaySpa'                                => 'HealthAndBeautyBusiness',
		'StatisticalVariable'                   => 'ConstraintNode',
		'InstallAction'                         => 'ConsumeAction',
		'DataType'                              => 'rdfs:Class',
		'UserPlusOnes'                          => 'UserInteraction',
		'Property'                              => 'Intangible',
		'School'                                => 'EducationalOrganization',
		'WearableSizeSystemEnumeration'         => 'SizeSystemEnumeration',
		'PodcastSeason'                         => 'CreativeWorkSeason',
		'Float'                                 => 'Number',
		'Museum'                                => 'CivicStructure',
		'MovieRentalStore'                      => 'Store',
		'MaximumDoseSchedule'                   => 'DoseSchedule',
		'Play'                                  => 'CreativeWork',
		'PublicationEvent'                      => 'Event',
		'HomeGoodsStore'                        => 'Store',
		'Message'                               => 'CreativeWork',
		'InteractionCounter'                    => 'StructuredValue',
		'EmailMessage'                          => 'Message',
		'BusOrCoach'                            => 'Vehicle',
		'OccupationalTherapy'                   => 'MedicalTherapy',
		'ClaimReview'                           => 'Review',
		'CommunicateAction'                     => 'InteractAction',
		'MusicGroup'                            => 'PerformingGroup',
		'MusicAlbumReleaseType'                 => 'Enumeration',
		'MedicalTherapy'                        => 'TherapeuticProcedure',
		'MerchantReturnPolicy'                  => 'Intangible',
		'BodyMeasurementTypeEnumeration'        => 'MeasurementTypeEnumeration',
		'ComputerLanguage'                      => 'Intangible',
		'FulfillmentTypeEnumeration'            => 'Enumeration',
		'InsertAction'                          => 'AddAction',
		'VoteAction'                            => 'ChooseAction',
		'CableOrSatelliteService'               => 'Service',
		'PerformingGroup'                       => 'Organization',
		'GameAvailabilityEnumeration'           => 'Enumeration',
		'BankAccount'                           => 'FinancialProduct',
		'RadiationTherapy'                      => 'MedicalTherapy',
		'WinAction'                             => 'AchieveAction',
		'MotorcycleDealer'                      => 'AutomotiveBusiness',
		'SendAction'                            => 'TransferAction',
		'Menu'                                  => 'CreativeWork',
		'VideoObject'                           => 'MediaObject',
		'ApartmentComplex'                      => 'Residence',
		'ResumeAction'                          => 'ControlAction',
		'Crematorium'                           => 'CivicStructure',
		'UnRegisterAction'                      => 'InteractAction',
		'MedicalBusiness'                       => 'LocalBusiness',
		'Dataset'                               => 'CreativeWork',
		'Gene'                                  => 'BioChemEntity',
		'IgnoreAction'                          => 'AssessAction',
		'Restaurant'                            => 'FoodEstablishment',
		'EatAction'                             => 'ConsumeAction',
		'BoatTrip'                              => 'Trip',
		'CheckoutPage'                          => 'WebPage',
		'OutletStore'                           => 'Store',
		'Residence'                             => 'Place',
		'Specialty'                             => 'Enumeration',
		'Landform'                              => 'Place',
		'ComedyClub'                            => 'EntertainmentBusiness',
		'ArchiveOrganization'                   => 'LocalBusiness',
		'DrugCostCategory'                      => 'MedicalEnumeration',
		'Hostel'                                => 'LodgingBusiness',
		'AnatomicalSystem'                      => 'MedicalEntity',
		'Motorcycle'                            => 'Vehicle',
		'ParcelDelivery'                        => 'Intangible',
		'BlogPosting'                           => 'SocialMediaPosting',
		'BookFormatType'                        => 'Enumeration',
		'EventStatusType'                       => 'StatusEnumeration',
		'BeautySalon'                           => 'HealthAndBeautyBusiness',
		'DataCatalog'                           => 'CreativeWork',
		'MedicalDevice'                         => 'MedicalEntity',
		'OrderStatus'                           => 'StatusEnumeration',
		'ProfessionalService'                   => 'LocalBusiness',
		'HighSchool'                            => 'EducationalOrganization',
		'PhotographAction'                      => 'CreateAction',
		'TVEpisode'                             => 'Episode',
		'ConstraintNode'                        => 'Intangible',
		'RefundTypeEnumeration'                 => 'Enumeration',
		'ApprovedIndication'                    => 'MedicalIndication',
		'ReplyAction'                           => 'CommunicateAction',
		'ServiceChannel'                        => 'Intangible',
		'DoseSchedule'                          => 'MedicalIntangible',
		'InfectiousAgentClass'                  => 'MedicalEnumeration',
		'BankOrCreditUnion'                     => 'FinancialService',
		'Festival'                              => 'Event',
		'LegalService'                          => 'LocalBusiness',
		'MedicalDevicePurpose'                  => 'MedicalEnumeration',
		'RentalCarReservation'                  => 'Reservation',
		'Role'                                  => 'Intangible',
		'PhysicalActivityCategory'              => 'Enumeration',
		'Mountain'                              => 'Landform',
		'UserReview'                            => 'Review',
		'State'                                 => 'AdministrativeArea',
		'Synagogue'                             => 'PlaceOfWorship',
		'LiteraryEvent'                         => 'Event',
		'GeoCircle'                             => 'GeoShape',
		'Poster'                                => 'CreativeWork',
		'Quantity'                              => 'Intangible',
		'Mass'                                  => 'Quantity',
		'EducationalAudience'                   => 'Audience',
		'MolecularEntity'                       => 'BioChemEntity',
		'WriteAction'                           => 'CreateAction',
		'GeneralContractor'                     => 'HomeAndConstructionBusiness',
		'CarUsageType'                          => 'Enumeration',
		'VideoGameClip'                         => 'Clip',
		'DownloadAction'                        => 'TransferAction',
		'ImageGallery'                          => 'MediaGallery',
		'UserCheckins'                          => 'UserInteraction',
		'EngineSpecification'                   => 'StructuredValue',
		'PronounceableText'                     => 'Text',
		'DigitalDocumentPermissionType'         => 'Enumeration',
		'Suite'                                 => 'Accommodation',
		'TelevisionChannel'                     => 'BroadcastChannel',
		'ResearchOrganization'                  => 'Organization',
		'CheckInAction'                         => 'CommunicateAction',
		'MedicalCause'                          => 'MedicalEntity',
		'BusinessFunction'                      => 'Enumeration',
		'SellAction'                            => 'TradeAction',
		'Blog'                                  => 'CreativeWork',
		'SaleEvent'                             => 'Event',
		'DriveWheelConfigurationValue'          => 'QualitativeValue',
		'PostOffice'                            => 'GovernmentOffice',
		'CDCPMDRecord'                          => 'StructuredValue',
		'MedicalRiskCalculator'                 => 'MedicalRiskEstimator',
		'Recommendation'                        => 'Review',
		'LinkRole'                              => 'Role',
		'PurchaseType'                          => 'Enumeration',
		'WorkersUnion'                          => 'Organization',
		'SportingGoodsStore'                    => 'Store',
		'BusinessEntityType'                    => 'Enumeration',
		'AutoDealer'                            => 'AutomotiveBusiness',
		'ChildrensEvent'                        => 'Event',
		'MedicalProcedure'                      => 'MedicalEntity',
		'ReservationPackage'                    => 'Reservation',
		'PhysicalTherapy'                       => 'MedicalTherapy',
		'TechArticle'                           => 'Article',
		'Park'                                  => 'CivicStructure',
		'Preschool'                             => 'EducationalOrganization',
		'MedicalRiskEstimator'                  => 'MedicalEntity',
		'OfferForLease'                         => 'Offer',
		'CreateAction'                          => 'Action',
		'MarryAction'                           => 'InteractAction',
		'InvestmentFund'                        => 'InvestmentOrDeposit',
		'RsvpAction'                            => 'InformAction',
		'VeterinaryCare'                        => 'MedicalOrganization',
		'Casino'                                => 'EntertainmentBusiness',
		'EventReservation'                      => 'Reservation',
		'GovernmentOffice'                      => 'LocalBusiness',
		'HobbyShop'                             => 'Store',
		'RecommendedDoseSchedule'               => 'DoseSchedule',
		'UserPlays'                             => 'UserInteraction',
		'ShoeStore'                             => 'Store',
		'HealthAspectEnumeration'               => 'Enumeration',
		'TennisComplex'                         => 'SportsActivityLocation',
		'PsychologicalTreatment'                => 'TherapeuticProcedure',
		'RadioChannel'                          => 'BroadcastChannel',
		'Review'                                => 'CreativeWork',
		'MedicalEvidenceLevel'                  => 'MedicalEnumeration',
		'TherapeuticProcedure'                  => 'MedicalProcedure',
		'ResearchProject'                       => 'Project',
		'CourseInstance'                        => 'Event',
		'BackgroundNewsArticle'                 => 'NewsArticle',
		'MonetaryAmount'                        => 'StructuredValue',
		'MobilePhoneStore'                      => 'Store',
		'ActivateAction'                        => 'ControlAction',
		'CheckOutAction'                        => 'CommunicateAction',
		'FoodService'                           => 'Service',
		'Syllabus'                              => 'LearningResource',
		'GovernmentBenefitsType'                => 'Enumeration',
		'UserDownloads'                         => 'UserInteraction',
		'MusicPlaylist'                         => 'CreativeWork',
		'BodyOfWater'                           => 'Landform',
		'SearchAction'                          => 'Action',
		'MusicEvent'                            => 'Event',
		'ReturnLabelSourceEnumeration'          => 'Enumeration',
		'Substance'                             => 'MedicalEntity',
		'OpinionNewsArticle'                    => 'NewsArticle',
		'TouristTrip'                           => 'Trip',
		'ContactPoint'                          => 'StructuredValue',
		'MobileApplication'                     => 'SoftwareApplication',
		'Statement'                             => 'CreativeWork',
		'RepaymentSpecification'                => 'StructuredValue',
		'MedicalContraindication'               => 'MedicalEntity',
		'WarrantyScope'                         => 'Enumeration',
		'DefinedTermSet'                        => 'CreativeWork',
		'DatedMoneySpecification'               => 'StructuredValue',
		'MediaManipulationRatingEnumeration'    => 'Enumeration',
		'NailSalon'                             => 'HealthAndBeautyBusiness',
		'LandmarksOrHistoricalBuildings'        => 'Place',
		'PaymentChargeSpecification'            => 'PriceSpecification',
		'MedicalGuidelineContraindication'      => 'MedicalGuideline',
		'Rating'                                => 'Intangible',
		'Pond'                                  => 'BodyOfWater',
		'LodgingReservation'                    => 'Reservation',
		'TipAction'                             => 'TradeAction',
		'OwnershipInfo'                         => 'StructuredValue',
		'PathologyTest'                         => 'MedicalTest',
		'HardwareStore'                         => 'Store',
		'ExerciseGym'                           => 'SportsActivityLocation',
		'VisualArtsEvent'                       => 'Event',
		'MeasurementMethodEnum'                 => 'Enumeration',
		'LikeAction'                            => 'ReactAction',
		'HinduTemple'                           => 'PlaceOfWorship',
		'VitalSign'                             => 'MedicalSign',
		'UKNonprofitType'                       => 'NonprofitType',
		'ElectronicsStore'                      => 'Store',
		'UserLikes'                             => 'UserInteraction',
		'PropertyValueSpecification'            => 'Intangible',
		'DanceEvent'                            => 'Event',
		'FindAction'                            => 'Action',
		'AskPublicNewsArticle'                  => 'NewsArticle',
		'QuoteAction'                           => 'TradeAction',
		'AMRadioChannel'                        => 'RadioChannel',
		'AccountingService'                     => 'FinancialService',
		'BarOrPub'                              => 'FoodEstablishment',
		'SearchResultsPage'                     => 'WebPage',
		'Church'                                => 'PlaceOfWorship',
		'VideoGameSeries'                       => 'CreativeWorkSeries',
		'AdultOrientedEnumeration'              => 'Enumeration',
		'Periodical'                            => 'CreativeWorkSeries',
		'IndividualPhysician'                   => 'Physician',
		'WearAction'                            => 'UseAction',
		'FoodEvent'                             => 'Event',
		'MedicalTest'                           => 'MedicalEntity',
		'PostalAddress'                         => 'ContactPoint',
		'MedicalSymptom'                        => 'MedicalSignOrSymptom',
		'FAQPage'                               => 'WebPage',
		'TrackAction'                           => 'FindAction',
		'GovernmentBuilding'                    => 'CivicStructure',
		'Zoo'                                   => 'CivicStructure',
		'ConsumeAction'                         => 'Action',
		'AudioObjectSnapshot'                   => 'AudioObject',
		'DayOfWeek'                             => 'Enumeration',
		'OfferCatalog'                          => 'ItemList',
		'Distance'                              => 'Quantity',
		'BorrowAction'                          => 'TransferAction',
		'Article'                               => 'CreativeWork',
		'ActionAccessSpecification'             => 'Intangible',
		'TouristAttraction'                     => 'Place',
		'GroceryStore'                          => 'Store',
		'EntryPoint'                            => 'Intangible',
		'Thesis'                                => 'CreativeWork',
		'StatusEnumeration'                     => 'Enumeration',
		'Nerve'                                 => 'AnatomicalStructure',
		'MeetingRoom'                           => 'Room',
		'DataFeedItem'                          => 'Intangible',
		'MusicStore'                            => 'Store',
		'ToyStore'                              => 'Store',
		'Muscle'                                => 'AnatomicalStructure',
		'DrugPregnancyCategory'                 => 'MedicalEnumeration',
		'OperatingSystem'                       => 'SoftwareApplication',
		'JoinAction'                            => 'InteractAction',
	);

	/**
	 * Property domain mappings
	 *
	 * Maps each property to the types it can be used with.
	 * For example: 'prepTime' => ['HowTo', 'HowToDirection']
	 *
	 * @var array
	 */
	public static $property_domains = array(
		'legislationPassedBy'                     => array(
			'Legislation',
		),
		'funding'                                 => array(
			'MedicalEntity',
			'BioChemEntity',
			'CreativeWork',
			'Organization',
			'Person',
			'Product',
			'Event',
		),
		'valuePattern'                            => array(
			'PropertyValueSpecification',
		),
		'provider'                                => array(
			'EducationalOccupationalProgram',
			'FinancialIncentive',
			'Invoice',
			'CreativeWork',
			'Service',
			'Trip',
			'ParcelDelivery',
			'Reservation',
			'Action',
		),
		'honorificPrefix'                         => array(
			'Person',
		),
		'modifiedTime'                            => array(
			'Reservation',
		),
		'numberOfCredits'                         => array(
			'EducationalOccupationalProgram',
			'Course',
		),
		'noBylinesPolicy'                         => array(
			'NewsMediaOrganization',
		),
		'genre'                                   => array(
			'BroadcastChannel',
			'CreativeWork',
			'MusicGroup',
		),
		'sameAs'                                  => array(
			'Thing',
		),
		'wordCount'                               => array(
			'CreativeWork',
			'Article',
		),
		'recommendedIntake'                       => array(
			'DietarySupplement',
		),
		'isGift'                                  => array(
			'Order',
		),
		'interactingDrug'                         => array(
			'Drug',
		),
		'experienceInPlaceOfEducation'            => array(
			'JobPosting',
		),
		'isProprietary'                           => array(
			'DietarySupplement',
			'Drug',
		),
		'accessModeSufficient'                    => array(
			'CreativeWork',
		),
		'breadcrumb'                              => array(
			'WebPage',
		),
		'recordedAs'                              => array(
			'MusicComposition',
		),
		'vehicleConfiguration'                    => array(
			'Vehicle',
		),
		'orderItemNumber'                         => array(
			'OrderItem',
		),
		'legislationIdentifier'                   => array(
			'Legislation',
		),
		'weightTotal'                             => array(
			'Vehicle',
		),
		'numberOfFullBathrooms'                   => array(
			'FloorPlan',
			'Accommodation',
		),
		'imagingTechnique'                        => array(
			'ImagingTest',
		),
		'readBy'                                  => array(
			'Audiobook',
		),
		'readonlyValue'                           => array(
			'PropertyValueSpecification',
		),
		'containsSeason'                          => array(
			'VideoGameSeries',
			'TVSeries',
			'RadioSeries',
		),
		'legislationCommences'                    => array(
			'Legislation',
		),
		'pickupTime'                              => array(
			'TaxiReservation',
			'RentalCarReservation',
		),
		'hoursAvailable'                          => array(
			'LocationFeatureSpecification',
			'Service',
			'ContactPoint',
		),
		'targetPlatform'                          => array(
			'APIReference',
		),
		'connectedTo'                             => array(
			'AnatomicalStructure',
		),
		'cvdNumBedsOcc'                           => array(
			'CDCPMDRecord',
		),
		'nonEqual'                                => array(
			'QualitativeValue',
		),
		'qualifiedExpense'                        => array(
			'FinancialIncentive',
		),
		'paymentUrl'                              => array(
			'Order',
		),
		'acquireLicensePage'                      => array(
			'CreativeWork',
		),
		'hasRepresentation'                       => array(
			'BioChemEntity',
		),
		'suggestedMinAge'                         => array(
			'PeopleAudience',
		),
		'polygon'                                 => array(
			'GeoShape',
		),
		'duration'                                => array(
			'Schedule',
			'Movie',
			'Event',
			'QuantitativeValueDistribution',
			'MediaObject',
			'Episode',
			'ServicePeriod',
			'Audiobook',
			'MusicRelease',
			'MusicRecording',
		),
		'maximumEnrollment'                       => array(
			'EducationalOccupationalProgram',
		),
		'numberOfForwardGears'                    => array(
			'Vehicle',
		),
		'taxonRank'                               => array(
			'Taxon',
		),
		'actionPlatform'                          => array(
			'EntryPoint',
		),
		'numTracks'                               => array(
			'MusicPlaylist',
		),
		'legislationLegalValue'                   => array(
			'LegislationObject',
		),
		'totalPaymentDue'                         => array(
			'Invoice',
		),
		'sensoryRequirement'                      => array(
			'JobPosting',
		),
		'hasDefinedTerm'                          => array(
			'DefinedTermSet',
			'Taxon',
		),
		'orderNumber'                             => array(
			'Order',
		),
		'geoCovers'                               => array(
			'Place',
			'GeospatialGeometry',
		),
		'mathExpression'                          => array(
			'MathSolver',
		),
		'lender'                                  => array(
			'BorrowAction',
		),
		'currency'                                => array(
			'DatedMoneySpecification',
			'MonetaryAmount',
			'MonetaryAmountDistribution',
			'ExchangeRateSpecification',
			'LoanOrCredit',
		),
		'temporalCoverage'                        => array(
			'CreativeWork',
		),
		'shippingDetails'                         => array(
			'Offer',
		),
		'specialOpeningHoursSpecification'        => array(
			'Place',
		),
		'publicAccess'                            => array(
			'Place',
		),
		'structuralClass'                         => array(
			'Joint',
		),
		'smokingAllowed'                          => array(
			'Place',
		),
		'currenciesAccepted'                      => array(
			'LocalBusiness',
		),
		'publisher'                               => array(
			'FinancialIncentive',
			'CreativeWork',
		),
		'targetUrl'                               => array(
			'AlignmentObject',
		),
		'endOffset'                               => array(
			'Clip',
		),
		'eligibleDuration'                        => array(
			'Demand',
			'Offer',
		),
		'costCurrency'                            => array(
			'DrugCost',
		),
		'arrivalTime'                             => array(
			'Trip',
		),
		'hasMeasurement'                          => array(
			'SizeSpecification',
			'Offer',
			'Product',
			'Certification',
		),
		'runtime'                                 => array(
			'SoftwareSourceCode',
		),
		'serviceAudience'                         => array(
			'Service',
		),
		'vehicleTransmission'                     => array(
			'Vehicle',
		),
		'reportNumber'                            => array(
			'Report',
		),
		'exerciseCourse'                          => array(
			'ExerciseAction',
		),
		'seasons'                                 => array(
			'VideoGameSeries',
			'TVSeries',
			'RadioSeries',
		),
		'knownVehicleDamages'                     => array(
			'Vehicle',
		),
		'name'                                    => array(
			'Thing',
		),
		'warranty'                                => array(
			'Demand',
			'Offer',
		),
		'distribution'                            => array(
			'Dataset',
		),
		'actionAccessibilityRequirement'          => array(
			'ConsumeAction',
		),
		'numberOfAccommodationUnits'              => array(
			'ApartmentComplex',
			'FloorPlan',
		),
		'weight'                                  => array(
			'Person',
			'VisualArtwork',
			'OfferShippingDetails',
			'ShippingConditions',
			'Product',
		),
		'associatedArticle'                       => array(
			'MediaObject',
		),
		'commentTime'                             => array(
			'UserComments',
		),
		'awards'                                  => array(
			'CreativeWork',
			'Person',
			'Organization',
			'Product',
		),
		'steeringPosition'                        => array(
			'Vehicle',
		),
		'legislationConsolidates'                 => array(
			'Legislation',
		),
		'hasEnergyEfficiencyCategory'             => array(
			'EnergyConsumptionDetails',
		),
		'reservationFor'                          => array(
			'Reservation',
		),
		'cssSelector'                             => array(
			'SpeakableSpecification',
			'WebPageElement',
		),
		'contraindication'                        => array(
			'MedicalDevice',
			'MedicalTherapy',
		),
		'proficiencyLevel'                        => array(
			'TechArticle',
		),
		'question'                                => array(
			'AskAction',
		),
		'thumbnail'                               => array(
			'CreativeWork',
		),
		'strengthUnit'                            => array(
			'DrugStrength',
		),
		'propertyID'                              => array(
			'PropertyValue',
		),
		'servicePostalAddress'                    => array(
			'ServiceChannel',
		),
		'billingDuration'                         => array(
			'UnitPriceSpecification',
		),
		'additionalNumberOfGuests'                => array(
			'RsvpAction',
		),
		'thumbnailUrl'                            => array(
			'CreativeWork',
		),
		'mediaAuthenticityCategory'               => array(
			'MediaReview',
		),
		'geoOverlaps'                             => array(
			'GeospatialGeometry',
			'Place',
		),
		'inAlbum'                                 => array(
			'MusicRecording',
		),
		'commentCount'                            => array(
			'CreativeWork',
		),
		'availableThrough'                        => array(
			'DeliveryEvent',
		),
		'busNumber'                               => array(
			'BusTrip',
		),
		'guidelineSubject'                        => array(
			'MedicalGuideline',
		),
		'refundType'                              => array(
			'MerchantReturnPolicySeasonalOverride',
			'MerchantReturnPolicy',
		),
		'height'                                  => array(
			'MediaObject',
			'Person',
			'VisualArtwork',
			'OfferShippingDetails',
			'Product',
			'ShippingConditions',
		),
		'addressCountry'                          => array(
			'PostalAddress',
			'DefinedRegion',
			'GeoShape',
			'GeoCoordinates',
		),
		'catalog'                                 => array(
			'Dataset',
		),
		'customer'                                => array(
			'Invoice',
			'Order',
		),
		'hasMenuItem'                             => array(
			'MenuSection',
			'Menu',
		),
		'displayLocation'                         => array(
			'Product',
			'CreativeWork',
		),
		'practicesAt'                             => array(
			'IndividualPhysician',
		),
		'roofLoad'                                => array(
			'Car',
			'BusOrCoach',
		),
		'latitude'                                => array(
			'Place',
			'GeoCoordinates',
		),
		'coverageStartTime'                       => array(
			'LiveBlogPosting',
		),
		'medicalSpecialty'                        => array(
			'Physician',
			'MedicalClinic',
			'MedicalOrganization',
			'Hospital',
		),
		'emissionsCO2'                            => array(
			'Vehicle',
		),
		'webCheckinTime'                          => array(
			'Flight',
		),
		'experienceRequirements'                  => array(
			'JobPosting',
			'Occupation',
		),
		'printPage'                               => array(
			'NewsArticle',
		),
		'includesHealthPlanFormulary'             => array(
			'HealthInsurancePlan',
		),
		'fatContent'                              => array(
			'NutritionInformation',
		),
		'musicBy'                                 => array(
			'Movie',
			'Clip',
			'Episode',
			'VideoGame',
			'MovieSeries',
			'VideoObject',
			'TVSeries',
			'RadioSeries',
			'VideoGameSeries',
		),
		'knowsAbout'                              => array(
			'Person',
			'Organization',
		),
		'syllabusSections'                        => array(
			'Course',
		),
		'gtin'                                    => array(
			'Product',
			'Demand',
			'Offer',
		),
		'orderDelivery'                           => array(
			'OrderItem',
			'Order',
		),
		'archivedAt'                              => array(
			'CreativeWork',
		),
		'cholesterolContent'                      => array(
			'NutritionInformation',
		),
		'workPresented'                           => array(
			'ScreeningEvent',
		),
		'broker'                                  => array(
			'Reservation',
			'Invoice',
			'Order',
			'Service',
		),
		'epidemiology'                            => array(
			'PhysicalActivity',
			'MedicalCondition',
		),
		'numberOfRooms'                           => array(
			'SingleFamilyResidence',
			'Apartment',
			'LodgingBusiness',
			'Accommodation',
			'Suite',
			'FloorPlan',
			'House',
		),
		'checkoutPageURLTemplate'                 => array(
			'Offer',
		),
		'fileSize'                                => array(
			'SoftwareApplication',
		),
		'expectedPrognosis'                       => array(
			'MedicalCondition',
		),
		'countriesSupported'                      => array(
			'SoftwareApplication',
		),
		'signOrSymptom'                           => array(
			'MedicalCondition',
		),
		'sampleType'                              => array(
			'SoftwareSourceCode',
		),
		'openingHoursSpecification'               => array(
			'Place',
		),
		'vehicleInteriorType'                     => array(
			'Vehicle',
		),
		'partOfInvoice'                           => array(
			'Order',
		),
		'employee'                                => array(
			'Organization',
		),
		'data'                                    => array(
			'InstantaneousEvent',
		),
		'scheduledPaymentDate'                    => array(
			'Invoice',
		),
		'geoRadius'                               => array(
			'GeoCircle',
		),
		'occupationLocation'                      => array(
			'Occupation',
		),
		'validIn'                                 => array(
			'Certification',
			'EducationalOccupationalCredential',
			'Permit',
		),
		'exerciseRelatedDiet'                     => array(
			'ExerciseAction',
		),
		'digitalSourceType'                       => array(
			'CreativeWork',
		),
		'departureTime'                           => array(
			'Trip',
		),
		'normalRange'                             => array(
			'MedicalTest',
		),
		'broadcastOfEvent'                        => array(
			'BroadcastEvent',
		),
		'reviews'                                 => array(
			'Product',
			'Place',
			'CreativeWork',
			'Offer',
			'Organization',
		),
		'stage'                                   => array(
			'MedicalCondition',
		),
		'boardingPolicy'                          => array(
			'Airline',
			'Flight',
		),
		'issn'                                    => array(
			'CreativeWorkSeries',
			'Blog',
			'WebSite',
			'Dataset',
		),
		'instructor'                              => array(
			'CourseInstance',
		),
		'vendor'                                  => array(
			'BuyAction',
		),
		'educationalCredentialAwarded'            => array(
			'EducationalOccupationalProgram',
			'Course',
		),
		'transcript'                              => array(
			'VideoObject',
			'AudioObject',
		),
		'byMonth'                                 => array(
			'Schedule',
		),
		'assembly'                                => array(
			'APIReference',
		),
		'freeShippingThreshold'                   => array(
			'ShippingRateSettings',
		),
		'discusses'                               => array(
			'UserComments',
		),
		'requiredGender'                          => array(
			'PeopleAudience',
		),
		'termsPerYear'                            => array(
			'EducationalOccupationalProgram',
		),
		'source'                                  => array(
			'InstantaneousEvent',
		),
		'assesses'                                => array(
			'CreativeWork',
			'LearningResource',
			'EducationEvent',
		),
		'logo'                                    => array(
			'Organization',
			'Product',
			'Certification',
			'Brand',
			'Place',
			'Service',
		),
		'isStoreOn'                               => array(
			'OnlineStore',
		),
		'relevantSpecialty'                       => array(
			'MedicalEntity',
		),
		'gtin12'                                  => array(
			'Product',
			'Demand',
			'Offer',
		),
		'upvoteCount'                             => array(
			'Comment',
		),
		'hasCourseInstance'                       => array(
			'Course',
		),
		'usNPI'                                   => array(
			'Physician',
		),
		'price'                                   => array(
			'PriceSpecification',
			'Offer',
			'DonateAction',
			'TradeAction',
		),
		'result'                                  => array(
			'Action',
		),
		'geoContains'                             => array(
			'GeospatialGeometry',
			'Place',
		),
		'featureList'                             => array(
			'SoftwareApplication',
		),
		'hasMenuSection'                          => array(
			'MenuSection',
			'Menu',
		),
		'license'                                 => array(
			'CreativeWork',
		),
		'servesCuisine'                           => array(
			'FoodEstablishment',
		),
		'salaryUponCompletion'                    => array(
			'EducationalOccupationalProgram',
		),
		'query'                                   => array(
			'SearchAction',
		),
		'gender'                                  => array(
			'SportsTeam',
			'Person',
		),
		'processorRequirements'                   => array(
			'SoftwareApplication',
		),
		'totalHistoricalEnrollment'               => array(
			'Course',
		),
		'foundingDate'                            => array(
			'Organization',
		),
		'missionCoveragePrioritiesPolicy'         => array(
			'NewsMediaOrganization',
		),
		'eduQuestionType'                         => array(
			'SolveMathAction',
			'Question',
		),
		'additionalType'                          => array(
			'Thing',
		),
		'broadcastChannelId'                      => array(
			'BroadcastChannel',
		),
		'yearBuilt'                               => array(
			'Accommodation',
		),
		'partOfSeason'                            => array(
			'Clip',
			'Episode',
		),
		'broadcastSignalModulation'               => array(
			'BroadcastFrequencySpecification',
		),
		'performers'                              => array(
			'Event',
		),
		'programName'                             => array(
			'ProgramMembership',
		),
		'providerMobility'                        => array(
			'Service',
		),
		'amountOfThisGood'                        => array(
			'TypeAndQuantityNode',
		),
		'amount'                                  => array(
			'MonetaryGrant',
			'InvestmentOrDeposit',
			'DatedMoneySpecification',
			'MoneyTransfer',
			'LoanOrCredit',
		),
		'actionProcess'                           => array(
			'Action',
		),
		'diversityStaffingReport'                 => array(
			'Organization',
			'NewsMediaOrganization',
		),
		'textValue'                               => array(
			'PronounceableText',
		),
		'gameTip'                                 => array(
			'VideoGame',
		),
		'legislationTransposes'                   => array(
			'Legislation',
		),
		'sourcedFrom'                             => array(
			'Nerve',
		),
		'paymentStatus'                           => array(
			'Invoice',
		),
		'requiredCollateral'                      => array(
			'LoanOrCredit',
		),
		'financialAidEligible'                    => array(
			'EducationalOccupationalProgram',
			'Course',
		),
		'paymentDue'                              => array(
			'Invoice',
			'Order',
		),
		'itinerary'                               => array(
			'Trip',
		),
		'bookEdition'                             => array(
			'Book',
		),
		'addOn'                                   => array(
			'Offer',
		),
		'baseSalary'                              => array(
			'EmployeeRole',
			'JobPosting',
		),
		'evidenceOrigin'                          => array(
			'MedicalGuideline',
		),
		'foodEstablishment'                       => array(
			'CookAction',
		),
		'byArtist'                                => array(
			'MusicAlbum',
			'MusicRecording',
		),
		'algorithm'                               => array(
			'MedicalRiskScore',
		),
		'numberOfPartialBathrooms'                => array(
			'FloorPlan',
			'Accommodation',
		),
		'orderPercentage'                         => array(
			'ShippingRateSettings',
		),
		'hasMolecularFunction'                    => array(
			'BioChemEntity',
		),
		'pickupLocation'                          => array(
			'RentalCarReservation',
			'TaxiReservation',
		),
		'payload'                                 => array(
			'Vehicle',
		),
		'startTime'                               => array(
			'MediaObject',
			'FoodEstablishmentReservation',
			'InteractionCounter',
			'Action',
			'Schedule',
		),
		'isrcCode'                                => array(
			'MusicRecording',
		),
		'applicableCountry'                       => array(
			'MerchantReturnPolicy',
		),
		'howPerformed'                            => array(
			'MedicalProcedure',
		),
		'isRelatedTo'                             => array(
			'Service',
			'Product',
		),
		'clipNumber'                              => array(
			'Clip',
		),
		'storageRequirements'                     => array(
			'SoftwareApplication',
		),
		'colorist'                                => array(
			'ComicStory',
			'VisualArtwork',
			'ComicIssue',
		),
		'keywords'                                => array(
			'Product',
			'Event',
			'Place',
			'CreativeWork',
			'Organization',
		),
		'healthPlanCoinsuranceOption'             => array(
			'HealthPlanCostSharingSpecification',
		),
		'priceCurrency'                           => array(
			'Offer',
			'Ticket',
			'TradeAction',
			'Reservation',
			'DonateAction',
			'PriceSpecification',
		),
		'blogPosts'                               => array(
			'Blog',
		),
		'track'                                   => array(
			'MusicGroup',
			'MusicPlaylist',
		),
		'legislationType'                         => array(
			'Legislation',
		),
		'serviceSmsNumber'                        => array(
			'ServiceChannel',
		),
		'interactionService'                      => array(
			'InteractionCounter',
		),
		'slogan'                                  => array(
			'Brand',
			'Product',
			'Place',
			'Service',
			'Organization',
		),
		'broadcastTimezone'                       => array(
			'BroadcastService',
		),
		'educationalProgramMode'                  => array(
			'EducationalOccupationalProgram',
		),
		'priceType'                               => array(
			'CompoundPriceSpecification',
			'UnitPriceSpecification',
		),
		'labelDetails'                            => array(
			'Drug',
		),
		'endDate'                                 => array(
			'EducationalOccupationalProgram',
			'MerchantReturnPolicySeasonalOverride',
			'CreativeWorkSeason',
			'CreativeWorkSeries',
			'DatedMoneySpecification',
			'Role',
			'Schedule',
			'Event',
		),
		'requiredQuantity'                        => array(
			'HowToItem',
		),
		'eventAttendanceMode'                     => array(
			'Event',
		),
		'seatSection'                             => array(
			'Seat',
		),
		'calories'                                => array(
			'NutritionInformation',
		),
		'hasPart'                                 => array(
			'CreativeWork',
		),
		'transitTime'                             => array(
			'ShippingConditions',
			'ShippingDeliveryTime',
		),
		'floorSize'                               => array(
			'Accommodation',
			'FloorPlan',
		),
		'totalJobOpenings'                        => array(
			'JobPosting',
		),
		'funder'                                  => array(
			'CreativeWork',
			'MonetaryGrant',
			'Person',
			'Organization',
			'Grant',
			'Event',
		),
		'publishedOn'                             => array(
			'PublicationEvent',
		),
		'accessMode'                              => array(
			'CreativeWork',
		),
		'appearance'                              => array(
			'Claim',
		),
		'seasonNumber'                            => array(
			'CreativeWorkSeason',
		),
		'cvdCollectionDate'                       => array(
			'CDCPMDRecord',
		),
		'bookFormat'                              => array(
			'Book',
		),
		'deliveryLeadTime'                        => array(
			'Demand',
			'Offer',
		),
		'returnMethod'                            => array(
			'MerchantReturnPolicySeasonalOverride',
			'MerchantReturnPolicy',
		),
		'representativeOfPage'                    => array(
			'ImageObject',
		),
		'incomeLimit'                             => array(
			'FinancialIncentive',
		),
		'printColumn'                             => array(
			'NewsArticle',
		),
		'inChI'                                   => array(
			'MolecularEntity',
		),
		'toRecipient'                             => array(
			'Message',
		),
		'issueNumber'                             => array(
			'PublicationIssue',
		),
		'yearsInOperation'                        => array(
			'BusinessAudience',
		),
		'pageEnd'                                 => array(
			'PublicationIssue',
			'Article',
			'PublicationVolume',
			'Chapter',
		),
		'productID'                               => array(
			'Product',
		),
		'realEstateAgent'                         => array(
			'RentAction',
		),
		'usesDevice'                              => array(
			'MedicalTest',
		),
		'legislationDateOfApplicability'          => array(
			'Legislation',
		),
		'countryOfLastProcessing'                 => array(
			'Product',
		),
		'schoolClosuresInfo'                      => array(
			'SpecialAnnouncement',
		),
		'duringMedia'                             => array(
			'HowToDirection',
		),
		'providesService'                         => array(
			'ServiceChannel',
		),
		'mobileUrl'                               => array(
			'Product',
			'Offer',
		),
		'actor'                                   => array(
			'VideoGameSeries',
			'Movie',
			'PodcastSeries',
			'Clip',
			'Episode',
			'Event',
			'CreativeWorkSeason',
			'VideoGame',
			'MovieSeries',
			'VideoObject',
			'TVSeries',
			'RadioSeries',
		),
		'geo'                                     => array(
			'Place',
		),
		'maximumVirtualAttendeeCapacity'          => array(
			'Event',
		),
		'constraintProperty'                      => array(
			'ConstraintNode',
		),
		'aggregateRating'                         => array(
			'Service',
			'Offer',
			'Organization',
			'Brand',
			'Product',
			'Event',
			'Place',
			'CreativeWork',
		),
		'isPlanForApartment'                      => array(
			'FloorPlan',
		),
		'cause'                                   => array(
			'MedicalCondition',
		),
		'postalCodeRange'                         => array(
			'DefinedRegion',
		),
		'statType'                                => array(
			'StatisticalVariable',
		),
		'prepTime'                                => array(
			'HowTo',
			'HowToDirection',
		),
		'itemReviewed'                            => array(
			'Review',
			'AggregateRating',
		),
		'itemDefectReturnLabelSource'             => array(
			'MerchantReturnPolicy',
		),
		'holdingArchive'                          => array(
			'ArchiveComponent',
		),
		'smiles'                                  => array(
			'MolecularEntity',
		),
		'eligibilityToWorkRequirement'            => array(
			'JobPosting',
		),
		'measurementTechnique'                    => array(
			'DataDownload',
			'PropertyValue',
			'Observation',
			'StatisticalVariable',
			'Dataset',
			'DataCatalog',
		),
		'illustrator'                             => array(
			'Book',
		),
		'strengthValue'                           => array(
			'DrugStrength',
		),
		'relatedTherapy'                          => array(
			'AnatomicalSystem',
			'SuperficialAnatomy',
			'AnatomicalStructure',
		),
		'namedPosition'                           => array(
			'Role',
		),
		'jobStartDate'                            => array(
			'JobPosting',
		),
		'material'                                => array(
			'CreativeWork',
			'Product',
		),
		'candidate'                               => array(
			'VoteAction',
		),
		'accessibilityControl'                    => array(
			'CreativeWork',
		),
		'arterialBranch'                          => array(
			'Artery',
		),
		'numberOfSeasons'                         => array(
			'VideoGameSeries',
			'TVSeries',
			'RadioSeries',
		),
		'recordedAt'                              => array(
			'CreativeWork',
		),
		'studyDesign'                             => array(
			'MedicalObservationalStudy',
		),
		'bankAccountType'                         => array(
			'BankAccount',
		),
		'trainNumber'                             => array(
			'TrainTrip',
		),
		'clincalPharmacology'                     => array(
			'Drug',
		),
		'authenticator'                           => array(
			'MediaSubscription',
		),
		'serviceOutput'                           => array(
			'Service',
		),
		'productSupported'                        => array(
			'ContactPoint',
		),
		'rangeIncludes'                           => array(
			'Property',
		),
		'recipeInstructions'                      => array(
			'Recipe',
		),
		'bed'                                     => array(
			'HotelRoom',
			'Accommodation',
			'Suite',
		),
		'accelerationTime'                        => array(
			'Vehicle',
		),
		'merchantReturnDays'                      => array(
			'MerchantReturnPolicySeasonalOverride',
			'MerchantReturnPolicy',
		),
		'successorOf'                             => array(
			'ProductModel',
		),
		'applicationStartDate'                    => array(
			'EducationalOccupationalProgram',
		),
		'countryOfAssembly'                       => array(
			'Product',
		),
		'characterAttribute'                      => array(
			'Game',
			'VideoGameSeries',
		),
		'coursePrerequisites'                     => array(
			'Course',
		),
		'dependencies'                            => array(
			'TechArticle',
		),
		'leiCode'                                 => array(
			'Organization',
		),
		'loanPaymentAmount'                       => array(
			'RepaymentSpecification',
		),
		'orderItemStatus'                         => array(
			'OrderItem',
		),
		'evidenceLevel'                           => array(
			'MedicalGuideline',
		),
		'knowsLanguage'                           => array(
			'Organization',
			'Person',
		),
		'maintainer'                              => array(
			'CreativeWork',
		),
		'meetsEmissionStandard'                   => array(
			'Vehicle',
		),
		'playerType'                              => array(
			'MediaObject',
		),
		'populationType'                          => array(
			'StatisticalVariable',
			'StatisticalPopulation',
		),
		'healthPlanCopayOption'                   => array(
			'HealthPlanCostSharingSpecification',
		),
		'timeRequired'                            => array(
			'CreativeWork',
		),
		'assemblyVersion'                         => array(
			'APIReference',
		),
		'tool'                                    => array(
			'HowToDirection',
			'HowTo',
		),
		'sha256'                                  => array(
			'MediaObject',
		),
		'isBasedOn'                               => array(
			'CreativeWork',
		),
		'spokenByCharacter'                       => array(
			'Quotation',
		),
		'downvoteCount'                           => array(
			'Comment',
		),
		'parentService'                           => array(
			'BroadcastService',
		),
		'partOfOrder'                             => array(
			'ParcelDelivery',
		),
		'warning'                                 => array(
			'Drug',
		),
		'dropoffTime'                             => array(
			'RentalCarReservation',
		),
		'legislationJurisdiction'                 => array(
			'Legislation',
		),
		'answerCount'                             => array(
			'Question',
		),
		'yearlyRevenue'                           => array(
			'BusinessAudience',
		),
		'maxPrice'                                => array(
			'PriceSpecification',
		),
		'availableStrength'                       => array(
			'Drug',
		),
		'estimatedFlightDuration'                 => array(
			'Flight',
		),
		'itemShipped'                             => array(
			'ParcelDelivery',
		),
		'lodgingUnitDescription'                  => array(
			'LodgingReservation',
		),
		'playersOnline'                           => array(
			'GameServer',
		),
		'extendedAddress'                         => array(
			'PostalAddress',
		),
		'sugarContent'                            => array(
			'NutritionInformation',
		),
		'gtin14'                                  => array(
			'Offer',
			'Product',
			'Demand',
		),
		'tributary'                               => array(
			'Vein',
		),
		'value'                                   => array(
			'PropertyValue',
			'QuantitativeValue',
			'MonetaryAmount',
		),
		'brand'                                   => array(
			'Product',
			'Service',
			'Person',
			'Organization',
		),
		'streetAddress'                           => array(
			'PostalAddress',
		),
		'codeValue'                               => array(
			'MedicalCode',
			'CategoryCode',
		),
		'identifier'                              => array(
			'Thing',
		),
		'downPayment'                             => array(
			'RepaymentSpecification',
		),
		'skills'                                  => array(
			'Occupation',
			'JobPosting',
			'Person',
			'Organization',
		),
		'cvdNumC19MechVentPats'                   => array(
			'CDCPMDRecord',
		),
		'associatedAnatomy'                       => array(
			'PhysicalActivity',
			'MedicalCondition',
		),
		'editEIDR'                                => array(
			'CreativeWork',
		),
		'unsaturatedFatContent'                   => array(
			'NutritionInformation',
		),
		'returnFees'                              => array(
			'MerchantReturnPolicySeasonalOverride',
			'MerchantReturnPolicy',
		),
		'naics'                                   => array(
			'Person',
			'Organization',
		),
		'firstPerformance'                        => array(
			'MusicComposition',
		),
		'referencesOrder'                         => array(
			'Invoice',
		),
		'departureGate'                           => array(
			'Flight',
		),
		'founder'                                 => array(
			'Organization',
		),
		'expectsAcceptanceOf'                     => array(
			'ConsumeAction',
			'ActionAccessSpecification',
			'MediaSubscription',
		),
		'hasMerchantReturnPolicy'                 => array(
			'Offer',
			'Organization',
			'Product',
		),
		'artworkSurface'                          => array(
			'VisualArtwork',
		),
		'parentOrganization'                      => array(
			'Organization',
		),
		'possibleTreatment'                       => array(
			'MedicalCondition',
			'MedicalSignOrSymptom',
		),
		'inverseOf'                               => array(
			'Property',
		),
		'eligibleWithSupplier'                    => array(
			'FinancialIncentive',
		),
		'seatingCapacity'                         => array(
			'Vehicle',
		),
		'releaseNotes'                            => array(
			'SoftwareApplication',
		),
		'hasAdultConsideration'                   => array(
			'Product',
			'Offer',
		),
		'exerciseType'                            => array(
			'ExerciseAction',
			'ExercisePlan',
		),
		'broadcastFrequencyValue'                 => array(
			'BroadcastFrequencySpecification',
		),
		'originalMediaLink'                       => array(
			'MediaReview',
		),
		'hasMap'                                  => array(
			'Place',
		),
		'orderQuantity'                           => array(
			'OrderItem',
		),
		'areaServed'                              => array(
			'ContactPoint',
			'Offer',
			'Organization',
			'DeliveryChargeSpecification',
			'FinancialIncentive',
			'Demand',
			'Service',
		),
		'artist'                                  => array(
			'VisualArtwork',
			'ComicStory',
			'ComicIssue',
		),
		'object'                                  => array(
			'Action',
		),
		'comprisedOf'                             => array(
			'AnatomicalSystem',
		),
		'customerRemorseReturnFees'               => array(
			'MerchantReturnPolicy',
		),
		'firstAppearance'                         => array(
			'Claim',
		),
		'containedIn'                             => array(
			'Place',
		),
		'globalLocationNumber'                    => array(
			'Place',
			'Person',
			'Organization',
		),
		'handlingTime'                            => array(
			'ShippingDeliveryTime',
			'ShippingService',
		),
		'proprietaryName'                         => array(
			'Drug',
			'DietarySupplement',
		),
		'shippingConditions'                      => array(
			'ShippingService',
		),
		'lyrics'                                  => array(
			'MusicComposition',
		),
		'availableDeliveryMethod'                 => array(
			'Offer',
			'Demand',
		),
		'opponent'                                => array(
			'ExerciseAction',
		),
		'size'                                    => array(
			'Product',
			'CreativeWork',
		),
		'courseSchedule'                          => array(
			'CourseInstance',
		),
		'inventoryLevel'                          => array(
			'Offer',
			'SomeProducts',
			'Demand',
		),
		'insertion'                               => array(
			'Muscle',
		),
		'alignmentType'                           => array(
			'AlignmentObject',
		),
		'printEdition'                            => array(
			'NewsArticle',
		),
		'membershipNumber'                        => array(
			'ProgramMembership',
		),
		'suggestedGender'                         => array(
			'PeopleAudience',
			'SizeSpecification',
		),
		'valueAddedTaxIncluded'                   => array(
			'PriceSpecification',
		),
		'owner'                                   => array(
			'Thing',
		),
		'branch'                                  => array(
			'Nerve',
		),
		'hasVariant'                              => array(
			'ProductGroup',
		),
		'pronouns'                                => array(
			'Person',
		),
		'citation'                                => array(
			'CreativeWork',
		),
		'courseMode'                              => array(
			'CourseInstance',
		),
		'healthPlanNetworkId'                     => array(
			'HealthPlanNetwork',
			'MedicalOrganization',
		),
		'review'                                  => array(
			'CreativeWork',
			'Service',
			'Offer',
			'Organization',
			'Brand',
			'Product',
			'Event',
			'Place',
		),
		'event'                                   => array(
			'JoinAction',
			'InformAction',
			'LeaveAction',
			'InviteAction',
			'Place',
			'Organization',
			'PlayAction',
		),
		'phoneticText'                            => array(
			'PronounceableText',
		),
		'returnShippingFeesAmount'                => array(
			'MerchantReturnPolicySeasonalOverride',
			'MerchantReturnPolicy',
		),
		'governmentBenefitsInfo'                  => array(
			'SpecialAnnouncement',
		),
		'partOfTVSeries'                          => array(
			'TVClip',
			'TVSeason',
			'TVEpisode',
		),
		'addressRegion'                           => array(
			'DefinedRegion',
			'PostalAddress',
		),
		'broadcastSubChannel'                     => array(
			'BroadcastFrequencySpecification',
		),
		'headline'                                => array(
			'CreativeWork',
		),
		'numberOfDoors'                           => array(
			'Vehicle',
		),
		'deathDate'                               => array(
			'Person',
		),
		'employerOverview'                        => array(
			'JobPosting',
		),
		'affiliation'                             => array(
			'Person',
		),
		'interactionStatistic'                    => array(
			'Person',
			'Organization',
			'CreativeWork',
		),
		'acceptsReservations'                     => array(
			'FoodEstablishment',
		),
		'workExample'                             => array(
			'CreativeWork',
		),
		'children'                                => array(
			'Person',
		),
		'touristType'                             => array(
			'TouristDestination',
			'TouristTrip',
			'TouristAttraction',
		),
		'certificationStatus'                     => array(
			'Certification',
		),
		'xpath'                                   => array(
			'SpeakableSpecification',
			'WebPageElement',
		),
		'closes'                                  => array(
			'OpeningHoursSpecification',
		),
		'uploadDate'                              => array(
			'MediaObject',
		),
		'cvdNumICUBeds'                           => array(
			'CDCPMDRecord',
		),
		'iataCode'                                => array(
			'Airport',
			'Airline',
		),
		'gtin8'                                   => array(
			'Product',
			'Demand',
			'Offer',
		),
		'trialDesign'                             => array(
			'MedicalTrial',
		),
		'nutrition'                               => array(
			'Recipe',
			'MenuItem',
		),
		'typeOfGood'                              => array(
			'TypeAndQuantityNode',
			'OwnershipInfo',
		),
		'possibleComplication'                    => array(
			'MedicalCondition',
		),
		'webFeed'                                 => array(
			'PodcastSeries',
			'SpecialAnnouncement',
		),
		'supersededBy'                            => array(
			'Property',
			'Enumeration',
			'Class',
		),
		'sku'                                     => array(
			'Offer',
			'Product',
			'Demand',
		),
		'isLiveBroadcast'                         => array(
			'BroadcastEvent',
		),
		'maxValue'                                => array(
			'QuantitativeValue',
			'PropertyValueSpecification',
			'MonetaryAmount',
			'PropertyValue',
		),
		'tourBookingPage'                         => array(
			'Accommodation',
			'Place',
			'ApartmentComplex',
		),
		'artform'                                 => array(
			'VisualArtwork',
		),
		'unitCode'                                => array(
			'PropertyValue',
			'TypeAndQuantityNode',
			'QuantitativeValue',
			'UnitPriceSpecification',
		),
		'materialExtent'                          => array(
			'CreativeWork',
		),
		'softwareRequirements'                    => array(
			'SoftwareApplication',
		),
		'superEvent'                              => array(
			'Event',
		),
		'expectedArrivalFrom'                     => array(
			'ParcelDelivery',
		),
		'cheatCode'                               => array(
			'VideoGame',
			'VideoGameSeries',
		),
		'domainIncludes'                          => array(
			'Property',
		),
		'distinguishingSign'                      => array(
			'DDxElement',
		),
		'ccRecipient'                             => array(
			'Message',
		),
		'measurementMethod'                       => array(
			'Observation',
			'StatisticalVariable',
			'Dataset',
			'DataCatalog',
			'DataDownload',
			'PropertyValue',
		),
		'employmentUnit'                          => array(
			'JobPosting',
		),
		'recordLabel'                             => array(
			'MusicRelease',
		),
		'legalName'                               => array(
			'Organization',
		),
		'address'                                 => array(
			'Place',
			'Person',
			'Organization',
			'GeoShape',
			'GeoCoordinates',
		),
		'publicTransportClosuresInfo'             => array(
			'SpecialAnnouncement',
		),
		'recipeIngredient'                        => array(
			'Recipe',
		),
		'category'                                => array(
			'Product',
			'PhysicalActivity',
			'Recommendation',
			'Invoice',
			'Offer',
			'Service',
			'ActionAccessSpecification',
			'Guide',
			'SpecialAnnouncement',
		),
		'healthCondition'                         => array(
			'PeopleAudience',
			'Patient',
			'MedicalStudy',
		),
		'membershipPointsEarned'                  => array(
			'ProgramMembership',
			'MemberProgramTier',
			'PriceSpecification',
		),
		'follows'                                 => array(
			'Person',
		),
		'lesserOrEqual'                           => array(
			'QualitativeValue',
		),
		'programmingLanguage'                     => array(
			'SoftwareSourceCode',
		),
		'beneficiaryBank'                         => array(
			'MoneyTransfer',
		),
		'tocContinuation'                         => array(
			'HyperTocEntry',
		),
		'certificationRating'                     => array(
			'Certification',
		),
		'prescribingInfo'                         => array(
			'Drug',
		),
		'hasTierBenefit'                          => array(
			'MemberProgramTier',
		),
		'measurementDenominator'                  => array(
			'Observation',
			'StatisticalVariable',
		),
		'isTierOf'                                => array(
			'MemberProgramTier',
		),
		'spatial'                                 => array(
			'CreativeWork',
		),
		'language'                                => array(
			'WriteAction',
			'CommunicateAction',
		),
		'valueReference'                          => array(
			'PropertyValue',
			'QuantitativeValue',
			'QualitativeValue',
		),
		'carrierRequirements'                     => array(
			'MobileApplication',
		),
		'molecularFormula'                        => array(
			'MolecularEntity',
		),
		'reviewCount'                             => array(
			'AggregateRating',
		),
		'cookingMethod'                           => array(
			'Recipe',
		),
		'courseWorkload'                          => array(
			'CourseInstance',
		),
		'associatedClaimReview'                   => array(
			'Review',
		),
		'releaseOf'                               => array(
			'MusicRelease',
		),
		'videoFormat'                             => array(
			'ScreeningEvent',
			'BroadcastService',
			'BroadcastEvent',
		),
		'homeTeam'                                => array(
			'SportsEvent',
		),
		'cvdNumC19OFMechVentPats'                 => array(
			'CDCPMDRecord',
		),
		'parentTaxon'                             => array(
			'Taxon',
		),
		'elevation'                               => array(
			'GeoShape',
			'GeoCoordinates',
		),
		'marginOfError'                           => array(
			'Observation',
		),
		'gtin13'                                  => array(
			'Product',
			'Demand',
			'Offer',
		),
		'subTrip'                                 => array(
			'Trip',
		),
		'producer'                                => array(
			'CreativeWork',
		),
		'audienceType'                            => array(
			'Audience',
		),
		'cvdNumC19HOPats'                         => array(
			'CDCPMDRecord',
		),
		'procedureType'                           => array(
			'MedicalProcedure',
		),
		'vehicleSpecialUsage'                     => array(
			'Vehicle',
		),
		'safetyConsideration'                     => array(
			'DietarySupplement',
		),
		'offers'                                  => array(
			'Service',
			'MenuItem',
			'Product',
			'AggregateOffer',
			'EducationalOccupationalProgram',
			'Event',
			'Trip',
			'CreativeWork',
		),
		'departureBoatTerminal'                   => array(
			'BoatTrip',
		),
		'mentions'                                => array(
			'CreativeWork',
		),
		'vehicleSeatingCapacity'                  => array(
			'Vehicle',
		),
		'signDetected'                            => array(
			'MedicalTest',
		),
		'acceptedOffer'                           => array(
			'Order',
		),
		'costPerUnit'                             => array(
			'DrugCost',
		),
		'encodings'                               => array(
			'CreativeWork',
		),
		'servicePhone'                            => array(
			'ServiceChannel',
		),
		'albumRelease'                            => array(
			'MusicAlbum',
		),
		'workload'                                => array(
			'ExercisePlan',
		),
		'loanPaymentFrequency'                    => array(
			'RepaymentSpecification',
		),
		'relatedTo'                               => array(
			'Person',
		),
		'valueName'                               => array(
			'PropertyValueSpecification',
		),
		'timeToComplete'                          => array(
			'EducationalOccupationalProgram',
		),
		'customerRemorseReturnShippingFeesAmount' => array(
			'MerchantReturnPolicy',
		),
		'seasonalOverride'                        => array(
			'ShippingConditions',
		),
		'serverStatus'                            => array(
			'GameServer',
		),
		'domiciledMortgage'                       => array(
			'MortgageLoan',
		),
		'study'                                   => array(
			'MedicalEntity',
		),
		'lowPrice'                                => array(
			'AggregateOffer',
		),
		'isFamilyFriendly'                        => array(
			'Offer',
			'Product',
			'CreativeWork',
		),
		'referenceQuantity'                       => array(
			'UnitPriceSpecification',
		),
		'serviceUrl'                              => array(
			'ServiceChannel',
		),
		'mileageFromOdometer'                     => array(
			'Vehicle',
		),
		'riskFactor'                              => array(
			'MedicalCondition',
		),
		'accessibilityFeature'                    => array(
			'CreativeWork',
		),
		'legislationLegalForce'                   => array(
			'Legislation',
		),
		'monthsOfExperience'                      => array(
			'OccupationalExperienceRequirements',
		),
		'secondaryPrevention'                     => array(
			'MedicalCondition',
		),
		'addressLocality'                         => array(
			'PostalAddress',
		),
		'datasetTimeInterval'                     => array(
			'Dataset',
		),
		'jobImmediateStart'                       => array(
			'JobPosting',
		),
		'claimReviewed'                           => array(
			'ClaimReview',
		),
		'nationality'                             => array(
			'Person',
		),
		'termsOfService'                          => array(
			'Service',
		),
		'step'                                    => array(
			'HowTo',
		),
		'containsPlace'                           => array(
			'Place',
		),
		'memberOf'                                => array(
			'Person',
			'Organization',
		),
		'suggestedAnswer'                         => array(
			'Question',
		),
		'bookingTime'                             => array(
			'Reservation',
		),
		'gameServer'                              => array(
			'VideoGame',
		),
		'videoFrameSize'                          => array(
			'VideoObject',
		),
		'code'                                    => array(
			'MedicalEntity',
		),
		'dateIssued'                              => array(
			'Ticket',
		),
		'version'                                 => array(
			'CreativeWork',
		),
		'availableFrom'                           => array(
			'DeliveryEvent',
		),
		'employmentType'                          => array(
			'JobPosting',
		),
		'actionableFeedbackPolicy'                => array(
			'NewsMediaOrganization',
			'Organization',
		),
		'floorLimit'                              => array(
			'PaymentCard',
		),
		'numberOfBeds'                            => array(
			'BedDetails',
		),
		'purchaseDate'                            => array(
			'Vehicle',
			'Product',
		),
		'originalMediaContextDescription'         => array(
			'MediaReview',
		),
		'multipleValues'                          => array(
			'PropertyValueSpecification',
		),
		'video'                                   => array(
			'CreativeWork',
		),
		'events'                                  => array(
			'Place',
			'Organization',
		),
		'contactlessPayment'                      => array(
			'PaymentCard',
		),
		'recordedIn'                              => array(
			'Event',
		),
		'flightNumber'                            => array(
			'Flight',
		),
		'itemDefectReturnShippingFeesAmount'      => array(
			'MerchantReturnPolicy',
		),
		'remainingAttendeeCapacity'               => array(
			'Event',
		),
		'hasTiers'                                => array(
			'MemberProgram',
		),
		'birthDate'                               => array(
			'Person',
		),
		'ineligibleRegion'                        => array(
			'MediaObject',
			'Demand',
			'ActionAccessSpecification',
			'Offer',
			'DeliveryChargeSpecification',
		),
		'blogPost'                                => array(
			'Blog',
		),
		'arrivalBoatTerminal'                     => array(
			'BoatTrip',
		),
		'permittedUsage'                          => array(
			'Accommodation',
		),
		'hasEnergyConsumptionDetails'             => array(
			'Product',
		),
		'endorsers'                               => array(
			'Diet',
		),
		'purchaseType'                            => array(
			'FinancialIncentive',
		),
		'operatingSystem'                         => array(
			'SoftwareApplication',
		),
		'referee'                                 => array(
			'SportsEvent',
		),
		'merchant'                                => array(
			'Order',
		),
		'applicationDeadline'                     => array(
			'EducationalOccupationalProgram',
		),
		'gameEdition'                             => array(
			'VideoGame',
		),
		'relatedAnatomy'                          => array(
			'SuperficialAnatomy',
		),
		'permissionType'                          => array(
			'DigitalDocumentPermission',
		),
		'replacer'                                => array(
			'ReplaceAction',
		),
		'associatedDisease'                       => array(
			'BioChemEntity',
		),
		'hospitalAffiliation'                     => array(
			'Physician',
		),
		'softwareVersion'                         => array(
			'SoftwareApplication',
		),
		'accountId'                               => array(
			'Invoice',
		),
		'availableOnDevice'                       => array(
			'SoftwareApplication',
		),
		'embedUrl'                                => array(
			'MediaObject',
		),
		'workPerformed'                           => array(
			'Event',
		),
		'opens'                                   => array(
			'OpeningHoursSpecification',
		),
		'musicArrangement'                        => array(
			'MusicComposition',
		),
		'postOp'                                  => array(
			'MedicalDevice',
		),
		'feesAndCommissionsSpecification'         => array(
			'FinancialProduct',
			'FinancialService',
		),
		'author'                                  => array(
			'CreativeWork',
			'Rating',
		),
		'actionOption'                            => array(
			'ChooseAction',
		),
		'percentile10'                            => array(
			'QuantitativeValueDistribution',
		),
		'item'                                    => array(
			'ListItem',
			'DataFeedItem',
		),
		'postOfficeBoxNumber'                     => array(
			'PostalAddress',
		),
		'hasBioPolymerSequence'                   => array(
			'Gene',
			'Protein',
		),
		'requiredMinAge'                          => array(
			'PeopleAudience',
		),
		'contentSize'                             => array(
			'MediaObject',
		),
		'validFrom'                               => array(
			'FinancialIncentive',
			'PriceSpecification',
			'Demand',
			'LocationFeatureSpecification',
			'Permit',
			'Offer',
			'OpeningHoursSpecification',
			'MonetaryAmount',
			'Certification',
		),
		'comment'                                 => array(
			'RsvpAction',
			'CreativeWork',
		),
		'userInteractionCount'                    => array(
			'InteractionCounter',
		),
		'attendee'                                => array(
			'Event',
		),
		'nerve'                                   => array(
			'Muscle',
		),
		'contentRating'                           => array(
			'CreativeWork',
		),
		'subStructure'                            => array(
			'AnatomicalStructure',
		),
		'passengerPriorityStatus'                 => array(
			'FlightReservation',
		),
		'priceComponent'                          => array(
			'CompoundPriceSpecification',
		),
		'postalCodeBegin'                         => array(
			'PostalCodeRangeSpecification',
		),
		'incentiveCompensation'                   => array(
			'JobPosting',
		),
		'fuelCapacity'                            => array(
			'Vehicle',
		),
		'leaseLength'                             => array(
			'Offer',
			'RealEstateListing',
			'Accommodation',
		),
		'trailerWeight'                           => array(
			'Vehicle',
		),
		'hasBioChemEntityPart'                    => array(
			'BioChemEntity',
		),
		'branchOf'                                => array(
			'LocalBusiness',
		),
		'contactPoint'                            => array(
			'HealthInsurancePlan',
			'Organization',
			'Person',
		),
		'drainsTo'                                => array(
			'Vein',
		),
		'collection'                              => array(
			'UpdateAction',
		),
		'positiveNotes'                           => array(
			'Product',
			'Review',
		),
		'containedInPlace'                        => array(
			'Place',
		),
		'accommodationCategory'                   => array(
			'Accommodation',
		),
		'dateline'                                => array(
			'NewsArticle',
		),
		'competencyRequired'                      => array(
			'LearningResource',
			'EducationalOccupationalCredential',
		),
		'iupacName'                               => array(
			'MolecularEntity',
		),
		'carrier'                                 => array(
			'ParcelDelivery',
			'Flight',
		),
		'actionStatus'                            => array(
			'Action',
		),
		'dosageForm'                              => array(
			'Drug',
		),
		'reviewAspect'                            => array(
			'Guide',
			'Rating',
			'Review',
		),
		'inBroadcastLineup'                       => array(
			'BroadcastChannel',
		),
		'typeOfBed'                               => array(
			'BedDetails',
		),
		'processingTime'                          => array(
			'ServiceChannel',
		),
		'subjectOf'                               => array(
			'Thing',
		),
		'foodEvent'                               => array(
			'CookAction',
		),
		'relatedDrug'                             => array(
			'Drug',
		),
		'encodesBioChemEntity'                    => array(
			'Gene',
		),
		'naturalProgression'                      => array(
			'MedicalCondition',
		),
		'healthPlanCostSharing'                   => array(
			'HealthPlanFormulary',
			'HealthPlanNetwork',
		),
		'significance'                            => array(
			'SuperficialAnatomy',
		),
		'manufacturer'                            => array(
			'Product',
		),
		'lodgingUnitType'                         => array(
			'LodgingReservation',
		),
		'trainingSalary'                          => array(
			'EducationalOccupationalProgram',
			'WorkBasedProgram',
		),
		'recourseLoan'                            => array(
			'LoanOrCredit',
		),
		'eligibleCustomerType'                    => array(
			'Demand',
			'Offer',
		),
		'sdLicense'                               => array(
			'CreativeWork',
		),
		'shippingDestination'                     => array(
			'OfferShippingDetails',
			'ShippingConditions',
			'ShippingRateSettings',
			'DeliveryTimeSettings',
		),
		'orderDate'                               => array(
			'Order',
		),
		'isInvolvedInBiologicalProcess'           => array(
			'BioChemEntity',
		),
		'employees'                               => array(
			'Organization',
		),
		'incentivizedItem'                        => array(
			'FinancialIncentive',
		),
		'programmingModel'                        => array(
			'APIReference',
		),
		'contentReferenceTime'                    => array(
			'CreativeWork',
		),
		'agent'                                   => array(
			'Action',
		),
		'recognizedBy'                            => array(
			'EducationalOccupationalCredential',
		),
		'validForMemberTier'                      => array(
			'MerchantReturnPolicy',
			'Offer',
			'OfferShippingDetails',
			'ShippingService',
			'PriceSpecification',
		),
		'contentLocation'                         => array(
			'CreativeWork',
		),
		'hasBroadcastChannel'                     => array(
			'BroadcastService',
		),
		'albums'                                  => array(
			'MusicGroup',
		),
		'accountOverdraftLimit'                   => array(
			'BankAccount',
		),
		'colorSwatch'                             => array(
			'Product',
		),
		'educationalFramework'                    => array(
			'AlignmentObject',
		),
		'dateReceived'                            => array(
			'Message',
		),
		'sodiumContent'                           => array(
			'NutritionInformation',
		),
		'caption'                                 => array(
			'ImageObject',
			'VideoObject',
			'AudioObject',
		),
		'quarantineGuidelines'                    => array(
			'SpecialAnnouncement',
		),
		'codeRepository'                          => array(
			'SoftwareSourceCode',
		),
		'modelDate'                               => array(
			'Vehicle',
		),
		'priceComponentType'                      => array(
			'UnitPriceSpecification',
		),
		'datePublished'                           => array(
			'Certification',
			'CreativeWork',
		),
		'arrivalPlatform'                         => array(
			'TrainTrip',
		),
		'sdPublisher'                             => array(
			'CreativeWork',
		),
		'openingHours'                            => array(
			'CivicStructure',
			'LocalBusiness',
		),
		'tongueWeight'                            => array(
			'Vehicle',
		),
		'occupationalCredentialAwarded'           => array(
			'Course',
			'EducationalOccupationalProgram',
		),
		'episode'                                 => array(
			'TVSeries',
			'RadioSeries',
			'VideoGameSeries',
			'CreativeWorkSeason',
		),
		'bioChemInteraction'                      => array(
			'BioChemEntity',
		),
		'programMembershipUsed'                   => array(
			'Reservation',
		),
		'ethicsPolicy'                            => array(
			'Organization',
			'NewsMediaOrganization',
		),
		'suitableForDiet'                         => array(
			'MenuItem',
			'Recipe',
		),
		'area'                                    => array(
			'BroadcastService',
		),
		'suggestedMaxAge'                         => array(
			'PeopleAudience',
		),
		'pathophysiology'                         => array(
			'PhysicalActivity',
			'MedicalCondition',
		),
		'surface'                                 => array(
			'VisualArtwork',
		),
		'identifyingTest'                         => array(
			'MedicalSign',
		),
		'geoMidpoint'                             => array(
			'GeoCircle',
		),
		'numberOfAvailableAccommodationUnits'     => array(
			'ApartmentComplex',
			'FloorPlan',
		),
		'expertConsiderations'                    => array(
			'Diet',
		),
		'affectedBy'                              => array(
			'MedicalTest',
		),
		'alternativeHeadline'                     => array(
			'CreativeWork',
		),
		'lyricist'                                => array(
			'MusicComposition',
		),
		'permitAudience'                          => array(
			'Permit',
		),
		'repeatFrequency'                         => array(
			'Schedule',
		),
		'recipe'                                  => array(
			'CookAction',
		),
		'applicableLocation'                      => array(
			'DrugLegalStatus',
			'DrugCost',
		),
		'reservationId'                           => array(
			'Reservation',
		),
		'requiredMaxAge'                          => array(
			'PeopleAudience',
		),
		'supportingData'                          => array(
			'SoftwareApplication',
		),
		'percentile75'                            => array(
			'QuantitativeValueDistribution',
		),
		'geoEquals'                               => array(
			'Place',
			'GeospatialGeometry',
		),
		'mechanismOfAction'                       => array(
			'DietarySupplement',
			'Drug',
		),
		'rxcui'                                   => array(
			'Drug',
		),
		'salaryCurrency'                          => array(
			'JobPosting',
			'EmployeeRole',
		),
		'ticketToken'                             => array(
			'Ticket',
		),
		'hasParticipationOffer'                   => array(
			'Event',
		),
		'isbn'                                    => array(
			'Book',
		),
		'grantee'                                 => array(
			'DigitalDocumentPermission',
		),
		'abstract'                                => array(
			'CreativeWork',
		),
		'vehicleIdentificationNumber'             => array(
			'Vehicle',
		),
		'orderStatus'                             => array(
			'Order',
		),
		'geographicArea'                          => array(
			'Audience',
		),
		'publisherImprint'                        => array(
			'CreativeWork',
		),
		'encodingFormat'                          => array(
			'CreativeWork',
			'MediaObject',
		),
		'inLanguage'                              => array(
			'BroadcastService',
			'CommunicateAction',
			'LinkRole',
			'Event',
			'CreativeWork',
			'PronounceableText',
			'WriteAction',
		),
		'loanRepaymentForm'                       => array(
			'LoanOrCredit',
		),
		'healthPlanPharmacyCategory'              => array(
			'HealthPlanCostSharingSpecification',
		),
		'biomechnicalClass'                       => array(
			'Joint',
		),
		'acceptedAnswer'                          => array(
			'Question',
		),
		'trainName'                               => array(
			'TrainTrip',
		),
		'accessCode'                              => array(
			'DeliveryEvent',
		),
		'produces'                                => array(
			'Service',
		),
		'mainEntityOfPage'                        => array(
			'Thing',
		),
		'ticketNumber'                            => array(
			'Ticket',
		),
		'arrivalStation'                          => array(
			'TrainTrip',
		),
		'dietFeatures'                            => array(
			'Diet',
		),
		'layoutImage'                             => array(
			'FloorPlan',
		),
		'significantLink'                         => array(
			'WebPage',
		),
		'game'                                    => array(
			'GameServer',
		),
		'dateCreated'                             => array(
			'DataFeedItem',
			'CreativeWork',
		),
		'benefitsSummaryUrl'                      => array(
			'HealthInsurancePlan',
		),
		'albumReleaseType'                        => array(
			'MusicAlbum',
		),
		'archiveHeld'                             => array(
			'ArchiveOrganization',
		),
		'hasCertification'                        => array(
			'Place',
			'Service',
			'Person',
			'Organization',
			'Product',
		),
		'seller'                                  => array(
			'Offer',
			'BuyAction',
			'Flight',
			'Order',
			'Demand',
		),
		'negativeNotes'                           => array(
			'Product',
			'Review',
		),
		'increasesRiskOf'                         => array(
			'MedicalRiskFactor',
		),
		'yield'                                   => array(
			'HowTo',
		),
		'hasDriveThroughService'                  => array(
			'Place',
		),
		'includesAttraction'                      => array(
			'TouristDestination',
		),
		'restockingFee'                           => array(
			'MerchantReturnPolicySeasonalOverride',
			'MerchantReturnPolicy',
		),
		'numberOfPreviousOwners'                  => array(
			'Vehicle',
		),
		'typicalCreditsPerTerm'                   => array(
			'EducationalOccupationalProgram',
		),
		'wheelbase'                               => array(
			'Vehicle',
		),
		'legislationDateVersion'                  => array(
			'Legislation',
		),
		'accommodationFloorPlan'                  => array(
			'Accommodation',
			'Residence',
		),
		'subEvents'                               => array(
			'Event',
		),
		'fromLocation'                            => array(
			'MoveAction',
			'TransferAction',
			'ExerciseAction',
		),
		'additionalProperty'                      => array(
			'MerchantReturnPolicy',
			'Offer',
			'QuantitativeValue',
			'Product',
			'QualitativeValue',
			'Place',
		),
		'broadcastServiceTier'                    => array(
			'BroadcastChannel',
		),
		'numberOfEmployees'                       => array(
			'Organization',
			'BusinessAudience',
		),
		'renegotiableLoan'                        => array(
			'LoanOrCredit',
		),
		'torque'                                  => array(
			'EngineSpecification',
		),
		'sourceOrganization'                      => array(
			'CreativeWork',
		),
		'depth'                                   => array(
			'OfferShippingDetails',
			'VisualArtwork',
			'ShippingConditions',
			'Product',
		),
		'runsTo'                                  => array(
			'LymphaticVessel',
		),
		'roleName'                                => array(
			'Role',
		),
		'audio'                                   => array(
			'CreativeWork',
		),
		'usedToDiagnose'                          => array(
			'MedicalTest',
		),
		'isPartOfBioChemEntity'                   => array(
			'BioChemEntity',
		),
		'composer'                                => array(
			'MusicComposition',
			'Event',
		),
		'monoisotopicMolecularWeight'             => array(
			'MolecularEntity',
		),
		'targetDescription'                       => array(
			'AlignmentObject',
		),
		'expressedIn'                             => array(
			'Gene',
		),
		'workHours'                               => array(
			'JobPosting',
		),
		'targetPopulation'                        => array(
			'DietarySupplement',
			'DoseSchedule',
		),
		'distance'                                => array(
			'ExerciseAction',
			'TravelAction',
		),
		'availableLanguage'                       => array(
			'LodgingBusiness',
			'TouristAttraction',
			'ServiceChannel',
			'ContactPoint',
			'Course',
		),
		'serviceType'                             => array(
			'Service',
		),
		'expectedArrivalUntil'                    => array(
			'ParcelDelivery',
		),
		'issuedThrough'                           => array(
			'Permit',
		),
		'healthPlanCopay'                         => array(
			'HealthPlanCostSharingSpecification',
		),
		'appliesToDeliveryMethod'                 => array(
			'DeliveryChargeSpecification',
			'PaymentChargeSpecification',
		),
		'answerExplanation'                       => array(
			'Answer',
		),
		'eventStatus'                             => array(
			'Event',
		),
		'seriousAdverseOutcome'                   => array(
			'MedicalDevice',
			'MedicalTherapy',
		),
		'subEvent'                                => array(
			'Event',
		),
		'legislationRepeals'                      => array(
			'Legislation',
		),
		'mainContentOfPage'                       => array(
			'WebPage',
		),
		'followup'                                => array(
			'MedicalProcedure',
		),
		'occupationalCategory'                    => array(
			'Physician',
			'JobPosting',
			'Occupation',
			'EducationalOccupationalProgram',
			'WorkBasedProgram',
		),
		'paymentMethodType'                       => array(
			'PaymentMethod',
		),
		'arrivalTerminal'                         => array(
			'Flight',
		),
		'preOp'                                   => array(
			'MedicalDevice',
		),
		'inProductGroupWithID'                    => array(
			'Product',
		),
		'securityScreening'                       => array(
			'FlightReservation',
		),
		'quest'                                   => array(
			'Game',
			'VideoGameSeries',
		),
		'learningResourceType'                    => array(
			'CreativeWork',
			'LearningResource',
		),
		'minValue'                                => array(
			'PropertyValue',
			'QuantitativeValue',
			'PropertyValueSpecification',
			'MonetaryAmount',
		),
		'resultReview'                            => array(
			'ReviewAction',
		),
		'circle'                                  => array(
			'GeoShape',
		),
		'creativeWorkStatus'                      => array(
			'CreativeWork',
		),
		'potentialUse'                            => array(
			'ChemicalSubstance',
			'MolecularEntity',
		),
		'hasDigitalDocumentPermission'            => array(
			'DigitalDocument',
		),
		'audience'                                => array(
			'Service',
			'PlayAction',
			'LodgingBusiness',
			'Product',
			'Event',
			'CreativeWork',
		),
		'dayOfWeek'                               => array(
			'EducationalOccupationalProgram',
			'OpeningHoursSpecification',
		),
		'startDate'                               => array(
			'MerchantReturnPolicySeasonalOverride',
			'CreativeWorkSeason',
			'CreativeWorkSeries',
			'Role',
			'DatedMoneySpecification',
			'Schedule',
			'EducationalOccupationalProgram',
			'Event',
		),
		'gettingTestedInfo'                       => array(
			'SpecialAnnouncement',
		),
		'iso6523Code'                             => array(
			'Organization',
		),
		'vehicleEngine'                           => array(
			'Vehicle',
		),
		'cvdNumC19Died'                           => array(
			'CDCPMDRecord',
		),
		'breastfeedingWarning'                    => array(
			'Drug',
		),
		'sharedContent'                           => array(
			'Comment',
			'SocialMediaPosting',
		),
		'typicalTest'                             => array(
			'MedicalCondition',
		),
		'auditDate'                               => array(
			'Certification',
		),
		'byDay'                                   => array(
			'Schedule',
		),
		'guidelineDate'                           => array(
			'MedicalGuideline',
		),
		'birthPlace'                              => array(
			'Person',
		),
		'intensity'                               => array(
			'ExercisePlan',
		),
		'serviceArea'                             => array(
			'Organization',
			'ContactPoint',
			'Service',
		),
		'trailer'                                 => array(
			'Movie',
			'VideoGameSeries',
			'Episode',
			'CreativeWorkSeason',
			'VideoGame',
			'MovieSeries',
			'TVSeries',
			'RadioSeries',
		),
		'supply'                                  => array(
			'HowTo',
			'HowToDirection',
		),
		'correctionsPolicy'                       => array(
			'NewsMediaOrganization',
			'Organization',
		),
		'locationCreated'                         => array(
			'CreativeWork',
		),
		'ingredients'                             => array(
			'Recipe',
		),
		'returnLabelSource'                       => array(
			'MerchantReturnPolicy',
		),
		'fiberContent'                            => array(
			'NutritionInformation',
		),
		'acceptedPaymentMethod'                   => array(
			'Demand',
			'Offer',
			'Organization',
		),
		'broadcastFrequency'                      => array(
			'BroadcastService',
			'BroadcastChannel',
		),
		'byMonthWeek'                             => array(
			'Schedule',
		),
		'itemOffered'                             => array(
			'Demand',
			'Offer',
		),
		'legislationEnsuresImplementationOf'      => array(
			'Legislation',
		),
		'legalStatus'                             => array(
			'MedicalEntity',
			'Drug',
			'DietarySupplement',
		),
		'performer'                               => array(
			'Event',
		),
		'line'                                    => array(
			'GeoShape',
		),
		'numChildren'                             => array(
			'LodgingReservation',
		),
		'transFatContent'                         => array(
			'NutritionInformation',
		),
		'recipient'                               => array(
			'GiveAction',
			'TipAction',
			'Message',
			'PayAction',
			'SendAction',
			'AuthorizeAction',
			'DonateAction',
			'ReturnAction',
			'CommunicateAction',
		),
		'availability'                            => array(
			'Demand',
			'Offer',
		),
		'repetitions'                             => array(
			'ExercisePlan',
		),
		'billingPeriod'                           => array(
			'Invoice',
		),
		'diseaseSpreadStatistics'                 => array(
			'SpecialAnnouncement',
		),
		'workTranslation'                         => array(
			'CreativeWork',
		),
		'loanTerm'                                => array(
			'LoanOrCredit',
		),
		'albumProductionType'                     => array(
			'MusicAlbum',
		),
		'volumeNumber'                            => array(
			'PublicationVolume',
		),
		'liveBlogUpdate'                          => array(
			'LiveBlogPosting',
		),
		'loanMortgageMandateAmount'               => array(
			'MortgageLoan',
		),
		'typicalAgeRange'                         => array(
			'CreativeWork',
			'Event',
		),
		'returnPolicyCategory'                    => array(
			'MerchantReturnPolicySeasonalOverride',
			'MerchantReturnPolicy',
		),
		'isResizable'                             => array(
			'3DModel',
		),
		'underName'                               => array(
			'Ticket',
			'Reservation',
		),
		'recommendationStrength'                  => array(
			'MedicalGuidelineRecommendation',
		),
		'contentType'                             => array(
			'EntryPoint',
		),
		'jobBenefits'                             => array(
			'JobPosting',
		),
		'isicV4'                                  => array(
			'Place',
			'Person',
			'Organization',
		),
		'scheduleTimezone'                        => array(
			'Schedule',
		),
		'recordingOf'                             => array(
			'MusicRecording',
		),
		'deliveryMethod'                          => array(
			'SendAction',
			'ReceiveAction',
			'OrderAction',
			'TrackAction',
		),
		'jobLocation'                             => array(
			'JobPosting',
		),
		'costOrigin'                              => array(
			'DrugCost',
		),
		'departureAirport'                        => array(
			'Flight',
		),
		'awayTeam'                                => array(
			'SportsEvent',
		),
		'medicalAudience'                         => array(
			'MedicalWebPage',
		),
		'option'                                  => array(
			'ChooseAction',
		),
		'season'                                  => array(
			'TVSeries',
			'RadioSeries',
			'VideoGameSeries',
		),
		'healthPlanCoinsuranceRate'               => array(
			'HealthPlanCostSharingSpecification',
		),
		'departurePlatform'                       => array(
			'TrainTrip',
		),
		'bodyType'                                => array(
			'Vehicle',
		),
		'childMinAge'                             => array(
			'ParentAudience',
		),
		'timestamp'                               => array(
			'InstantaneousEvent',
		),
		'equal'                                   => array(
			'QualitativeValue',
		),
		'iswcCode'                                => array(
			'MusicComposition',
		),
		'relevantOccupation'                      => array(
			'JobPosting',
		),
		'ownedFrom'                               => array(
			'OwnershipInfo',
		),
		'highPrice'                               => array(
			'AggregateOffer',
		),
		'validUntil'                              => array(
			'Permit',
		),
		'postalCodeEnd'                           => array(
			'PostalCodeRangeSpecification',
		),
		'saturatedFatContent'                     => array(
			'NutritionInformation',
		),
		'observationAbout'                        => array(
			'Observation',
		),
		'servingSize'                             => array(
			'NutritionInformation',
		),
		'courseCode'                              => array(
			'Course',
		),
		'measurementQualifier'                    => array(
			'Observation',
			'StatisticalVariable',
		),
		'identifyingExam'                         => array(
			'MedicalSign',
		),
		'creator'                                 => array(
			'UserComments',
			'CreativeWork',
		),
		'checkinTime'                             => array(
			'LodgingBusiness',
			'LodgingReservation',
		),
		'color'                                   => array(
			'Product',
		),
		'cvdNumVent'                              => array(
			'CDCPMDRecord',
		),
		'broadcaster'                             => array(
			'BroadcastService',
		),
		'discount'                                => array(
			'Order',
		),
		'numberOfAirbags'                         => array(
			'Vehicle',
		),
		'isBasedOnUrl'                            => array(
			'CreativeWork',
		),
		'percentile90'                            => array(
			'QuantitativeValueDistribution',
		),
		'reviewedBy'                              => array(
			'WebPage',
		),
		'associatedMediaReview'                   => array(
			'Review',
		),
		'suggestedAge'                            => array(
			'PeopleAudience',
			'SizeSpecification',
		),
		'measuredProperty'                        => array(
			'Observation',
			'StatisticalVariable',
		),
		'publicationType'                         => array(
			'MedicalScholarlyArticle',
		),
		'deliveryAddress'                         => array(
			'ParcelDelivery',
		),
		'includesObject'                          => array(
			'Offer',
			'ProductCollection',
			'Demand',
		),
		'ownedThrough'                            => array(
			'OwnershipInfo',
		),
		'returnPolicySeasonalOverride'            => array(
			'MerchantReturnPolicy',
		),
		'dateRead'                                => array(
			'Message',
		),
		'fileFormat'                              => array(
			'CreativeWork',
		),
		'titleEIDR'                               => array(
			'TVSeries',
			'TVSeason',
			'Movie',
			'TVEpisode',
		),
		'itemCondition'                           => array(
			'Product',
			'Demand',
			'Offer',
			'MerchantReturnPolicy',
		),
		'bodyLocation'                            => array(
			'MedicalProcedure',
			'AnatomicalStructure',
		),
		'encoding'                                => array(
			'CreativeWork',
		),
		'releasedEvent'                           => array(
			'CreativeWork',
		),
		'accountablePerson'                       => array(
			'CreativeWork',
		),
		'musicCompositionForm'                    => array(
			'MusicComposition',
		),
		'steps'                                   => array(
			'HowToSection',
			'HowTo',
		),
		'educationalUse'                          => array(
			'CreativeWork',
			'LearningResource',
		),
		'subtitleLanguage'                        => array(
			'Movie',
			'TVEpisode',
			'BroadcastEvent',
			'ScreeningEvent',
		),
		'chemicalComposition'                     => array(
			'ChemicalSubstance',
		),
		'department'                              => array(
			'Organization',
		),
		'playMode'                                => array(
			'VideoGameSeries',
			'VideoGame',
		),
		'ticketedSeat'                            => array(
			'Ticket',
		),
		'percentile25'                            => array(
			'QuantitativeValueDistribution',
		),
		'availableChannel'                        => array(
			'Service',
		),
		'sizeGroup'                               => array(
			'SizeSpecification',
		),
		'costCategory'                            => array(
			'DrugCost',
		),
		'cargoVolume'                             => array(
			'Vehicle',
		),
		'greaterOrEqual'                          => array(
			'QualitativeValue',
		),
		'legalRepresentative'                     => array(
			'Organization',
		),
		'accountMinimumInflow'                    => array(
			'BankAccount',
		),
		'flightDistance'                          => array(
			'Flight',
		),
		'bioChemSimilarity'                       => array(
			'BioChemEntity',
		),
		'regionsAllowed'                          => array(
			'MediaObject',
		),
		'occupancy'                               => array(
			'Accommodation',
			'Suite',
			'SingleFamilyResidence',
			'HotelRoom',
			'Apartment',
		),
		'physicalRequirement'                     => array(
			'JobPosting',
		),
		'isAcceptingNewPatients'                  => array(
			'MedicalOrganization',
		),
		'productionDate'                          => array(
			'Vehicle',
			'Product',
		),
		'fuelConsumption'                         => array(
			'Vehicle',
		),
		'sportsActivityLocation'                  => array(
			'ExerciseAction',
		),
		'activityFrequency'                       => array(
			'ExercisePlan',
		),
		'foundingLocation'                        => array(
			'Organization',
		),
		'schemaVersion'                           => array(
			'CreativeWork',
		),
		'companyRegistration'                     => array(
			'Organization',
		),
		'businessFunction'                        => array(
			'Demand',
			'Offer',
			'TypeAndQuantityNode',
		),
		'minimumPaymentDue'                       => array(
			'Invoice',
		),
		'durationOfWarranty'                      => array(
			'WarrantyPromise',
		),
		'workFeatured'                            => array(
			'Event',
		),
		'codeSampleType'                          => array(
			'SoftwareSourceCode',
		),
		'acquiredFrom'                            => array(
			'OwnershipInfo',
		),
		'dateVehicleFirstRegistered'              => array(
			'Vehicle',
		),
		'hasMemberProgram'                        => array(
			'Organization',
		),
		'member'                                  => array(
			'ProgramMembership',
			'Organization',
		),
		'catalogNumber'                           => array(
			'MusicRelease',
		),
		'potentialAction'                         => array(
			'Thing',
		),
		'jurisdiction'                            => array(
			'Legislation',
			'GovernmentService',
		),
		'isUnlabelledFallback'                    => array(
			'ShippingRateSettings',
			'DeliveryTimeSettings',
		),
		'dateDeleted'                             => array(
			'DataFeedItem',
		),
		'tocEntry'                                => array(
			'HyperToc',
		),
		'adverseOutcome'                          => array(
			'TherapeuticProcedure',
			'MedicalDevice',
		),
		'accessibilityHazard'                     => array(
			'CreativeWork',
		),
		'correction'                              => array(
			'CreativeWork',
		),
		'recipeYield'                             => array(
			'Recipe',
		),
		'sport'                                   => array(
			'SportsOrganization',
			'SportsEvent',
		),
		'appliesToPaymentMethod'                  => array(
			'PaymentChargeSpecification',
		),
		'pageStart'                               => array(
			'PublicationIssue',
			'Article',
			'PublicationVolume',
			'Chapter',
		),
		'episodeNumber'                           => array(
			'Episode',
		),
		'fulfillmentType'                         => array(
			'ShippingService',
		),
		'advanceBookingRequirement'               => array(
			'Demand',
			'Offer',
		),
		'doseValue'                               => array(
			'DoseSchedule',
		),
		'hasOccupation'                           => array(
			'Person',
		),
		'differentialDiagnosis'                   => array(
			'MedicalCondition',
		),
		'printSection'                            => array(
			'NewsArticle',
		),
		'menu'                                    => array(
			'FoodEstablishment',
		),
		'doesNotShip'                             => array(
			'ShippingRateSettings',
			'OfferShippingDetails',
			'ShippingConditions',
		),
		'functionalClass'                         => array(
			'Joint',
		),
		'drugClass'                               => array(
			'Drug',
		),
		'legislationCountersignedBy'              => array(
			'Legislation',
		),
		'geoDisjoint'                             => array(
			'GeospatialGeometry',
			'Place',
		),
		'colleague'                               => array(
			'Person',
		),
		'doorTime'                                => array(
			'Event',
		),
		'menuAddOn'                               => array(
			'MenuItem',
		),
		'collectionSize'                          => array(
			'Collection',
		),
		'arrivalAirport'                          => array(
			'Flight',
		),
		'buyer'                                   => array(
			'SellAction',
		),
		'musicGroupMember'                        => array(
			'MusicGroup',
		),
		'proteinContent'                          => array(
			'NutritionInformation',
		),
		'travelBans'                              => array(
			'SpecialAnnouncement',
		),
		'lifeEvent'                               => array(
			'Person',
		),
		'rsvpResponse'                            => array(
			'RsvpAction',
		),
		'documentation'                           => array(
			'WebAPI',
		),
		'partOfSystem'                            => array(
			'AnatomicalStructure',
		),
		'actionApplication'                       => array(
			'EntryPoint',
		),
		'isVariantOf'                             => array(
			'Product',
			'ProductModel',
		),
		'bloodSupply'                             => array(
			'Muscle',
		),
		'studyLocation'                           => array(
			'MedicalStudy',
		),
		'itemListElement'                         => array(
			'ItemList',
		),
		'unitText'                                => array(
			'UnitPriceSpecification',
			'PropertyValue',
			'TypeAndQuantityNode',
			'QuantitativeValue',
		),
		'legislationCorrects'                     => array(
			'Legislation',
		),
		'album'                                   => array(
			'MusicGroup',
		),
		'longitude'                               => array(
			'GeoCoordinates',
			'Place',
		),
		'honorificSuffix'                         => array(
			'Person',
		),
		'contactOption'                           => array(
			'ContactPoint',
		),
		'inStoreReturnsOffered'                   => array(
			'MerchantReturnPolicy',
		),
		'minPrice'                                => array(
			'PriceSpecification',
		),
		'geoIntersects'                           => array(
			'GeospatialGeometry',
			'Place',
		),
		'urlTemplate'                             => array(
			'EntryPoint',
		),
		'healthPlanMarketingUrl'                  => array(
			'HealthInsurancePlan',
		),
		'cvdNumVentUse'                           => array(
			'CDCPMDRecord',
		),
		'fuelType'                                => array(
			'Vehicle',
			'EngineSpecification',
		),
		'alumni'                                  => array(
			'Organization',
			'EducationalOrganization',
		),
		'availableService'                        => array(
			'Hospital',
			'Physician',
			'MedicalClinic',
		),
		'estimatedCost'                           => array(
			'HowTo',
			'HowToSupply',
		),
		'speed'                                   => array(
			'Vehicle',
		),
		'subOrganization'                         => array(
			'Organization',
		),
		'temporal'                                => array(
			'CreativeWork',
		),
		'announcementLocation'                    => array(
			'SpecialAnnouncement',
		),
		'seatingType'                             => array(
			'Seat',
		),
		'legalAddress'                            => array(
			'Organization',
		),
		'targetProduct'                           => array(
			'SoftwareSourceCode',
		),
		'studySubject'                            => array(
			'MedicalStudy',
		),
		'publishedBy'                             => array(
			'PublicationEvent',
		),
		'isSimilarTo'                             => array(
			'Product',
			'Service',
		),
		'stageAsNumber'                           => array(
			'MedicalConditionStage',
		),
		'orderValue'                              => array(
			'ShippingConditions',
		),
		'energyEfficiencyScaleMax'                => array(
			'EnergyConsumptionDetails',
		),
		'byMonthDay'                              => array(
			'Schedule',
		),
		'speakable'                               => array(
			'Article',
			'WebPage',
		),
		'relatedStructure'                        => array(
			'AnatomicalSystem',
		),
		'nextItem'                                => array(
			'ListItem',
		),
		'requiresSubscription'                    => array(
			'MediaObject',
			'ActionAccessSpecification',
		),
		'dropoffLocation'                         => array(
			'RentalCarReservation',
		),
		'executableLibraryName'                   => array(
			'APIReference',
		),
		'gracePeriod'                             => array(
			'LoanOrCredit',
		),
		'reservationStatus'                       => array(
			'Reservation',
		),
		'course'                                  => array(
			'ExerciseAction',
		),
		'instrument'                              => array(
			'Action',
		),
		'checkoutTime'                            => array(
			'LodgingBusiness',
			'LodgingReservation',
		),
		'educationalRole'                         => array(
			'EducationalAudience',
		),
		'expires'                                 => array(
			'Certification',
			'CreativeWork',
		),
		'softwareHelp'                            => array(
			'SoftwareApplication',
		),
		'interestRate'                            => array(
			'FinancialProduct',
		),
		'physiologicalBenefits'                   => array(
			'Diet',
		),
		'relatedCondition'                        => array(
			'AnatomicalStructure',
			'AnatomicalSystem',
			'SuperficialAnatomy',
		),
		'diseasePreventionInfo'                   => array(
			'SpecialAnnouncement',
		),
		'variableMeasured'                        => array(
			'Observation',
			'Dataset',
		),
		'knows'                                   => array(
			'Person',
		),
		'numberOfEpisodes'                        => array(
			'CreativeWorkSeason',
			'RadioSeries',
			'TVSeries',
			'VideoGameSeries',
		),
		'programType'                             => array(
			'EducationalOccupationalProgram',
		),
		'energyEfficiencyScaleMin'                => array(
			'EnergyConsumptionDetails',
		),
		'itemLocation'                            => array(
			'ArchiveComponent',
		),
		'engineType'                              => array(
			'EngineSpecification',
		),
		'telephone'                               => array(
			'Place',
			'ContactPoint',
			'Person',
			'Organization',
		),
		'merchantReturnLink'                      => array(
			'MerchantReturnPolicy',
		),
		'applicationCategory'                     => array(
			'SoftwareApplication',
		),
		'sibling'                                 => array(
			'Person',
		),
		'hasDeliveryMethod'                       => array(
			'DeliveryEvent',
			'ParcelDelivery',
		),
		'replacee'                                => array(
			'ReplaceAction',
		),
		'aggregateElement'                        => array(
			'ItemList',
		),
		'industry'                                => array(
			'JobPosting',
		),
		'bookingAgent'                            => array(
			'Reservation',
		),
		'contactPoints'                           => array(
			'Organization',
			'Person',
		),
		'paymentMethod'                           => array(
			'Order',
			'Invoice',
		),
		'diet'                                    => array(
			'ExerciseAction',
		),
		'endorsee'                                => array(
			'EndorseAction',
		),
		'copyrightNotice'                         => array(
			'CreativeWork',
		),
		'boardingGroup'                           => array(
			'FlightReservation',
		),
		'exchangeRateSpread'                      => array(
			'ExchangeRateSpecification',
		),
		'isEncodedByBioChemEntity'                => array(
			'BioChemEntity',
		),
		'prescriptionStatus'                      => array(
			'Drug',
		),
		'starRating'                              => array(
			'FoodEstablishment',
			'LodgingBusiness',
		),
		'newsUpdatesAndGuidelines'                => array(
			'SpecialAnnouncement',
		),
		'median'                                  => array(
			'QuantitativeValueDistribution',
		),
		'broadcastAffiliateOf'                    => array(
			'BroadcastService',
		),
		'infectiousAgent'                         => array(
			'InfectiousDisease',
		),
		'netWorth'                                => array(
			'Person',
		),
		'availableIn'                             => array(
			'DrugStrength',
		),
		'cvdFacilityCounty'                       => array(
			'CDCPMDRecord',
		),
		'hiringOrganization'                      => array(
			'JobPosting',
		),
		'offerCount'                              => array(
			'AggregateOffer',
		),
		'jobLocationType'                         => array(
			'JobPosting',
		),
		'recipeCuisine'                           => array(
			'Recipe',
		),
		'estimatesRiskOf'                         => array(
			'MedicalRiskEstimator',
		),
		'recognizingAuthority'                    => array(
			'MedicalEntity',
		),
		'discountCode'                            => array(
			'Order',
		),
		'hasSponsorshipOffer'                     => array(
			'Event',
		),
		'mpn'                                     => array(
			'Product',
			'Demand',
			'Offer',
		),
		'coverageEndTime'                         => array(
			'LiveBlogPosting',
		),
		'warrantyScope'                           => array(
			'WarrantyPromise',
		),
		'drugUnit'                                => array(
			'DrugCost',
			'Drug',
		),
		'greater'                                 => array(
			'QualitativeValue',
		),
		'risks'                                   => array(
			'Diet',
		),
		'incentiveType'                           => array(
			'FinancialIncentive',
		),
		'arrivalBusStop'                          => array(
			'BusTrip',
		),
		'programPrerequisites'                    => array(
			'EducationalOccupationalProgram',
		),
		'shippingOrigin'                          => array(
			'OfferShippingDetails',
			'ShippingConditions',
		),
		'workLocation'                            => array(
			'Person',
		),
		'priceRange'                              => array(
			'LocalBusiness',
		),
		'predecessorOf'                           => array(
			'ProductModel',
		),
		'contactType'                             => array(
			'ContactPoint',
		),
		'maps'                                    => array(
			'Place',
		),
		'educationRequirements'                   => array(
			'Occupation',
			'JobPosting',
		),
		'competitor'                              => array(
			'SportsEvent',
		),
		'installUrl'                              => array(
			'SoftwareApplication',
		),
		'eligibleRegion'                          => array(
			'DeliveryChargeSpecification',
			'Offer',
			'Demand',
			'ActionAccessSpecification',
		),
		'ratingCount'                             => array(
			'AggregateRating',
		),
		'gameItem'                                => array(
			'Game',
			'VideoGameSeries',
		),
		'description'                             => array(
			'Thing',
		),
		'creditedTo'                              => array(
			'MusicRelease',
		),
		'legislationResponsible'                  => array(
			'Legislation',
		),
		'ratingValue'                             => array(
			'Rating',
		),
		'stepValue'                               => array(
			'PropertyValueSpecification',
		),
		'numItems'                                => array(
			'ShippingConditions',
		),
		'commentText'                             => array(
			'UserComments',
		),
		'incentives'                              => array(
			'JobPosting',
		),
		'previousItem'                            => array(
			'ListItem',
		),
		'numberOfLoanPayments'                    => array(
			'RepaymentSpecification',
		),
		'frequency'                               => array(
			'DoseSchedule',
		),
		'partySize'                               => array(
			'TaxiReservation',
			'FoodEstablishmentReservation',
		),
		'includedRiskFactor'                      => array(
			'MedicalRiskEstimator',
		),
		'trackingNumber'                          => array(
			'ParcelDelivery',
		),
		'musicReleaseFormat'                      => array(
			'MusicRelease',
		),
		'restPeriods'                             => array(
			'ExercisePlan',
		),
		'sdDatePublished'                         => array(
			'CreativeWork',
		),
		'cvdNumICUBedsOcc'                        => array(
			'CDCPMDRecord',
		),
		'petsAllowed'                             => array(
			'LodgingBusiness',
			'Accommodation',
			'FloorPlan',
			'ApartmentComplex',
		),
		'requirements'                            => array(
			'SoftwareApplication',
		),
		'doseUnit'                                => array(
			'DoseSchedule',
		),
		'engineDisplacement'                      => array(
			'EngineSpecification',
		),
		'teaches'                                 => array(
			'LearningResource',
			'EducationEvent',
			'CreativeWork',
		),
		'deliveryTime'                            => array(
			'DeliveryTimeSettings',
			'OfferShippingDetails',
		),
		'carbohydrateContent'                     => array(
			'NutritionInformation',
		),
		'hasMenu'                                 => array(
			'FoodEstablishment',
		),
		'healthPlanId'                            => array(
			'HealthInsurancePlan',
		),
		'reviewRating'                            => array(
			'Review',
		),
		'sportsTeam'                              => array(
			'ExerciseAction',
		),
		'screenCount'                             => array(
			'MovieTheater',
		),
		'alcoholWarning'                          => array(
			'Drug',
		),
		'partOfSeries'                            => array(
			'Clip',
			'Episode',
			'CreativeWorkSeason',
		),
		'businessDays'                            => array(
			'ShippingDeliveryTime',
			'ServicePeriod',
		),
		'dataset'                                 => array(
			'DataCatalog',
		),
		'alumniOf'                                => array(
			'Person',
		),
		'numberOfItems'                           => array(
			'ItemList',
		),
		'publishingPrinciples'                    => array(
			'Person',
			'Organization',
			'CreativeWork',
		),
		'hasStore'                                => array(
			'OnlineMarketplace',
		),
		'productionCompany'                       => array(
			'MediaObject',
			'Episode',
			'CreativeWorkSeason',
			'MovieSeries',
			'TVSeries',
			'RadioSeries',
			'VideoGameSeries',
			'Movie',
		),
		'trackingUrl'                             => array(
			'ParcelDelivery',
		),
		'valueMaxLength'                          => array(
			'PropertyValueSpecification',
		),
		'nerveMotor'                              => array(
			'Nerve',
		),
		'includedDataCatalog'                     => array(
			'Dataset',
		),
		'hasHealthAspect'                         => array(
			'HealthTopicContent',
		),
		'editor'                                  => array(
			'CreativeWork',
		),
		'exceptDate'                              => array(
			'Schedule',
		),
		'interactionType'                         => array(
			'InteractionCounter',
		),
		'spatialCoverage'                         => array(
			'CreativeWork',
		),
		'suggestedMeasurement'                    => array(
			'SizeSpecification',
			'PeopleAudience',
		),
		'entertainmentBusiness'                   => array(
			'PerformAction',
		),
		'associatedReview'                        => array(
			'Review',
		),
		'award'                                   => array(
			'Service',
			'Person',
			'Organization',
			'Product',
			'CreativeWork',
		),
		'parents'                                 => array(
			'Person',
		),
		'inChIKey'                                => array(
			'MolecularEntity',
		),
		'targetCollection'                        => array(
			'UpdateAction',
		),
		'healthPlanNetworkTier'                   => array(
			'HealthPlanNetwork',
		),
		'directors'                               => array(
			'Movie',
			'VideoGameSeries',
			'Clip',
			'Episode',
			'VideoGame',
			'MovieSeries',
			'VideoObject',
			'TVSeries',
			'RadioSeries',
		),
		'ownershipFundingInfo'                    => array(
			'Organization',
			'NewsMediaOrganization',
		),
		'doseSchedule'                            => array(
			'Drug',
			'TherapeuticProcedure',
		),
		'mealService'                             => array(
			'Flight',
		),
		'purchasePriceLimit'                      => array(
			'FinancialIncentive',
		),
		'usageInfo'                               => array(
			'CreativeWork',
		),
		'jobTitle'                                => array(
			'Person',
		),
		'siblings'                                => array(
			'Person',
		),
		'infectiousAgentClass'                    => array(
			'InfectiousDisease',
		),
		'replyToUrl'                              => array(
			'UserComments',
		),
		'floorLevel'                              => array(
			'Accommodation',
		),
		'sportsEvent'                             => array(
			'ExerciseAction',
		),
		'taxID'                                   => array(
			'Person',
			'Organization',
		),
		'followee'                                => array(
			'FollowAction',
		),
		'application'                             => array(
			'EntryPoint',
		),
		'dateSent'                                => array(
			'Message',
		),
		'overdosage'                              => array(
			'Drug',
		),
		'monthlyMinimumRepaymentAmount'           => array(
			'PaymentCard',
		),
		'isAccessibleForFree'                     => array(
			'Event',
			'Place',
			'CreativeWork',
		),
		'about'                                   => array(
			'CommunicateAction',
			'Certification',
			'DefinedTermSet',
			'Event',
			'CreativeWork',
			'DefinedTerm',
		),
		'endTime'                                 => array(
			'MediaObject',
			'InteractionCounter',
			'FoodEstablishmentReservation',
			'Action',
			'Schedule',
		),
		'colleagues'                              => array(
			'Person',
		),
		'numConstraints'                          => array(
			'ConstraintNode',
		),
		'activeIngredient'                        => array(
			'Substance',
			'DietarySupplement',
			'DrugStrength',
			'Drug',
		),
		'hostingOrganization'                     => array(
			'MemberProgram',
			'ProgramMembership',
		),
		'clinicalPharmacology'                    => array(
			'Drug',
		),
		'numberOfBedrooms'                        => array(
			'ApartmentComplex',
			'Accommodation',
			'FloorPlan',
		),
		'discussionUrl'                           => array(
			'CreativeWork',
		),
		'alternateName'                           => array(
			'Thing',
		),
		'numberOfPlayers'                         => array(
			'Game',
			'VideoGameSeries',
		),
		'inSupportOf'                             => array(
			'Thesis',
		),
		'encodesCreativeWork'                     => array(
			'MediaObject',
		),
		'model'                                   => array(
			'Product',
		),
		'beforeMedia'                             => array(
			'HowToDirection',
		),
		'partOfEpisode'                           => array(
			'Clip',
		),
		'athlete'                                 => array(
			'SportsTeam',
		),
		'pagination'                              => array(
			'PublicationVolume',
			'Chapter',
			'PublicationIssue',
			'Article',
		),
		'originAddress'                           => array(
			'ParcelDelivery',
		),
		'hasCategoryCode'                         => array(
			'CategoryCodeSet',
		),
		'muscleAction'                            => array(
			'Muscle',
		),
		'biologicalRole'                          => array(
			'BioChemEntity',
		),
		'duplicateTherapy'                        => array(
			'MedicalTherapy',
		),
		'screenshot'                              => array(
			'SoftwareApplication',
		),
		'certificationIdentification'             => array(
			'Certification',
		),
		'nsn'                                     => array(
			'Product',
		),
		'warrantyPromise'                         => array(
			'BuyAction',
			'SellAction',
		),
		'subReservation'                          => array(
			'ReservationPackage',
		),
		'familyName'                              => array(
			'Person',
		),
		'codingSystem'                            => array(
			'MedicalCode',
		),
		'additionalVariable'                      => array(
			'ExercisePlan',
		),
		'supplyTo'                                => array(
			'Artery',
		),
		'childMaxAge'                             => array(
			'ParentAudience',
		),
		'billingIncrement'                        => array(
			'UnitPriceSpecification',
		),
		'diversityPolicy'                         => array(
			'Organization',
			'NewsMediaOrganization',
		),
		'countryOfOrigin'                         => array(
			'Movie',
			'Product',
			'CreativeWork',
			'TVSeries',
			'TVSeason',
			'TVEpisode',
		),
		'photos'                                  => array(
			'Place',
		),
		'articleBody'                             => array(
			'Article',
		),
		'availabilityStarts'                      => array(
			'ActionAccessSpecification',
			'Demand',
			'Offer',
		),
		'deliveryStatus'                          => array(
			'ParcelDelivery',
		),
		'hasCredential'                           => array(
			'Person',
			'Organization',
		),
		'paymentMethodId'                         => array(
			'Invoice',
			'Order',
		),
		'significantLinks'                        => array(
			'WebPage',
		),
		'artEdition'                              => array(
			'VisualArtwork',
		),
		'causeOf'                                 => array(
			'MedicalCause',
		),
		'isAvailableGenerically'                  => array(
			'Drug',
		),
		'parentItem'                              => array(
			'Question',
			'Comment',
			'Answer',
		),
		'encodingType'                            => array(
			'EntryPoint',
		),
		'sponsor'                                 => array(
			'MedicalStudy',
			'Event',
			'CreativeWork',
			'Person',
			'Organization',
			'Grant',
		),
		'downloadUrl'                             => array(
			'SoftwareApplication',
		),
		'valueMinLength'                          => array(
			'PropertyValueSpecification',
		),
		'coach'                                   => array(
			'SportsTeam',
		),
		'performerIn'                             => array(
			'Person',
		),
		'isConsumableFor'                         => array(
			'Product',
		),
		'maximumPhysicalAttendeeCapacity'         => array(
			'Event',
		),
		'agentInteractionStatistic'               => array(
			'Person',
			'Organization',
		),
		'masthead'                                => array(
			'NewsMediaOrganization',
		),
		'bccRecipient'                            => array(
			'Message',
		),
		'dataFeedElement'                         => array(
			'DataFeed',
		),
		'billingStart'                            => array(
			'UnitPriceSpecification',
		),
		'primaryPrevention'                       => array(
			'MedicalCondition',
		),
		'serviceOperator'                         => array(
			'GovernmentService',
		),
		'includedComposition'                     => array(
			'MusicComposition',
		),
		'recipeCategory'                          => array(
			'Recipe',
		),
		'geoWithin'                               => array(
			'GeospatialGeometry',
			'Place',
		),
		'givenName'                               => array(
			'Person',
		),
		'branchCode'                              => array(
			'Place',
		),
		'width'                                   => array(
			'Product',
			'MediaObject',
			'VisualArtwork',
			'OfferShippingDetails',
			'ShippingConditions',
		),
		'borrower'                                => array(
			'LendAction',
		),
		'subTest'                                 => array(
			'MedicalTestPanel',
		),
		'musicalKey'                              => array(
			'MusicComposition',
		),
		'error'                                   => array(
			'Action',
		),
		'startOffset'                             => array(
			'Clip',
			'SeekToAction',
		),
		'cvdFacilityId'                           => array(
			'CDCPMDRecord',
		),
		'partOfTrip'                              => array(
			'Trip',
		),
		'geoCoveredBy'                            => array(
			'Place',
			'GeospatialGeometry',
		),
		'abridged'                                => array(
			'Book',
		),
		'lastReviewed'                            => array(
			'WebPage',
		),
		'cvdNumBeds'                              => array(
			'CDCPMDRecord',
		),
		'worksFor'                                => array(
			'Person',
		),
		'orderedItem'                             => array(
			'OrderItem',
			'Order',
		),
		'specialty'                               => array(
			'WebPage',
		),
		'interactivityType'                       => array(
			'CreativeWork',
		),
		'includedInDataCatalog'                   => array(
			'Dataset',
		),
		'numberedPosition'                        => array(
			'OrganizationRole',
		),
		'maximumAttendeeCapacity'                 => array(
			'Event',
			'Place',
		),
		'guideline'                               => array(
			'MedicalEntity',
		),
		'associatedPathophysiology'               => array(
			'AnatomicalSystem',
			'SuperficialAnatomy',
			'AnatomicalStructure',
		),
		'lesser'                                  => array(
			'QualitativeValue',
		),
		'returnPolicyCountry'                     => array(
			'MerchantReturnPolicy',
		),
		'translator'                              => array(
			'Event',
			'CreativeWork',
		),
		'includesHealthPlanNetwork'               => array(
			'HealthInsurancePlan',
		),
		'eligibleTransactionVolume'               => array(
			'PriceSpecification',
			'Offer',
			'Demand',
		),
		'healthPlanDrugTier'                      => array(
			'HealthPlanFormulary',
			'HealthInsurancePlan',
		),
		'creditText'                              => array(
			'CreativeWork',
		),
		'vehicleInteriorColor'                    => array(
			'Vehicle',
		),
		'inDefinedTermSet'                        => array(
			'DefinedTerm',
		),
		'taxonomicRange'                          => array(
			'BioChemEntity',
		),
		'location'                                => array(
			'Action',
			'Event',
			'Organization',
			'InteractionCounter',
		),
		'legislationAmends'                       => array(
			'Legislation',
		),
		'inCodeSet'                               => array(
			'CategoryCode',
		),
		'timeOfDay'                               => array(
			'EducationalOccupationalProgram',
		),
		'messageAttachment'                       => array(
			'Message',
		),
		'offersPrescriptionByMail'                => array(
			'HealthPlanFormulary',
		),
		'letterer'                                => array(
			'VisualArtwork',
			'ComicStory',
			'ComicIssue',
		),
		'actors'                                  => array(
			'Movie',
			'VideoGameSeries',
			'VideoGame',
			'MovieSeries',
			'Clip',
			'Episode',
			'VideoObject',
			'RadioSeries',
			'TVSeries',
		),
		'availableTest'                           => array(
			'DiagnosticLab',
		),
		'seeks'                                   => array(
			'Person',
			'Organization',
		),
		'legislationDate'                         => array(
			'Legislation',
		),
		'serviceLocation'                         => array(
			'ServiceChannel',
		),
		'applicationSubCategory'                  => array(
			'SoftwareApplication',
		),
		'numberOfPages'                           => array(
			'Book',
		),
		'mapType'                                 => array(
			'Map',
		),
		'ratingExplanation'                       => array(
			'Rating',
		),
		'contributor'                             => array(
			'Event',
			'CreativeWork',
		),
		'paymentDueDate'                          => array(
			'Invoice',
			'Order',
		),
		'translationOfWork'                       => array(
			'CreativeWork',
		),
		'winner'                                  => array(
			'LoseAction',
		),
		'utterances'                              => array(
			'HyperTocEntry',
		),
		'loanType'                                => array(
			'LoanOrCredit',
		),
		'healthPlanDrugOption'                    => array(
			'HealthInsurancePlan',
		),
		'passengerSequenceNumber'                 => array(
			'FlightReservation',
		),
		'makesOffer'                              => array(
			'Person',
			'Organization',
		),
		'applicationSuite'                        => array(
			'SoftwareApplication',
		),
		'alternativeOf'                           => array(
			'Gene',
		),
		'enginePower'                             => array(
			'EngineSpecification',
		),
		'verificationFactCheckingPolicy'          => array(
			'NewsMediaOrganization',
		),
		'productGroupID'                          => array(
			'ProductGroup',
		),
		'legislationApplies'                      => array(
			'Legislation',
		),
		'observationPeriod'                       => array(
			'Observation',
		),
		'inPlaylist'                              => array(
			'MusicRecording',
		),
		'map'                                     => array(
			'Place',
		),
		'vatID'                                   => array(
			'Person',
			'Organization',
		),
		'status'                                  => array(
			'MedicalProcedure',
			'MedicalCondition',
			'MedicalStudy',
		),
		'valueRequired'                           => array(
			'PropertyValueSpecification',
		),
		'associatedMedia'                         => array(
			'HyperToc',
			'HyperTocEntry',
			'CreativeWork',
		),
		'participant'                             => array(
			'Action',
		),
		'discountCurrency'                        => array(
			'Order',
		),
		'maximumIntake'                           => array(
			'Substance',
			'DietarySupplement',
			'DrugStrength',
			'Drug',
		),
		'datePosted'                              => array(
			'RealEstateListing',
			'SpecialAnnouncement',
			'JobPosting',
			'CDCPMDRecord',
		),
		'originatesFrom'                          => array(
			'LymphaticVessel',
		),
		'permissions'                             => array(
			'SoftwareApplication',
		),
		'molecularWeight'                         => array(
			'MolecularEntity',
		),
		'nonProprietaryName'                      => array(
			'DietarySupplement',
			'Drug',
		),
		'members'                                 => array(
			'Organization',
			'ProgramMembership',
		),
		'pattern'                                 => array(
			'Product',
			'CreativeWork',
		),
		'asin'                                    => array(
			'Offer',
			'Product',
			'Demand',
		),
		'gamePlatform'                            => array(
			'VideoGameSeries',
			'VideoGame',
		),
		'directApply'                             => array(
			'JobPosting',
		),
		'educationalAlignment'                    => array(
			'LearningResource',
			'CreativeWork',
		),
		'usesHealthPlanIdStandard'                => array(
			'HealthInsurancePlan',
		),
		'serialNumber'                            => array(
			'IndividualProduct',
			'Demand',
			'Offer',
		),
		'previousStartDate'                       => array(
			'Event',
		),
		'credentialCategory'                      => array(
			'EducationalOccupationalCredential',
		),
		'url'                                     => array(
			'Thing',
		),
		'gameLocation'                            => array(
			'Game',
			'VideoGameSeries',
		),
		'incentiveStatus'                         => array(
			'FinancialIncentive',
		),
		'hasCourse'                               => array(
			'EducationalOccupationalProgram',
		),
		'weightPercentage'                        => array(
			'ShippingRateSettings',
		),
		'accessibilityAPI'                        => array(
			'CreativeWork',
		),
		'duns'                                    => array(
			'Person',
			'Organization',
		),
		'geoTouches'                              => array(
			'GeospatialGeometry',
			'Place',
		),
		'box'                                     => array(
			'GeoShape',
		),
		'worstRating'                             => array(
			'Rating',
		),
		'director'                                => array(
			'Movie',
			'VideoGameSeries',
			'Event',
			'VideoGame',
			'MovieSeries',
			'Clip',
			'Episode',
			'CreativeWorkSeason',
			'VideoObject',
			'RadioSeries',
			'TVSeries',
		),
		'characterName'                           => array(
			'PerformanceRole',
		),
		'chemicalRole'                            => array(
			'MolecularEntity',
			'ChemicalSubstance',
		),
		'diagram'                                 => array(
			'AnatomicalStructure',
		),
		'providesBroadcastService'                => array(
			'BroadcastChannel',
		),
		'artMedium'                               => array(
			'VisualArtwork',
		),
		'termCode'                                => array(
			'DefinedTerm',
		),
		'fuelEfficiency'                          => array(
			'Vehicle',
		),
		'loser'                                   => array(
			'WinAction',
		),
		'hasShippingService'                      => array(
			'Organization',
			'OfferShippingDetails',
		),
		'variantCover'                            => array(
			'ComicIssue',
		),
		'image'                                   => array(
			'Thing',
		),
		'tracks'                                  => array(
			'MusicPlaylist',
			'MusicGroup',
		),
		'confirmationNumber'                      => array(
			'Invoice',
			'Order',
		),
		'totalTime'                               => array(
			'HowToDirection',
			'HowTo',
		),
		'homeLocation'                            => array(
			'Person',
		),
		'offeredBy'                               => array(
			'Offer',
		),
		'billingAddress'                          => array(
			'Order',
		),
		'accessibilitySummary'                    => array(
			'CreativeWork',
		),
		'embeddedTextCaption'                     => array(
			'ImageObject',
			'VideoObject',
			'AudioObject',
		),
		'exampleOfWork'                           => array(
			'CreativeWork',
		),
		'publication'                             => array(
			'CreativeWork',
		),
		'attendees'                               => array(
			'Event',
		),
		'reviewBody'                              => array(
			'Review',
		),
		'fundedItem'                              => array(
			'Grant',
		),
		'faxNumber'                               => array(
			'ContactPoint',
			'Person',
			'Organization',
			'Place',
		),
		'vehicleModelDate'                        => array(
			'Vehicle',
		),
		'eligibleQuantity'                        => array(
			'Demand',
			'PriceSpecification',
			'Offer',
		),
		'pregnancyCategory'                       => array(
			'Drug',
		),
		'repeatCount'                             => array(
			'Schedule',
		),
		'aircraft'                                => array(
			'Flight',
		),
		'pregnancyWarning'                        => array(
			'Drug',
		),
		'tripOrigin'                              => array(
			'Trip',
		),
		'performTime'                             => array(
			'HowToDirection',
			'HowTo',
		),
		'hasPOS'                                  => array(
			'Person',
			'Organization',
		),
		'bitrate'                                 => array(
			'MediaObject',
		),
		'busName'                                 => array(
			'BusTrip',
		),
		'softwareAddOn'                           => array(
			'SoftwareApplication',
		),
		'isAccessoryOrSparePartFor'               => array(
			'Product',
		),
		'foodWarning'                             => array(
			'Drug',
		),
		'paymentAccepted'                         => array(
			'LocalBusiness',
		),
		'driveWheelConfiguration'                 => array(
			'Vehicle',
		),
		'seatNumber'                              => array(
			'Seat',
		),
		'departureBusStop'                        => array(
			'BusTrip',
		),
		'medicineSystem'                          => array(
			'MedicalEntity',
		),
		'disambiguatingDescription'               => array(
			'Thing',
		),
		'responsibilities'                        => array(
			'JobPosting',
			'Occupation',
		),
		'isLocatedInSubcellularLocation'          => array(
			'BioChemEntity',
		),
		'parent'                                  => array(
			'Person',
		),
		'device'                                  => array(
			'SoftwareApplication',
		),
		'countriesNotSupported'                   => array(
			'SoftwareApplication',
		),
		'position'                                => array(
			'ListItem',
			'CreativeWork',
		),
		'relatedLink'                             => array(
			'WebPage',
		),
		'validThrough'                            => array(
			'LocationFeatureSpecification',
			'PriceSpecification',
			'Offer',
			'OpeningHoursSpecification',
			'MonetaryAmount',
			'JobPosting',
			'Demand',
			'FinancialIncentive',
		),
		'tissueSample'                            => array(
			'PathologyTest',
		),
		'hasGS1DigitalLink'                       => array(
			'Product',
			'Place',
			'Offer',
			'Organization',
		),
		'conditionsOfAccess'                      => array(
			'CreativeWork',
		),
		'mainEntity'                              => array(
			'CreativeWork',
		),
		'observationDate'                         => array(
			'Observation',
		),
		'copyrightYear'                           => array(
			'CreativeWork',
		),
		'title'                                   => array(
			'JobPosting',
		),
		'acrissCode'                              => array(
			'Car',
			'BusOrCoach',
		),
		'additionalName'                          => array(
			'Person',
		),
		'text'                                    => array(
			'CreativeWork',
		),
		'exifData'                                => array(
			'ImageObject',
		),
		'contentUrl'                              => array(
			'MediaObject',
		),
		'seatRow'                                 => array(
			'Seat',
		),
		'cashBack'                                => array(
			'PaymentCard',
		),
		'reservedTicket'                          => array(
			'Reservation',
		),
		'tickerSymbol'                            => array(
			'Corporation',
		),
		'defaultValue'                            => array(
			'PropertyValueSpecification',
		),
		'childTaxon'                              => array(
			'Taxon',
		),
		'releaseDate'                             => array(
			'Product',
		),
		'preparation'                             => array(
			'MedicalProcedure',
		),
		'email'                                   => array(
			'ContactPoint',
			'Person',
			'Organization',
		),
		'interpretedAsClaim'                      => array(
			'CreativeWork',
			'MediaObject',
		),
		'procedure'                               => array(
			'MedicalDevice',
		),
		'diagnosis'                               => array(
			'DDxElement',
			'Patient',
		),
		'callSign'                                => array(
			'Person',
			'BroadcastService',
			'Vehicle',
		),
		'cookTime'                                => array(
			'Recipe',
		),
		'hasOfferCatalog'                         => array(
			'Service',
			'Person',
			'Organization',
		),
		'isPartOf'                                => array(
			'CreativeWork',
		),
		'legislationChanges'                      => array(
			'Legislation',
		),
		'deathPlace'                              => array(
			'Person',
		),
		'claimInterpreter'                        => array(
			'Claim',
		),
		'landlord'                                => array(
			'RentAction',
		),
		'antagonist'                              => array(
			'Muscle',
		),
		'nonprofitStatus'                         => array(
			'Organization',
		),
		'transmissionMethod'                      => array(
			'InfectiousDisease',
		),
		'itemListOrder'                           => array(
			'ItemList',
		),
		'shippingRate'                            => array(
			'ShippingRateSettings',
			'OfferShippingDetails',
			'ShippingConditions',
		),
		'termDuration'                            => array(
			'EducationalOccupationalProgram',
		),
		'linkRelationship'                        => array(
			'LinkRole',
		),
		'httpMethod'                              => array(
			'EntryPoint',
		),
		'numberOfBathroomsTotal'                  => array(
			'FloorPlan',
			'Accommodation',
		),
		'browserRequirements'                     => array(
			'WebApplication',
		),
		'priceSpecification'                      => array(
			'Demand',
			'Offer',
			'DonateAction',
			'TradeAction',
		),
		'numberOfAxles'                           => array(
			'Vehicle',
		),
		'exercisePlan'                            => array(
			'ExerciseAction',
		),
		'arrivalGate'                             => array(
			'Flight',
		),
		'speechToTextMarkup'                      => array(
			'PronounceableText',
		),
		'geoCrosses'                              => array(
			'Place',
			'GeospatialGeometry',
		),
		'earlyPrepaymentPenalty'                  => array(
			'RepaymentSpecification',
		),
		'postalCode'                              => array(
			'PostalAddress',
			'DefinedRegion',
			'GeoShape',
			'GeoCoordinates',
		),
		'educationalLevel'                        => array(
			'CreativeWork',
			'LearningResource',
			'EducationEvent',
			'EducationalOccupationalCredential',
		),
		'variesBy'                                => array(
			'ProductGroup',
		),
		'broadcastDisplayName'                    => array(
			'BroadcastService',
		),
		'itemDefectReturnFees'                    => array(
			'MerchantReturnPolicy',
		),
		'administrationRoute'                     => array(
			'Drug',
		),
		'eventSchedule'                           => array(
			'Event',
		),
		'toLocation'                              => array(
			'MoveAction',
			'ExerciseAction',
			'TransferAction',
			'InsertAction',
		),
		'applicantLocationRequirements'           => array(
			'JobPosting',
		),
		'postalCodePrefix'                        => array(
			'DefinedRegion',
		),
		'sizeSystem'                              => array(
			'SizeSpecification',
		),
		'founders'                                => array(
			'Organization',
		),
		'articleSection'                          => array(
			'Article',
		),
		'videoQuality'                            => array(
			'VideoObject',
		),
		'subStageSuffix'                          => array(
			'MedicalConditionStage',
		),
		'regionDrained'                           => array(
			'Vein',
			'LymphaticVessel',
		),
		'memoryRequirements'                      => array(
			'SoftwareApplication',
		),
		'applicationContact'                      => array(
			'JobPosting',
		),
		'numAdults'                               => array(
			'LodgingReservation',
		),
		'customerRemorseReturnLabelSource'        => array(
			'MerchantReturnPolicy',
		),
		'activityDuration'                        => array(
			'ExercisePlan',
		),
		'validFor'                                => array(
			'EducationalOccupationalCredential',
			'Permit',
		),
		'primaryImageOfPage'                      => array(
			'WebPage',
		),
		'penciler'                                => array(
			'ComicStory',
			'VisualArtwork',
			'ComicIssue',
		),
		'errorCode'                               => array(
			'Error',
		),
		'sender'                                  => array(
			'ReceiveAction',
			'Message',
		),
		'bestRating'                              => array(
			'Rating',
		),
		'character'                               => array(
			'CreativeWork',
		),
		'spouse'                                  => array(
			'Person',
		),
		'copyrightHolder'                         => array(
			'CreativeWork',
		),
		'runtimePlatform'                         => array(
			'SoftwareApplication',
			'SoftwareSourceCode',
		),
		'target'                                  => array(
			'Action',
		),
		'free'                                    => array(
			'PublicationEvent',
		),
		'benefits'                                => array(
			'JobPosting',
		),
		'securityClearanceRequirement'            => array(
			'JobPosting',
		),
		'gameAvailabilityType'                    => array(
			'PlayGameAction',
		),
		'specialCommitments'                      => array(
			'JobPosting',
		),
		'departureStation'                        => array(
			'TrainTrip',
		),
		'issuedBy'                                => array(
			'Ticket',
			'Permit',
			'Certification',
		),
		'backstory'                               => array(
			'Article',
		),
		'dateModified'                            => array(
			'DataFeedItem',
			'CreativeWork',
		),
		'departureTerminal'                       => array(
			'Flight',
		),
		'resultComment'                           => array(
			'ReplyAction',
			'CommentAction',
		),
		'mediaItemAppearance'                     => array(
			'MediaReviewItem',
		),
		'aspect'                                  => array(
			'MedicalWebPage',
		),
		'currentExchangeRate'                     => array(
			'ExchangeRateSpecification',
		),
		'availabilityEnds'                        => array(
			'ActionAccessSpecification',
			'Offer',
			'Demand',
		),
		'priceValidUntil'                         => array(
			'Offer',
		),
		'includedInHealthInsurancePlan'           => array(
			'Drug',
		),
		'hasTierRequirement'                      => array(
			'MemberProgramTier',
		),
		'afterMedia'                              => array(
			'HowToDirection',
		),
		'availableAtOrFrom'                       => array(
			'Demand',
			'Offer',
		),
		'cvdNumC19OverflowPats'                   => array(
			'CDCPMDRecord',
		),
		'sensoryUnit'                             => array(
			'Nerve',
		),
		'cvdNumTotBeds'                           => array(
			'CDCPMDRecord',
		),
		'healthcareReportingData'                 => array(
			'Hospital',
		),
		'dissolutionDate'                         => array(
			'Organization',
		),
		'cutoffTime'                              => array(
			'ServicePeriod',
			'ShippingDeliveryTime',
		),
		'cvdNumC19HospPats'                       => array(
			'CDCPMDRecord',
		),
		'unnamedSourcesPolicy'                    => array(
			'Organization',
			'NewsMediaOrganization',
		),
		'icaoCode'                                => array(
			'Airport',
		),
		'targetName'                              => array(
			'AlignmentObject',
		),
		'estimatedSalary'                         => array(
			'Occupation',
			'JobPosting',
		),
		'drug'                                    => array(
			'TherapeuticProcedure',
			'MedicalCondition',
			'DrugClass',
			'Patient',
		),
		'annualPercentageRate'                    => array(
			'FinancialProduct',
		),
		'episodes'                                => array(
			'CreativeWorkSeason',
			'TVSeries',
			'RadioSeries',
			'VideoGameSeries',
		),
		'owns'                                    => array(
			'Person',
			'Organization',
		),
		'incentiveAmount'                         => array(
			'FinancialIncentive',
		),
		'program'                                 => array(
			'ProgramMembership',
		),
		'inker'                                   => array(
			'VisualArtwork',
			'ComicStory',
			'ComicIssue',
		),
		'scheduledTime'                           => array(
			'PlanAction',
		),
		'photo'                                   => array(
			'Place',
		),
		'totalPrice'                              => array(
			'Reservation',
			'Ticket',
		),
		'amenityFeature'                          => array(
			'Accommodation',
			'FloorPlan',
			'Place',
			'LodgingBusiness',
		),
		'organizer'                               => array(
			'Event',
		),
		'qualifications'                          => array(
			'JobPosting',
			'Occupation',
		),
	);

	/**
	 * Property range mappings
	 *
	 * Maps each property to the types it expects as values.
	 * For example: 'author' => ['Person', 'Organization']
	 *
	 * Data types like Text, Number, Boolean, Date, URL, etc. indicate primitive values.
	 * Other types indicate nested objects that should include @type.
	 *
	 * @var array
	 */
	public static $property_ranges = array(
		'legislationPassedBy'                     => array(
			'Organization',
			'Person',
		),
		'funding'                                 => array(
			'Grant',
		),
		'valuePattern'                            => array(
			'Text',
		),
		'provider'                                => array(
			'Person',
			'Organization',
		),
		'honorificPrefix'                         => array(
			'Text',
		),
		'modifiedTime'                            => array(
			'DateTime',
		),
		'numberOfCredits'                         => array(
			'StructuredValue',
			'Integer',
		),
		'noBylinesPolicy'                         => array(
			'CreativeWork',
			'URL',
		),
		'genre'                                   => array(
			'URL',
			'Text',
			'DefinedTerm',
		),
		'sameAs'                                  => array(
			'URL',
		),
		'wordCount'                               => array(
			'Integer',
		),
		'recommendedIntake'                       => array(
			'RecommendedDoseSchedule',
		),
		'isGift'                                  => array(
			'Boolean',
		),
		'interactingDrug'                         => array(
			'Drug',
		),
		'experienceInPlaceOfEducation'            => array(
			'Boolean',
		),
		'isProprietary'                           => array(
			'Boolean',
		),
		'accessModeSufficient'                    => array(
			'ItemList',
		),
		'breadcrumb'                              => array(
			'BreadcrumbList',
			'Text',
		),
		'recordedAs'                              => array(
			'MusicRecording',
		),
		'vehicleConfiguration'                    => array(
			'Text',
		),
		'orderItemNumber'                         => array(
			'Text',
		),
		'legislationIdentifier'                   => array(
			'Text',
			'URL',
		),
		'weightTotal'                             => array(
			'QuantitativeValue',
		),
		'numberOfFullBathrooms'                   => array(
			'Number',
		),
		'imagingTechnique'                        => array(
			'MedicalImagingTechnique',
		),
		'readBy'                                  => array(
			'Person',
		),
		'readonlyValue'                           => array(
			'Boolean',
		),
		'containsSeason'                          => array(
			'CreativeWorkSeason',
		),
		'legislationCommences'                    => array(
			'Legislation',
		),
		'pickupTime'                              => array(
			'DateTime',
		),
		'hoursAvailable'                          => array(
			'OpeningHoursSpecification',
		),
		'targetPlatform'                          => array(
			'Text',
		),
		'connectedTo'                             => array(
			'AnatomicalStructure',
		),
		'cvdNumBedsOcc'                           => array(
			'Number',
		),
		'nonEqual'                                => array(
			'QualitativeValue',
		),
		'qualifiedExpense'                        => array(
			'IncentiveQualifiedExpenseType',
		),
		'paymentUrl'                              => array(
			'URL',
		),
		'acquireLicensePage'                      => array(
			'CreativeWork',
			'URL',
		),
		'hasRepresentation'                       => array(
			'Text',
			'URL',
			'PropertyValue',
		),
		'suggestedMinAge'                         => array(
			'Number',
		),
		'polygon'                                 => array(
			'Text',
		),
		'duration'                                => array(
			'Duration',
			'QuantitativeValue',
		),
		'maximumEnrollment'                       => array(
			'Integer',
		),
		'numberOfForwardGears'                    => array(
			'Number',
			'QuantitativeValue',
		),
		'taxonRank'                               => array(
			'Text',
			'URL',
			'PropertyValue',
		),
		'actionPlatform'                          => array(
			'DigitalPlatformEnumeration',
			'URL',
			'Text',
		),
		'numTracks'                               => array(
			'Integer',
		),
		'legislationLegalValue'                   => array(
			'LegalValueLevel',
		),
		'totalPaymentDue'                         => array(
			'PriceSpecification',
			'MonetaryAmount',
		),
		'sensoryRequirement'                      => array(
			'DefinedTerm',
			'URL',
			'Text',
		),
		'hasDefinedTerm'                          => array(
			'DefinedTerm',
		),
		'orderNumber'                             => array(
			'Text',
		),
		'geoCovers'                               => array(
			'GeospatialGeometry',
			'Place',
		),
		'mathExpression'                          => array(
			'SolveMathAction',
			'Text',
		),
		'lender'                                  => array(
			'Organization',
			'Person',
		),
		'currency'                                => array(
			'Text',
		),
		'temporalCoverage'                        => array(
			'DateTime',
			'URL',
			'Text',
		),
		'shippingDetails'                         => array(
			'OfferShippingDetails',
		),
		'specialOpeningHoursSpecification'        => array(
			'OpeningHoursSpecification',
		),
		'publicAccess'                            => array(
			'Boolean',
		),
		'structuralClass'                         => array(
			'Text',
		),
		'smokingAllowed'                          => array(
			'Boolean',
		),
		'currenciesAccepted'                      => array(
			'Text',
		),
		'publisher'                               => array(
			'Person',
			'Organization',
		),
		'targetUrl'                               => array(
			'URL',
		),
		'endOffset'                               => array(
			'HyperTocEntry',
			'Number',
		),
		'eligibleDuration'                        => array(
			'QuantitativeValue',
		),
		'costCurrency'                            => array(
			'Text',
		),
		'arrivalTime'                             => array(
			'DateTime',
			'Time',
		),
		'hasMeasurement'                          => array(
			'QuantitativeValue',
		),
		'runtime'                                 => array(
			'Text',
		),
		'serviceAudience'                         => array(
			'Audience',
		),
		'vehicleTransmission'                     => array(
			'Text',
			'QualitativeValue',
			'URL',
		),
		'reportNumber'                            => array(
			'Text',
		),
		'exerciseCourse'                          => array(
			'Place',
		),
		'seasons'                                 => array(
			'CreativeWorkSeason',
		),
		'knownVehicleDamages'                     => array(
			'Text',
		),
		'name'                                    => array(
			'Text',
		),
		'warranty'                                => array(
			'WarrantyPromise',
		),
		'distribution'                            => array(
			'DataDownload',
		),
		'actionAccessibilityRequirement'          => array(
			'ActionAccessSpecification',
		),
		'numberOfAccommodationUnits'              => array(
			'QuantitativeValue',
		),
		'weight'                                  => array(
			'Mass',
			'QuantitativeValue',
		),
		'associatedArticle'                       => array(
			'NewsArticle',
		),
		'commentTime'                             => array(
			'Date',
			'DateTime',
		),
		'awards'                                  => array(
			'Text',
		),
		'steeringPosition'                        => array(
			'SteeringPositionValue',
		),
		'legislationConsolidates'                 => array(
			'Legislation',
		),
		'hasEnergyEfficiencyCategory'             => array(
			'EnergyEfficiencyEnumeration',
		),
		'reservationFor'                          => array(
			'Thing',
		),
		'cssSelector'                             => array(
			'CssSelectorType',
		),
		'contraindication'                        => array(
			'MedicalContraindication',
			'Text',
		),
		'proficiencyLevel'                        => array(
			'Text',
		),
		'question'                                => array(
			'Question',
		),
		'thumbnail'                               => array(
			'ImageObject',
		),
		'strengthUnit'                            => array(
			'Text',
		),
		'propertyID'                              => array(
			'Text',
			'URL',
		),
		'servicePostalAddress'                    => array(
			'PostalAddress',
		),
		'billingDuration'                         => array(
			'Duration',
			'QuantitativeValue',
			'Number',
		),
		'additionalNumberOfGuests'                => array(
			'Number',
		),
		'thumbnailUrl'                            => array(
			'URL',
		),
		'mediaAuthenticityCategory'               => array(
			'MediaManipulationRatingEnumeration',
		),
		'geoOverlaps'                             => array(
			'GeospatialGeometry',
			'Place',
		),
		'inAlbum'                                 => array(
			'MusicAlbum',
		),
		'commentCount'                            => array(
			'Integer',
		),
		'availableThrough'                        => array(
			'DateTime',
		),
		'busNumber'                               => array(
			'Text',
		),
		'guidelineSubject'                        => array(
			'MedicalEntity',
		),
		'refundType'                              => array(
			'RefundTypeEnumeration',
		),
		'height'                                  => array(
			'QuantitativeValue',
			'Distance',
		),
		'addressCountry'                          => array(
			'Country',
			'Text',
		),
		'catalog'                                 => array(
			'DataCatalog',
		),
		'customer'                                => array(
			'Person',
			'Organization',
		),
		'hasMenuItem'                             => array(
			'MenuItem',
		),
		'displayLocation'                         => array(
			'Place',
		),
		'practicesAt'                             => array(
			'MedicalOrganization',
		),
		'roofLoad'                                => array(
			'QuantitativeValue',
		),
		'latitude'                                => array(
			'Number',
			'Text',
		),
		'coverageStartTime'                       => array(
			'DateTime',
		),
		'medicalSpecialty'                        => array(
			'MedicalSpecialty',
		),
		'emissionsCO2'                            => array(
			'Number',
		),
		'webCheckinTime'                          => array(
			'DateTime',
		),
		'experienceRequirements'                  => array(
			'Text',
			'OccupationalExperienceRequirements',
		),
		'printPage'                               => array(
			'Text',
		),
		'includesHealthPlanFormulary'             => array(
			'HealthPlanFormulary',
		),
		'fatContent'                              => array(
			'Mass',
		),
		'musicBy'                                 => array(
			'MusicGroup',
			'Person',
		),
		'knowsAbout'                              => array(
			'Text',
			'Thing',
			'URL',
		),
		'syllabusSections'                        => array(
			'Syllabus',
		),
		'gtin'                                    => array(
			'Text',
			'URL',
		),
		'orderDelivery'                           => array(
			'ParcelDelivery',
		),
		'archivedAt'                              => array(
			'WebPage',
			'URL',
		),
		'cholesterolContent'                      => array(
			'Mass',
		),
		'workPresented'                           => array(
			'Movie',
		),
		'broker'                                  => array(
			'Person',
			'Organization',
		),
		'epidemiology'                            => array(
			'Text',
		),
		'numberOfRooms'                           => array(
			'QuantitativeValue',
			'Number',
		),
		'checkoutPageURLTemplate'                 => array(
			'Text',
		),
		'fileSize'                                => array(
			'Text',
		),
		'expectedPrognosis'                       => array(
			'Text',
		),
		'countriesSupported'                      => array(
			'Text',
		),
		'signOrSymptom'                           => array(
			'MedicalSignOrSymptom',
		),
		'sampleType'                              => array(
			'Text',
		),
		'openingHoursSpecification'               => array(
			'OpeningHoursSpecification',
		),
		'vehicleInteriorType'                     => array(
			'Text',
		),
		'partOfInvoice'                           => array(
			'Invoice',
		),
		'employee'                                => array(
			'Person',
		),
		'data'                                    => array(
			'Thing',
		),
		'scheduledPaymentDate'                    => array(
			'Date',
		),
		'geoRadius'                               => array(
			'Number',
			'Distance',
			'Text',
		),
		'occupationLocation'                      => array(
			'AdministrativeArea',
		),
		'validIn'                                 => array(
			'AdministrativeArea',
		),
		'exerciseRelatedDiet'                     => array(
			'Diet',
		),
		'digitalSourceType'                       => array(
			'IPTCDigitalSourceEnumeration',
		),
		'departureTime'                           => array(
			'Time',
			'DateTime',
		),
		'normalRange'                             => array(
			'MedicalEnumeration',
			'Text',
		),
		'broadcastOfEvent'                        => array(
			'Event',
		),
		'reviews'                                 => array(
			'Review',
		),
		'stage'                                   => array(
			'MedicalConditionStage',
		),
		'boardingPolicy'                          => array(
			'BoardingPolicyType',
		),
		'issn'                                    => array(
			'Text',
		),
		'instructor'                              => array(
			'Person',
		),
		'vendor'                                  => array(
			'Organization',
			'Person',
		),
		'educationalCredentialAwarded'            => array(
			'Text',
			'EducationalOccupationalCredential',
			'URL',
		),
		'transcript'                              => array(
			'Text',
		),
		'byMonth'                                 => array(
			'Integer',
		),
		'assembly'                                => array(
			'Text',
		),
		'freeShippingThreshold'                   => array(
			'DeliveryChargeSpecification',
			'MonetaryAmount',
		),
		'discusses'                               => array(
			'CreativeWork',
		),
		'requiredGender'                          => array(
			'Text',
		),
		'termsPerYear'                            => array(
			'Number',
		),
		'source'                                  => array(
			'Thing',
		),
		'assesses'                                => array(
			'DefinedTerm',
			'Text',
		),
		'logo'                                    => array(
			'URL',
			'ImageObject',
		),
		'isStoreOn'                               => array(
			'OnlineMarketplace',
		),
		'relevantSpecialty'                       => array(
			'MedicalSpecialty',
		),
		'gtin12'                                  => array(
			'Text',
		),
		'upvoteCount'                             => array(
			'Integer',
		),
		'hasCourseInstance'                       => array(
			'CourseInstance',
		),
		'usNPI'                                   => array(
			'Text',
		),
		'price'                                   => array(
			'Number',
			'Text',
		),
		'result'                                  => array(
			'Thing',
		),
		'geoContains'                             => array(
			'Place',
			'GeospatialGeometry',
		),
		'featureList'                             => array(
			'URL',
			'Text',
		),
		'hasMenuSection'                          => array(
			'MenuSection',
		),
		'license'                                 => array(
			'CreativeWork',
			'URL',
		),
		'servesCuisine'                           => array(
			'Text',
		),
		'salaryUponCompletion'                    => array(
			'MonetaryAmountDistribution',
		),
		'query'                                   => array(
			'Text',
		),
		'gender'                                  => array(
			'Text',
			'GenderType',
		),
		'processorRequirements'                   => array(
			'Text',
		),
		'totalHistoricalEnrollment'               => array(
			'Integer',
		),
		'foundingDate'                            => array(
			'Date',
		),
		'missionCoveragePrioritiesPolicy'         => array(
			'CreativeWork',
			'URL',
		),
		'eduQuestionType'                         => array(
			'Text',
		),
		'additionalType'                          => array(
			'URL',
			'Text',
		),
		'broadcastChannelId'                      => array(
			'Text',
		),
		'yearBuilt'                               => array(
			'Number',
		),
		'partOfSeason'                            => array(
			'CreativeWorkSeason',
		),
		'broadcastSignalModulation'               => array(
			'QualitativeValue',
			'Text',
		),
		'performers'                              => array(
			'Person',
			'Organization',
		),
		'programName'                             => array(
			'Text',
		),
		'providerMobility'                        => array(
			'Text',
		),
		'amountOfThisGood'                        => array(
			'Number',
		),
		'amount'                                  => array(
			'Number',
			'MonetaryAmount',
		),
		'actionProcess'                           => array(
			'HowTo',
		),
		'diversityStaffingReport'                 => array(
			'URL',
			'Article',
		),
		'textValue'                               => array(
			'Text',
		),
		'gameTip'                                 => array(
			'CreativeWork',
		),
		'legislationTransposes'                   => array(
			'Legislation',
		),
		'sourcedFrom'                             => array(
			'BrainStructure',
		),
		'paymentStatus'                           => array(
			'Text',
			'PaymentStatusType',
		),
		'requiredCollateral'                      => array(
			'Thing',
			'Text',
		),
		'financialAidEligible'                    => array(
			'DefinedTerm',
			'Text',
		),
		'paymentDue'                              => array(
			'DateTime',
		),
		'itinerary'                               => array(
			'Place',
			'ItemList',
		),
		'bookEdition'                             => array(
			'Text',
		),
		'addOn'                                   => array(
			'Offer',
		),
		'baseSalary'                              => array(
			'MonetaryAmount',
			'PriceSpecification',
			'Number',
		),
		'evidenceOrigin'                          => array(
			'Text',
		),
		'foodEstablishment'                       => array(
			'Place',
			'FoodEstablishment',
		),
		'byArtist'                                => array(
			'Person',
			'MusicGroup',
		),
		'algorithm'                               => array(
			'Text',
		),
		'numberOfPartialBathrooms'                => array(
			'Number',
		),
		'orderPercentage'                         => array(
			'Number',
		),
		'hasMolecularFunction'                    => array(
			'DefinedTerm',
			'URL',
			'PropertyValue',
		),
		'pickupLocation'                          => array(
			'Place',
		),
		'payload'                                 => array(
			'QuantitativeValue',
		),
		'startTime'                               => array(
			'DateTime',
			'Time',
		),
		'isrcCode'                                => array(
			'Text',
		),
		'applicableCountry'                       => array(
			'Country',
			'Text',
		),
		'howPerformed'                            => array(
			'Text',
		),
		'isRelatedTo'                             => array(
			'Service',
			'Product',
		),
		'clipNumber'                              => array(
			'Text',
			'Integer',
		),
		'storageRequirements'                     => array(
			'URL',
			'Text',
		),
		'colorist'                                => array(
			'Person',
		),
		'keywords'                                => array(
			'Text',
			'DefinedTerm',
			'URL',
		),
		'healthPlanCoinsuranceOption'             => array(
			'Text',
		),
		'priceCurrency'                           => array(
			'Text',
		),
		'blogPosts'                               => array(
			'BlogPosting',
		),
		'track'                                   => array(
			'ItemList',
			'MusicRecording',
		),
		'legislationType'                         => array(
			'Text',
			'CategoryCode',
		),
		'serviceSmsNumber'                        => array(
			'ContactPoint',
		),
		'interactionService'                      => array(
			'SoftwareApplication',
			'WebSite',
		),
		'slogan'                                  => array(
			'Text',
		),
		'broadcastTimezone'                       => array(
			'Text',
		),
		'educationalProgramMode'                  => array(
			'URL',
			'Text',
		),
		'priceType'                               => array(
			'Text',
			'PriceTypeEnumeration',
		),
		'labelDetails'                            => array(
			'URL',
		),
		'endDate'                                 => array(
			'DateTime',
			'Date',
		),
		'requiredQuantity'                        => array(
			'Number',
			'Text',
			'QuantitativeValue',
		),
		'eventAttendanceMode'                     => array(
			'EventAttendanceModeEnumeration',
		),
		'seatSection'                             => array(
			'Text',
		),
		'calories'                                => array(
			'Energy',
		),
		'hasPart'                                 => array(
			'CreativeWork',
		),
		'transitTime'                             => array(
			'ServicePeriod',
			'QuantitativeValue',
		),
		'floorSize'                               => array(
			'QuantitativeValue',
		),
		'totalJobOpenings'                        => array(
			'Integer',
		),
		'funder'                                  => array(
			'Organization',
			'Person',
		),
		'publishedOn'                             => array(
			'BroadcastService',
		),
		'accessMode'                              => array(
			'Text',
		),
		'appearance'                              => array(
			'CreativeWork',
		),
		'seasonNumber'                            => array(
			'Text',
			'Integer',
		),
		'cvdCollectionDate'                       => array(
			'DateTime',
			'Text',
		),
		'bookFormat'                              => array(
			'BookFormatType',
		),
		'deliveryLeadTime'                        => array(
			'QuantitativeValue',
		),
		'returnMethod'                            => array(
			'ReturnMethodEnumeration',
		),
		'representativeOfPage'                    => array(
			'Boolean',
		),
		'incomeLimit'                             => array(
			'MonetaryAmount',
			'Text',
		),
		'printColumn'                             => array(
			'Text',
		),
		'inChI'                                   => array(
			'Text',
		),
		'toRecipient'                             => array(
			'ContactPoint',
			'Person',
			'Organization',
			'Audience',
		),
		'issueNumber'                             => array(
			'Text',
			'Integer',
		),
		'yearsInOperation'                        => array(
			'QuantitativeValue',
		),
		'pageEnd'                                 => array(
			'Integer',
			'Text',
		),
		'productID'                               => array(
			'Text',
		),
		'realEstateAgent'                         => array(
			'RealEstateAgent',
		),
		'usesDevice'                              => array(
			'MedicalDevice',
		),
		'legislationDateOfApplicability'          => array(
			'Date',
		),
		'countryOfLastProcessing'                 => array(
			'Text',
		),
		'schoolClosuresInfo'                      => array(
			'URL',
			'WebContent',
		),
		'duringMedia'                             => array(
			'MediaObject',
			'URL',
		),
		'providesService'                         => array(
			'Service',
		),
		'mobileUrl'                               => array(
			'Text',
		),
		'actor'                                   => array(
			'PerformingGroup',
			'Person',
		),
		'geo'                                     => array(
			'GeoShape',
			'GeoCoordinates',
		),
		'maximumVirtualAttendeeCapacity'          => array(
			'Integer',
		),
		'constraintProperty'                      => array(
			'URL',
			'Property',
		),
		'aggregateRating'                         => array(
			'AggregateRating',
		),
		'isPlanForApartment'                      => array(
			'Accommodation',
		),
		'cause'                                   => array(
			'MedicalCause',
		),
		'postalCodeRange'                         => array(
			'PostalCodeRangeSpecification',
		),
		'statType'                                => array(
			'Text',
			'Property',
			'URL',
		),
		'prepTime'                                => array(
			'Duration',
		),
		'itemReviewed'                            => array(
			'Thing',
		),
		'itemDefectReturnLabelSource'             => array(
			'ReturnLabelSourceEnumeration',
		),
		'holdingArchive'                          => array(
			'ArchiveOrganization',
		),
		'smiles'                                  => array(
			'Text',
		),
		'eligibilityToWorkRequirement'            => array(
			'Text',
		),
		'measurementTechnique'                    => array(
			'MeasurementMethodEnum',
			'DefinedTerm',
			'URL',
			'Text',
		),
		'illustrator'                             => array(
			'Person',
		),
		'strengthValue'                           => array(
			'Number',
		),
		'relatedTherapy'                          => array(
			'MedicalTherapy',
		),
		'namedPosition'                           => array(
			'URL',
			'Text',
		),
		'jobStartDate'                            => array(
			'Date',
			'Text',
		),
		'material'                                => array(
			'Product',
			'URL',
			'Text',
		),
		'candidate'                               => array(
			'Person',
		),
		'accessibilityControl'                    => array(
			'Text',
		),
		'arterialBranch'                          => array(
			'AnatomicalStructure',
		),
		'numberOfSeasons'                         => array(
			'Integer',
		),
		'recordedAt'                              => array(
			'Event',
		),
		'studyDesign'                             => array(
			'MedicalObservationalStudyDesign',
		),
		'bankAccountType'                         => array(
			'URL',
			'Text',
		),
		'trainNumber'                             => array(
			'Text',
		),
		'clincalPharmacology'                     => array(
			'Text',
		),
		'authenticator'                           => array(
			'Organization',
		),
		'serviceOutput'                           => array(
			'Thing',
		),
		'productSupported'                        => array(
			'Text',
			'Product',
		),
		'rangeIncludes'                           => array(
			'Class',
		),
		'recipeInstructions'                      => array(
			'CreativeWork',
			'ItemList',
			'Text',
		),
		'bed'                                     => array(
			'BedType',
			'Text',
			'BedDetails',
		),
		'accelerationTime'                        => array(
			'QuantitativeValue',
		),
		'merchantReturnDays'                      => array(
			'Date',
			'Integer',
			'DateTime',
		),
		'successorOf'                             => array(
			'ProductModel',
		),
		'applicationStartDate'                    => array(
			'Date',
		),
		'countryOfAssembly'                       => array(
			'Text',
		),
		'characterAttribute'                      => array(
			'Thing',
		),
		'coursePrerequisites'                     => array(
			'Course',
			'AlignmentObject',
			'Text',
		),
		'dependencies'                            => array(
			'Text',
		),
		'leiCode'                                 => array(
			'Text',
		),
		'loanPaymentAmount'                       => array(
			'MonetaryAmount',
		),
		'orderItemStatus'                         => array(
			'OrderStatus',
		),
		'evidenceLevel'                           => array(
			'MedicalEvidenceLevel',
		),
		'knowsLanguage'                           => array(
			'Language',
			'Text',
		),
		'maintainer'                              => array(
			'Person',
			'Organization',
		),
		'meetsEmissionStandard'                   => array(
			'Text',
			'QualitativeValue',
			'URL',
		),
		'playerType'                              => array(
			'Text',
		),
		'populationType'                          => array(
			'Class',
		),
		'healthPlanCopayOption'                   => array(
			'Text',
		),
		'timeRequired'                            => array(
			'Duration',
		),
		'assemblyVersion'                         => array(
			'Text',
		),
		'tool'                                    => array(
			'HowToTool',
			'Text',
		),
		'sha256'                                  => array(
			'Text',
		),
		'isBasedOn'                               => array(
			'CreativeWork',
			'URL',
			'Product',
		),
		'spokenByCharacter'                       => array(
			'Person',
			'Organization',
		),
		'downvoteCount'                           => array(
			'Integer',
		),
		'parentService'                           => array(
			'BroadcastService',
		),
		'partOfOrder'                             => array(
			'Order',
		),
		'warning'                                 => array(
			'URL',
			'Text',
		),
		'dropoffTime'                             => array(
			'DateTime',
		),
		'legislationJurisdiction'                 => array(
			'Text',
			'AdministrativeArea',
		),
		'answerCount'                             => array(
			'Integer',
		),
		'yearlyRevenue'                           => array(
			'QuantitativeValue',
		),
		'maxPrice'                                => array(
			'Number',
		),
		'availableStrength'                       => array(
			'DrugStrength',
		),
		'estimatedFlightDuration'                 => array(
			'Text',
			'Duration',
		),
		'itemShipped'                             => array(
			'Product',
		),
		'lodgingUnitDescription'                  => array(
			'Text',
		),
		'playersOnline'                           => array(
			'Integer',
		),
		'extendedAddress'                         => array(
			'Text',
		),
		'sugarContent'                            => array(
			'Mass',
		),
		'gtin14'                                  => array(
			'Text',
		),
		'tributary'                               => array(
			'AnatomicalStructure',
		),
		'value'                                   => array(
			'Boolean',
			'Number',
			'Text',
			'StructuredValue',
		),
		'brand'                                   => array(
			'Brand',
			'Organization',
		),
		'streetAddress'                           => array(
			'Text',
		),
		'codeValue'                               => array(
			'Text',
		),
		'identifier'                              => array(
			'URL',
			'PropertyValue',
			'Text',
		),
		'downPayment'                             => array(
			'Number',
			'MonetaryAmount',
		),
		'skills'                                  => array(
			'Text',
			'DefinedTerm',
		),
		'cvdNumC19MechVentPats'                   => array(
			'Number',
		),
		'associatedAnatomy'                       => array(
			'SuperficialAnatomy',
			'AnatomicalStructure',
			'AnatomicalSystem',
		),
		'editEIDR'                                => array(
			'URL',
			'Text',
		),
		'unsaturatedFatContent'                   => array(
			'Mass',
		),
		'returnFees'                              => array(
			'ReturnFeesEnumeration',
		),
		'naics'                                   => array(
			'Text',
		),
		'firstPerformance'                        => array(
			'Event',
		),
		'referencesOrder'                         => array(
			'Order',
		),
		'departureGate'                           => array(
			'Text',
		),
		'founder'                                 => array(
			'Organization',
			'Person',
		),
		'expectsAcceptanceOf'                     => array(
			'Offer',
		),
		'hasMerchantReturnPolicy'                 => array(
			'MerchantReturnPolicy',
		),
		'artworkSurface'                          => array(
			'Text',
			'URL',
		),
		'parentOrganization'                      => array(
			'Organization',
		),
		'possibleTreatment'                       => array(
			'Drug',
			'DrugClass',
			'MedicalTherapy',
			'LifestyleModification',
		),
		'inverseOf'                               => array(
			'Property',
		),
		'eligibleWithSupplier'                    => array(
			'Organization',
		),
		'seatingCapacity'                         => array(
			'QuantitativeValue',
			'Number',
		),
		'releaseNotes'                            => array(
			'URL',
			'Text',
		),
		'hasAdultConsideration'                   => array(
			'AdultOrientedEnumeration',
		),
		'exerciseType'                            => array(
			'Text',
		),
		'broadcastFrequencyValue'                 => array(
			'QuantitativeValue',
			'Number',
		),
		'originalMediaLink'                       => array(
			'WebPage',
			'MediaObject',
			'URL',
		),
		'hasMap'                                  => array(
			'URL',
			'Map',
		),
		'orderQuantity'                           => array(
			'QuantitativeValue',
			'Number',
		),
		'areaServed'                              => array(
			'Place',
			'AdministrativeArea',
			'GeoShape',
			'Text',
		),
		'artist'                                  => array(
			'Person',
		),
		'object'                                  => array(
			'Thing',
		),
		'comprisedOf'                             => array(
			'AnatomicalStructure',
			'AnatomicalSystem',
		),
		'customerRemorseReturnFees'               => array(
			'ReturnFeesEnumeration',
		),
		'firstAppearance'                         => array(
			'CreativeWork',
		),
		'containedIn'                             => array(
			'Place',
		),
		'globalLocationNumber'                    => array(
			'Text',
		),
		'handlingTime'                            => array(
			'ServicePeriod',
			'QuantitativeValue',
		),
		'proprietaryName'                         => array(
			'Text',
		),
		'shippingConditions'                      => array(
			'ShippingConditions',
		),
		'lyrics'                                  => array(
			'CreativeWork',
		),
		'availableDeliveryMethod'                 => array(
			'DeliveryMethod',
		),
		'opponent'                                => array(
			'Person',
		),
		'size'                                    => array(
			'QuantitativeValue',
			'Text',
			'DefinedTerm',
			'SizeSpecification',
		),
		'courseSchedule'                          => array(
			'Schedule',
		),
		'inventoryLevel'                          => array(
			'QuantitativeValue',
		),
		'insertion'                               => array(
			'AnatomicalStructure',
		),
		'alignmentType'                           => array(
			'Text',
		),
		'printEdition'                            => array(
			'Text',
		),
		'membershipNumber'                        => array(
			'Text',
		),
		'suggestedGender'                         => array(
			'Text',
			'GenderType',
		),
		'valueAddedTaxIncluded'                   => array(
			'Boolean',
		),
		'owner'                                   => array(
			'Person',
			'Organization',
		),
		'branch'                                  => array(
			'AnatomicalStructure',
		),
		'hasVariant'                              => array(
			'Product',
		),
		'pronouns'                                => array(
			'Text',
			'StructuredValue',
			'DefinedTerm',
		),
		'citation'                                => array(
			'Text',
			'CreativeWork',
		),
		'courseMode'                              => array(
			'Text',
			'URL',
		),
		'healthPlanNetworkId'                     => array(
			'Text',
		),
		'review'                                  => array(
			'Review',
		),
		'event'                                   => array(
			'Event',
		),
		'phoneticText'                            => array(
			'Text',
		),
		'returnShippingFeesAmount'                => array(
			'MonetaryAmount',
		),
		'governmentBenefitsInfo'                  => array(
			'GovernmentService',
		),
		'partOfTVSeries'                          => array(
			'TVSeries',
		),
		'addressRegion'                           => array(
			'AdministrativeArea',
			'Text',
		),
		'broadcastSubChannel'                     => array(
			'Text',
		),
		'headline'                                => array(
			'Text',
		),
		'numberOfDoors'                           => array(
			'QuantitativeValue',
			'Number',
		),
		'deathDate'                               => array(
			'Date',
		),
		'employerOverview'                        => array(
			'Text',
		),
		'affiliation'                             => array(
			'Organization',
		),
		'interactionStatistic'                    => array(
			'InteractionCounter',
		),
		'acceptsReservations'                     => array(
			'Boolean',
			'URL',
			'Text',
		),
		'workExample'                             => array(
			'CreativeWork',
		),
		'children'                                => array(
			'Person',
		),
		'touristType'                             => array(
			'Text',
			'Audience',
		),
		'certificationStatus'                     => array(
			'CertificationStatusEnumeration',
		),
		'xpath'                                   => array(
			'XPathType',
		),
		'closes'                                  => array(
			'Time',
		),
		'uploadDate'                              => array(
			'DateTime',
			'Date',
		),
		'cvdNumICUBeds'                           => array(
			'Number',
		),
		'iataCode'                                => array(
			'Text',
		),
		'gtin8'                                   => array(
			'Text',
		),
		'trialDesign'                             => array(
			'MedicalTrialDesign',
		),
		'nutrition'                               => array(
			'NutritionInformation',
		),
		'typeOfGood'                              => array(
			'Service',
			'Product',
		),
		'possibleComplication'                    => array(
			'Text',
		),
		'webFeed'                                 => array(
			'DataFeed',
			'URL',
		),
		'supersededBy'                            => array(
			'Property',
			'Class',
			'Enumeration',
		),
		'sku'                                     => array(
			'Text',
		),
		'isLiveBroadcast'                         => array(
			'Boolean',
		),
		'maxValue'                                => array(
			'Number',
		),
		'tourBookingPage'                         => array(
			'URL',
		),
		'artform'                                 => array(
			'URL',
			'Text',
		),
		'unitCode'                                => array(
			'URL',
			'Text',
		),
		'materialExtent'                          => array(
			'QuantitativeValue',
			'Text',
		),
		'softwareRequirements'                    => array(
			'URL',
			'SoftwareApplication',
			'Text',
		),
		'superEvent'                              => array(
			'Event',
		),
		'expectedArrivalFrom'                     => array(
			'DateTime',
			'Date',
		),
		'cheatCode'                               => array(
			'CreativeWork',
		),
		'domainIncludes'                          => array(
			'Class',
		),
		'distinguishingSign'                      => array(
			'MedicalSignOrSymptom',
		),
		'ccRecipient'                             => array(
			'ContactPoint',
			'Organization',
			'Person',
		),
		'measurementMethod'                       => array(
			'Text',
			'MeasurementMethodEnum',
			'DefinedTerm',
			'URL',
		),
		'employmentUnit'                          => array(
			'Organization',
		),
		'recordLabel'                             => array(
			'Organization',
		),
		'legalName'                               => array(
			'Text',
		),
		'address'                                 => array(
			'PostalAddress',
			'Text',
		),
		'publicTransportClosuresInfo'             => array(
			'URL',
			'WebContent',
		),
		'recipeIngredient'                        => array(
			'ItemList',
			'PropertyValue',
			'Text',
		),
		'category'                                => array(
			'Text',
			'PhysicalActivityCategory',
			'CategoryCode',
			'Thing',
			'URL',
		),
		'healthCondition'                         => array(
			'MedicalCondition',
		),
		'membershipPointsEarned'                  => array(
			'QuantitativeValue',
			'Number',
		),
		'follows'                                 => array(
			'Person',
		),
		'lesserOrEqual'                           => array(
			'QualitativeValue',
		),
		'programmingLanguage'                     => array(
			'ComputerLanguage',
			'Text',
		),
		'beneficiaryBank'                         => array(
			'BankOrCreditUnion',
			'Text',
		),
		'tocContinuation'                         => array(
			'HyperTocEntry',
		),
		'certificationRating'                     => array(
			'Rating',
		),
		'prescribingInfo'                         => array(
			'URL',
		),
		'hasTierBenefit'                          => array(
			'TierBenefitEnumeration',
		),
		'measurementDenominator'                  => array(
			'StatisticalVariable',
		),
		'isTierOf'                                => array(
			'MemberProgram',
		),
		'spatial'                                 => array(
			'Place',
		),
		'language'                                => array(
			'Language',
		),
		'valueReference'                          => array(
			'StructuredValue',
			'DefinedTerm',
			'PropertyValue',
			'QuantitativeValue',
			'Enumeration',
			'MeasurementTypeEnumeration',
			'Text',
			'QualitativeValue',
		),
		'carrierRequirements'                     => array(
			'Text',
		),
		'molecularFormula'                        => array(
			'Text',
		),
		'reviewCount'                             => array(
			'Integer',
		),
		'cookingMethod'                           => array(
			'Text',
		),
		'courseWorkload'                          => array(
			'Text',
		),
		'associatedClaimReview'                   => array(
			'Review',
		),
		'releaseOf'                               => array(
			'MusicAlbum',
		),
		'videoFormat'                             => array(
			'Text',
		),
		'homeTeam'                                => array(
			'Person',
			'SportsTeam',
		),
		'cvdNumC19OFMechVentPats'                 => array(
			'Number',
		),
		'parentTaxon'                             => array(
			'Taxon',
			'URL',
			'Text',
		),
		'elevation'                               => array(
			'Number',
			'Text',
		),
		'marginOfError'                           => array(
			'QuantitativeValue',
		),
		'gtin13'                                  => array(
			'Text',
		),
		'subTrip'                                 => array(
			'Trip',
		),
		'producer'                                => array(
			'Person',
			'Organization',
		),
		'audienceType'                            => array(
			'Text',
		),
		'cvdNumC19HOPats'                         => array(
			'Number',
		),
		'procedureType'                           => array(
			'MedicalProcedureType',
		),
		'vehicleSpecialUsage'                     => array(
			'Text',
			'CarUsageType',
		),
		'safetyConsideration'                     => array(
			'Text',
		),
		'offers'                                  => array(
			'Offer',
			'Demand',
		),
		'departureBoatTerminal'                   => array(
			'BoatTerminal',
		),
		'mentions'                                => array(
			'Thing',
		),
		'vehicleSeatingCapacity'                  => array(
			'QuantitativeValue',
			'Number',
		),
		'signDetected'                            => array(
			'MedicalSign',
		),
		'acceptedOffer'                           => array(
			'Offer',
		),
		'costPerUnit'                             => array(
			'Text',
			'QualitativeValue',
			'Number',
		),
		'encodings'                               => array(
			'MediaObject',
		),
		'servicePhone'                            => array(
			'ContactPoint',
		),
		'albumRelease'                            => array(
			'MusicRelease',
		),
		'workload'                                => array(
			'QuantitativeValue',
			'Energy',
		),
		'loanPaymentFrequency'                    => array(
			'Number',
		),
		'relatedTo'                               => array(
			'Person',
		),
		'valueName'                               => array(
			'Text',
		),
		'timeToComplete'                          => array(
			'Duration',
		),
		'customerRemorseReturnShippingFeesAmount' => array(
			'MonetaryAmount',
		),
		'seasonalOverride'                        => array(
			'OpeningHoursSpecification',
		),
		'serverStatus'                            => array(
			'GameServerStatus',
		),
		'domiciledMortgage'                       => array(
			'Boolean',
		),
		'study'                                   => array(
			'MedicalStudy',
		),
		'lowPrice'                                => array(
			'Text',
			'Number',
		),
		'isFamilyFriendly'                        => array(
			'Boolean',
		),
		'referenceQuantity'                       => array(
			'QuantitativeValue',
		),
		'serviceUrl'                              => array(
			'URL',
		),
		'mileageFromOdometer'                     => array(
			'QuantitativeValue',
		),
		'riskFactor'                              => array(
			'MedicalRiskFactor',
		),
		'accessibilityFeature'                    => array(
			'Text',
		),
		'legislationLegalForce'                   => array(
			'LegalForceStatus',
		),
		'monthsOfExperience'                      => array(
			'Number',
		),
		'secondaryPrevention'                     => array(
			'Drug',
			'DrugClass',
			'MedicalTherapy',
			'LifestyleModification',
		),
		'addressLocality'                         => array(
			'Text',
		),
		'datasetTimeInterval'                     => array(
			'DateTime',
		),
		'jobImmediateStart'                       => array(
			'Boolean',
		),
		'claimReviewed'                           => array(
			'Text',
		),
		'nationality'                             => array(
			'Country',
		),
		'termsOfService'                          => array(
			'URL',
			'Text',
		),
		'step'                                    => array(
			'Text',
			'HowToStep',
			'HowToSection',
			'CreativeWork',
		),
		'containsPlace'                           => array(
			'Place',
		),
		'memberOf'                                => array(
			'ProgramMembership',
			'Organization',
			'MemberProgramTier',
		),
		'suggestedAnswer'                         => array(
			'ItemList',
			'Answer',
		),
		'bookingTime'                             => array(
			'DateTime',
		),
		'gameServer'                              => array(
			'GameServer',
		),
		'videoFrameSize'                          => array(
			'Text',
		),
		'code'                                    => array(
			'MedicalCode',
		),
		'dateIssued'                              => array(
			'DateTime',
			'Date',
		),
		'version'                                 => array(
			'Number',
			'Text',
		),
		'availableFrom'                           => array(
			'DateTime',
		),
		'employmentType'                          => array(
			'Text',
		),
		'actionableFeedbackPolicy'                => array(
			'CreativeWork',
			'URL',
		),
		'floorLimit'                              => array(
			'MonetaryAmount',
		),
		'numberOfBeds'                            => array(
			'Number',
		),
		'purchaseDate'                            => array(
			'Date',
		),
		'originalMediaContextDescription'         => array(
			'Text',
		),
		'multipleValues'                          => array(
			'Boolean',
		),
		'video'                                   => array(
			'VideoObject',
			'Clip',
		),
		'events'                                  => array(
			'Event',
		),
		'contactlessPayment'                      => array(
			'Boolean',
		),
		'recordedIn'                              => array(
			'CreativeWork',
		),
		'flightNumber'                            => array(
			'Text',
		),
		'itemDefectReturnShippingFeesAmount'      => array(
			'MonetaryAmount',
		),
		'remainingAttendeeCapacity'               => array(
			'Integer',
		),
		'hasTiers'                                => array(
			'MemberProgramTier',
		),
		'birthDate'                               => array(
			'Date',
		),
		'ineligibleRegion'                        => array(
			'GeoShape',
			'Text',
			'Place',
		),
		'blogPost'                                => array(
			'BlogPosting',
		),
		'arrivalBoatTerminal'                     => array(
			'BoatTerminal',
		),
		'permittedUsage'                          => array(
			'Text',
		),
		'hasEnergyConsumptionDetails'             => array(
			'EnergyConsumptionDetails',
		),
		'endorsers'                               => array(
			'Person',
			'Organization',
		),
		'purchaseType'                            => array(
			'PurchaseType',
		),
		'operatingSystem'                         => array(
			'OperatingSystem',
			'Text',
		),
		'referee'                                 => array(
			'Person',
		),
		'merchant'                                => array(
			'Person',
			'Organization',
		),
		'applicationDeadline'                     => array(
			'Date',
			'Text',
		),
		'gameEdition'                             => array(
			'Text',
		),
		'relatedAnatomy'                          => array(
			'AnatomicalStructure',
			'AnatomicalSystem',
		),
		'permissionType'                          => array(
			'DigitalDocumentPermissionType',
		),
		'replacer'                                => array(
			'Thing',
		),
		'associatedDisease'                       => array(
			'MedicalCondition',
			'URL',
			'PropertyValue',
		),
		'hospitalAffiliation'                     => array(
			'Hospital',
		),
		'softwareVersion'                         => array(
			'Text',
		),
		'accountId'                               => array(
			'Text',
		),
		'availableOnDevice'                       => array(
			'Text',
		),
		'embedUrl'                                => array(
			'URL',
		),
		'workPerformed'                           => array(
			'CreativeWork',
		),
		'opens'                                   => array(
			'Time',
		),
		'musicArrangement'                        => array(
			'MusicComposition',
		),
		'postOp'                                  => array(
			'Text',
		),
		'feesAndCommissionsSpecification'         => array(
			'URL',
			'Text',
		),
		'author'                                  => array(
			'Organization',
			'Person',
		),
		'actionOption'                            => array(
			'Thing',
			'Text',
		),
		'percentile10'                            => array(
			'Number',
		),
		'item'                                    => array(
			'Thing',
		),
		'postOfficeBoxNumber'                     => array(
			'Text',
		),
		'hasBioPolymerSequence'                   => array(
			'Text',
		),
		'requiredMinAge'                          => array(
			'Integer',
		),
		'contentSize'                             => array(
			'Text',
		),
		'validFrom'                               => array(
			'DateTime',
			'Date',
		),
		'comment'                                 => array(
			'Comment',
		),
		'userInteractionCount'                    => array(
			'Integer',
		),
		'attendee'                                => array(
			'Person',
			'Organization',
		),
		'nerve'                                   => array(
			'Nerve',
		),
		'contentRating'                           => array(
			'Text',
			'Rating',
		),
		'subStructure'                            => array(
			'AnatomicalStructure',
		),
		'passengerPriorityStatus'                 => array(
			'Text',
			'QualitativeValue',
		),
		'priceComponent'                          => array(
			'PriceSpecification',
		),
		'postalCodeBegin'                         => array(
			'Text',
		),
		'incentiveCompensation'                   => array(
			'Text',
		),
		'fuelCapacity'                            => array(
			'QuantitativeValue',
		),
		'leaseLength'                             => array(
			'Duration',
			'QuantitativeValue',
		),
		'trailerWeight'                           => array(
			'QuantitativeValue',
		),
		'hasBioChemEntityPart'                    => array(
			'BioChemEntity',
		),
		'branchOf'                                => array(
			'Organization',
		),
		'contactPoint'                            => array(
			'ContactPoint',
		),
		'drainsTo'                                => array(
			'Vessel',
		),
		'collection'                              => array(
			'Thing',
		),
		'positiveNotes'                           => array(
			'ListItem',
			'Text',
			'WebContent',
			'ItemList',
		),
		'containedInPlace'                        => array(
			'Place',
		),
		'accommodationCategory'                   => array(
			'Text',
		),
		'dateline'                                => array(
			'Text',
		),
		'competencyRequired'                      => array(
			'DefinedTerm',
			'URL',
			'Text',
		),
		'iupacName'                               => array(
			'Text',
		),
		'carrier'                                 => array(
			'Organization',
		),
		'actionStatus'                            => array(
			'ActionStatusType',
		),
		'dosageForm'                              => array(
			'Text',
		),
		'reviewAspect'                            => array(
			'Text',
			'StructuredValue',
		),
		'inBroadcastLineup'                       => array(
			'CableOrSatelliteService',
		),
		'typeOfBed'                               => array(
			'Text',
			'BedType',
		),
		'processingTime'                          => array(
			'Duration',
		),
		'subjectOf'                               => array(
			'Event',
			'CreativeWork',
		),
		'foodEvent'                               => array(
			'FoodEvent',
		),
		'relatedDrug'                             => array(
			'Drug',
		),
		'encodesBioChemEntity'                    => array(
			'BioChemEntity',
		),
		'naturalProgression'                      => array(
			'Text',
		),
		'healthPlanCostSharing'                   => array(
			'HealthPlanCostSharingSpecification',
			'Boolean',
		),
		'significance'                            => array(
			'Text',
		),
		'manufacturer'                            => array(
			'Organization',
		),
		'lodgingUnitType'                         => array(
			'QualitativeValue',
			'Text',
		),
		'trainingSalary'                          => array(
			'MonetaryAmountDistribution',
		),
		'recourseLoan'                            => array(
			'Boolean',
		),
		'eligibleCustomerType'                    => array(
			'BusinessEntityType',
		),
		'sdLicense'                               => array(
			'CreativeWork',
			'URL',
		),
		'shippingDestination'                     => array(
			'DefinedRegion',
		),
		'orderDate'                               => array(
			'DateTime',
			'Date',
		),
		'isInvolvedInBiologicalProcess'           => array(
			'DefinedTerm',
			'URL',
			'PropertyValue',
		),
		'employees'                               => array(
			'Person',
		),
		'incentivizedItem'                        => array(
			'DefinedTerm',
			'Product',
		),
		'programmingModel'                        => array(
			'Text',
		),
		'contentReferenceTime'                    => array(
			'DateTime',
		),
		'agent'                                   => array(
			'Organization',
			'Person',
		),
		'recognizedBy'                            => array(
			'Organization',
		),
		'validForMemberTier'                      => array(
			'MemberProgramTier',
		),
		'contentLocation'                         => array(
			'Place',
		),
		'hasBroadcastChannel'                     => array(
			'BroadcastChannel',
		),
		'albums'                                  => array(
			'MusicAlbum',
		),
		'accountOverdraftLimit'                   => array(
			'MonetaryAmount',
		),
		'colorSwatch'                             => array(
			'ImageObject',
			'URL',
		),
		'educationalFramework'                    => array(
			'Text',
		),
		'dateReceived'                            => array(
			'DateTime',
		),
		'sodiumContent'                           => array(
			'Mass',
		),
		'caption'                                 => array(
			'Text',
			'MediaObject',
		),
		'quarantineGuidelines'                    => array(
			'URL',
			'WebContent',
		),
		'codeRepository'                          => array(
			'URL',
		),
		'modelDate'                               => array(
			'Date',
		),
		'priceComponentType'                      => array(
			'PriceComponentTypeEnumeration',
		),
		'datePublished'                           => array(
			'Date',
			'DateTime',
		),
		'arrivalPlatform'                         => array(
			'Text',
		),
		'sdPublisher'                             => array(
			'Person',
			'Organization',
		),
		'openingHours'                            => array(
			'Text',
		),
		'tongueWeight'                            => array(
			'QuantitativeValue',
		),
		'occupationalCredentialAwarded'           => array(
			'EducationalOccupationalCredential',
			'URL',
			'Text',
		),
		'episode'                                 => array(
			'Episode',
		),
		'bioChemInteraction'                      => array(
			'BioChemEntity',
		),
		'programMembershipUsed'                   => array(
			'ProgramMembership',
		),
		'ethicsPolicy'                            => array(
			'CreativeWork',
			'URL',
		),
		'suitableForDiet'                         => array(
			'RestrictedDiet',
		),
		'area'                                    => array(
			'Place',
		),
		'suggestedMaxAge'                         => array(
			'Number',
		),
		'pathophysiology'                         => array(
			'Text',
		),
		'surface'                                 => array(
			'Text',
			'URL',
		),
		'identifyingTest'                         => array(
			'MedicalTest',
		),
		'geoMidpoint'                             => array(
			'GeoCoordinates',
		),
		'numberOfAvailableAccommodationUnits'     => array(
			'QuantitativeValue',
		),
		'expertConsiderations'                    => array(
			'Text',
		),
		'affectedBy'                              => array(
			'Drug',
		),
		'alternativeHeadline'                     => array(
			'Text',
		),
		'lyricist'                                => array(
			'Person',
		),
		'permitAudience'                          => array(
			'Audience',
		),
		'repeatFrequency'                         => array(
			'Text',
			'Duration',
		),
		'recipe'                                  => array(
			'Recipe',
		),
		'applicableLocation'                      => array(
			'AdministrativeArea',
		),
		'reservationId'                           => array(
			'Text',
		),
		'requiredMaxAge'                          => array(
			'Integer',
		),
		'supportingData'                          => array(
			'DataFeed',
		),
		'percentile75'                            => array(
			'Number',
		),
		'geoEquals'                               => array(
			'GeospatialGeometry',
			'Place',
		),
		'mechanismOfAction'                       => array(
			'Text',
		),
		'rxcui'                                   => array(
			'Text',
		),
		'salaryCurrency'                          => array(
			'Text',
		),
		'ticketToken'                             => array(
			'URL',
			'Text',
		),
		'hasParticipationOffer'                   => array(
			'Offer',
		),
		'isbn'                                    => array(
			'Text',
		),
		'grantee'                                 => array(
			'Audience',
			'ContactPoint',
			'Person',
			'Organization',
		),
		'abstract'                                => array(
			'Text',
		),
		'vehicleIdentificationNumber'             => array(
			'Text',
		),
		'orderStatus'                             => array(
			'OrderStatus',
		),
		'geographicArea'                          => array(
			'AdministrativeArea',
		),
		'publisherImprint'                        => array(
			'Organization',
		),
		'encodingFormat'                          => array(
			'URL',
			'Text',
		),
		'inLanguage'                              => array(
			'Language',
			'Text',
		),
		'loanRepaymentForm'                       => array(
			'RepaymentSpecification',
		),
		'healthPlanPharmacyCategory'              => array(
			'Text',
		),
		'biomechnicalClass'                       => array(
			'Text',
		),
		'acceptedAnswer'                          => array(
			'Answer',
			'ItemList',
		),
		'trainName'                               => array(
			'Text',
		),
		'accessCode'                              => array(
			'Text',
		),
		'produces'                                => array(
			'Thing',
		),
		'mainEntityOfPage'                        => array(
			'CreativeWork',
			'URL',
		),
		'ticketNumber'                            => array(
			'Text',
		),
		'arrivalStation'                          => array(
			'TrainStation',
		),
		'dietFeatures'                            => array(
			'Text',
		),
		'layoutImage'                             => array(
			'ImageObject',
			'URL',
		),
		'significantLink'                         => array(
			'URL',
		),
		'game'                                    => array(
			'VideoGame',
		),
		'dateCreated'                             => array(
			'DateTime',
			'Date',
		),
		'benefitsSummaryUrl'                      => array(
			'URL',
		),
		'albumReleaseType'                        => array(
			'MusicAlbumReleaseType',
		),
		'archiveHeld'                             => array(
			'ArchiveComponent',
		),
		'hasCertification'                        => array(
			'Certification',
		),
		'seller'                                  => array(
			'Person',
			'Organization',
		),
		'negativeNotes'                           => array(
			'ItemList',
			'ListItem',
			'Text',
			'WebContent',
		),
		'increasesRiskOf'                         => array(
			'MedicalEntity',
		),
		'yield'                                   => array(
			'QuantitativeValue',
			'Text',
		),
		'hasDriveThroughService'                  => array(
			'Boolean',
		),
		'includesAttraction'                      => array(
			'TouristAttraction',
		),
		'restockingFee'                           => array(
			'Number',
			'MonetaryAmount',
		),
		'numberOfPreviousOwners'                  => array(
			'QuantitativeValue',
			'Number',
		),
		'typicalCreditsPerTerm'                   => array(
			'StructuredValue',
			'Integer',
		),
		'wheelbase'                               => array(
			'QuantitativeValue',
		),
		'legislationDateVersion'                  => array(
			'Date',
		),
		'accommodationFloorPlan'                  => array(
			'FloorPlan',
		),
		'subEvents'                               => array(
			'Event',
		),
		'fromLocation'                            => array(
			'Place',
		),
		'additionalProperty'                      => array(
			'PropertyValue',
		),
		'broadcastServiceTier'                    => array(
			'Text',
		),
		'numberOfEmployees'                       => array(
			'QuantitativeValue',
		),
		'renegotiableLoan'                        => array(
			'Boolean',
		),
		'torque'                                  => array(
			'QuantitativeValue',
		),
		'sourceOrganization'                      => array(
			'Organization',
		),
		'depth'                                   => array(
			'Distance',
			'QuantitativeValue',
		),
		'runsTo'                                  => array(
			'Vessel',
		),
		'roleName'                                => array(
			'URL',
			'Text',
		),
		'audio'                                   => array(
			'MusicRecording',
			'Clip',
			'AudioObject',
		),
		'usedToDiagnose'                          => array(
			'MedicalCondition',
		),
		'isPartOfBioChemEntity'                   => array(
			'BioChemEntity',
		),
		'composer'                                => array(
			'Person',
			'Organization',
		),
		'monoisotopicMolecularWeight'             => array(
			'QuantitativeValue',
			'Text',
		),
		'targetDescription'                       => array(
			'Text',
		),
		'expressedIn'                             => array(
			'DefinedTerm',
			'AnatomicalSystem',
			'BioChemEntity',
			'AnatomicalStructure',
		),
		'workHours'                               => array(
			'Text',
		),
		'targetPopulation'                        => array(
			'Text',
		),
		'distance'                                => array(
			'Distance',
		),
		'availableLanguage'                       => array(
			'Language',
			'Text',
		),
		'serviceType'                             => array(
			'Text',
			'GovernmentBenefitsType',
		),
		'expectedArrivalUntil'                    => array(
			'Date',
			'DateTime',
		),
		'issuedThrough'                           => array(
			'Service',
		),
		'healthPlanCopay'                         => array(
			'PriceSpecification',
		),
		'appliesToDeliveryMethod'                 => array(
			'DeliveryMethod',
		),
		'answerExplanation'                       => array(
			'Comment',
			'WebContent',
		),
		'eventStatus'                             => array(
			'EventStatusType',
		),
		'seriousAdverseOutcome'                   => array(
			'MedicalEntity',
		),
		'subEvent'                                => array(
			'Event',
		),
		'legislationRepeals'                      => array(
			'Legislation',
		),
		'mainContentOfPage'                       => array(
			'WebPageElement',
		),
		'followup'                                => array(
			'Text',
		),
		'occupationalCategory'                    => array(
			'Text',
			'CategoryCode',
		),
		'paymentMethodType'                       => array(
			'PaymentMethodType',
		),
		'arrivalTerminal'                         => array(
			'Text',
		),
		'preOp'                                   => array(
			'Text',
		),
		'inProductGroupWithID'                    => array(
			'Text',
		),
		'securityScreening'                       => array(
			'Text',
		),
		'quest'                                   => array(
			'Thing',
		),
		'learningResourceType'                    => array(
			'Text',
			'DefinedTerm',
		),
		'minValue'                                => array(
			'Number',
		),
		'resultReview'                            => array(
			'Review',
		),
		'circle'                                  => array(
			'Text',
		),
		'creativeWorkStatus'                      => array(
			'DefinedTerm',
			'Text',
		),
		'potentialUse'                            => array(
			'DefinedTerm',
		),
		'hasDigitalDocumentPermission'            => array(
			'DigitalDocumentPermission',
		),
		'audience'                                => array(
			'Audience',
		),
		'dayOfWeek'                               => array(
			'DayOfWeek',
		),
		'startDate'                               => array(
			'DateTime',
			'Date',
		),
		'gettingTestedInfo'                       => array(
			'URL',
			'WebContent',
		),
		'iso6523Code'                             => array(
			'Text',
		),
		'vehicleEngine'                           => array(
			'EngineSpecification',
		),
		'cvdNumC19Died'                           => array(
			'Number',
		),
		'breastfeedingWarning'                    => array(
			'Text',
		),
		'sharedContent'                           => array(
			'CreativeWork',
		),
		'typicalTest'                             => array(
			'MedicalTest',
		),
		'auditDate'                               => array(
			'DateTime',
			'Date',
		),
		'byDay'                                   => array(
			'Text',
			'DayOfWeek',
		),
		'guidelineDate'                           => array(
			'Date',
		),
		'birthPlace'                              => array(
			'Place',
		),
		'intensity'                               => array(
			'QuantitativeValue',
			'Text',
		),
		'serviceArea'                             => array(
			'AdministrativeArea',
			'GeoShape',
			'Place',
		),
		'trailer'                                 => array(
			'VideoObject',
		),
		'supply'                                  => array(
			'Text',
			'HowToSupply',
		),
		'correctionsPolicy'                       => array(
			'URL',
			'CreativeWork',
		),
		'locationCreated'                         => array(
			'Place',
		),
		'ingredients'                             => array(
			'Text',
		),
		'returnLabelSource'                       => array(
			'ReturnLabelSourceEnumeration',
		),
		'fiberContent'                            => array(
			'Mass',
		),
		'acceptedPaymentMethod'                   => array(
			'Text',
			'LoanOrCredit',
			'PaymentMethod',
		),
		'broadcastFrequency'                      => array(
			'Text',
			'BroadcastFrequencySpecification',
		),
		'byMonthWeek'                             => array(
			'Integer',
		),
		'itemOffered'                             => array(
			'Product',
			'Event',
			'AggregateOffer',
			'Trip',
			'CreativeWork',
			'Service',
			'MenuItem',
		),
		'legislationEnsuresImplementationOf'      => array(
			'Legislation',
		),
		'legalStatus'                             => array(
			'Text',
			'DrugLegalStatus',
			'MedicalEnumeration',
		),
		'performer'                               => array(
			'Person',
			'Organization',
		),
		'line'                                    => array(
			'Text',
		),
		'numChildren'                             => array(
			'QuantitativeValue',
			'Integer',
		),
		'transFatContent'                         => array(
			'Mass',
		),
		'recipient'                               => array(
			'ContactPoint',
			'Person',
			'Organization',
			'Audience',
		),
		'availability'                            => array(
			'ItemAvailability',
		),
		'repetitions'                             => array(
			'QuantitativeValue',
			'Number',
		),
		'billingPeriod'                           => array(
			'Duration',
		),
		'diseaseSpreadStatistics'                 => array(
			'Dataset',
			'URL',
			'WebContent',
			'Observation',
		),
		'workTranslation'                         => array(
			'CreativeWork',
		),
		'loanTerm'                                => array(
			'QuantitativeValue',
		),
		'albumProductionType'                     => array(
			'MusicAlbumProductionType',
		),
		'volumeNumber'                            => array(
			'Text',
			'Integer',
		),
		'liveBlogUpdate'                          => array(
			'BlogPosting',
		),
		'loanMortgageMandateAmount'               => array(
			'MonetaryAmount',
		),
		'typicalAgeRange'                         => array(
			'Text',
		),
		'returnPolicyCategory'                    => array(
			'MerchantReturnEnumeration',
		),
		'isResizable'                             => array(
			'Boolean',
		),
		'underName'                               => array(
			'Person',
			'Organization',
		),
		'recommendationStrength'                  => array(
			'Text',
		),
		'contentType'                             => array(
			'Text',
		),
		'jobBenefits'                             => array(
			'Text',
		),
		'isicV4'                                  => array(
			'Text',
		),
		'scheduleTimezone'                        => array(
			'Text',
		),
		'recordingOf'                             => array(
			'MusicComposition',
		),
		'deliveryMethod'                          => array(
			'DeliveryMethod',
		),
		'jobLocation'                             => array(
			'Place',
		),
		'costOrigin'                              => array(
			'Text',
		),
		'departureAirport'                        => array(
			'Airport',
		),
		'awayTeam'                                => array(
			'SportsTeam',
			'Person',
		),
		'medicalAudience'                         => array(
			'MedicalAudienceType',
			'MedicalAudience',
		),
		'option'                                  => array(
			'Text',
			'Thing',
		),
		'season'                                  => array(
			'CreativeWorkSeason',
			'URL',
		),
		'healthPlanCoinsuranceRate'               => array(
			'Number',
		),
		'departurePlatform'                       => array(
			'Text',
		),
		'bodyType'                                => array(
			'Text',
			'QualitativeValue',
			'URL',
		),
		'childMinAge'                             => array(
			'Number',
		),
		'timestamp'                               => array(
			'DateTime',
		),
		'equal'                                   => array(
			'QualitativeValue',
		),
		'iswcCode'                                => array(
			'Text',
		),
		'relevantOccupation'                      => array(
			'Occupation',
		),
		'ownedFrom'                               => array(
			'DateTime',
		),
		'highPrice'                               => array(
			'Number',
			'Text',
		),
		'validUntil'                              => array(
			'Date',
		),
		'postalCodeEnd'                           => array(
			'Text',
		),
		'saturatedFatContent'                     => array(
			'Mass',
		),
		'observationAbout'                        => array(
			'Place',
			'Thing',
		),
		'servingSize'                             => array(
			'Text',
		),
		'courseCode'                              => array(
			'Text',
		),
		'measurementQualifier'                    => array(
			'Enumeration',
		),
		'identifyingExam'                         => array(
			'PhysicalExam',
		),
		'creator'                                 => array(
			'Person',
			'Organization',
		),
		'checkinTime'                             => array(
			'DateTime',
			'Time',
		),
		'color'                                   => array(
			'Text',
		),
		'cvdNumVent'                              => array(
			'Number',
		),
		'broadcaster'                             => array(
			'Organization',
		),
		'discount'                                => array(
			'Number',
			'Text',
		),
		'numberOfAirbags'                         => array(
			'Number',
			'Text',
		),
		'isBasedOnUrl'                            => array(
			'CreativeWork',
			'URL',
			'Product',
		),
		'percentile90'                            => array(
			'Number',
		),
		'reviewedBy'                              => array(
			'Person',
			'Organization',
		),
		'associatedMediaReview'                   => array(
			'Review',
		),
		'suggestedAge'                            => array(
			'QuantitativeValue',
		),
		'measuredProperty'                        => array(
			'Property',
		),
		'publicationType'                         => array(
			'Text',
		),
		'deliveryAddress'                         => array(
			'PostalAddress',
		),
		'includesObject'                          => array(
			'TypeAndQuantityNode',
		),
		'ownedThrough'                            => array(
			'DateTime',
		),
		'returnPolicySeasonalOverride'            => array(
			'MerchantReturnPolicySeasonalOverride',
		),
		'dateRead'                                => array(
			'Date',
			'DateTime',
		),
		'fileFormat'                              => array(
			'URL',
			'Text',
		),
		'titleEIDR'                               => array(
			'URL',
			'Text',
		),
		'itemCondition'                           => array(
			'OfferItemCondition',
		),
		'bodyLocation'                            => array(
			'Text',
		),
		'encoding'                                => array(
			'MediaObject',
		),
		'releasedEvent'                           => array(
			'PublicationEvent',
		),
		'accountablePerson'                       => array(
			'Person',
		),
		'musicCompositionForm'                    => array(
			'Text',
		),
		'steps'                                   => array(
			'CreativeWork',
			'ItemList',
			'Text',
		),
		'educationalUse'                          => array(
			'Text',
			'DefinedTerm',
		),
		'subtitleLanguage'                        => array(
			'Text',
			'Language',
		),
		'chemicalComposition'                     => array(
			'Text',
		),
		'department'                              => array(
			'Organization',
		),
		'playMode'                                => array(
			'GamePlayMode',
		),
		'ticketedSeat'                            => array(
			'Seat',
		),
		'percentile25'                            => array(
			'Number',
		),
		'availableChannel'                        => array(
			'ServiceChannel',
		),
		'sizeGroup'                               => array(
			'Text',
			'SizeGroupEnumeration',
		),
		'costCategory'                            => array(
			'DrugCostCategory',
		),
		'cargoVolume'                             => array(
			'QuantitativeValue',
		),
		'greaterOrEqual'                          => array(
			'QualitativeValue',
		),
		'legalRepresentative'                     => array(
			'Person',
		),
		'accountMinimumInflow'                    => array(
			'MonetaryAmount',
		),
		'flightDistance'                          => array(
			'Distance',
			'Text',
		),
		'bioChemSimilarity'                       => array(
			'BioChemEntity',
		),
		'regionsAllowed'                          => array(
			'Place',
		),
		'occupancy'                               => array(
			'QuantitativeValue',
		),
		'physicalRequirement'                     => array(
			'DefinedTerm',
			'URL',
			'Text',
		),
		'isAcceptingNewPatients'                  => array(
			'Boolean',
		),
		'productionDate'                          => array(
			'Date',
		),
		'fuelConsumption'                         => array(
			'QuantitativeValue',
		),
		'sportsActivityLocation'                  => array(
			'SportsActivityLocation',
		),
		'activityFrequency'                       => array(
			'Text',
			'QuantitativeValue',
		),
		'foundingLocation'                        => array(
			'Place',
		),
		'schemaVersion'                           => array(
			'Text',
			'URL',
		),
		'companyRegistration'                     => array(
			'Certification',
		),
		'businessFunction'                        => array(
			'BusinessFunction',
		),
		'minimumPaymentDue'                       => array(
			'PriceSpecification',
			'MonetaryAmount',
		),
		'durationOfWarranty'                      => array(
			'QuantitativeValue',
		),
		'workFeatured'                            => array(
			'CreativeWork',
		),
		'codeSampleType'                          => array(
			'Text',
		),
		'acquiredFrom'                            => array(
			'Person',
			'Organization',
		),
		'dateVehicleFirstRegistered'              => array(
			'Date',
		),
		'hasMemberProgram'                        => array(
			'MemberProgram',
		),
		'member'                                  => array(
			'Organization',
			'Person',
		),
		'catalogNumber'                           => array(
			'Text',
		),
		'potentialAction'                         => array(
			'Action',
		),
		'jurisdiction'                            => array(
			'AdministrativeArea',
			'Text',
		),
		'isUnlabelledFallback'                    => array(
			'Boolean',
		),
		'dateDeleted'                             => array(
			'DateTime',
			'Date',
		),
		'tocEntry'                                => array(
			'HyperTocEntry',
		),
		'adverseOutcome'                          => array(
			'MedicalEntity',
		),
		'accessibilityHazard'                     => array(
			'Text',
		),
		'correction'                              => array(
			'CorrectionComment',
			'URL',
			'Text',
		),
		'recipeYield'                             => array(
			'QuantitativeValue',
			'Text',
		),
		'sport'                                   => array(
			'Text',
			'URL',
		),
		'appliesToPaymentMethod'                  => array(
			'PaymentMethod',
		),
		'pageStart'                               => array(
			'Text',
			'Integer',
		),
		'episodeNumber'                           => array(
			'Text',
			'Integer',
		),
		'fulfillmentType'                         => array(
			'FulfillmentTypeEnumeration',
		),
		'advanceBookingRequirement'               => array(
			'QuantitativeValue',
		),
		'doseValue'                               => array(
			'Number',
			'QualitativeValue',
		),
		'hasOccupation'                           => array(
			'Occupation',
		),
		'differentialDiagnosis'                   => array(
			'DDxElement',
		),
		'printSection'                            => array(
			'Text',
		),
		'menu'                                    => array(
			'Menu',
			'URL',
			'Text',
		),
		'doesNotShip'                             => array(
			'Boolean',
		),
		'functionalClass'                         => array(
			'MedicalEntity',
			'Text',
		),
		'drugClass'                               => array(
			'DrugClass',
		),
		'legislationCountersignedBy'              => array(
			'Person',
			'Organization',
		),
		'geoDisjoint'                             => array(
			'Place',
			'GeospatialGeometry',
		),
		'colleague'                               => array(
			'Person',
			'URL',
		),
		'doorTime'                                => array(
			'Time',
			'DateTime',
		),
		'menuAddOn'                               => array(
			'MenuSection',
			'MenuItem',
		),
		'collectionSize'                          => array(
			'Integer',
		),
		'arrivalAirport'                          => array(
			'Airport',
		),
		'buyer'                                   => array(
			'Person',
			'Organization',
		),
		'musicGroupMember'                        => array(
			'Person',
		),
		'proteinContent'                          => array(
			'Mass',
		),
		'travelBans'                              => array(
			'URL',
			'WebContent',
		),
		'lifeEvent'                               => array(
			'Event',
		),
		'rsvpResponse'                            => array(
			'RsvpResponseType',
		),
		'documentation'                           => array(
			'URL',
			'CreativeWork',
		),
		'partOfSystem'                            => array(
			'AnatomicalSystem',
		),
		'actionApplication'                       => array(
			'SoftwareApplication',
		),
		'isVariantOf'                             => array(
			'ProductModel',
			'ProductGroup',
		),
		'bloodSupply'                             => array(
			'Vessel',
		),
		'studyLocation'                           => array(
			'AdministrativeArea',
		),
		'itemListElement'                         => array(
			'Thing',
			'ListItem',
			'Text',
		),
		'unitText'                                => array(
			'Text',
		),
		'legislationCorrects'                     => array(
			'Legislation',
		),
		'album'                                   => array(
			'MusicAlbum',
		),
		'longitude'                               => array(
			'Number',
			'Text',
		),
		'honorificSuffix'                         => array(
			'Text',
		),
		'contactOption'                           => array(
			'ContactPointOption',
		),
		'inStoreReturnsOffered'                   => array(
			'Boolean',
		),
		'minPrice'                                => array(
			'Number',
		),
		'geoIntersects'                           => array(
			'Place',
			'GeospatialGeometry',
		),
		'urlTemplate'                             => array(
			'Text',
		),
		'healthPlanMarketingUrl'                  => array(
			'URL',
		),
		'cvdNumVentUse'                           => array(
			'Number',
		),
		'fuelType'                                => array(
			'URL',
			'Text',
			'QualitativeValue',
		),
		'alumni'                                  => array(
			'Person',
		),
		'availableService'                        => array(
			'MedicalProcedure',
			'MedicalTest',
			'MedicalTherapy',
		),
		'estimatedCost'                           => array(
			'MonetaryAmount',
			'Text',
		),
		'speed'                                   => array(
			'QuantitativeValue',
		),
		'subOrganization'                         => array(
			'Organization',
		),
		'temporal'                                => array(
			'Text',
			'DateTime',
		),
		'announcementLocation'                    => array(
			'CivicStructure',
			'LocalBusiness',
		),
		'seatingType'                             => array(
			'Text',
			'QualitativeValue',
		),
		'legalAddress'                            => array(
			'PostalAddress',
		),
		'targetProduct'                           => array(
			'SoftwareApplication',
		),
		'studySubject'                            => array(
			'MedicalEntity',
		),
		'publishedBy'                             => array(
			'Person',
			'Organization',
		),
		'isSimilarTo'                             => array(
			'Service',
			'Product',
		),
		'stageAsNumber'                           => array(
			'Number',
		),
		'orderValue'                              => array(
			'MonetaryAmount',
		),
		'energyEfficiencyScaleMax'                => array(
			'EUEnergyEfficiencyEnumeration',
		),
		'byMonthDay'                              => array(
			'Integer',
		),
		'speakable'                               => array(
			'URL',
			'SpeakableSpecification',
		),
		'relatedStructure'                        => array(
			'AnatomicalStructure',
		),
		'nextItem'                                => array(
			'ListItem',
		),
		'requiresSubscription'                    => array(
			'Boolean',
			'MediaSubscription',
		),
		'dropoffLocation'                         => array(
			'Place',
		),
		'executableLibraryName'                   => array(
			'Text',
		),
		'gracePeriod'                             => array(
			'Duration',
		),
		'reservationStatus'                       => array(
			'ReservationStatusType',
		),
		'course'                                  => array(
			'Place',
		),
		'instrument'                              => array(
			'Thing',
		),
		'checkoutTime'                            => array(
			'DateTime',
			'Time',
		),
		'educationalRole'                         => array(
			'Text',
		),
		'expires'                                 => array(
			'DateTime',
			'Date',
		),
		'softwareHelp'                            => array(
			'CreativeWork',
		),
		'interestRate'                            => array(
			'QuantitativeValue',
			'Number',
		),
		'physiologicalBenefits'                   => array(
			'Text',
		),
		'relatedCondition'                        => array(
			'MedicalCondition',
		),
		'diseasePreventionInfo'                   => array(
			'URL',
			'WebContent',
		),
		'variableMeasured'                        => array(
			'Property',
			'PropertyValue',
			'Text',
			'StatisticalVariable',
		),
		'knows'                                   => array(
			'Person',
		),
		'numberOfEpisodes'                        => array(
			'Integer',
		),
		'programType'                             => array(
			'Text',
			'DefinedTerm',
		),
		'energyEfficiencyScaleMin'                => array(
			'EUEnergyEfficiencyEnumeration',
		),
		'itemLocation'                            => array(
			'Place',
			'PostalAddress',
			'Text',
		),
		'engineType'                              => array(
			'URL',
			'Text',
			'QualitativeValue',
		),
		'telephone'                               => array(
			'Text',
		),
		'merchantReturnLink'                      => array(
			'URL',
		),
		'applicationCategory'                     => array(
			'Text',
			'URL',
		),
		'sibling'                                 => array(
			'Person',
		),
		'hasDeliveryMethod'                       => array(
			'DeliveryMethod',
		),
		'replacee'                                => array(
			'Thing',
		),
		'aggregateElement'                        => array(
			'Thing',
		),
		'industry'                                => array(
			'DefinedTerm',
			'Text',
		),
		'bookingAgent'                            => array(
			'Organization',
			'Person',
		),
		'contactPoints'                           => array(
			'ContactPoint',
		),
		'paymentMethod'                           => array(
			'PaymentMethod',
			'Text',
		),
		'diet'                                    => array(
			'Diet',
		),
		'endorsee'                                => array(
			'Person',
			'Organization',
		),
		'copyrightNotice'                         => array(
			'Text',
		),
		'boardingGroup'                           => array(
			'Text',
		),
		'exchangeRateSpread'                      => array(
			'Number',
			'MonetaryAmount',
		),
		'isEncodedByBioChemEntity'                => array(
			'Gene',
		),
		'prescriptionStatus'                      => array(
			'DrugPrescriptionStatus',
			'Text',
		),
		'starRating'                              => array(
			'Rating',
		),
		'newsUpdatesAndGuidelines'                => array(
			'URL',
			'WebContent',
		),
		'median'                                  => array(
			'Number',
		),
		'broadcastAffiliateOf'                    => array(
			'Organization',
		),
		'infectiousAgent'                         => array(
			'Text',
		),
		'netWorth'                                => array(
			'PriceSpecification',
			'MonetaryAmount',
		),
		'availableIn'                             => array(
			'AdministrativeArea',
		),
		'cvdFacilityCounty'                       => array(
			'Text',
		),
		'hiringOrganization'                      => array(
			'Person',
			'Organization',
		),
		'offerCount'                              => array(
			'Integer',
		),
		'jobLocationType'                         => array(
			'Text',
		),
		'recipeCuisine'                           => array(
			'Text',
		),
		'estimatesRiskOf'                         => array(
			'MedicalEntity',
		),
		'recognizingAuthority'                    => array(
			'Organization',
		),
		'discountCode'                            => array(
			'Text',
		),
		'hasSponsorshipOffer'                     => array(
			'Offer',
		),
		'mpn'                                     => array(
			'Text',
		),
		'coverageEndTime'                         => array(
			'DateTime',
		),
		'warrantyScope'                           => array(
			'WarrantyScope',
		),
		'drugUnit'                                => array(
			'Text',
		),
		'greater'                                 => array(
			'QualitativeValue',
		),
		'risks'                                   => array(
			'Text',
		),
		'incentiveType'                           => array(
			'IncentiveType',
		),
		'arrivalBusStop'                          => array(
			'BusStop',
			'BusStation',
		),
		'programPrerequisites'                    => array(
			'Course',
			'EducationalOccupationalCredential',
			'AlignmentObject',
			'Text',
		),
		'shippingOrigin'                          => array(
			'DefinedRegion',
		),
		'workLocation'                            => array(
			'Place',
			'ContactPoint',
		),
		'priceRange'                              => array(
			'Text',
		),
		'predecessorOf'                           => array(
			'ProductModel',
		),
		'contactType'                             => array(
			'Text',
		),
		'maps'                                    => array(
			'URL',
		),
		'educationRequirements'                   => array(
			'Text',
			'EducationalOccupationalCredential',
		),
		'competitor'                              => array(
			'Person',
			'SportsTeam',
		),
		'installUrl'                              => array(
			'URL',
		),
		'eligibleRegion'                          => array(
			'GeoShape',
			'Text',
			'Place',
		),
		'ratingCount'                             => array(
			'Integer',
		),
		'gameItem'                                => array(
			'Thing',
		),
		'description'                             => array(
			'TextObject',
			'Text',
		),
		'creditedTo'                              => array(
			'Person',
			'Organization',
		),
		'legislationResponsible'                  => array(
			'Person',
			'Organization',
		),
		'ratingValue'                             => array(
			'Number',
			'Text',
		),
		'stepValue'                               => array(
			'Number',
		),
		'numItems'                                => array(
			'QuantitativeValue',
		),
		'commentText'                             => array(
			'Text',
		),
		'incentives'                              => array(
			'Text',
		),
		'previousItem'                            => array(
			'ListItem',
		),
		'numberOfLoanPayments'                    => array(
			'Number',
		),
		'frequency'                               => array(
			'Text',
		),
		'partySize'                               => array(
			'Integer',
			'QuantitativeValue',
		),
		'includedRiskFactor'                      => array(
			'MedicalRiskFactor',
		),
		'trackingNumber'                          => array(
			'Text',
		),
		'musicReleaseFormat'                      => array(
			'MusicReleaseFormatType',
		),
		'restPeriods'                             => array(
			'Text',
			'QuantitativeValue',
		),
		'sdDatePublished'                         => array(
			'Date',
		),
		'cvdNumICUBedsOcc'                        => array(
			'Number',
		),
		'petsAllowed'                             => array(
			'Boolean',
			'Text',
		),
		'requirements'                            => array(
			'URL',
			'Text',
		),
		'doseUnit'                                => array(
			'Text',
		),
		'engineDisplacement'                      => array(
			'QuantitativeValue',
		),
		'teaches'                                 => array(
			'DefinedTerm',
			'Text',
		),
		'deliveryTime'                            => array(
			'ShippingDeliveryTime',
		),
		'carbohydrateContent'                     => array(
			'Mass',
		),
		'hasMenu'                                 => array(
			'Text',
			'Menu',
			'URL',
		),
		'healthPlanId'                            => array(
			'Text',
		),
		'reviewRating'                            => array(
			'Rating',
		),
		'sportsTeam'                              => array(
			'SportsTeam',
		),
		'screenCount'                             => array(
			'Number',
		),
		'alcoholWarning'                          => array(
			'Text',
		),
		'partOfSeries'                            => array(
			'CreativeWorkSeries',
		),
		'businessDays'                            => array(
			'OpeningHoursSpecification',
			'DayOfWeek',
		),
		'dataset'                                 => array(
			'Dataset',
		),
		'alumniOf'                                => array(
			'EducationalOrganization',
			'Organization',
		),
		'numberOfItems'                           => array(
			'Integer',
		),
		'publishingPrinciples'                    => array(
			'CreativeWork',
			'URL',
		),
		'hasStore'                                => array(
			'OnlineStore',
		),
		'productionCompany'                       => array(
			'Organization',
		),
		'trackingUrl'                             => array(
			'URL',
		),
		'valueMaxLength'                          => array(
			'Number',
		),
		'nerveMotor'                              => array(
			'Muscle',
		),
		'includedDataCatalog'                     => array(
			'DataCatalog',
		),
		'hasHealthAspect'                         => array(
			'HealthAspectEnumeration',
		),
		'editor'                                  => array(
			'Person',
		),
		'exceptDate'                              => array(
			'Date',
			'DateTime',
		),
		'interactionType'                         => array(
			'Action',
		),
		'spatialCoverage'                         => array(
			'Place',
		),
		'suggestedMeasurement'                    => array(
			'QuantitativeValue',
		),
		'entertainmentBusiness'                   => array(
			'EntertainmentBusiness',
		),
		'associatedReview'                        => array(
			'Review',
		),
		'award'                                   => array(
			'Text',
		),
		'parents'                                 => array(
			'Person',
		),
		'inChIKey'                                => array(
			'Text',
		),
		'targetCollection'                        => array(
			'Thing',
		),
		'healthPlanNetworkTier'                   => array(
			'Text',
		),
		'directors'                               => array(
			'Person',
		),
		'ownershipFundingInfo'                    => array(
			'CreativeWork',
			'URL',
			'AboutPage',
			'Text',
		),
		'doseSchedule'                            => array(
			'DoseSchedule',
		),
		'mealService'                             => array(
			'Text',
		),
		'purchasePriceLimit'                      => array(
			'MonetaryAmount',
		),
		'usageInfo'                               => array(
			'CreativeWork',
			'URL',
		),
		'jobTitle'                                => array(
			'DefinedTerm',
			'Text',
		),
		'siblings'                                => array(
			'Person',
		),
		'infectiousAgentClass'                    => array(
			'InfectiousAgentClass',
		),
		'replyToUrl'                              => array(
			'URL',
		),
		'floorLevel'                              => array(
			'Text',
		),
		'sportsEvent'                             => array(
			'SportsEvent',
		),
		'taxID'                                   => array(
			'Text',
		),
		'followee'                                => array(
			'Person',
			'Organization',
		),
		'application'                             => array(
			'SoftwareApplication',
		),
		'dateSent'                                => array(
			'DateTime',
		),
		'overdosage'                              => array(
			'Text',
		),
		'monthlyMinimumRepaymentAmount'           => array(
			'Number',
			'MonetaryAmount',
		),
		'isAccessibleForFree'                     => array(
			'Boolean',
		),
		'about'                                   => array(
			'Thing',
		),
		'endTime'                                 => array(
			'DateTime',
			'Time',
		),
		'colleagues'                              => array(
			'Person',
		),
		'numConstraints'                          => array(
			'Integer',
		),
		'activeIngredient'                        => array(
			'Text',
		),
		'hostingOrganization'                     => array(
			'Organization',
		),
		'clinicalPharmacology'                    => array(
			'Text',
		),
		'numberOfBedrooms'                        => array(
			'QuantitativeValue',
			'Number',
		),
		'discussionUrl'                           => array(
			'URL',
		),
		'alternateName'                           => array(
			'Text',
		),
		'numberOfPlayers'                         => array(
			'QuantitativeValue',
		),
		'inSupportOf'                             => array(
			'Text',
		),
		'encodesCreativeWork'                     => array(
			'CreativeWork',
		),
		'model'                                   => array(
			'Text',
			'ProductModel',
		),
		'beforeMedia'                             => array(
			'MediaObject',
			'URL',
		),
		'partOfEpisode'                           => array(
			'Episode',
		),
		'athlete'                                 => array(
			'Person',
		),
		'pagination'                              => array(
			'Text',
		),
		'originAddress'                           => array(
			'PostalAddress',
		),
		'hasCategoryCode'                         => array(
			'CategoryCode',
		),
		'muscleAction'                            => array(
			'Text',
		),
		'biologicalRole'                          => array(
			'DefinedTerm',
		),
		'duplicateTherapy'                        => array(
			'MedicalTherapy',
		),
		'screenshot'                              => array(
			'ImageObject',
			'URL',
		),
		'certificationIdentification'             => array(
			'DefinedTerm',
			'Text',
		),
		'nsn'                                     => array(
			'Text',
		),
		'warrantyPromise'                         => array(
			'WarrantyPromise',
		),
		'subReservation'                          => array(
			'Reservation',
		),
		'familyName'                              => array(
			'Text',
		),
		'codingSystem'                            => array(
			'Text',
		),
		'additionalVariable'                      => array(
			'Text',
		),
		'supplyTo'                                => array(
			'AnatomicalStructure',
		),
		'childMaxAge'                             => array(
			'Number',
		),
		'billingIncrement'                        => array(
			'Number',
		),
		'diversityPolicy'                         => array(
			'CreativeWork',
			'URL',
		),
		'countryOfOrigin'                         => array(
			'Country',
		),
		'photos'                                  => array(
			'Photograph',
			'ImageObject',
		),
		'articleBody'                             => array(
			'Text',
		),
		'availabilityStarts'                      => array(
			'DateTime',
			'Date',
			'Time',
		),
		'deliveryStatus'                          => array(
			'DeliveryEvent',
		),
		'hasCredential'                           => array(
			'EducationalOccupationalCredential',
		),
		'paymentMethodId'                         => array(
			'Text',
		),
		'significantLinks'                        => array(
			'URL',
		),
		'artEdition'                              => array(
			'Text',
			'Integer',
		),
		'causeOf'                                 => array(
			'MedicalEntity',
		),
		'isAvailableGenerically'                  => array(
			'Boolean',
		),
		'parentItem'                              => array(
			'CreativeWork',
			'Comment',
		),
		'encodingType'                            => array(
			'Text',
		),
		'sponsor'                                 => array(
			'Person',
			'Organization',
		),
		'downloadUrl'                             => array(
			'URL',
		),
		'valueMinLength'                          => array(
			'Number',
		),
		'coach'                                   => array(
			'Person',
		),
		'performerIn'                             => array(
			'Event',
		),
		'isConsumableFor'                         => array(
			'Product',
		),
		'maximumPhysicalAttendeeCapacity'         => array(
			'Integer',
		),
		'agentInteractionStatistic'               => array(
			'InteractionCounter',
		),
		'masthead'                                => array(
			'CreativeWork',
			'URL',
		),
		'bccRecipient'                            => array(
			'Person',
			'Organization',
			'ContactPoint',
		),
		'dataFeedElement'                         => array(
			'DataFeedItem',
			'Thing',
			'Text',
		),
		'billingStart'                            => array(
			'Number',
		),
		'primaryPrevention'                       => array(
			'MedicalTherapy',
		),
		'serviceOperator'                         => array(
			'Organization',
		),
		'includedComposition'                     => array(
			'MusicComposition',
		),
		'recipeCategory'                          => array(
			'Text',
		),
		'geoWithin'                               => array(
			'GeospatialGeometry',
			'Place',
		),
		'givenName'                               => array(
			'Text',
		),
		'branchCode'                              => array(
			'Text',
		),
		'width'                                   => array(
			'QuantitativeValue',
			'Distance',
		),
		'borrower'                                => array(
			'Person',
		),
		'subTest'                                 => array(
			'MedicalTest',
		),
		'musicalKey'                              => array(
			'Text',
		),
		'error'                                   => array(
			'Thing',
		),
		'startOffset'                             => array(
			'HyperTocEntry',
			'Number',
		),
		'cvdFacilityId'                           => array(
			'Text',
		),
		'partOfTrip'                              => array(
			'Trip',
		),
		'geoCoveredBy'                            => array(
			'GeospatialGeometry',
			'Place',
		),
		'abridged'                                => array(
			'Boolean',
		),
		'lastReviewed'                            => array(
			'Date',
		),
		'cvdNumBeds'                              => array(
			'Number',
		),
		'worksFor'                                => array(
			'Organization',
		),
		'orderedItem'                             => array(
			'Service',
			'Product',
			'OrderItem',
		),
		'specialty'                               => array(
			'Specialty',
		),
		'interactivityType'                       => array(
			'Text',
		),
		'includedInDataCatalog'                   => array(
			'DataCatalog',
		),
		'numberedPosition'                        => array(
			'Number',
		),
		'maximumAttendeeCapacity'                 => array(
			'Integer',
		),
		'guideline'                               => array(
			'MedicalGuideline',
		),
		'associatedPathophysiology'               => array(
			'Text',
		),
		'lesser'                                  => array(
			'QualitativeValue',
		),
		'returnPolicyCountry'                     => array(
			'Country',
			'Text',
		),
		'translator'                              => array(
			'Organization',
			'Person',
		),
		'includesHealthPlanNetwork'               => array(
			'HealthPlanNetwork',
		),
		'eligibleTransactionVolume'               => array(
			'PriceSpecification',
		),
		'healthPlanDrugTier'                      => array(
			'Text',
		),
		'creditText'                              => array(
			'Text',
		),
		'vehicleInteriorColor'                    => array(
			'Text',
		),
		'inDefinedTermSet'                        => array(
			'URL',
			'DefinedTermSet',
		),
		'taxonomicRange'                          => array(
			'Taxon',
			'DefinedTerm',
			'URL',
			'Text',
		),
		'location'                                => array(
			'Text',
			'VirtualLocation',
			'Place',
			'PostalAddress',
		),
		'legislationAmends'                       => array(
			'Legislation',
		),
		'inCodeSet'                               => array(
			'CategoryCodeSet',
			'URL',
		),
		'timeOfDay'                               => array(
			'Text',
		),
		'messageAttachment'                       => array(
			'CreativeWork',
		),
		'offersPrescriptionByMail'                => array(
			'Boolean',
		),
		'letterer'                                => array(
			'Person',
		),
		'actors'                                  => array(
			'Person',
		),
		'availableTest'                           => array(
			'MedicalTest',
		),
		'seeks'                                   => array(
			'Demand',
		),
		'legislationDate'                         => array(
			'Date',
		),
		'serviceLocation'                         => array(
			'Place',
		),
		'applicationSubCategory'                  => array(
			'Text',
			'URL',
		),
		'numberOfPages'                           => array(
			'Integer',
		),
		'mapType'                                 => array(
			'MapCategoryType',
		),
		'ratingExplanation'                       => array(
			'Text',
		),
		'contributor'                             => array(
			'Person',
			'Organization',
		),
		'paymentDueDate'                          => array(
			'DateTime',
			'Date',
		),
		'translationOfWork'                       => array(
			'CreativeWork',
		),
		'winner'                                  => array(
			'Person',
		),
		'utterances'                              => array(
			'Text',
		),
		'loanType'                                => array(
			'URL',
			'Text',
		),
		'healthPlanDrugOption'                    => array(
			'Text',
		),
		'passengerSequenceNumber'                 => array(
			'Text',
		),
		'makesOffer'                              => array(
			'Offer',
		),
		'applicationSuite'                        => array(
			'Text',
		),
		'alternativeOf'                           => array(
			'Gene',
		),
		'enginePower'                             => array(
			'QuantitativeValue',
		),
		'verificationFactCheckingPolicy'          => array(
			'URL',
			'CreativeWork',
		),
		'productGroupID'                          => array(
			'Text',
		),
		'legislationApplies'                      => array(
			'Legislation',
		),
		'observationPeriod'                       => array(
			'Text',
		),
		'inPlaylist'                              => array(
			'MusicPlaylist',
		),
		'map'                                     => array(
			'URL',
		),
		'vatID'                                   => array(
			'Text',
		),
		'status'                                  => array(
			'EventStatusType',
			'Text',
			'MedicalStudyStatus',
		),
		'valueRequired'                           => array(
			'Boolean',
		),
		'associatedMedia'                         => array(
			'MediaObject',
		),
		'participant'                             => array(
			'Person',
			'Organization',
		),
		'discountCurrency'                        => array(
			'Text',
		),
		'maximumIntake'                           => array(
			'MaximumDoseSchedule',
		),
		'datePosted'                              => array(
			'DateTime',
			'Date',
		),
		'originatesFrom'                          => array(
			'Vessel',
		),
		'permissions'                             => array(
			'Text',
		),
		'molecularWeight'                         => array(
			'QuantitativeValue',
			'Text',
		),
		'nonProprietaryName'                      => array(
			'Text',
		),
		'members'                                 => array(
			'Person',
			'Organization',
		),
		'pattern'                                 => array(
			'DefinedTerm',
			'Text',
		),
		'asin'                                    => array(
			'URL',
			'Text',
		),
		'gamePlatform'                            => array(
			'Text',
			'Thing',
			'URL',
		),
		'directApply'                             => array(
			'Boolean',
		),
		'educationalAlignment'                    => array(
			'AlignmentObject',
		),
		'usesHealthPlanIdStandard'                => array(
			'URL',
			'Text',
		),
		'serialNumber'                            => array(
			'Text',
		),
		'previousStartDate'                       => array(
			'Date',
		),
		'credentialCategory'                      => array(
			'DefinedTerm',
			'URL',
			'Text',
		),
		'url'                                     => array(
			'URL',
		),
		'gameLocation'                            => array(
			'URL',
			'Place',
			'PostalAddress',
		),
		'incentiveStatus'                         => array(
			'IncentiveStatus',
		),
		'hasCourse'                               => array(
			'Course',
		),
		'weightPercentage'                        => array(
			'Number',
		),
		'accessibilityAPI'                        => array(
			'Text',
		),
		'duns'                                    => array(
			'Text',
		),
		'geoTouches'                              => array(
			'Place',
			'GeospatialGeometry',
		),
		'box'                                     => array(
			'Text',
		),
		'worstRating'                             => array(
			'Text',
			'Number',
		),
		'director'                                => array(
			'Person',
		),
		'characterName'                           => array(
			'Text',
		),
		'chemicalRole'                            => array(
			'DefinedTerm',
		),
		'diagram'                                 => array(
			'ImageObject',
		),
		'providesBroadcastService'                => array(
			'BroadcastService',
		),
		'artMedium'                               => array(
			'URL',
			'Text',
		),
		'termCode'                                => array(
			'Text',
		),
		'fuelEfficiency'                          => array(
			'QuantitativeValue',
		),
		'loser'                                   => array(
			'Person',
		),
		'hasShippingService'                      => array(
			'ShippingService',
		),
		'variantCover'                            => array(
			'Text',
		),
		'image'                                   => array(
			'ImageObject',
			'URL',
		),
		'tracks'                                  => array(
			'MusicRecording',
		),
		'confirmationNumber'                      => array(
			'Text',
		),
		'totalTime'                               => array(
			'Duration',
		),
		'homeLocation'                            => array(
			'Place',
			'ContactPoint',
		),
		'offeredBy'                               => array(
			'Person',
			'Organization',
		),
		'billingAddress'                          => array(
			'PostalAddress',
		),
		'accessibilitySummary'                    => array(
			'Text',
		),
		'embeddedTextCaption'                     => array(
			'Text',
		),
		'exampleOfWork'                           => array(
			'CreativeWork',
		),
		'publication'                             => array(
			'PublicationEvent',
		),
		'attendees'                               => array(
			'Person',
			'Organization',
		),
		'reviewBody'                              => array(
			'Text',
		),
		'fundedItem'                              => array(
			'Product',
			'Event',
			'CreativeWork',
			'MedicalEntity',
			'BioChemEntity',
			'Person',
			'Organization',
		),
		'faxNumber'                               => array(
			'Text',
		),
		'vehicleModelDate'                        => array(
			'Date',
		),
		'eligibleQuantity'                        => array(
			'QuantitativeValue',
		),
		'pregnancyCategory'                       => array(
			'DrugPregnancyCategory',
		),
		'repeatCount'                             => array(
			'Integer',
		),
		'aircraft'                                => array(
			'Vehicle',
			'Text',
		),
		'pregnancyWarning'                        => array(
			'Text',
		),
		'tripOrigin'                              => array(
			'Place',
		),
		'performTime'                             => array(
			'Duration',
		),
		'hasPOS'                                  => array(
			'Place',
		),
		'bitrate'                                 => array(
			'Text',
		),
		'busName'                                 => array(
			'Text',
		),
		'softwareAddOn'                           => array(
			'SoftwareApplication',
		),
		'isAccessoryOrSparePartFor'               => array(
			'Product',
		),
		'foodWarning'                             => array(
			'Text',
		),
		'paymentAccepted'                         => array(
			'Text',
		),
		'driveWheelConfiguration'                 => array(
			'Text',
			'DriveWheelConfigurationValue',
		),
		'seatNumber'                              => array(
			'Text',
		),
		'departureBusStop'                        => array(
			'BusStop',
			'BusStation',
		),
		'medicineSystem'                          => array(
			'MedicineSystem',
		),
		'disambiguatingDescription'               => array(
			'Text',
		),
		'responsibilities'                        => array(
			'Text',
		),
		'isLocatedInSubcellularLocation'          => array(
			'DefinedTerm',
			'URL',
			'PropertyValue',
		),
		'parent'                                  => array(
			'Person',
		),
		'device'                                  => array(
			'Text',
		),
		'countriesNotSupported'                   => array(
			'Text',
		),
		'position'                                => array(
			'Text',
			'Integer',
		),
		'relatedLink'                             => array(
			'URL',
		),
		'validThrough'                            => array(
			'DateTime',
			'Date',
		),
		'tissueSample'                            => array(
			'Text',
		),
		'hasGS1DigitalLink'                       => array(
			'URL',
		),
		'conditionsOfAccess'                      => array(
			'Text',
		),
		'mainEntity'                              => array(
			'Thing',
		),
		'observationDate'                         => array(
			'Date',
			'DateTime',
		),
		'copyrightYear'                           => array(
			'Number',
		),
		'title'                                   => array(
			'Text',
		),
		'acrissCode'                              => array(
			'Text',
		),
		'additionalName'                          => array(
			'Text',
		),
		'text'                                    => array(
			'Text',
		),
		'exifData'                                => array(
			'PropertyValue',
			'Text',
		),
		'contentUrl'                              => array(
			'URL',
		),
		'seatRow'                                 => array(
			'Text',
		),
		'cashBack'                                => array(
			'Boolean',
			'Number',
		),
		'reservedTicket'                          => array(
			'Ticket',
		),
		'tickerSymbol'                            => array(
			'Text',
		),
		'defaultValue'                            => array(
			'Text',
			'Thing',
		),
		'childTaxon'                              => array(
			'Taxon',
			'URL',
			'Text',
		),
		'releaseDate'                             => array(
			'Date',
		),
		'preparation'                             => array(
			'Text',
			'MedicalEntity',
		),
		'email'                                   => array(
			'Text',
		),
		'interpretedAsClaim'                      => array(
			'Claim',
		),
		'procedure'                               => array(
			'Text',
		),
		'diagnosis'                               => array(
			'MedicalCondition',
		),
		'callSign'                                => array(
			'Text',
		),
		'cookTime'                                => array(
			'Duration',
		),
		'hasOfferCatalog'                         => array(
			'OfferCatalog',
		),
		'isPartOf'                                => array(
			'URL',
			'CreativeWork',
		),
		'legislationChanges'                      => array(
			'Legislation',
		),
		'deathPlace'                              => array(
			'Place',
		),
		'claimInterpreter'                        => array(
			'Person',
			'Organization',
		),
		'landlord'                                => array(
			'Organization',
			'Person',
		),
		'antagonist'                              => array(
			'Muscle',
		),
		'nonprofitStatus'                         => array(
			'NonprofitType',
		),
		'transmissionMethod'                      => array(
			'Text',
		),
		'itemListOrder'                           => array(
			'ItemListOrderType',
			'Text',
		),
		'shippingRate'                            => array(
			'MonetaryAmount',
			'ShippingRateSettings',
		),
		'termDuration'                            => array(
			'Duration',
		),
		'linkRelationship'                        => array(
			'Text',
		),
		'httpMethod'                              => array(
			'Text',
		),
		'numberOfBathroomsTotal'                  => array(
			'Integer',
		),
		'browserRequirements'                     => array(
			'Text',
		),
		'priceSpecification'                      => array(
			'PriceSpecification',
		),
		'numberOfAxles'                           => array(
			'QuantitativeValue',
			'Number',
		),
		'exercisePlan'                            => array(
			'ExercisePlan',
		),
		'arrivalGate'                             => array(
			'Text',
		),
		'speechToTextMarkup'                      => array(
			'Text',
		),
		'geoCrosses'                              => array(
			'Place',
			'GeospatialGeometry',
		),
		'earlyPrepaymentPenalty'                  => array(
			'MonetaryAmount',
		),
		'postalCode'                              => array(
			'Text',
		),
		'educationalLevel'                        => array(
			'DefinedTerm',
			'URL',
			'Text',
		),
		'variesBy'                                => array(
			'DefinedTerm',
			'Text',
		),
		'broadcastDisplayName'                    => array(
			'Text',
		),
		'itemDefectReturnFees'                    => array(
			'ReturnFeesEnumeration',
		),
		'administrationRoute'                     => array(
			'Text',
		),
		'eventSchedule'                           => array(
			'Schedule',
		),
		'toLocation'                              => array(
			'Place',
		),
		'applicantLocationRequirements'           => array(
			'AdministrativeArea',
		),
		'postalCodePrefix'                        => array(
			'Text',
		),
		'sizeSystem'                              => array(
			'SizeSystemEnumeration',
			'Text',
		),
		'founders'                                => array(
			'Person',
		),
		'articleSection'                          => array(
			'Text',
		),
		'videoQuality'                            => array(
			'Text',
		),
		'subStageSuffix'                          => array(
			'Text',
		),
		'regionDrained'                           => array(
			'AnatomicalSystem',
			'AnatomicalStructure',
		),
		'memoryRequirements'                      => array(
			'URL',
			'Text',
		),
		'applicationContact'                      => array(
			'ContactPoint',
		),
		'numAdults'                               => array(
			'QuantitativeValue',
			'Integer',
		),
		'customerRemorseReturnLabelSource'        => array(
			'ReturnLabelSourceEnumeration',
		),
		'activityDuration'                        => array(
			'Duration',
			'QuantitativeValue',
		),
		'validFor'                                => array(
			'Duration',
		),
		'primaryImageOfPage'                      => array(
			'ImageObject',
		),
		'penciler'                                => array(
			'Person',
		),
		'errorCode'                               => array(
			'Text',
			'Integer',
			'DefinedTerm',
			'StatusEnumeration',
		),
		'sender'                                  => array(
			'Organization',
			'Audience',
			'Person',
		),
		'bestRating'                              => array(
			'Text',
			'Number',
		),
		'character'                               => array(
			'Person',
		),
		'spouse'                                  => array(
			'Person',
		),
		'copyrightHolder'                         => array(
			'Person',
			'Organization',
		),
		'runtimePlatform'                         => array(
			'Text',
			'RuntimePlatform',
		),
		'target'                                  => array(
			'EntryPoint',
			'URL',
		),
		'free'                                    => array(
			'Boolean',
		),
		'benefits'                                => array(
			'Text',
		),
		'securityClearanceRequirement'            => array(
			'Text',
			'URL',
		),
		'gameAvailabilityType'                    => array(
			'Text',
			'GameAvailabilityEnumeration',
		),
		'specialCommitments'                      => array(
			'Text',
		),
		'departureStation'                        => array(
			'TrainStation',
		),
		'issuedBy'                                => array(
			'Organization',
		),
		'backstory'                               => array(
			'Text',
			'CreativeWork',
		),
		'dateModified'                            => array(
			'Date',
			'DateTime',
		),
		'departureTerminal'                       => array(
			'Text',
		),
		'resultComment'                           => array(
			'Comment',
		),
		'mediaItemAppearance'                     => array(
			'MediaObject',
		),
		'aspect'                                  => array(
			'Text',
		),
		'currentExchangeRate'                     => array(
			'UnitPriceSpecification',
		),
		'availabilityEnds'                        => array(
			'DateTime',
			'Date',
			'Time',
		),
		'priceValidUntil'                         => array(
			'Date',
		),
		'includedInHealthInsurancePlan'           => array(
			'HealthInsurancePlan',
		),
		'hasTierRequirement'                      => array(
			'MonetaryAmount',
			'Text',
			'CreditCard',
			'UnitPriceSpecification',
		),
		'afterMedia'                              => array(
			'MediaObject',
			'URL',
		),
		'availableAtOrFrom'                       => array(
			'Place',
		),
		'cvdNumC19OverflowPats'                   => array(
			'Number',
		),
		'sensoryUnit'                             => array(
			'SuperficialAnatomy',
			'AnatomicalStructure',
		),
		'cvdNumTotBeds'                           => array(
			'Number',
		),
		'healthcareReportingData'                 => array(
			'Dataset',
			'CDCPMDRecord',
		),
		'dissolutionDate'                         => array(
			'Date',
		),
		'cutoffTime'                              => array(
			'Time',
		),
		'cvdNumC19HospPats'                       => array(
			'Number',
		),
		'unnamedSourcesPolicy'                    => array(
			'CreativeWork',
			'URL',
		),
		'icaoCode'                                => array(
			'Text',
		),
		'targetName'                              => array(
			'Text',
		),
		'estimatedSalary'                         => array(
			'Number',
			'MonetaryAmount',
			'MonetaryAmountDistribution',
		),
		'drug'                                    => array(
			'Drug',
		),
		'annualPercentageRate'                    => array(
			'QuantitativeValue',
			'Number',
		),
		'episodes'                                => array(
			'Episode',
		),
		'owns'                                    => array(
			'Thing',
		),
		'incentiveAmount'                         => array(
			'LoanOrCredit',
			'UnitPriceSpecification',
			'QuantitativeValue',
		),
		'program'                                 => array(
			'MemberProgram',
		),
		'inker'                                   => array(
			'Person',
		),
		'scheduledTime'                           => array(
			'Date',
			'DateTime',
		),
		'photo'                                   => array(
			'Photograph',
			'ImageObject',
		),
		'totalPrice'                              => array(
			'Number',
			'Text',
			'PriceSpecification',
		),
		'amenityFeature'                          => array(
			'LocationFeatureSpecification',
		),
		'organizer'                               => array(
			'Person',
			'Organization',
		),
		'qualifications'                          => array(
			'EducationalOccupationalCredential',
			'Text',
		),
	);
}
