<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ServiceManagement;

class ConfigFile extends \Google\Model
{
  /**
   * Unknown file type.
   */
  public const FILE_TYPE_FILE_TYPE_UNSPECIFIED = 'FILE_TYPE_UNSPECIFIED';
  /**
   * YAML-specification of service.
   */
  public const FILE_TYPE_SERVICE_CONFIG_YAML = 'SERVICE_CONFIG_YAML';
  /**
   * OpenAPI specification, serialized in JSON.
   */
  public const FILE_TYPE_OPEN_API_JSON = 'OPEN_API_JSON';
  /**
   * OpenAPI specification, serialized in YAML.
   */
  public const FILE_TYPE_OPEN_API_YAML = 'OPEN_API_YAML';
  /**
   * FileDescriptorSet, generated by protoc. To generate, use protoc with
   * imports and source info included. For an example test.proto file, the
   * following command would put the value in a new file named out.pb. $protoc
   * --include_imports --include_source_info test.proto -o out.pb
   */
  public const FILE_TYPE_FILE_DESCRIPTOR_SET_PROTO = 'FILE_DESCRIPTOR_SET_PROTO';
  /**
   * Uncompiled Proto file. Used for storage and display purposes only,
   * currently server-side compilation is not supported. Should match the inputs
   * to 'protoc' command used to generated FILE_DESCRIPTOR_SET_PROTO. A file of
   * this type can only be included if at least one file of type
   * FILE_DESCRIPTOR_SET_PROTO is included.
   */
  public const FILE_TYPE_PROTO_FILE = 'PROTO_FILE';
  /**
   * The bytes that constitute the file.
   *
   * @var string
   */
  public $fileContents;
  /**
   * The file name of the configuration file (full or relative path).
   *
   * @var string
   */
  public $filePath;
  /**
   * The type of configuration file this represents.
   *
   * @var string
   */
  public $fileType;

  /**
   * The bytes that constitute the file.
   *
   * @param string $fileContents
   */
  public function setFileContents($fileContents)
  {
    $this->fileContents = $fileContents;
  }
  /**
   * @return string
   */
  public function getFileContents()
  {
    return $this->fileContents;
  }
  /**
   * The file name of the configuration file (full or relative path).
   *
   * @param string $filePath
   */
  public function setFilePath($filePath)
  {
    $this->filePath = $filePath;
  }
  /**
   * @return string
   */
  public function getFilePath()
  {
    return $this->filePath;
  }
  /**
   * The type of configuration file this represents.
   *
   * Accepted values: FILE_TYPE_UNSPECIFIED, SERVICE_CONFIG_YAML, OPEN_API_JSON,
   * OPEN_API_YAML, FILE_DESCRIPTOR_SET_PROTO, PROTO_FILE
   *
   * @param self::FILE_TYPE_* $fileType
   */
  public function setFileType($fileType)
  {
    $this->fileType = $fileType;
  }
  /**
   * @return self::FILE_TYPE_*
   */
  public function getFileType()
  {
    return $this->fileType;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ConfigFile::class, 'Google_Service_ServiceManagement_ConfigFile');
