<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ManagedKafka;

class CreateVersionRequest extends \Google\Collection
{
  /**
   * No schema type. The default will be AVRO.
   */
  public const SCHEMA_TYPE_SCHEMA_TYPE_UNSPECIFIED = 'SCHEMA_TYPE_UNSPECIFIED';
  /**
   * Avro schema type.
   */
  public const SCHEMA_TYPE_AVRO = 'AVRO';
  /**
   * JSON schema type.
   */
  public const SCHEMA_TYPE_JSON = 'JSON';
  /**
   * Protobuf schema type.
   */
  public const SCHEMA_TYPE_PROTOBUF = 'PROTOBUF';
  protected $collection_key = 'references';
  /**
   * Optional. The schema ID of the schema. If not specified, the schema ID will
   * be generated by the server. If the schema ID is specified, it must not be
   * used by an existing schema that is different from the schema to be created.
   *
   * @var int
   */
  public $id;
  /**
   * Optional. If true, the schema will be normalized before being stored. The
   * default is false.
   *
   * @var bool
   */
  public $normalize;
  protected $referencesType = SchemaReference::class;
  protected $referencesDataType = 'array';
  /**
   * Required. The schema payload
   *
   * @var string
   */
  public $schema;
  /**
   * Optional. The type of the schema. It is optional. If not specified, the
   * schema type will be AVRO.
   *
   * @var string
   */
  public $schemaType;
  /**
   * Optional. The version to create. It is optional. If not specified, the
   * version will be created with the max version ID of the subject increased by
   * 1. If the version ID is specified, it will be used as the new version ID
   * and must not be used by an existing version of the subject.
   *
   * @var int
   */
  public $version;

  /**
   * Optional. The schema ID of the schema. If not specified, the schema ID will
   * be generated by the server. If the schema ID is specified, it must not be
   * used by an existing schema that is different from the schema to be created.
   *
   * @param int $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return int
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * Optional. If true, the schema will be normalized before being stored. The
   * default is false.
   *
   * @param bool $normalize
   */
  public function setNormalize($normalize)
  {
    $this->normalize = $normalize;
  }
  /**
   * @return bool
   */
  public function getNormalize()
  {
    return $this->normalize;
  }
  /**
   * Optional. The schema references used by the schema.
   *
   * @param SchemaReference[] $references
   */
  public function setReferences($references)
  {
    $this->references = $references;
  }
  /**
   * @return SchemaReference[]
   */
  public function getReferences()
  {
    return $this->references;
  }
  /**
   * Required. The schema payload
   *
   * @param string $schema
   */
  public function setSchema($schema)
  {
    $this->schema = $schema;
  }
  /**
   * @return string
   */
  public function getSchema()
  {
    return $this->schema;
  }
  /**
   * Optional. The type of the schema. It is optional. If not specified, the
   * schema type will be AVRO.
   *
   * Accepted values: SCHEMA_TYPE_UNSPECIFIED, AVRO, JSON, PROTOBUF
   *
   * @param self::SCHEMA_TYPE_* $schemaType
   */
  public function setSchemaType($schemaType)
  {
    $this->schemaType = $schemaType;
  }
  /**
   * @return self::SCHEMA_TYPE_*
   */
  public function getSchemaType()
  {
    return $this->schemaType;
  }
  /**
   * Optional. The version to create. It is optional. If not specified, the
   * version will be created with the max version ID of the subject increased by
   * 1. If the version ID is specified, it will be used as the new version ID
   * and must not be used by an existing version of the subject.
   *
   * @param int $version
   */
  public function setVersion($version)
  {
    $this->version = $version;
  }
  /**
   * @return int
   */
  public function getVersion()
  {
    return $this->version;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(CreateVersionRequest::class, 'Google_Service_ManagedKafka_CreateVersionRequest');
