<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Config;

class Revision extends \Google\Collection
{
  /**
   * The default value. This value is used if the action is omitted.
   */
  public const ACTION_ACTION_UNSPECIFIED = 'ACTION_UNSPECIFIED';
  /**
   * The revision was generated by creating a deployment.
   */
  public const ACTION_CREATE = 'CREATE';
  /**
   * The revision was generated by updating a deployment.
   */
  public const ACTION_UPDATE = 'UPDATE';
  /**
   * The revision was deleted.
   */
  public const ACTION_DELETE = 'DELETE';
  /**
   * No error code was specified.
   */
  public const ERROR_CODE_ERROR_CODE_UNSPECIFIED = 'ERROR_CODE_UNSPECIFIED';
  /**
   * Cloud Build failed due to a permission issue.
   */
  public const ERROR_CODE_CLOUD_BUILD_PERMISSION_DENIED = 'CLOUD_BUILD_PERMISSION_DENIED';
  /**
   * Cloud Build job associated with creating or updating a deployment could not
   * be started.
   */
  public const ERROR_CODE_APPLY_BUILD_API_FAILED = 'APPLY_BUILD_API_FAILED';
  /**
   * Cloud Build job associated with creating or updating a deployment was
   * started but failed.
   */
  public const ERROR_CODE_APPLY_BUILD_RUN_FAILED = 'APPLY_BUILD_RUN_FAILED';
  /**
   * quota validation failed for one or more resources in terraform
   * configuration files.
   */
  public const ERROR_CODE_QUOTA_VALIDATION_FAILED = 'QUOTA_VALIDATION_FAILED';
  /**
   * The default value. QuotaValidation on terraform configuration files will be
   * disabled in this case.
   */
  public const QUOTA_VALIDATION_QUOTA_VALIDATION_UNSPECIFIED = 'QUOTA_VALIDATION_UNSPECIFIED';
  /**
   * Enable computing quotas for resources in terraform configuration files to
   * get visibility on resources with insufficient quotas.
   */
  public const QUOTA_VALIDATION_ENABLED = 'ENABLED';
  /**
   * Enforce quota checks so deployment fails if there isn't sufficient quotas
   * available to deploy resources in terraform configuration files.
   */
  public const QUOTA_VALIDATION_ENFORCED = 'ENFORCED';
  /**
   * The default value. This value is used if the state is omitted.
   */
  public const STATE_STATE_UNSPECIFIED = 'STATE_UNSPECIFIED';
  /**
   * The revision is being applied.
   */
  public const STATE_APPLYING = 'APPLYING';
  /**
   * The revision was applied successfully.
   */
  public const STATE_APPLIED = 'APPLIED';
  /**
   * The revision could not be applied successfully.
   */
  public const STATE_FAILED = 'FAILED';
  protected $collection_key = 'tfErrors';
  /**
   * Output only. The action which created this revision
   *
   * @var string
   */
  public $action;
  protected $applyResultsType = ApplyResults::class;
  protected $applyResultsDataType = '';
  /**
   * Output only. Cloud Build instance UUID associated with this revision.
   *
   * @var string
   */
  public $build;
  /**
   * Output only. Time when the revision was created.
   *
   * @var string
   */
  public $createTime;
  /**
   * Output only. Code describing any errors that may have occurred.
   *
   * @var string
   */
  public $errorCode;
  /**
   * Output only. Location of Terraform error logs in Google Cloud Storage.
   * Format: `gs://{bucket}/{object}`.
   *
   * @var string
   */
  public $errorLogs;
  /**
   * Output only. By default, Infra Manager will return a failure when Terraform
   * encounters a 409 code (resource conflict error) during actuation. If this
   * flag is set to true, Infra Manager will instead attempt to automatically
   * import the resource into the Terraform state (for supported resource types)
   * and continue actuation. Not all resource types are supported, refer to
   * documentation.
   *
   * @var bool
   */
  public $importExistingResources;
  /**
   * Output only. Location of Revision operation logs in
   * `gs://{bucket}/{object}` format.
   *
   * @var string
   */
  public $logs;
  /**
   * Revision name. Format:
   * `projects/{project}/locations/{location}/deployments/{deployment}/
   * revisions/{revision}`
   *
   * @var string
   */
  public $name;
  protected $providerConfigType = ProviderConfig::class;
  protected $providerConfigDataType = '';
  /**
   * Optional. Input to control quota checks for resources in terraform
   * configuration files. There are limited resources on which quota validation
   * applies.
   *
   * @var string
   */
  public $quotaValidation;
  /**
   * Output only. Cloud Storage path containing quota validation results. This
   * field is set when a user sets Deployment.quota_validation field to ENABLED
   * or ENFORCED. Format: `gs://{bucket}/{object}`.
   *
   * @var string
   */
  public $quotaValidationResults;
  /**
   * Output only. User-specified Service Account (SA) to be used as credential
   * to manage resources. Format:
   * `projects/{projectID}/serviceAccounts/{serviceAccount}`
   *
   * @var string
   */
  public $serviceAccount;
  /**
   * Output only. Current state of the revision.
   *
   * @var string
   */
  public $state;
  /**
   * Output only. Additional info regarding the current state.
   *
   * @var string
   */
  public $stateDetail;
  protected $terraformBlueprintType = TerraformBlueprint::class;
  protected $terraformBlueprintDataType = '';
  protected $tfErrorsType = TerraformError::class;
  protected $tfErrorsDataType = 'array';
  /**
   * Output only. The version of Terraform used to create the Revision. It is in
   * the format of "Major.Minor.Patch", for example, "1.3.10".
   *
   * @var string
   */
  public $tfVersion;
  /**
   * Output only. The user-specified Terraform version constraint. Example:
   * "=1.3.10".
   *
   * @var string
   */
  public $tfVersionConstraint;
  /**
   * Output only. Time when the revision was last modified.
   *
   * @var string
   */
  public $updateTime;
  /**
   * Output only. The user-specified Cloud Build worker pool resource in which
   * the Cloud Build job will execute. Format:
   * `projects/{project}/locations/{location}/workerPools/{workerPoolId}`. If
   * this field is unspecified, the default Cloud Build worker pool will be
   * used.
   *
   * @var string
   */
  public $workerPool;

  /**
   * Output only. The action which created this revision
   *
   * Accepted values: ACTION_UNSPECIFIED, CREATE, UPDATE, DELETE
   *
   * @param self::ACTION_* $action
   */
  public function setAction($action)
  {
    $this->action = $action;
  }
  /**
   * @return self::ACTION_*
   */
  public function getAction()
  {
    return $this->action;
  }
  /**
   * Output only. Outputs and artifacts from applying a deployment.
   *
   * @param ApplyResults $applyResults
   */
  public function setApplyResults(ApplyResults $applyResults)
  {
    $this->applyResults = $applyResults;
  }
  /**
   * @return ApplyResults
   */
  public function getApplyResults()
  {
    return $this->applyResults;
  }
  /**
   * Output only. Cloud Build instance UUID associated with this revision.
   *
   * @param string $build
   */
  public function setBuild($build)
  {
    $this->build = $build;
  }
  /**
   * @return string
   */
  public function getBuild()
  {
    return $this->build;
  }
  /**
   * Output only. Time when the revision was created.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * Output only. Code describing any errors that may have occurred.
   *
   * Accepted values: ERROR_CODE_UNSPECIFIED, CLOUD_BUILD_PERMISSION_DENIED,
   * APPLY_BUILD_API_FAILED, APPLY_BUILD_RUN_FAILED, QUOTA_VALIDATION_FAILED
   *
   * @param self::ERROR_CODE_* $errorCode
   */
  public function setErrorCode($errorCode)
  {
    $this->errorCode = $errorCode;
  }
  /**
   * @return self::ERROR_CODE_*
   */
  public function getErrorCode()
  {
    return $this->errorCode;
  }
  /**
   * Output only. Location of Terraform error logs in Google Cloud Storage.
   * Format: `gs://{bucket}/{object}`.
   *
   * @param string $errorLogs
   */
  public function setErrorLogs($errorLogs)
  {
    $this->errorLogs = $errorLogs;
  }
  /**
   * @return string
   */
  public function getErrorLogs()
  {
    return $this->errorLogs;
  }
  /**
   * Output only. By default, Infra Manager will return a failure when Terraform
   * encounters a 409 code (resource conflict error) during actuation. If this
   * flag is set to true, Infra Manager will instead attempt to automatically
   * import the resource into the Terraform state (for supported resource types)
   * and continue actuation. Not all resource types are supported, refer to
   * documentation.
   *
   * @param bool $importExistingResources
   */
  public function setImportExistingResources($importExistingResources)
  {
    $this->importExistingResources = $importExistingResources;
  }
  /**
   * @return bool
   */
  public function getImportExistingResources()
  {
    return $this->importExistingResources;
  }
  /**
   * Output only. Location of Revision operation logs in
   * `gs://{bucket}/{object}` format.
   *
   * @param string $logs
   */
  public function setLogs($logs)
  {
    $this->logs = $logs;
  }
  /**
   * @return string
   */
  public function getLogs()
  {
    return $this->logs;
  }
  /**
   * Revision name. Format:
   * `projects/{project}/locations/{location}/deployments/{deployment}/
   * revisions/{revision}`
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Output only. This field specifies the provider configurations.
   *
   * @param ProviderConfig $providerConfig
   */
  public function setProviderConfig(ProviderConfig $providerConfig)
  {
    $this->providerConfig = $providerConfig;
  }
  /**
   * @return ProviderConfig
   */
  public function getProviderConfig()
  {
    return $this->providerConfig;
  }
  /**
   * Optional. Input to control quota checks for resources in terraform
   * configuration files. There are limited resources on which quota validation
   * applies.
   *
   * Accepted values: QUOTA_VALIDATION_UNSPECIFIED, ENABLED, ENFORCED
   *
   * @param self::QUOTA_VALIDATION_* $quotaValidation
   */
  public function setQuotaValidation($quotaValidation)
  {
    $this->quotaValidation = $quotaValidation;
  }
  /**
   * @return self::QUOTA_VALIDATION_*
   */
  public function getQuotaValidation()
  {
    return $this->quotaValidation;
  }
  /**
   * Output only. Cloud Storage path containing quota validation results. This
   * field is set when a user sets Deployment.quota_validation field to ENABLED
   * or ENFORCED. Format: `gs://{bucket}/{object}`.
   *
   * @param string $quotaValidationResults
   */
  public function setQuotaValidationResults($quotaValidationResults)
  {
    $this->quotaValidationResults = $quotaValidationResults;
  }
  /**
   * @return string
   */
  public function getQuotaValidationResults()
  {
    return $this->quotaValidationResults;
  }
  /**
   * Output only. User-specified Service Account (SA) to be used as credential
   * to manage resources. Format:
   * `projects/{projectID}/serviceAccounts/{serviceAccount}`
   *
   * @param string $serviceAccount
   */
  public function setServiceAccount($serviceAccount)
  {
    $this->serviceAccount = $serviceAccount;
  }
  /**
   * @return string
   */
  public function getServiceAccount()
  {
    return $this->serviceAccount;
  }
  /**
   * Output only. Current state of the revision.
   *
   * Accepted values: STATE_UNSPECIFIED, APPLYING, APPLIED, FAILED
   *
   * @param self::STATE_* $state
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return self::STATE_*
   */
  public function getState()
  {
    return $this->state;
  }
  /**
   * Output only. Additional info regarding the current state.
   *
   * @param string $stateDetail
   */
  public function setStateDetail($stateDetail)
  {
    $this->stateDetail = $stateDetail;
  }
  /**
   * @return string
   */
  public function getStateDetail()
  {
    return $this->stateDetail;
  }
  /**
   * Output only. A blueprint described using Terraform's HashiCorp
   * Configuration Language as a root module.
   *
   * @param TerraformBlueprint $terraformBlueprint
   */
  public function setTerraformBlueprint(TerraformBlueprint $terraformBlueprint)
  {
    $this->terraformBlueprint = $terraformBlueprint;
  }
  /**
   * @return TerraformBlueprint
   */
  public function getTerraformBlueprint()
  {
    return $this->terraformBlueprint;
  }
  /**
   * Output only. Errors encountered when creating or updating this deployment.
   * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
   * for full details.
   *
   * @param TerraformError[] $tfErrors
   */
  public function setTfErrors($tfErrors)
  {
    $this->tfErrors = $tfErrors;
  }
  /**
   * @return TerraformError[]
   */
  public function getTfErrors()
  {
    return $this->tfErrors;
  }
  /**
   * Output only. The version of Terraform used to create the Revision. It is in
   * the format of "Major.Minor.Patch", for example, "1.3.10".
   *
   * @param string $tfVersion
   */
  public function setTfVersion($tfVersion)
  {
    $this->tfVersion = $tfVersion;
  }
  /**
   * @return string
   */
  public function getTfVersion()
  {
    return $this->tfVersion;
  }
  /**
   * Output only. The user-specified Terraform version constraint. Example:
   * "=1.3.10".
   *
   * @param string $tfVersionConstraint
   */
  public function setTfVersionConstraint($tfVersionConstraint)
  {
    $this->tfVersionConstraint = $tfVersionConstraint;
  }
  /**
   * @return string
   */
  public function getTfVersionConstraint()
  {
    return $this->tfVersionConstraint;
  }
  /**
   * Output only. Time when the revision was last modified.
   *
   * @param string $updateTime
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
  /**
   * Output only. The user-specified Cloud Build worker pool resource in which
   * the Cloud Build job will execute. Format:
   * `projects/{project}/locations/{location}/workerPools/{workerPoolId}`. If
   * this field is unspecified, the default Cloud Build worker pool will be
   * used.
   *
   * @param string $workerPool
   */
  public function setWorkerPool($workerPool)
  {
    $this->workerPool = $workerPool;
  }
  /**
   * @return string
   */
  public function getWorkerPool()
  {
    return $this->workerPool;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Revision::class, 'Google_Service_Config_Revision');
