<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AndroidManagement;

class RemoteLockEvent extends \Google\Model
{
  /**
   * Package name of the admin app requesting the change.
   *
   * @var string
   */
  public $adminPackageName;
  /**
   * User ID of the admin app from the which the change was requested.
   *
   * @var int
   */
  public $adminUserId;
  /**
   * User ID in which the change was requested in.
   *
   * @var int
   */
  public $targetUserId;

  /**
   * Package name of the admin app requesting the change.
   *
   * @param string $adminPackageName
   */
  public function setAdminPackageName($adminPackageName)
  {
    $this->adminPackageName = $adminPackageName;
  }
  /**
   * @return string
   */
  public function getAdminPackageName()
  {
    return $this->adminPackageName;
  }
  /**
   * User ID of the admin app from the which the change was requested.
   *
   * @param int $adminUserId
   */
  public function setAdminUserId($adminUserId)
  {
    $this->adminUserId = $adminUserId;
  }
  /**
   * @return int
   */
  public function getAdminUserId()
  {
    return $this->adminUserId;
  }
  /**
   * User ID in which the change was requested in.
   *
   * @param int $targetUserId
   */
  public function setTargetUserId($targetUserId)
  {
    $this->targetUserId = $targetUserId;
  }
  /**
   * @return int
   */
  public function getTargetUserId()
  {
    return $this->targetUserId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(RemoteLockEvent::class, 'Google_Service_AndroidManagement_RemoteLockEvent');
