<?php
/**
 * Plugin Name:       Strategy Suite
 * Description:       The best suite of WordPress enhancements to make the most out of your websites.
 * Version:           1.3.0
 * Requires at least: 6.0
 * Requires PHP:      8.2
 * Author:            Strategy, LLC
 * Author URI:        https://strategynewmedia.com
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       strategy
 * Domain Path:       /languages
 *
 * @package           StrategySuite
 */

// Useful global constants.
define( 'STRATEGY_SUITE_VERSION', '1.3.0' );
define( 'STRATEGY_SUITE_BASE', plugin_basename( __FILE__ ) );
define( 'STRATEGY_SUITE_URL', plugin_dir_url( __FILE__ ) );
define( 'STRATEGY_SUITE_PATH', plugin_dir_path( __FILE__ ) );
define( 'STRATEGY_SUITE_INC', STRATEGY_SUITE_PATH . 'includes/' );
define( 'STRATEGY_SUITE_DIST_URL', STRATEGY_SUITE_URL . 'dist/' );
define( 'STRATEGY_SUITE_DIST_PATH', STRATEGY_SUITE_PATH . 'dist/' );

// Require Composer autoloader if it exists.
if ( file_exists( STRATEGY_SUITE_PATH . 'vendor/autoload.php' ) ) {
	require_once STRATEGY_SUITE_PATH . 'vendor/autoload.php';
}

// Include files.
require_once STRATEGY_SUITE_INC . '/utility.php';
require_once STRATEGY_SUITE_INC . '/core.php';

// Plugin Updates (token needs to be defined in wp-config)
if ( defined( 'STRATEGY_UPDATE_TOKEN' ) ) {
	include_once STRATEGY_SUITE_INC . '/plugin-updater.php';
	$updater = new StrategyPluginUpdater( __FILE__ );
	$updater->init();
}

// Activation/Deactivation.
register_activation_hook( __FILE__, '\StrategySuite\Core\activate' );
register_deactivation_hook( __FILE__, '\StrategySuite\Core\deactivate' );

// Bootstrap.
StrategySuite\Core\setup();
