<?php
/**
 * Aryo
 *
 * @package StrategySuite
 */

namespace StrategySuite;

/**
 * Class Aryo
 */
class Aryo extends \StrategySuite\Module {

	/**
	 * Determine if the module can be registered.
	 *
	 * @return bool
	 */
	public function can_register() {
		return class_exists( 'AAL_Main' );
	}

	/**
	 * Register hooks for customizing the WordPress login page.
	 *
	 * @return void
	 */
	public function register() {
		add_filter( 'aal_default_options', [ $this, 'configure_activity_tracking_default_options' ], 20 );
	}

	/**
	 * Adds the default settings for the Activity Tracking plugins.
	 *
	 * @param array $options            The activity tracking database options.
	 *
	 * @return array $options           The activity tracking database options.
	 */
	public function configure_activity_tracking_default_options( $options ) {
		$options = [
			'logs_lifespan' => '90',
			'logs_failed_login' => 'yes',
			'logs_email' => 'yes',
			'log_visitor_ip_source' => 'REMOTE_ADDR',
		];

		return $options;
	}
}
