<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ServiceControl;

class FirstPartyPrincipal extends \Google\Model
{
  /**
   * The email address of a Google account. .
   *
   * @var string
   */
  public $principalEmail;
  /**
   * Metadata about the service that uses the service account. .
   *
   * @var array[]
   */
  public $serviceMetadata;

  /**
   * The email address of a Google account. .
   *
   * @param string $principalEmail
   */
  public function setPrincipalEmail($principalEmail)
  {
    $this->principalEmail = $principalEmail;
  }
  /**
   * @return string
   */
  public function getPrincipalEmail()
  {
    return $this->principalEmail;
  }
  /**
   * Metadata about the service that uses the service account. .
   *
   * @param array[] $serviceMetadata
   */
  public function setServiceMetadata($serviceMetadata)
  {
    $this->serviceMetadata = $serviceMetadata;
  }
  /**
   * @return array[]
   */
  public function getServiceMetadata()
  {
    return $this->serviceMetadata;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(FirstPartyPrincipal::class, 'Google_Service_ServiceControl_FirstPartyPrincipal');
