<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Firebaseappcheck;

class GoogleFirebaseAppcheckV1ExchangeAppAttestAttestationRequest extends \Google\Model
{
  /**
   * Required. The App Attest statement returned by the client-side App Attest
   * API. This is a base64url encoded CBOR object in the JSON response.
   *
   * @var string
   */
  public $attestationStatement;
  /**
   * Required. A one-time challenge returned by an immediately prior call to
   * GenerateAppAttestChallenge.
   *
   * @var string
   */
  public $challenge;
  /**
   * Required. The key ID generated by App Attest for the client app.
   *
   * @var string
   */
  public $keyId;
  /**
   * Specifies whether this attestation is for use in a *limited use* (`true`)
   * or *session based* (`false`) context. To enable this attestation to be used
   * with the *replay protection* feature, set this to `true`. The default value
   * is `false`.
   *
   * @var bool
   */
  public $limitedUse;

  /**
   * Required. The App Attest statement returned by the client-side App Attest
   * API. This is a base64url encoded CBOR object in the JSON response.
   *
   * @param string $attestationStatement
   */
  public function setAttestationStatement($attestationStatement)
  {
    $this->attestationStatement = $attestationStatement;
  }
  /**
   * @return string
   */
  public function getAttestationStatement()
  {
    return $this->attestationStatement;
  }
  /**
   * Required. A one-time challenge returned by an immediately prior call to
   * GenerateAppAttestChallenge.
   *
   * @param string $challenge
   */
  public function setChallenge($challenge)
  {
    $this->challenge = $challenge;
  }
  /**
   * @return string
   */
  public function getChallenge()
  {
    return $this->challenge;
  }
  /**
   * Required. The key ID generated by App Attest for the client app.
   *
   * @param string $keyId
   */
  public function setKeyId($keyId)
  {
    $this->keyId = $keyId;
  }
  /**
   * @return string
   */
  public function getKeyId()
  {
    return $this->keyId;
  }
  /**
   * Specifies whether this attestation is for use in a *limited use* (`true`)
   * or *session based* (`false`) context. To enable this attestation to be used
   * with the *replay protection* feature, set this to `true`. The default value
   * is `false`.
   *
   * @param bool $limitedUse
   */
  public function setLimitedUse($limitedUse)
  {
    $this->limitedUse = $limitedUse;
  }
  /**
   * @return bool
   */
  public function getLimitedUse()
  {
    return $this->limitedUse;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleFirebaseAppcheckV1ExchangeAppAttestAttestationRequest::class, 'Google_Service_Firebaseappcheck_GoogleFirebaseAppcheckV1ExchangeAppAttestAttestationRequest');
