<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dataform;

class MoveDirectoryRequest extends \Google\Model
{
  /**
   * Required. The new path for the directory including directory name, rooted
   * at workspace root.
   *
   * @var string
   */
  public $newPath;
  /**
   * Required. The directory's full path including directory name, relative to
   * the workspace root.
   *
   * @var string
   */
  public $path;

  /**
   * Required. The new path for the directory including directory name, rooted
   * at workspace root.
   *
   * @param string $newPath
   */
  public function setNewPath($newPath)
  {
    $this->newPath = $newPath;
  }
  /**
   * @return string
   */
  public function getNewPath()
  {
    return $this->newPath;
  }
  /**
   * Required. The directory's full path including directory name, relative to
   * the workspace root.
   *
   * @param string $path
   */
  public function setPath($path)
  {
    $this->path = $path;
  }
  /**
   * @return string
   */
  public function getPath()
  {
    return $this->path;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(MoveDirectoryRequest::class, 'Google_Service_Dataform_MoveDirectoryRequest');
