<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class NetworkInterface extends \Google\Collection
{
  /**
   * The network interface has disabled IGMP query.
   */
  public const IGMP_QUERY_IGMP_QUERY_DISABLED = 'IGMP_QUERY_DISABLED';
  /**
   * The network interface has enabled IGMP query - v2.
   */
  public const IGMP_QUERY_IGMP_QUERY_V2 = 'IGMP_QUERY_V2';
  /**
   * This network interface can have external IPv6.
   */
  public const IPV6_ACCESS_TYPE_EXTERNAL = 'EXTERNAL';
  /**
   * This network interface can have internal IPv6.
   */
  public const IPV6_ACCESS_TYPE_INTERNAL = 'INTERNAL';
  /**
   * GVNIC
   */
  public const NIC_TYPE_GVNIC = 'GVNIC';
  /**
   * IDPF
   */
  public const NIC_TYPE_IDPF = 'IDPF';
  /**
   * IRDMA
   */
  public const NIC_TYPE_IRDMA = 'IRDMA';
  /**
   * MRDMA
   */
  public const NIC_TYPE_MRDMA = 'MRDMA';
  /**
   * No type specified.
   */
  public const NIC_TYPE_UNSPECIFIED_NIC_TYPE = 'UNSPECIFIED_NIC_TYPE';
  /**
   * VIRTIO
   */
  public const NIC_TYPE_VIRTIO_NET = 'VIRTIO_NET';
  /**
   * The network interface can have both IPv4 and IPv6 addresses.
   */
  public const STACK_TYPE_IPV4_IPV6 = 'IPV4_IPV6';
  /**
   * The network interface will only be assigned IPv4 addresses.
   */
  public const STACK_TYPE_IPV4_ONLY = 'IPV4_ONLY';
  /**
   * The network interface will only be assigned IPv6 addresses.
   */
  public const STACK_TYPE_IPV6_ONLY = 'IPV6_ONLY';
  protected $collection_key = 'ipv6AccessConfigs';
  protected $accessConfigsType = AccessConfig::class;
  protected $accessConfigsDataType = 'array';
  protected $aliasIpRangesType = AliasIpRange::class;
  protected $aliasIpRangesDataType = 'array';
  /**
   * Fingerprint hash of contents stored in this network interface. This field
   * will be ignored when inserting an Instance or adding a NetworkInterface. An
   * up-to-date fingerprint must be provided in order to update
   * theNetworkInterface. The request will fail with error400 Bad Request if the
   * fingerprint is not provided, or412 Precondition Failed if the fingerprint
   * is out of date.
   *
   * @var string
   */
  public $fingerprint;
  /**
   * Indicate whether igmp query is enabled on the network interface or not. If
   * enabled, also indicates the version of IGMP supported.
   *
   * @var string
   */
  public $igmpQuery;
  /**
   * The prefix length of the primary internal IPv6 range.
   *
   * @var int
   */
  public $internalIpv6PrefixLength;
  protected $ipv6AccessConfigsType = AccessConfig::class;
  protected $ipv6AccessConfigsDataType = 'array';
  /**
   * [Output Only] One of EXTERNAL, INTERNAL to indicate whether the IP can be
   * accessed from the Internet. This field is always inherited from its
   * subnetwork.
   *
   * Valid only if stackType is IPV4_IPV6.
   *
   * @var string
   */
  public $ipv6AccessType;
  /**
   * An IPv6 internal network address for this network interface. To use a
   * static internal IP address, it must be unused and in the same region as the
   * instance's zone. If not specified, Google Cloud will automatically assign
   * an internal IPv6 address from the instance's subnetwork.
   *
   * @var string
   */
  public $ipv6Address;
  /**
   * [Output Only] Type of the resource. Alwayscompute#networkInterface for
   * network interfaces.
   *
   * @var string
   */
  public $kind;
  /**
   * [Output Only] The name of the network interface, which is generated by the
   * server. For a VM, the network interface uses the nicN naming format. Where
   * N is a value between 0 and7. The default interface value is nic0.
   *
   * @var string
   */
  public $name;
  /**
   * URL of the VPC network resource for this instance. When creating an
   * instance, if neither the network nor the subnetwork is specified, the
   * default network global/networks/default is used. If the selected project
   * doesn't have the default network, you must specify a network or subnet. If
   * the network is not specified but the subnetwork is specified, the network
   * is inferred.
   *
   * If you specify this property, you can specify the network as a full or
   * partial URL. For example, the following are all valid URLs:               -
   * https://www.googleapis.com/compute/v1/projects/project/global/networks/netw
   * ork       - projects/project/global/networks/network       -
   * global/networks/default
   *
   * @var string
   */
  public $network;
  /**
   * The URL of the network attachment that this interface should connect to in
   * the following format: projects/{project_number}/regions/{region_name}/netwo
   * rkAttachments/{network_attachment_name}.
   *
   * @var string
   */
  public $networkAttachment;
  /**
   * An IPv4 internal IP address to assign to the instance for this network
   * interface. If not specified by the user, an unused internal IP is assigned
   * by the system.
   *
   * @var string
   */
  public $networkIP;
  /**
   * The type of vNIC to be used on this interface. This may be gVNIC or
   * VirtioNet.
   *
   * @var string
   */
  public $nicType;
  /**
   * Name of the parent network interface of a dynamic network interface.
   *
   * @var string
   */
  public $parentNicName;
  /**
   * The networking queue count that's specified by users for the network
   * interface. Both Rx and Tx queues will be set to this number. It'll be empty
   * if not specified by the users.
   *
   * @var int
   */
  public $queueCount;
  /**
   * The stack type for this network interface. To assign only IPv4 addresses,
   * use IPV4_ONLY. To assign both IPv4 and IPv6 addresses, useIPV4_IPV6. If not
   * specified, IPV4_ONLY is used.
   *
   * This field can be both set at instance creation and update network
   * interface operations.
   *
   * @var string
   */
  public $stackType;
  /**
   * The URL of the Subnetwork resource for this instance. If the network
   * resource is inlegacy mode, do not specify this field. If the network is in
   * auto subnet mode, specifying the subnetwork is optional. If the network is
   * in custom subnet mode, specifying the subnetwork is required. If you
   * specify this field, you can specify the subnetwork as a full or partial
   * URL. For example, the following are all valid URLs:               - https:/
   * /www.googleapis.com/compute/v1/projects/project/regions/region/subnetworks/
   * subnetwork     - regions/region/subnetworks/subnetwork
   *
   * @var string
   */
  public $subnetwork;
  /**
   * VLAN tag of a dynamic network interface, must be  an integer in the range
   * from 2 to 255 inclusively.
   *
   * @var int
   */
  public $vlan;

  /**
   * An array of configurations for this interface. Currently, only one access
   * config, ONE_TO_ONE_NAT, is supported. If there are noaccessConfigs
   * specified, then this instance will have no external internet access.
   *
   * @param AccessConfig[] $accessConfigs
   */
  public function setAccessConfigs($accessConfigs)
  {
    $this->accessConfigs = $accessConfigs;
  }
  /**
   * @return AccessConfig[]
   */
  public function getAccessConfigs()
  {
    return $this->accessConfigs;
  }
  /**
   * An array of alias IP ranges for this network interface. You can only
   * specify this field for network interfaces in VPC networks.
   *
   * @param AliasIpRange[] $aliasIpRanges
   */
  public function setAliasIpRanges($aliasIpRanges)
  {
    $this->aliasIpRanges = $aliasIpRanges;
  }
  /**
   * @return AliasIpRange[]
   */
  public function getAliasIpRanges()
  {
    return $this->aliasIpRanges;
  }
  /**
   * Fingerprint hash of contents stored in this network interface. This field
   * will be ignored when inserting an Instance or adding a NetworkInterface. An
   * up-to-date fingerprint must be provided in order to update
   * theNetworkInterface. The request will fail with error400 Bad Request if the
   * fingerprint is not provided, or412 Precondition Failed if the fingerprint
   * is out of date.
   *
   * @param string $fingerprint
   */
  public function setFingerprint($fingerprint)
  {
    $this->fingerprint = $fingerprint;
  }
  /**
   * @return string
   */
  public function getFingerprint()
  {
    return $this->fingerprint;
  }
  /**
   * Indicate whether igmp query is enabled on the network interface or not. If
   * enabled, also indicates the version of IGMP supported.
   *
   * Accepted values: IGMP_QUERY_DISABLED, IGMP_QUERY_V2
   *
   * @param self::IGMP_QUERY_* $igmpQuery
   */
  public function setIgmpQuery($igmpQuery)
  {
    $this->igmpQuery = $igmpQuery;
  }
  /**
   * @return self::IGMP_QUERY_*
   */
  public function getIgmpQuery()
  {
    return $this->igmpQuery;
  }
  /**
   * The prefix length of the primary internal IPv6 range.
   *
   * @param int $internalIpv6PrefixLength
   */
  public function setInternalIpv6PrefixLength($internalIpv6PrefixLength)
  {
    $this->internalIpv6PrefixLength = $internalIpv6PrefixLength;
  }
  /**
   * @return int
   */
  public function getInternalIpv6PrefixLength()
  {
    return $this->internalIpv6PrefixLength;
  }
  /**
   * An array of IPv6 access configurations for this interface. Currently, only
   * one IPv6 access config, DIRECT_IPV6, is supported. If there is no
   * ipv6AccessConfig specified, then this instance will have no external IPv6
   * Internet access.
   *
   * @param AccessConfig[] $ipv6AccessConfigs
   */
  public function setIpv6AccessConfigs($ipv6AccessConfigs)
  {
    $this->ipv6AccessConfigs = $ipv6AccessConfigs;
  }
  /**
   * @return AccessConfig[]
   */
  public function getIpv6AccessConfigs()
  {
    return $this->ipv6AccessConfigs;
  }
  /**
   * [Output Only] One of EXTERNAL, INTERNAL to indicate whether the IP can be
   * accessed from the Internet. This field is always inherited from its
   * subnetwork.
   *
   * Valid only if stackType is IPV4_IPV6.
   *
   * Accepted values: EXTERNAL, INTERNAL
   *
   * @param self::IPV6_ACCESS_TYPE_* $ipv6AccessType
   */
  public function setIpv6AccessType($ipv6AccessType)
  {
    $this->ipv6AccessType = $ipv6AccessType;
  }
  /**
   * @return self::IPV6_ACCESS_TYPE_*
   */
  public function getIpv6AccessType()
  {
    return $this->ipv6AccessType;
  }
  /**
   * An IPv6 internal network address for this network interface. To use a
   * static internal IP address, it must be unused and in the same region as the
   * instance's zone. If not specified, Google Cloud will automatically assign
   * an internal IPv6 address from the instance's subnetwork.
   *
   * @param string $ipv6Address
   */
  public function setIpv6Address($ipv6Address)
  {
    $this->ipv6Address = $ipv6Address;
  }
  /**
   * @return string
   */
  public function getIpv6Address()
  {
    return $this->ipv6Address;
  }
  /**
   * [Output Only] Type of the resource. Alwayscompute#networkInterface for
   * network interfaces.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * [Output Only] The name of the network interface, which is generated by the
   * server. For a VM, the network interface uses the nicN naming format. Where
   * N is a value between 0 and7. The default interface value is nic0.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * URL of the VPC network resource for this instance. When creating an
   * instance, if neither the network nor the subnetwork is specified, the
   * default network global/networks/default is used. If the selected project
   * doesn't have the default network, you must specify a network or subnet. If
   * the network is not specified but the subnetwork is specified, the network
   * is inferred.
   *
   * If you specify this property, you can specify the network as a full or
   * partial URL. For example, the following are all valid URLs:               -
   * https://www.googleapis.com/compute/v1/projects/project/global/networks/netw
   * ork       - projects/project/global/networks/network       -
   * global/networks/default
   *
   * @param string $network
   */
  public function setNetwork($network)
  {
    $this->network = $network;
  }
  /**
   * @return string
   */
  public function getNetwork()
  {
    return $this->network;
  }
  /**
   * The URL of the network attachment that this interface should connect to in
   * the following format: projects/{project_number}/regions/{region_name}/netwo
   * rkAttachments/{network_attachment_name}.
   *
   * @param string $networkAttachment
   */
  public function setNetworkAttachment($networkAttachment)
  {
    $this->networkAttachment = $networkAttachment;
  }
  /**
   * @return string
   */
  public function getNetworkAttachment()
  {
    return $this->networkAttachment;
  }
  /**
   * An IPv4 internal IP address to assign to the instance for this network
   * interface. If not specified by the user, an unused internal IP is assigned
   * by the system.
   *
   * @param string $networkIP
   */
  public function setNetworkIP($networkIP)
  {
    $this->networkIP = $networkIP;
  }
  /**
   * @return string
   */
  public function getNetworkIP()
  {
    return $this->networkIP;
  }
  /**
   * The type of vNIC to be used on this interface. This may be gVNIC or
   * VirtioNet.
   *
   * Accepted values: GVNIC, IDPF, IRDMA, MRDMA, UNSPECIFIED_NIC_TYPE,
   * VIRTIO_NET
   *
   * @param self::NIC_TYPE_* $nicType
   */
  public function setNicType($nicType)
  {
    $this->nicType = $nicType;
  }
  /**
   * @return self::NIC_TYPE_*
   */
  public function getNicType()
  {
    return $this->nicType;
  }
  /**
   * Name of the parent network interface of a dynamic network interface.
   *
   * @param string $parentNicName
   */
  public function setParentNicName($parentNicName)
  {
    $this->parentNicName = $parentNicName;
  }
  /**
   * @return string
   */
  public function getParentNicName()
  {
    return $this->parentNicName;
  }
  /**
   * The networking queue count that's specified by users for the network
   * interface. Both Rx and Tx queues will be set to this number. It'll be empty
   * if not specified by the users.
   *
   * @param int $queueCount
   */
  public function setQueueCount($queueCount)
  {
    $this->queueCount = $queueCount;
  }
  /**
   * @return int
   */
  public function getQueueCount()
  {
    return $this->queueCount;
  }
  /**
   * The stack type for this network interface. To assign only IPv4 addresses,
   * use IPV4_ONLY. To assign both IPv4 and IPv6 addresses, useIPV4_IPV6. If not
   * specified, IPV4_ONLY is used.
   *
   * This field can be both set at instance creation and update network
   * interface operations.
   *
   * Accepted values: IPV4_IPV6, IPV4_ONLY, IPV6_ONLY
   *
   * @param self::STACK_TYPE_* $stackType
   */
  public function setStackType($stackType)
  {
    $this->stackType = $stackType;
  }
  /**
   * @return self::STACK_TYPE_*
   */
  public function getStackType()
  {
    return $this->stackType;
  }
  /**
   * The URL of the Subnetwork resource for this instance. If the network
   * resource is inlegacy mode, do not specify this field. If the network is in
   * auto subnet mode, specifying the subnetwork is optional. If the network is
   * in custom subnet mode, specifying the subnetwork is required. If you
   * specify this field, you can specify the subnetwork as a full or partial
   * URL. For example, the following are all valid URLs:               - https:/
   * /www.googleapis.com/compute/v1/projects/project/regions/region/subnetworks/
   * subnetwork     - regions/region/subnetworks/subnetwork
   *
   * @param string $subnetwork
   */
  public function setSubnetwork($subnetwork)
  {
    $this->subnetwork = $subnetwork;
  }
  /**
   * @return string
   */
  public function getSubnetwork()
  {
    return $this->subnetwork;
  }
  /**
   * VLAN tag of a dynamic network interface, must be  an integer in the range
   * from 2 to 255 inclusively.
   *
   * @param int $vlan
   */
  public function setVlan($vlan)
  {
    $this->vlan = $vlan;
  }
  /**
   * @return int
   */
  public function getVlan()
  {
    return $this->vlan;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(NetworkInterface::class, 'Google_Service_Compute_NetworkInterface');
