<?php
/**
 * Core plugin functionality.
 *
 * @package StrategySuite
 */

namespace StrategySuite\Core;

use StrategySuite\ModuleInitialization;

/**
 * Default setup routine
 *
 * @return void
 */
function setup() {
	$n = function ( $function ) {
		return __NAMESPACE__ . "\\$function";
	};

	add_action( 'init', $n( 'i18n' ) );
	add_action( 'init', $n( 'init' ), apply_filters( 'strategy_suite_init_priority', 4 ) );

	do_action( 'strategy_suite_loaded' );
}

/**
 * Registers the default textdomain.
 *
 * @return void
 */
function i18n() {
	$locale = apply_filters( 'plugin_locale', get_locale(), 'strategy-suite' );
	load_textdomain( 'strategy-suite', WP_LANG_DIR . '/strategy-suite/strategy-suite-' . $locale . '.mo' );
	load_plugin_textdomain( 'strategy-suite', false, plugin_basename( STRATEGY_SUITE_PATH ) . '/languages/' );
}

/**
 * Initializes the plugin and fires an action other plugins can hook into.
 *
 * @return void
 */
function init() {
	do_action( 'strategy_suite_before_init' );

	// If the composer.json isn't found, trigger a warning.
	if ( ! file_exists( STRATEGY_SUITE_PATH . 'composer.json' ) ) {
		add_action(
			'admin_notices',
			function () {
				$class = 'notice notice-error';
				/* translators: %s: the path to the plugin */
				$message = sprintf( __( 'The composer.json file was not found within %s. No classes will be loaded.', 'strategy-suite' ), STRATEGY_SUITE_PATH );

				printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), esc_html( $message ) );
			}
		);
		return;
	}

	ModuleInitialization::instance()->init_classes();
	do_action( 'strategy_suite_init' );
}

/**
 * Activate the plugin
 *
 * @return void
 */
function activate() {
	// First load the init scripts in case any rewrite functionality is being loaded
	init();
	flush_rewrite_rules();
	add_option( 'strategy_suite_repo', 'Strategyllcweb/strategy-suite' );
	add_option( 'strategy_suite_branch', 'master' );
}

/**
 * Deactivate the plugin
 *
 * Uninstall routines should be in uninstall.php
 *
 * @return void
 */
function deactivate() {
	delete_option( 'strategy_suite_repo' );
	delete_option( 'strategy_suite_branch' );
}
