<?php
/**
 * WPRocket
 *
 * @package StrategySuite
 */

namespace StrategySuite;

/**
 * Class WPRocket
 */
class WPRocket extends \StrategySuite\Module {

	/**
	 * Determine if the module can be registered.
	 *
	 * @return bool
	 */
	public function can_register() {
		return is_plugin_active( 'wp-rocket/wp-rocket.php' );
	}

	/**
	 * Register hooks for customizing the WordPress login page.
	 *
	 * @return void
	 */
	public function register() {
		add_filter( 'rocket_lrc_exclusions', [ $this, 'alr_exclusions' ], 999 );
		add_filter( 'rocket_insights_enabled', '__return_false' );
		add_action( 'acf/save_post', [ $this, 'configure_wp_rocket' ], 20 );
	}

	/**
	 * Excludes the footer from being cached by WP Rocket.
	 *
	 * @param array $exclusions The current exclusions array.
	 *
	 * @return array $exclusions The updated exclusions array.
	 */
	public function alr_exclusions( $exclusions ) {
		$exclusions[] = 'class="lg-footer"';

		return $exclusions;
	}

	/**
	 * Configures WP Rocket to ignore certain paths.
	 */
	public function configure_wp_rocket() {
		$screen = get_current_screen();
		if ( function_exists( 'update_rocket_option' ) && ( strpos( $screen->id, 'site_settings' ) == true ) ) {
			update_rocket_option(
				'cache_reject_uri',
				[
					'\/wp-json\/gh\/(.*)',
					'\/gh\/(.*)',
				]
			);
		}
	}
}
