<?php
/**
 * Plugin Name:       Strategy Spam Protection
 * Description:       Protects your website from spam submissions by testing email deliverability.
 * Version:           0.1.0
 * Requires at least: 4.9
 * Requires PHP:      7.2
 * Author:            Strategy, LLC
 * Author URI:        https://strategynewmedia.com
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       strategy
 * Domain Path:       /languages
 *
 * @package           StrategySpamProtection
 */

// Useful global constants.
define( 'STRATEGY_SPAM_PROTECTION_VERSION', '1.1.0' );
define( 'STRATEGY_SPAM_PROTECTION_URL', plugin_dir_url( __FILE__ ) );
define( 'STRATEGY_SPAM_PROTECTION_PATH', plugin_dir_path( __FILE__ ) );
define( 'STRATEGY_SPAM_PROTECTION_INC', STRATEGY_SPAM_PROTECTION_PATH . 'includes/' );
define( 'STRATEGY_SPAM_PROTECTION_DIST_URL', STRATEGY_SPAM_PROTECTION_URL . 'dist/' );
define( 'STRATEGY_SPAM_PROTECTION_DIST_PATH', STRATEGY_SPAM_PROTECTION_PATH . 'dist/' );

// Require Composer autoloader if it exists.
if ( file_exists( STRATEGY_SPAM_PROTECTION_PATH . 'vendor/autoload.php' ) ) {
	require_once STRATEGY_SPAM_PROTECTION_PATH . 'vendor/autoload.php';
}

// Include files.
require_once STRATEGY_SPAM_PROTECTION_INC . '/utility.php';
require_once STRATEGY_SPAM_PROTECTION_INC . '/core.php';

// Activation/Deactivation.
register_activation_hook( __FILE__, '\StrategySpamProtection\Core\activate' );
register_deactivation_hook( __FILE__, '\StrategySpamProtection\Core\deactivate' );

// Bootstrap.
StrategySpamProtection\Core\setup();
