<?php
/**
 * Reviews Block Editor
 *
 * @package StrategyPlugin
 */

namespace StrategyPlugin;

/**
 * Reviews Block Editor
 */
class BlockEditor extends \StrategyPlugin\Module {

	/**
	 * Only register if on an admin page and if fieldmanager plugin is active.
	 *
	 * @return bool
	 */
	public function can_register() {
		$theme = wp_get_theme();
		return 'leadgen' === $theme->stylesheet;
	}

	/**
	 * Register our hooks.
	 *
	 * @return void
	 */
	public function register() {
		add_action( 'init', [ $this, 'register_block_patterns' ] );
	}

	/**
	 * Register block patterns
	 *
	 * @return void
	 */
	public function register_block_patterns() {

		// Register a block pattern category
		register_block_pattern_category(
			'reviews',
			[ 'label' => __( 'Reviews', 'lead-gen' ) ]
		);

		if ( function_exists( 'register_block_pattern' ) ) {
			$block_patterns = array(
				[
					'slug'      => 'reviews-section',
					'title'     => 'Review Us Section',
					'category'  => 'reviews',
				],
				[
					'slug'      => 'referrals-section',
					'title'     => 'Referrals Section',
					'category'  => 'reviews',
				],
			);

			foreach ( $block_patterns as $block_pattern ) {
				if ( $this->check_blocks_version( 2 ) ) {
					$block_pattern['slug'] = $block_pattern['slug'] . '-v2';
				}
				register_block_pattern(
					$block_pattern['category'] . '/' . $block_pattern['slug'],
					array(
						'title'      => $block_pattern['title'],
						'content'    => file_get_contents( STRATEGY_REVIEWS_PATH . '/patterns/' . $block_pattern['slug'] . '.html' ),
						'categories' => [ $block_pattern['category'] ],
					)
				);
			}
		}
	}

	private function check_blocks_version( $version ) {
		return is_plugin_active( 'strategy-blocks/plugin.php' ) && (int) get_option( 'strategy_blocks_version' ) === $version;
	}
}
