<?php
/**
 * Plugin Name:       Strategy Reviews
 * Description:       Strategy Reviews makes it easy to get more reviews.
 * Version:           1.2.4
 * Requires at least: 5.6
 * Requires PHP:      8.0
 * Author:            Strategy, LLC
 * Author URI:        https://strategynewmedia.com
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       strategy
 * Domain Path:       /languages
 *
 * @package           StrategyPlugin
 */

// Useful global constants.
define( 'STRATEGY_REVIEWS_VERSION', '1.2.4' );
define( 'STRATEGY_REVIEWS_URL', plugin_dir_url( __FILE__ ) );
define( 'STRATEGY_REVIEWS_PATH', plugin_dir_path( __FILE__ ) );
define( 'STRATEGY_REVIEWS_INC', STRATEGY_REVIEWS_PATH . 'includes/' );
define( 'STRATEGY_REVIEWS_DIST_URL', STRATEGY_REVIEWS_URL . 'dist/' );
define( 'STRATEGY_REVIEWS_DIST_PATH', STRATEGY_REVIEWS_PATH . 'dist/' );

// Require Composer autoloader if it exists.
if ( file_exists( STRATEGY_REVIEWS_PATH . 'vendor/autoload.php' ) ) {
	require_once STRATEGY_REVIEWS_PATH . 'vendor/autoload.php';
}

// Include files.
require_once STRATEGY_REVIEWS_INC . '/utility.php';
require_once STRATEGY_REVIEWS_INC . '/core.php';

// Activation/Deactivation.
register_activation_hook( __FILE__, '\StrategyPlugin\Core\activate' );
register_deactivation_hook( __FILE__, '\StrategyPlugin\Core\deactivate' );

// Bootstrap.
StrategyPlugin\Core\setup();
