<?php
/**
 * Reviews
 *
 * @package StrategyPlugin
 */

namespace StrategyPlugin;

use GFAPI;
use StrategyPlugin\Utility;

/**
 * Reviews
 */
class Referrals extends \StrategyPlugin\Module {

	/**
	 * Feedback Form ID
	 *
	 * @var string
	 */
	private $referral_form_id;

	/**
	 * Feedback Form title
	 *
	 * @var string
	 */
	private $referral_form_title;

	/**
	 * Locations
	 *
	 * @var array
	 */
	private $locations;

	/**
	 * Current Location ID
	 *
	 * @var string
	 */
	private $current_location_id;

	/**
	 * Rating Threshold
	 *
	 * @var int
	 */
	private $rating_threshold;

	/**
	 * Rating System
	 *
	 * @var int
	 */
	private $rating_system;

	/**
	 * Only register if on an admin page and if fieldmanager plugin is active.
	 *
	 * @return bool
	 */
	public function can_register() {
		return true;
	}

	/**
	 * Register our hooks.
	 *
	 * @return void
	 */
	public function register() {
		add_action( 'template_redirect', [ $this, 'set_variables' ] );
		add_shortcode( 'referrals', [ $this, 'strategy_referrals' ] );
	}

	/**
	 * Scaffolds the class properties.
	 *
	 * @return void
	 */
	public function set_variables() {
		$this->referral_form_title = apply_filters( 'strategy_reviews_referral_form_title', 'Referral Form' );
		$this->referral_form_id = $this->get_referral_form_id();
	}

	/**
	 * Retrieves the referral form ID.
	 *
	 * @return int
	 */
	private function get_referral_form_id() {
		// Check database option
		$id = get_option( 'strategy_reviews_referral_form_id' );
		if ( $id && GFAPI::get_form( $id ) ) {
			return $id;
		}

		// Check all forms for title
		$id = $this->get_form_id_by_title( $this->referral_form_title );
		if ( $id && GFAPI::get_form( $id ) ) {
			update_option( 'strategy_reviews_referral_form_id', $id );
			return $id;
		}

		return null;
	}

	/**
	 * Retrieves the form ID by title.
	 *
	 * @param string $title The form title.
	 * @return int
	 */
	private function get_form_id_by_title( $title ) {

		$forms = GFAPI::get_forms();
		foreach ( $forms as $form ) {
			if ( isset( $form['title'] ) && isset( $form['id'] ) && $title == $form['title'] ) {
				return $form['id'];
			}
		}

		return false;
	}

	/**
	 * Shortcode for the referral form.
	 *
	 * @return string
	 */
	public function strategy_referrals() {
		ob_start();

		echo do_shortcode( '[gravityform id="' . $this->referral_form_id . '" title="false" ajax="true"]' );

		$output = ob_get_contents();
		ob_end_clean();
		return $output;
	}
}
