<?php
/**
 * Plugin Name:       Strategy Blocks
 * Description:       An accessible and easy to use suite of blocks.
 * Version:           1.3.3
 * Requires at least: 5.6
 * Requires PHP:      8.0
 * Author:            Strategy, LLC
 * Author URI:        https://strategynewmedia.com
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       strategy
 * Domain Path:       /languages
 *
 * @package           StrategyBlocks
 */

// Useful global constants.
define( 'STRATEGY_BLOCKS_VERSION', '1.3.3' );
define( 'STRATEGY_BLOCKS_BASE', plugin_basename( __FILE__ ) );
define( 'STRATEGY_BLOCKS_URL', plugin_dir_url( __FILE__ ) );
define( 'STRATEGY_BLOCKS_PATH', plugin_dir_path( __FILE__ ) );
define( 'STRATEGY_BLOCKS_INC', STRATEGY_BLOCKS_PATH . 'includes/' );
define( 'STRATEGY_BLOCKS_DIST_URL', STRATEGY_BLOCKS_URL . 'dist/' );
define( 'STRATEGY_BLOCKS_DIST_PATH', STRATEGY_BLOCKS_PATH . 'dist/' );
define( 'STRATEGY_BLOCKS_BLOCK_DIR', STRATEGY_BLOCKS_INC . 'blocks/' );
define( 'STRATEGY_BLOCKS_BLOCK_DIST_DIR', STRATEGY_BLOCKS_DIST_PATH . 'blocks/' );

// For the Google Maps block, just to avoid errors in the console if GOOGLE_API_TOKEN is not defined
define( 'DEVELOPER_GOOGLE_API_TOKEN', 'AIzaSyA6n9b4Gaqb_rVKiMM0IKLJsOyVChqvrYk' );

// Require Composer autoloader if it exists.
if ( file_exists( STRATEGY_BLOCKS_PATH . 'vendor/autoload.php' ) ) {
	require_once STRATEGY_BLOCKS_PATH . 'vendor/autoload.php';
}

// Include files.
require_once STRATEGY_BLOCKS_INC . '/lib/BlockCustomCSS.php';
require_once STRATEGY_BLOCKS_INC . '/lib/FontAwesomeSVG.php';
require_once STRATEGY_BLOCKS_INC . '/utility.php';
require_once STRATEGY_BLOCKS_INC . '/aria-walker-nav-menu.php';
require_once STRATEGY_BLOCKS_INC . '/core.php';
require_once WP_PLUGIN_DIR . '/strategy-suite/includes/noautoload-classes/GA4Automation.php';

// Plugin Updates (token needs to be defined in wp-config)
if ( defined( 'STRATEGY_UPDATE_TOKEN' ) ) {
	include_once STRATEGY_BLOCKS_INC . '/plugin-updater.php';
	$updater = new StrategyPluginUpdater( __FILE__ );
	$updater->init();
}

// Activation/Deactivation.
register_activation_hook( __FILE__, '\StrategyBlocks\Core\activate' );
register_deactivation_hook( __FILE__, '\StrategyBlocks\Core\deactivate' );

// Bootstrap.
StrategyBlocks\Core\setup();
