<?php
/**
 * Shape Divider Template Part
 *
 * @package StrategyBlocks
 *
 * @param   array $args
 */

$class_names = 'section__divider section__divider-size-' . $args['height'];
$class_names .= 'top' === $args['position'] ? ' section__divider-top' : ' section__divider-bottom';

$path = '';

switch ( $args['type'] ) {
	case 'waves':
		$path = '<path d="M321.39,58.44c58-10.79,114.16-30.13,172-41.86,82.39-16.72,168.19-17.73,250.45-.39C823.78,33,906.67,74,985.66,94.83c70.05,18.48,146.53,26.09,214.34,5V0H0V29.35A600.21,600.21,0,0,0,321.39,58.44Z"/>';
		break;
	case 'curve':
		$path = '<path d="M0,0V7.23C0,65.52,268.63,112.77,600,112.77S1200,65.52,1200,7.23V0Z"></path>';
		break;
	case 'curve-asymmetrical':
		$path = '<path d="M0,0V6c0,21.6,291,111.46,741,110.26,445.39,3.6,459-88.3,459-110.26V0Z"></path>';
		break;
	case 'triangle':
		$path = '<path d="M1200 0L0 0 598.97 114.72 1200 0z"></path>';
		break;
	case 'triangle-asymmetrical':
		$path = '<path d="M1200 0L0 0 892.25 114.72 1200 0z"></path>';
		break;
	case 'tilt':
		$path = '<path d="M1200 120L0 16.48 0 0 1200 0 1200 120z"></path>';
		break;
	case 'arrow':
		$path = '<path d="M649.97 0L550.03 0 599.91 54.12 649.97 0z"></path>';
		break;
	case 'split':
		$path = '<rect x="1200" height="3.6"></rect><rect height="3.6"></rect><path d="M0,0V3.6H580.08c11,0,19.92,5.09,19.92,13.2,0-8.14,8.88-13.2,19.92-13.2H1200V0Z"></path>';
		break;
	case 'book':
		$path = '<path d="M1200,0H0V120H281.94C572.9,116.24,602.45,3.86,602.45,3.86h0S632,116.24,923,120h277Z"></path>';
		break;
} ?>

<div class="<?php echo esc_attr( $class_names ); ?>">
	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1200 120" preserveAspectRatio="none" class="section__divider-svg<?php echo $args['flip'] ? ' section__divider-flip' : ''; ?>" style="fill: <?php echo esc_attr( $args['color'] ); ?>" aria-hidden="true">
		<?php
		// @codingStandardsIgnoreStart
		echo $path;
		// @codingStandardsIgnoreEnd
		?>
	</svg>
</div>
