<?php
/**
 * Wrapper
 *
 * @package StrategyBlocks
 *
 * @param array  $attributes  The block's attributes.
 * @param string $content     The block's inner content (unused here).
 * @param object $block       The block object (contains anchor, etc.).
 */

use StrategyBlocks\Utility;

$id = ! empty( $attributes['anchor'] ) ? $attributes['anchor'] : '';

$class_name = 'lg-block lg-block__wrapper';
$class_name .= Utility\get_block_style_classes( $attributes );
$class_name .= Utility\get_native_wp_classes( $attributes );
$class_name .= Utility\get_visibility_classes( $attributes );
$animations = Utility\get_animation_data( $attributes );

$html_tag = $attributes['htmlTag'];

do_action( 'lg_block_wrapper_before' );?>

<<?php echo esc_attr( $html_tag ); ?> <?php echo ! empty( $id ) ? 'id="' . esc_attr( $id ) . '" ' : null; ?> class="<?php echo esc_attr( $class_name ); ?>" <?php echo ! empty( $aria_label ) ? 'aria-label="' . esc_attr( $aria_label ) . '" ' : null; ?> <?php echo ! empty( $animations ) ? 'data-animation="' . esc_attr( $animations ) . '" ' : null; ?> >
	<?php echo $content; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
</<?php echo esc_attr( $html_tag ); ?>>

<?php do_action( 'lg_block_wrapper_after' ); ?>
