<?php
/**
 * Testimonials Block
 *
 * @package StrategyBlocks
 *
 * @param array  $attributes  The block's attributes.
 * @param string $content     The block's inner content (unused here).
 * @param object $block       The block object (contains anchor, etc.).
 */

use StrategyBlocks\Utility;
use StrategyBlocks\FontAwesomeSVG;

$id = $attributes['anchor'] ?? '';
$display_type = $attributes['displayType'] ?? 'card';
$elements = $attributes['elements'] ?? [];
$slider_centered = $attributes['sliderCentered'] ?? false;

$class_name = implode(
	' ',
	array_filter(
		[
			'lg-block',
			'lg-block__testimonials',
			'testimonials',
			'testimonials--' . $display_type,
			'slider' === $display_type && ! empty( $attributes['sliderControls'] ) ? 'swiper--nav' : '',
			'row',
			Utility\get_block_style_classes( $attributes ),
			Utility\get_native_wp_classes( $attributes ),
			Utility\get_visibility_classes( $attributes ),
		]
	)
);

$animations = Utility\get_animation_data( $attributes );
$per_view   = max( 1, intval( $attributes['sliderPageSize'] ?? 3 ) );

$post_args = [
	'post_type'      => 'testimonials',
	'post_status'    => 'publish',
	'posts_per_page' => $attributes['maxReviews'] ?? -1,
	'orderby'        => $attributes['orderBy'] ?? 'date',
	'order'          => $attributes['order'] ?? 'DESC',
];

switch ( $attributes['selector'] ?? '' ) {
	case 'name':
		if ( ! empty( $attributes['testimonials'][0] ?? '' ) ) {
			$post_args['post__in'] = $attributes['testimonials'];
		}
		break;

	case 'categories':
		if ( ! empty( $attributes['categories'][0] ?? '' ) ) {
			$post_args['tax_query'] = [
				[
					'taxonomy' => 'testimonial-categories',
					'field'    => 'id',
					'terms'    => $attributes['categories'],
				],
			];
		}
		break;
}

$font_awesome = new FontAwesomeSVG( STRATEGY_BLOCKS_DIST_PATH . 'font-awesome/svgs' );

do_action( 'lg_block_testimonials_before' );
?>

	<div
		<?php
		if ( $id ) {
			echo 'id="' . esc_attr( $id ) . '"';
		}
		?>
		class="<?php echo esc_attr( $class_name ); ?>"
		<?php
		if ( $animations ) {
			echo 'data-animation="' . esc_attr( $animations ) . '"';
		}
		?>
	>
		<?php if ( $id ) : ?>
			<a id="skip-<?php echo esc_attr( $id ); ?>" class="skip-link" href="#after-<?php echo esc_attr( $id ); ?>">
				<?php esc_html_e( 'Skip Past Slider', 'lead-gen' ); ?>
			</a>
		<?php endif; ?>

		<?php
		$query = new WP_Query( $post_args );
		if ( $query->have_posts() ) :
			$length = $query->post_count;

			if ( 'slider' === $display_type ) :
				?>
			<div
				class="testimonial__slider swiper"
				data-swiper-perview="<?php echo esc_attr( $per_view ); ?>"
				data-swiper-centered="<?php echo esc_attr( $slider_centered ? '1' : '0' ); ?>"
			>
				<div class="swiper-wrapper">
			<?php endif; ?>

				<?php
				while ( $query->have_posts() ) :
					$query->the_post();
					if ( empty( $elements ) ) {
						// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
						echo Utility\render_testimonial_item( get_the_ID(), $display_type, $font_awesome );
					} else {
						// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
						echo Utility\render_ordered_testimonial_item( get_the_ID(), $display_type, $font_awesome, $attributes );
					}
				endwhile;
				?>

				<?php if ( 'slider' === $display_type ) : ?>
				</div>

					<?php if ( ! empty( $attributes['sliderControls'] ) ) : ?>
						<?php Utility\render_slider_controls( $font_awesome ); ?>
					<?php endif; ?>
			</div>

				<?php endif; ?>

			<?php
			endif;
			wp_reset_postdata();
		?>

		<?php if ( $id ) : ?>
			<div id="after-<?php echo esc_attr( $id ); ?>" aria-hidden="true" class="sr-only"></div>
		<?php endif; ?>
	</div>

<?php do_action( 'lg_block_testimonials_after' ); ?>
