<?php
/**
 * Spacer Block
 *
 * @package StrategyBlocks
 *
 * @param array  $attributes  Block attributes.
 * @param string $content     Inner block content (empty).
 * @param object $block       Block instance object.
 */

use StrategyBlocks\Utility;

$id = ! empty( $attributes['anchor'] ) ? $attributes['anchor'] : '';
$class_name = 'lg-block lg-block__spacer';
$class_name .= Utility\get_block_style_classes( $attributes );
$class_name .= Utility\get_native_wp_classes( $attributes );
$class_name .= Utility\get_visibility_classes( $attributes );
$class_name .= ' spacer-' . sanitize_html_class( $attributes['space'] ?? 'md' );

do_action( 'lg_block_spacer_before' ); ?>
<div <?php echo $id ? 'id="' . esc_attr( $id ) . '"' : ''; ?> class="<?php echo esc_attr( $class_name ); ?> <?php echo ! empty( $animations ) ? 'data-animation="' . esc_attr( $animations ) . '" ' : null; ?>" aria-hidden="true"></div>
<?php do_action( 'lg_block_spacer_after' ); ?>
