<?php
/**
 * Server-rendered output for Shortcode block.
 *
 * @package StrategyBlocks
 *
 * @param array  $attributes  Block attributes.
 * @param string $content     Block content (unused).
 * @param object $block       Block object (used for anchor).
 */

// use LeadGenTheme\Utility;
use StrategyBlocks\Utility;

$id = ! empty( $attributes['anchor'] ) ? $attributes['anchor'] : '';
$class_name = 'lg-block lg-block__shortcode';
$class_name .= Utility\get_block_style_classes( $attributes );
$class_name .= Utility\get_native_wp_classes( $attributes );
$class_name .= Utility\get_visibility_classes( $attributes );
$animations = Utility\get_animation_data( $attributes );

$shortcode = $attributes['shortcode'] ?? '';

do_action( 'lg_block_shortcode_before' );

if ( $shortcode ) :
	?>
	<div
		<?php echo $id ? 'id="' . esc_attr( $id ) . '"' : ''; ?>
		class="<?php echo esc_attr( $class_name ); ?>"
		<?php echo ! empty( $animations ) ? 'data-animation="' . esc_attr( $animations ) . '"' : ''; ?>
	>
		<?php echo do_shortcode( $shortcode ); ?>
	</div>
	<?php
endif;

do_action( 'lg_block_shortcode_after' ); ?>
