document.addEventListener('DOMContentLoaded', () => {
	const toggles = document.querySelectorAll('input[name="period"]');
	if (!toggles) return;

	const prices = document.querySelectorAll('.pricing-list__price-value');
	const periods = document.querySelectorAll('.pricing-list__price-period');

	function updatePrices() {
		const isYearly = document.getElementById('yearly')?.checked;
		prices.forEach(price => {
			const monthly = price.querySelector('.pricing-list__price-monthly');
			const yearly = price.querySelector('.pricing-list__price-yearly');

			if (isYearly) {
				monthly.style.display = 'none';
				yearly.style.display = 'inline';
			} else {
				monthly.style.display = 'inline';
				yearly.style.display = 'none';
			}
		});
	}

	function updatePeriods() {
		const isYearly = document.getElementById('yearly')?.checked;
		periods.forEach(periods => {
			const monthlyPeriod = periods.querySelector('.pricing-list__price-period-monthly');
			const yearlyPeriod = periods.querySelector('.pricing-list__price-period-yearly');

			if (isYearly) {
				monthlyPeriod.style.display = 'none';
				yearlyPeriod.style.display = 'inline';
			} else {
				monthlyPeriod.style.display = 'inline';
				yearlyPeriod.style.display = 'none';
			}
		});
	}

	updatePrices();
	updatePeriods();

	toggles.forEach(radio => {
		radio.addEventListener('change', () => {
			const isYearly = document.getElementById('yearly').checked;
			const container = document.querySelector('.pricing-toggle__container');

			if (!container) return;

			container.classList.toggle( 'pricing-toggle__container--monthly', !isYearly );
			updatePrices();
			updatePeriods();
		});
	});

	function setRowHeights() {
		const wrapper = document.querySelector('.pricing-list__wrapper');
		if (!wrapper) return;

		const sidebarCells = wrapper.querySelectorAll('.pricing-list__sidebar .pricing-list__cell');
		const slides = wrapper.querySelectorAll('.swiper-slide');

		if (!slides.length || !sidebarCells.length) return;
		const rowsCount = sidebarCells.length;

		for (let rowIndex = 0; rowIndex < rowsCount; rowIndex++) {
			const rowCells = [];

			const sidebarCell = sidebarCells[rowIndex];
			if (sidebarCell) rowCells.push(sidebarCell);

			slides.forEach(slide => {
				const slideCells = slide.querySelectorAll('.pricing-list__cell');
				if (slideCells[rowIndex]) rowCells.push(slideCells[rowIndex]);
			});

			rowCells.forEach(cell => cell.style.height = 'auto');
			const maxHeight = Math.max(...rowCells.map(cell => cell.offsetHeight));
			rowCells.forEach(cell => cell.style.height = maxHeight + 'px');
		}
	}

	setRowHeights();
	window.addEventListener('resize', setRowHeights);
});

