<?php
/**
 * Post Block
 *
 * @package StrategyBlocks
 *
 * @param array  $attributes  The block's attributes.
 * @param string $content     The block's inner content.
 * @param object $block       The block object.
 */

use StrategyBlocks\Utility;
use StrategyBlocks\Template;
use StrategyBlocks\FontAwesomeSVG;

$id = ! empty( $attributes['anchor'] ) ? $attributes['anchor'] : '';

$class_name = 'lg-block lg-block__post post';
$class_name .= Utility\get_block_style_classes( $attributes );
$class_name .= Utility\get_native_wp_classes( $attributes );
$class_name .= Utility\get_visibility_classes( $attributes );
$animations = Utility\get_animation_data( $attributes );

$elements    = $attributes['elements'] ?? [];
$meta_items   = $attributes['metaItems'] ?? [];
$navigation  = $attributes['navigation'] ?? false;
$social_share = $attributes['socialShare'] ?? false;
$title_html_tag = $attributes['titleHtmlTag'] ?? false;

$has_title = false;
$has_categories = false;
$has_meta = false;
$meta = null;
$has_content = false;
$has_image = false;

// We do conditional checks because we don't want to output in the array order like other blocks.
foreach ( $elements as $index => $element ) {
	if ( 'title' === $element ) {
		$has_title = true;
	}
	if ( 'categories' === $element ) {
		$has_categories = true;
	}
	if ( 'meta' === $element ) {
		$has_meta = true;
	}
	if ( 'content' === $element ) {
		$has_content = true;
	}
	if ( 'image' === $element ) {
		$has_image = true;
	}
}

global $post;
setup_postdata( $post );

do_action( 'lg_block_post_before' ); ?>
<article <?php echo $id ? 'id="' . esc_attr( $id ) . '"' : ''; ?> class="<?php echo esc_attr( $class_name ); ?>" <?php echo ! empty( $animations ) ? 'data-animation="' . esc_attr( $animations ) . '"' : ''; ?>>
	<?php if ( $has_meta || $has_title ) : ?>
		<div class="post__meta bg-color-primary-shade-1 link-color-secondary text-color-secondary rounded-xs px-sm py-sm">
			<?php if ( $has_categories ) : ?>
				<?php
				$primary_term_id = function_exists( 'yoast_get_primary_term_id' ) ? yoast_get_primary_term_id() : false;
				$categories = $primary_term_id ? [ get_category( $primary_term_id ) ] : get_the_category();
				?>
				<p class="post__categories">
					<span class="sr-only">Posted In: </span>
					<?php
					foreach ( $categories as $category ) {
						printf(
							'<a href="%1$s" class="post__category">%2$s</a>',
							esc_url( get_category_link( $category->term_id ) ),
							esc_html( $category->name )
						);
					}
					?>
				</p>
			<?php endif; ?>
			<?php if ( $has_title ) : ?>
				<<?php echo esc_attr( $title_html_tag ); ?> class="post__title h1">
					<?php the_title(); ?>
				</<?php echo esc_attr( $title_html_tag ); ?>>
			<?php endif; ?>
			<?php if ( $has_meta ) : ?>
				<div class="post__meta-items">
					<?php foreach ( $meta_items as $item ) { ?>
						<?php if ( 'author' === $item && ! empty( get_the_author() ) ) { ?>
							<span class="post__meta-item post__meta-author"><span class="sr-only">Posted By: </span><?php the_author(); ?></span>
						<?php } ?>
						<?php if ( 'date' === $item ) : ?>
							<span class="post__meta-item post__meta-date"><span class="sr-only">Posted On: </span><time><?php the_time( 'F jS, Y' ); ?></time></span>
						<?php endif; ?>
						<?php if ( 'date_time' === $item ) : ?>
							<span class="post__meta-item post__meta-datetime">
								<span class="sr-only"><?php esc_html_e( 'Posted On:', 'lead-gen' ); ?></span>
								<time datetime="<?php echo esc_attr( get_post_time( 'c', true ) ); ?>">
									<?php echo esc_html( get_the_date( 'F jS, Y g:i a' ) ); ?>
								</time>
							</span>
						<?php endif; ?>
						<?php if ( 'reading_time' === $item ) { ?>
							<span class="post__meta-item post__meta-readingtime"><?php echo esc_html( Utility\get_reading_time( get_the_ID(), 250 ) ); ?></span>
						<?php } ?>
					<?php } ?>
				</div>
			<?php endif; ?>
			<?php if ( $social_share ) { ?>
				<div class="post__socialshare">
					<?php Utility\social_share(); ?>
				</div>
			<?php } ?>
		</div>
	<?php endif; ?>
	<?php if ( has_post_thumbnail() && $has_image ) : ?>
		<div class="post__image">
			<?php echo wp_get_attachment_image( get_post_thumbnail_id(), 'large', false, [ 'class' => 'post__image rounded-xs' ] ); ?>
		</div>
	<?php endif; ?>
	<?php if ( $has_content ) : ?>
		<div class="post__content">
			<?php the_content(); ?>
		</div>
	<?php endif; ?>
	<?php if ( $social_share ) { ?>
		<?php Utility\social_share(); ?>
	<?php } ?>
	<?php if ( $navigation ) : ?>
		<?php
		$font_awesome = new FontAwesomeSVG( STRATEGY_BLOCKS_DIST_PATH . 'font-awesome/svgs' );
		/**
		 * Filters the SVG markup used for the pagination previous icon.
		 *
		 * @since TBD
		 *
		 * @param string $icon_id   The default icon ID used to generate the SVG.
		 */
		$prev_icon_id = apply_filters( 'lg_pagination_prev_svg', 'fas fa-chevron-left' );
		/**
		 * Filters the SVG markup used for the pagination next icon.
		 *
		 * @since TBD
		 *
		 * @param string $icon_id   The default icon ID used to generate the SVG.
		 */
		$next_icon_id = apply_filters( 'lg_pagination_next_svg', 'fas fa-chevron-right' );
		$previous_icon = $font_awesome->get_svg( $prev_icon_id, [ 'class' => 'post__navigation-icon' ] );
		$next_icon = $font_awesome->get_svg( $next_icon_id, [ 'class' => 'post__navigation-icon' ] );

		the_post_navigation(
			[
				'next_text' => '<span class="screen-reader-text">' . __( 'Next post:', 'lead-gen' ) . '</span> <span class="post-title">%title</span>' .
							Utility\sanitize_and_output_svg( $next_icon, false ),
				'prev_text' => Utility\sanitize_and_output_svg( $previous_icon, false ) .
							'<span class="screen-reader-text">' . __( 'Previous post:', 'lead-gen' ) . '</span> <span class="post-title">%title</span>',
				'class' => 'post__extra',
				'aria_label' => 'Posts Navigation',
			]
		);
		?>
	<?php endif; ?>
	<?php wp_reset_postdata(); ?>
</article>
<?php do_action( 'lg_block_post_after' ); ?>
