document.addEventListener('DOMContentLoaded', () => {
    const compares = document.querySelectorAll('[data-image-compare]');

    compares.forEach((compare) => {
        const range = compare.querySelector('.image-comparison__range');

        if (!range) {
            return;
        }

        const update = () => {
            let value = Number(range.value);
            value = Math.min(98, Math.max(2, value));

            compare.style.setProperty('--reveal', `${value}%`);
            range.setAttribute('aria-valuenow', value);
        };


        update();
        range.addEventListener('input', update);
    });
});