<?php
/**
 * Image Comparison Block
 *
 * @package StrategyBlocks
 *
 * @param array  $attributes  The block's attributes.
 * @param string $content     The block's inner content (unused here).
 * @param object $block       The block object (contains anchor, etc.).
 */

use StrategyBlocks\Utility;
use StrategyBlocks\FontAwesomeSVG;

global $images_loaded;
global $eager_images;

$id = ! empty( $attributes['anchor'] ) ? $attributes['anchor'] : '';

$class_name = 'lg-block lg-block__image-comparison image-comparison';
$class_name .= Utility\get_block_style_classes( $attributes );
$class_name .= Utility\get_native_wp_classes( $attributes );
$class_name .= Utility\get_visibility_classes( $attributes );
$animations = Utility\get_animation_data( $attributes );

$before_image = $attributes['beforeImage'] ?? null;
$after_image = $attributes['afterImage'] ?? null;

$fa = new FontAwesomeSVG( STRATEGY_BLOCKS_DIST_PATH . 'font-awesome/svgs' );
// $svg_raw = $fa->get_svg( "{$icon['iconSet']} {$icon['library']}" );
$svg_raw  = $fa->get_svg( 'fas fa-grip-vertical', [ 'class' => 'swiper__arrow-icon' ] );

do_action( 'lg_block_image_comparison_before' );
?>

<figure class="<?php echo esc_attr( $class_name ); ?>" <?php echo ! empty( $id ) ? 'id="' . esc_attr( $id ) . '" ' : ''; ?> <?php echo ! empty( $animations ) ? 'data-animation="' . esc_attr( $animations ) . '"' : ''; ?>
	data-image-compare style="--reveal: 50%;">
	<div class="image-comparison__images">
		<?php
		if ( $before_image ) {
			$images_loaded++;
			echo wp_get_attachment_image(
				$before_image,
				'full',
				false,
				[
					'class' => 'image-comparison__image image-comparison__image--before',
					'loading' => $images_loaded <= $eager_images ? 'eager' : 'lazy',
				]
			);
		} else {
			?>
			<img
				class="image-comparison__image image-comparison__image--before"
				src="https://placehold.co/1200x600/ffffff/000000/png"
				alt="Placeholder"
			/>
			<?php
		}
		if ( $after_image ) {
			$images_loaded++;
			echo wp_get_attachment_image(
				$after_image,
				'full',
				false,
				[
					'class' => 'image-comparison__image image-comparison__image--after',
					'loading' => $images_loaded <= $eager_images ? 'eager' : 'lazy',
				]
			);
		} else {
			?>
			<img
				class="image-comparison__image image-comparison__image--after"
				src="https://placehold.co/1200x600/000000/ffffff/png"
				alt="Placeholder"
			/>
		<?php } ?>
	</div>

	<div class="image-comparison__handle btn btn-primary" aria-hidden="true">
		<span>Before</span>
		<span class="image-comparison__handle-icon"><?php Utility\sanitize_and_output_svg( $svg_raw ); ?></span>
		<span>After</span>
	</div>

	<figcaption class="image-comparison__controls">
		<label for="compare-range-<?php echo esc_attr( $id ); ?>" class="sr-only">
			Image comparison slider
		</label>
		<input id="compare-range-<?php echo esc_attr( $id ); ?>" class="image-comparison__range" type="range" min="0"
			max="100" value="50" aria-valuemin="0" aria-valuemax="100" aria-valuenow="50"
			aria-label="Reveal after image" />
	</figcaption>
</figure>

<?php do_action( 'lg_block_image_comparison_after' ); ?>