<?php
/**
 * Heading Block
 *
 * @package StrategyBlocks
 *
 * @param array  $attributes  The block's attributes.
 * @param string $content     The block's inner content (unused here).
 * @param object $block       The block object (contains anchor, etc.).
 */

use StrategyBlocks\Utility;

$id = ! empty( $attributes['anchor'] ) ? $attributes['anchor'] : '';

$class_name = 'lg-block lg-block__heading';
$class_name .= Utility\get_block_style_classes( $attributes );
$class_name .= Utility\get_native_wp_classes( $attributes );
$class_name .= Utility\get_visibility_classes( $attributes );
$animations = Utility\get_animation_data( $attributes );

$html_tag = ! empty( $attributes['htmlTag'] ) ? $attributes['htmlTag'] : 'h2';
$content = $attributes['content'] ?? '';

do_action( 'lg_block_heading_before' );
?>

<<?php echo esc_attr( $html_tag ); ?> class="<?php echo esc_attr( $class_name ); ?>" <?php echo ! empty( $id ) ? 'id="' . esc_attr( $id ) . '" ' : ''; ?> <?php echo ! empty( $animations ) ? 'data-animation="' . esc_attr( $animations ) . '"' : ''; ?>>
	<?php Utility\sanitize_and_output_html_content( $content ); ?>
</<?php echo esc_attr( $html_tag ); ?>>

<?php do_action( 'lg_block_heading_after' ); ?>
