import { __ } from '@wordpress/i18n';
import {
	PanelBody,
	SelectControl,
} from '@wordpress/components';
import {
	InspectorControls,
	RichText,
} from '@wordpress/block-editor';
import AnimationControls from '../components/animations/AnimationControl';
import AnimatedBlockWrapper from '../components/animations/AnimatedBlockWrapper';
import {getBlockStyleClasses, getNativeWPClasses, getVisibilityClasses} from '../components/blockStyleUtils';
import VisibilityControls from "../components/visibility/VisibilityControls";

const Edit = ( { attributes, setAttributes } ) => {
	const {
		htmlTag = 'h2',
		content = '',
		animationEntrance = '',
		animationDuration = '',
		animationDelay = ''
	} = attributes;

	const combinedClasses = [
		'lg-block',
		'lg-block__heading',
		'heading-font',
		'heading-input',
		getBlockStyleClasses(attributes),
		getNativeWPClasses(attributes),
	].filter(Boolean).join(' ');

	return (
		<AnimatedBlockWrapper
			animationEntrance={animationEntrance}
			animationDuration={animationDuration}
			animationDelay={animationDelay}
			attributes={attributes}
			className={`lg-block lg-block__heading ${getVisibilityClasses(attributes)}`}
		>
			<InspectorControls>
				<PanelBody title={ __( 'Heading Settings', 'lead-gen' ) } initialOpen={ true }>
					<SelectControl
						label={ __( 'Title HTML Tag', 'lead-gen' ) }
						value={ htmlTag }
						options={ [
							{ label: 'H1', value: 'h1' },
							{ label: 'H2', value: 'h2' },
							{ label: 'H3', value: 'h3' },
							{ label: 'H4', value: 'h4' },
							{ label: 'H5', value: 'h5' },
							{ label: 'H6', value: 'h6' },
							{ label: 'P', value: 'p' },
							{ label: 'DIV', value: 'div' },
							{ label: 'SPAN', value: 'span' },
						] }
						onChange={ ( val ) => setAttributes( { htmlTag: val } ) }
					/>
				</PanelBody>
				<VisibilityControls attributes={attributes} setAttributes={setAttributes} />
				<AnimationControls attributes={attributes} setAttributes={setAttributes} />
			</InspectorControls>

			<RichText
				tagName={ htmlTag }
				className={combinedClasses}
				value={ content }
				onChange={ ( val ) => setAttributes( { content: val } ) }
				placeholder={ __( 'Add your heading content...', 'lead-gen' ) }
				allowedFormats={ [ 'core/bold', 'core/italic', 'core/link', 'core/underline' ] }
			/>
		</AnimatedBlockWrapper>
	);
};

export default Edit;
