<?php
/**
 * Divider Block
 *
 * @package StrategyBlocks
 */

use StrategyBlocks\Utility;

$id = ! empty( $attributes['anchor'] ) ? $attributes['anchor'] : '';
$class_name = 'lg-block lg-block__divider';
$class_name .= Utility\get_block_style_classes( $attributes );
$class_name .= Utility\get_native_wp_classes( $attributes );
$class_name .= Utility\get_visibility_classes( $attributes );
$animations = Utility\get_animation_data( $attributes );

$divider_classes = '';
$divider_classes .= ! empty( $attributes['dividerText'] ) ? ' text-divider-' . $attributes['dividerStyle'] : ' divider-' . $attributes['dividerStyle'];
$divider_classes .= ' divider-' . $attributes['dividerThickness'];
$divider_classes .= ! empty( $attributes['dividerText'] ) ? ' text-divider-' . $attributes['dividerWidth'] : ' divider-' . $attributes['dividerWidth'];
$divider_classes .= ! empty( $attributes['dividerText'] ) ? ' text-divider-' . $attributes['dividerTextPosition'] : '';
$divider_classes .= ' divider-' . $attributes['dividerAlignment'];

$tag = $attributes['htmlTag'] ?? 'span';

do_action( 'lg_block_divider_before' );
?>

	<div <?php echo $id ? 'id="' . esc_attr( $id ) . '"' : ''; ?>
		class="<?php echo esc_attr( $class_name ); ?>"
		<?php echo $animations ? 'data-animation="' . esc_attr( $animations ) . '"' : ''; ?>
		role="separator"
		aria-orientation="horizontal"
	>
		<span class="divider<?php echo esc_attr( $divider_classes ); ?>">
			<?php if ( $attributes['dividerText'] ) : ?>
				<<?php echo esc_html( $tag ); ?>>
					<?php echo wp_kses_post( $attributes['dividerText'] ); ?>
				</<?php echo esc_html( $tag ); ?>>
			<?php endif; ?>
		</span>
	</div>

<?php do_action( 'lg_block_divider_after' ); ?>
