import {
	PanelBody,
	SelectControl,
	ToggleControl,
	__experimentalToggleGroupControl as ToggleGroupControl,
	__experimentalToggleGroupControlOption as ToggleGroupControlOption,
	ColorPicker
} from '@wordpress/components';
import { __ } from '@wordpress/i18n';

const DIVIDER_TYPES = [
	{ label: 'None', value: 'none' },
	{ label: 'Waves', value: 'waves' },
	{ label: 'Curve', value: 'curve' },
	{ label: 'Curve Asymmetrical', value: 'curve-asymmetrical' },
	{ label: 'Triangle', value: 'triangle' },
	{ label: 'Triangle Asymmetrical', value: 'triangle-asymmetrical' },
	{ label: 'Tilt', value: 'tilt' },
	{ label: 'Arrow', value: 'arrow' },
	{ label: 'Split', value: 'split' },
	{ label: 'Book', value: 'book' },
];

const DIVIDER_HEIGHTS = [
	{ label: 'XS', value: 'xs' },
	{ label: 'SM', value: 'sm' },
	{ label: 'MD', value: 'md' },
	{ label: 'LG', value: 'lg' },
	{ label: 'XL', value: 'xl' },
];

export default function ShapeDividerControls({ attributes, setAttributes }) {
	const {
		shapeDividerTop = {},
		shapeDividerBottom = {}
	} = attributes;

	const updateTop = (update) => {
		setAttributes({ shapeDividerTop: { ...shapeDividerTop, ...update } });
	};

	const updateBottom = (update) => {
		setAttributes({ shapeDividerBottom: { ...shapeDividerBottom, ...update } });
	};

	return (
		<PanelBody title={__('Shape Dividers', 'lead-gen')} initialOpen={false}>
			{/* Top */}
			<p><strong>{__('Top Divider', 'lead-gen')}</strong></p>
			<SelectControl
				label={__('Type', 'lead-gen')}
				value={shapeDividerTop?.type || 'none'}
				options={DIVIDER_TYPES}
				onChange={(val) => updateTop({ type: val })}
			/>

			{shapeDividerTop?.type !== 'none' && (
				<>
					<ToggleGroupControl
						label={__('Height', 'lead-gen')}
						value={shapeDividerTop?.height || 'md'}
						onChange={(val) => updateTop({ height: val })}
					>
						{DIVIDER_HEIGHTS.map((opt) => (
							<ToggleGroupControlOption key={opt.value} value={opt.value} label={opt.label} />
						))}
					</ToggleGroupControl>

					<ToggleControl
						label={__('Flip', 'lead-gen')}
						checked={shapeDividerTop?.flip || false}
						onChange={(val) => updateTop({ flip: val })}
					/>

					<ColorPicker
						color={shapeDividerTop?.color || '#000000'}
						onChangeComplete={(value) => {
							if (value?.hex) {
								updateTop({ color: value.hex });
							}
						}}
					/>
				</>
			)}

			<hr />

			{/* Bottom */}
			<p><strong>{__('Bottom Divider', 'lead-gen')}</strong></p>
			<SelectControl
				label={__('Type', 'lead-gen')}
				value={shapeDividerBottom?.type || 'none'}
				options={DIVIDER_TYPES}
				onChange={(val) => updateBottom({ type: val })}
			/>

			{shapeDividerBottom?.type !== 'none' && (
				<>
					<ToggleGroupControl
						label={__('Height', 'lead-gen')}
						value={shapeDividerBottom?.height || 'md'}
						onChange={(val) => updateBottom({ height: val })}
					>
						{DIVIDER_HEIGHTS.map((opt) => (
							<ToggleGroupControlOption key={opt.value} value={opt.value} label={opt.label} />
						))}
					</ToggleGroupControl>

					<ToggleControl
						label={__('Flip', 'lead-gen')}
						checked={shapeDividerBottom?.flip || false}
						onChange={(val) => updateBottom({ flip: val })}
					/>

					<ColorPicker
						color={shapeDividerBottom?.color || '#000000'}
						onChangeComplete={(value) => {
							if (value?.hex) {
								updateBottom({ color: value.hex });
							}
						}}
					/>
				</>
			)}
		</PanelBody>
	);
}
