import { __ } from '@wordpress/i18n';

const SHAPE_PATHS = {
    waves: '<path d="M321.39,58.44c58-10.79,114.16-30.13,172-41.86,82.39-16.72,168.19-17.73,250.45-.39C823.78,33,906.67,74,985.66,94.83c70.05,18.48,146.53,26.09,214.34,5V0H0V29.35A600.21,600.21,0,0,0,321.39,58.44Z"/>',
    curve: '<path d="M0,0V7.23C0,65.52,268.63,112.77,600,112.77S1200,65.52,1200,7.23V0Z"></path>',
    'curve-asymmetrical': '<path d="M0,0V6c0,21.6,291,111.46,741,110.26,445.39,3.6,459-88.3,459-110.26V0Z"></path>',
    triangle: '<path d="M1200 0L0 0 598.97 114.72 1200 0z"></path>',
    'triangle-asymmetrical': '<path d="M1200 0L0 0 892.25 114.72 1200 0z"></path>',
    tilt: '<path d="M1200 120L0 16.48 0 0 1200 0 1200 120z"></path>',
    arrow: '<path d="M649.97 0L550.03 0 599.91 54.12 649.97 0z"></path>',
    split: '<rect x="1200" height="3.6"></rect><rect height="3.6"></rect><path d="M0,0V3.6H580.08c11,0,19.92,5.09,19.92,13.2,0-8.14,8.88-13.2,19.92-13.2H1200V0Z"></path>',
    book: '<path d="M1200,0H0V120H281.94C572.9,116.24,602.45,3.86,602.45,3.86h0S632,116.24,923,120h277Z"></path>',
};

const ShapeDivider = ({ type = 'waves', color = '#fff', height = 'md', flip = false, position = 'top' }) => {
    if (!type || type === 'none') {
        return null;
    }

    const dividerClassNames = [
        'section__divider',
        `section__divider-size-${height}`,
        `section__divider-${position}`
    ].filter(Boolean).join(' ');

    return (
        <div className={dividerClassNames}>
            <svg
                xmlns="http://www.w3.org/2000/svg"
                viewBox="0 0 1200 120"
                preserveAspectRatio="none"
                className={flip ? "section__divider-svg section__divider-svg-flip" : "section__divider-svg"}
                style={{ fill: color }}
                aria-hidden="true"
                dangerouslySetInnerHTML={{ __html: SHAPE_PATHS[type] }}
            />
        </div>
    );
};

export default ShapeDivider;