import * as solidMeta from '@fortawesome/free-solid-svg-icons';
import { registerIcons } from '@10up/block-components';

const addClassToSVG = (svgString, classNames = '') => {
	const parser = new DOMParser();
	const doc = parser.parseFromString(svgString, 'image/svg+xml');
	const svg = doc.querySelector('svg');

	if (svg) {
		classNames.split(' ').forEach(cls => svg.classList.add(cls));
		return svg.outerHTML;
	}

	return svgString;
};


const buildMetaMap = (icons) => {
	return Object.values( icons ).reduce( ( acc, icon ) => {
		if ( !icon.iconName ) return acc;
		acc[icon.iconName] = icon.icon[2] || [];
		return acc;
	}, {} );
}

const loadIcons = (context, setName, setLabel, metaMap = {}) => {
	const icons = context.keys().map((key) => {
		const name = key.replace('./', '').replace('.svg', '');
		const rawSvg = context(key).default;
		const svgWithClass = addClassToSVG(rawSvg, 'svg-inline--fa btn-icon');

		const label = name.replace(/-/g, ' ');
		const aliases = (metaMap[name] || []).filter(t => typeof t === 'string');
		const searchLabel = [label, ...aliases].join(' ');

		return {
			source: svgWithClass,
			name,
			label: searchLabel,
			iconSet: setName,
		};
	});

	registerIcons({
		name: `fontawesome/${setName}`,
		label: `Font Awesome ${setLabel}`,
		icons,
	});
};

export const registerFontAwesomeIcons = () => {
	if (window.fontAwesomeIconsLoaded) return; // Prevent double registration
	window.fontAwesomeIconsLoaded = true;

	const solidIconsContext = require.context(
		'!!raw-loader!@fortawesome/fontawesome-free/svgs/solid',
		false,
		/\.svg$/
	);
	const regularIconsContext = require.context(
		'!!raw-loader!@fortawesome/fontawesome-free/svgs/regular',
		false,
		/\.svg$/
	);
	const brandsIconsContext = require.context(
		'!!raw-loader!@fortawesome/fontawesome-free/svgs/brands',
		false,
		/\.svg$/
	);

	const solidMetaMap = buildMetaMap(solidMeta);

	loadIcons(solidIconsContext, 'solid', 'Solid', solidMetaMap);
	loadIcons(regularIconsContext, 'regular', 'Regular');
	loadIcons(brandsIconsContext, 'brands', 'Brands');
};
