import { PanelBody, ComboboxControl } from '@wordpress/components';
import { __ } from '@wordpress/i18n';

const animations = [
    { value: 'animate__bounce', label: 'Bounce' },
    { value: 'animate__flash', label: 'Flash' },
    { value: 'animate__pulse', label: 'Pulse' },
    { value: 'animate__rubberBand', label: 'Rubber Band' },
    { value: 'animate__shake', label: 'Shake' },
    { value: 'animate__headshake', label: 'Headshake' },
    { value: 'animate__swing', label: 'Swing' },
    { value: 'animate__tada', label: 'Tada' },
    { value: 'animate__wobble', label: 'Wobble' },
    { value: 'animate__jello', label: 'Jello' },
    { value: 'animate__bounceIn', label: 'Bounce In' },
    { value: 'animate__bounceInDown', label: 'Bounce In Down' },
    { value: 'animate__bounceInLeft', label: 'Bounce In Left' },
    { value: 'animate__bounceInRight', label: 'Bounce In Right' },
    { value: 'animate__bounceInUp', label: 'Bounce In Up' },
    { value: 'animate__bounceOut', label: 'Bounce Out' },
    { value: 'animate__bounceOutDown', label: 'Bounce Out Down' },
    { value: 'animate__bounceOutLeft', label: 'Bounce Out Left' },
    { value: 'animate__bounceOutRight', label: 'Bounce Out Right' },
    { value: 'animate__bounceOutUp', label: 'Bounce Out Up' },
    { value: 'animate__fadeIn', label: 'Fade In' },
    { value: 'animate__fadeInDown', label: 'Fade In Down' },
    { value: 'animate__fadeInDownBig', label: 'Fade In Down Big' },
    { value: 'animate__fadeInLeft', label: 'Fade In Left' },
    { value: 'animate__fadeInLeftBig', label: 'Fade In Left Big' },
    { value: 'animate__fadeInRight', label: 'Fade In Right' },
    { value: 'animate__fadeInRightBig', label: 'Fade In Right Big' },
    { value: 'animate__fadeInUp', label: 'Fade In Up' },
    { value: 'animate__fadeInUpBig', label: 'Fade In Up Big' },
    { value: 'animate__fadeout', label: 'Fadeout' },
    { value: 'animate__fadeOutDown', label: 'Fade Out Down' },
    { value: 'animate__fadeOutDownBig', label: 'Fade Out Down Big' },
    { value: 'animate__fadeOutLeft', label: 'Fade Out Left' },
    { value: 'animate__fadeOutLeftBig', label: 'Fade Out Left Big' },
    { value: 'animate__fadeOutRight', label: 'Fade Out Right' },
    { value: 'animate__fadeOutRightBig', label: 'Fade Out Right Big' },
    { value: 'animate__fadeOutUp', label: 'Fade Out Up' },
    { value: 'animate__fadeOutUpBig', label: 'Fade Out Up Big' },
    { value: 'animate__flipInX', label: 'Flip In X' },
    { value: 'animate__flipInY', label: 'Flip In Y' },
    { value: 'animate__flipOutX', label: 'Flip Out X' },
    { value: 'animate__flipOutY', label: 'Flip Out Y' },
    { value: 'animate__lightSpeedIn', label: 'Light Speed In' },
    { value: 'animate__lightSpeedOut', label: 'Light Speed Out' },
    { value: 'animate__rotateIn', label: 'Rotate In' },
    { value: 'animate__rotateInDownLeft', label: 'Rotate In Down Left' },
    { value: 'animate__rotateInDownRight', label: 'Rotate In Down Right' },
    { value: 'animate__rotateInUpLeft', label: 'Rotate In Up Left' },
    { value: 'animate__rotateInUpRight', label: 'Rotate In Up Right' },
    { value: 'animate__rotateOut', label: 'Rotate Out' },
    { value: 'animate__rotateOutDownLeft', label: 'Rotate Out Down Left' },
    { value: 'animate__rotateOutDownRight', label: 'Rotate Out Down Right' },
    { value: 'animate__rotateOutUpLeft', label: 'Rotate Out Up Left' },
    { value: 'animate__rotateOutUpRight', label: 'Rotate Out Up Right' },
    { value: 'animate__hinge', label: 'Hinge' },
    { value: 'animate__jackInTheBox', label: 'Jack In The Box' },
    { value: 'animate__rollIn', label: 'Roll In' },
    { value: 'animate__rollout', label: 'Rollout' },
    { value: 'animate__zoomIn', label: 'Zoom In' },
    { value: 'animate__zoomInDown', label: 'Zoom In Down' },
    { value: 'animate__zoomInLeft', label: 'Zoom In Left' },
    { value: 'animate__zoomInRight', label: 'Zoom In Right' },
    { value: 'animate__zoomInUp', label: 'Zoom In Up' },
    { value: 'animate__zoomOut', label: 'Zoom Out' },
    { value: 'animate__zoomOutDown', label: 'Zoom Out Down' },
    { value: 'animate__zoomOutLeft', label: 'Zoom Out Left' },
    { value: 'animate__zoomOutRight', label: 'Zoom Out Right' },
    { value: 'animate__zoomOutUp', label: 'Zoom Out Up' },
    { value: 'animate__slideInDown', label: 'Slide In Down' },
    { value: 'animate__slideInLeft', label: 'Slide In Left' },
    { value: 'animate__slideInRight', label: 'Slide In Right' },
    { value: 'animate__slideInUp', label: 'Slide In Up' },
    { value: 'animate__slideOutDown', label: 'Slide Out Down' },
    { value: 'animate__slideOutLeft', label: 'Slide Out Left' },
    { value: 'animate__slideOutRight', label: 'Slide Out Right' },
    { value: 'animate__slideOutUp', label: 'Slide Out Up' },
    { value: 'animate__heartBeat', label: 'Heart Beat' }
];

const durations = [
    { value: 'animate__slower', label: 'Slower' },
    { value: 'animate__slow', label: 'Slow' },
    { value: 'normal', label: 'Normal' },
    { value: 'animate__fast', label: 'Fast' },
    { value: 'animate__faster', label: 'Faster' }
];

const delays = [
    { value: 'animate__delay__025s', label: '0.25s' },
    { value: 'animate__delay__033s', label: '0.33s' },
    { value: 'animate__delay__050s', label: '0.50s' },
    { value: 'animate__delay__066s', label: '0.66s' },
    { value: 'animate__delay__075s', label: '0.75s' },
    { value: 'animate__delay__1s', label: '1s' },
    { value: 'animate__delay__1-25s', label: '1.25s' },
    { value: 'animate__delay__1-5s', label: '1.5s' },
    { value: 'animate__delay__1-75s', label: '1.75s' },
    { value: 'animate__delay-2s', label: '2s' },
    { value: 'animate__delay__2-5s', label: '2.5s' },
    { value: 'animate__delay-3s', label: '3s' },
    { value: 'animate__delay__3-5s', label: '3.5s' },
    { value: 'animate__delay-4s', label: '4s' },
    { value: 'animate__delay__4-5s', label: '4.5s' },
    { value: 'animate__delay-5s', label: '5s' },
    { value: 'animate__delay__5-5s', label: '5.5s' }
];

export default function AnimationControls({ attributes, setAttributes }) {
    const { animationEntrance, animationDuration, animationDelay } = attributes;

    return (
        <PanelBody title={__('Animations', 'lead-gen')} initialOpen={false}>
            <ComboboxControl
                label={__('Entrance Animation', 'lead-gen')}
                value={animationEntrance}
                options={[{ label: __('Select an animation', 'lead-gen'), value: '' }, ...animations]}
                onChange={(value) => setAttributes({ animationEntrance: value })}
            />
            <ComboboxControl
                label={__('Animation Duration', 'lead-gen')}
                value={animationDuration}
                options={[{ label: __('Select a duration', 'lead-gen'), value: '' }, ...durations]}
                onChange={(value) => setAttributes({ animationDuration: value })}
            />
            <ComboboxControl
                label={__('Animation Delay', 'lead-gen')}
                value={animationDelay}
                options={[{ label: __('Select a delay', 'lead-gen'), value: '' }, ...delays]}
                onChange={(value) => setAttributes({ animationDelay: value })}
            />
        </PanelBody>
    );
}