const AlignmentDropdownToggle = ({ alignment, onToggle, isOpen }) => {
	const getAlignmentIcon = (alignment) => {
		switch (alignment) {
			case 'left':
				return alignLeft;
			case 'center':
				return alignCenter;
			case 'right':
				return alignRight;
			case 'justify':
				return alignJustify;
			default:
				return alignLeft;
		}
	};

	return (
		<ToolbarButton
			icon={getAlignmentIcon(alignment)}
			label={__('Change alignment', 'lead-gen')}
			onClick={onToggle}
			aria-expanded={isOpen}
			isPressed={isOpen}
			showTooltip
		/>
	);
};