import { __ } from '@wordpress/i18n';
import { PanelBody, TextControl } from '@wordpress/components';

const PlaceholderDimensionControls = ({ attributes, setAttributes }) => {
	const dimensions = attributes.placeholderDimensions || {};

	const handleChange = (key, value) => {
		setAttributes({
			placeholderDimensions: {
				...dimensions,
				[key]: value,
			},
		});
	};

	return (
		<PanelBody title={__('Placeholder Dimensions', 'lead-gen')} initialOpen={false}>
			<TextControl
				label={__('Placeholder Width (px)', 'lead-gen')}
				type="number"
				value={dimensions?.width || dimensions?.placeholder_width || ''}
				onChange={(val) => handleChange('width', val)}
			/>
			<TextControl
				label={__('Placeholder Height (px)', 'lead-gen')}
				type="number"
				value={dimensions?.height || dimensions?.placeholder_height || ''}
				onChange={(val) => handleChange('height', val)}
			/>
		</PanelBody>
	);
};

export default PlaceholderDimensionControls;
