import { __ } from '@wordpress/i18n';
import { Button, RangeControl, TextControl, ToggleControl } from '@wordpress/components';
import AddressBox from "./AddressBox";
import MiniMap from "./MiniMap";

const MarkerItem = ({ marker, index, updateMarker, removeMarker }) => {

	return (
		<div className="marker-item">
			<TextControl
				label={__('Title', 'lead-gen')}
				value={marker.title}
				onChange={(val) => updateMarker(index, 'title', val)}
			/>
			<TextControl
				label={__('Description', 'lead-gen')}
				value={marker.description}
				onChange={(val) => updateMarker(index, 'description', val)}
			/>
			<AddressBox
				marker={marker}
				index={index}
				updateMarker={updateMarker}
			/>

			{marker.lat && marker.lng ? (
				<MiniMap
					lat={marker.lat}
					lng={marker.lng}
					onChange={({ lat, lng }) => {
						updateMarker(index, 'lat', lat.toString());
						updateMarker(index, 'lng', lng.toString());
					}}
				/>
			) : ''}

			<ToggleControl
				label={__('Enable Area', 'lead-gen')}
				help={__('Draw a circular area around the marker.', 'lead-gen')}
				checked={marker.area}
				onChange={(val) => updateMarker(index, 'area', val)}
			/>

			{marker.area ? (
				<>
					<RangeControl
						label={__('Radius', 'lead-gen')}
						help={__('Area radius (center to edge) in miles.', 'lead-gen')}
						value={marker.radius}
						onChange={(val) => updateMarker(index, 'radius', val)}
						min={0}
						max={50}
					/>

					<ToggleControl
						label={__('Show Marker', 'lead-gen')}
						help={__('Display the marker pin at the center of the area.', 'lead-gen')}
						checked={marker.show}
						onChange={(val) => updateMarker(index, 'show', val)}
					/>
				</>
			) : ''}

			<Button
				isDestructive
				variant="secondary"
				onClick={() => removeMarker(index)}
			>
				{__('Remove Marker', 'lead-gen')}
			</Button>
		</div>
	);
};

export default MarkerItem;
