import { PanelBody } from '@wordpress/components';
import { useState } from '@wordpress/element';
import CodeMirror from './CodeMirror';

export default function CustomCssPanel({ attributes, setAttributes }) {
    const [open, setOpen] = useState(false);

    return (
        <PanelBody
            title="Custom CSS"
            initialOpen={false}
            onToggle={setOpen}
        >
            <p style={{ marginTop: 0, opacity: 0.8 }}>
                Use <code>selector</code> to target this block.
            </p>

            <div style={{ display: open ? 'block' : 'none' }}>
                <CodeMirror
                    value={attributes.customCss}
                    onChange={(val) => setAttributes({ customCss: val })}
                />
            </div>
        </PanelBody>
    );
}
