import { useEffect, useRef } from '@wordpress/element';

export default function CssCodeMirror({ value, onChange }) {
    const textareaRef = useRef(null);
    const editorRef = useRef(null);

    useEffect(() => {
        if (!window.CodeMirror || editorRef.current) return;

        editorRef.current = window.CodeMirror.fromTextArea(
            textareaRef.current,
            {
                mode: 'css',
                lineNumbers: true,
                lineWrapping: true,
                tabSize: 4,
                
            }
        );

        editorRef.current.on('change', (cm) => {
            onChange(cm.getValue());
        });
    }, []);

    useEffect(() => {
        if (!editorRef.current) return;
        if (editorRef.current.getValue() !== value) {
            editorRef.current.setValue(value || '');
        }
    }, [value]);

    return <textarea ref={textareaRef} defaultValue={value} />;
}
