<?php
/**
 * Button Block
 *
 * @package StrategyBlocks
 *
 * @param   array  $attributes  The block's attributes.
 * @param   string $content     The block's inner content (unused here).
 * @param   object $block       The block object (contains anchor, etc.).
 */

use StrategyBlocks\Utility;
use StrategyBlocks\FontAwesomeSVG;

$id = ! empty( $attributes['anchor'] ) ? $attributes['anchor'] : '';

// Create classes from attributes set on block.
$class_name = 'lg-block lg-block__button';
$class_name .= Utility\get_block_style_classes( $attributes );
$class_name .= Utility\get_native_wp_classes( $attributes );
$class_name .= Utility\get_visibility_classes( $attributes );
$animations = Utility\get_animation_data( $attributes );

// Get all settings from ACF and store them in a central array.
$settings = array(
	'link'      => $attributes['link'] ?? array(
		'text'          => '',
		'url'           => '',
		'opensInNewTab' => false,
	),
	'alignment' => $attributes['alignment'],
	'type'      => $attributes['type'],
	'size'      => $attributes['size'],
	'icon' => isset( $attributes['icon'] ) && is_array( $attributes['icon'] ) ? $attributes['icon'] : [
		'type' => 'none',
		'mediaId' => 0,
		'url' => '',
		'library' => '',
		'iconSet' => '',
		'position' => 'before',
	],
);

// Set dynamic button classes
$button_class = 'btn';
$button_class .= ' btn-' . $settings['type'];
$button_class .= ' btn-' . $settings['alignment'];
$button_class .= ' btn-' . $settings['size'];

if ( isset( $settings['icon']['position'] ) && 'after' === $settings['icon']['position'] ) {
	$button_class .= ' btn-icon-' . $settings['icon']['position'];
}

$icon_markup = '';
$icon = $settings['icon'];

if ( isset( $icon['type'], $icon['url'] ) && 'upload' === $icon['type'] && ! empty( $icon['url'] ) ) {
	$icon_markup = Utility\get_svg_by_url_and_format_svg(
		$icon['url'],
		'btn-icon',
		'1em',
		'1em',
		'decorative',
		'',
		$icon['mediaId']
	);
} elseif ( 'library' === $icon['type'] && ! empty( $icon['library'] ) && ! empty( $icon['iconSet'] ) ) {
	$fa = new FontAwesomeSVG( STRATEGY_BLOCKS_DIST_PATH . 'font-awesome/svgs' );
	$svg_raw = $fa->get_svg( "{$icon['iconSet']} {$icon['library']}" );

	$icon_markup = preg_replace_callback(
		'/<svg\b([^>]*)>/i',
		function ( $matches ) use ( $icon ) {
			$existing_attrs = $matches[1];
			$clean_attrs = preg_replace(
				'/\s*(class|role|focusable|aria-[a-z\-]+)=["\'][^"\']*["\']/i',
				'',
				$existing_attrs
			);
			$svg_attrs = ' class="btn-icon" aria-hidden="true" focusable="false"';
			return '<svg' . $clean_attrs . $svg_attrs . '>';
		},
		$svg_raw,
		1
	);
}

do_action( 'lg_block_button_before' );

if ( ! empty( trim( $settings['link']['text'] ) ) || ! empty( $icon_markup ) ) :
	?>
<div <?php echo ! empty( $id ) ? 'id="' . esc_attr( $id ) . '" ' : null; ?> class="<?php echo esc_attr( $class_name ); ?>" <?php echo ! empty( $animations ) ? 'data-animation="' . esc_attr( $animations ) . '" ' : null; ?>>
	<a class="<?php echo esc_attr( $button_class ); ?>"
		<?php if ( isset( $settings['link'] ) && isset( $settings['link']['url'] ) && trim( $settings['link']['url'] ) != '' ) { ?>
			href="<?php echo esc_url( $settings['link']['url'] ); ?>"
			<?php if ( Utility\is_link_external( $settings['link']['url'] ) || $settings['link']['opensInNewTab'] ) { ?>
				target="_blank"
				rel="noopener noreferrer"
			<?php } ?>
		<?php } ?>
	>
		<?php
		if ( ! empty( $icon_markup ) ) {
			Utility\sanitize_and_output_svg( $icon_markup );
		}
		if ( ! empty( trim( $settings['link']['text'] ) ) ) {
			echo '<span class="btn-text">' . wp_kses( $settings['link']['text'], wp_kses_allowed_html( 'post' ) ) . '</span>';
		}
		?>
	</a>
</div>
	<?php
endif;

do_action( 'lg_block_button_after' ); ?>
