function searchAndReplaceClasses(element, filter, searchValue, replaceValue) {
	const classReplacements = [];
	for (let i = 0; i < element.classList.length; i++) {
		if (element.classList[i].includes(filter)) {
			const newClass = element.classList[i].replace(searchValue, replaceValue);
			classReplacements.push({
				remove: element.classList[i],
				add: newClass,
			});
		}
	}
	for (let i = 0; i < classReplacements.length; i++) {
		element.classList.remove(classReplacements[i].remove);
		element.classList.add(classReplacements[i].add);
	}
}

function setCardToPassive(element) {
	for (let i = 0; i < element.classList.length; i++) {
		if (
			element.classList[i].includes('row-max--closed') &&
			!element.classList[i].includes('-passive')
		) {
			const newClass = `${element.classList[i]}-passive`;
			element.classList.remove(element.classList[i]);
			element.classList.add(newClass);
			break;
		}
	}
}

function removePassive(element) {
	for (let i = 0; i < element.classList.length; i++) {
		if (element.classList[i].includes('-passive')) {
			const newClass = element.classList[i].substring(
				0,
				element.classList[i].indexOf('-passive'),
			);
			element.classList.remove(element.classList[i]);
			element.classList.add(newClass);
			break;
		}
	}
}

function openBioCard(element) {
	for (let i = 0; i < element.children.length; i++) {
		if (element.children[i].classList.contains('lg-bio--closed')) {
			element.children[i].style.opacity = 0;
			element.children[i].style.pointerEvents = 'none';
		} else if (element.children[i].classList.contains('lg-bio--open')) {
			element.children[i].style.opacity = 1;
			element.children[i].style.pointerEvents = 'all';
		}
	}
	searchAndReplaceClasses(element, '--closed', 'closed', 'open');
}

function closeBioCard(element) {
	for (let i = 0; i < element.children.length; i++) {
		if (element.children[i].classList.contains('lg-bio--closed')) {
			element.children[i].style.opacity = 1;
			element.children[i].style.pointerEvents = 'all';
		} else if (element.children[i].classList.contains('lg-bio--open')) {
			element.children[i].style.opacity = 0;
			element.children[i].style.pointerEvents = 'none';
		}
	}
	searchAndReplaceClasses(element, '--open', 'open', 'closed');
}

function initBio() {
	document.querySelectorAll('.lg-block__bio--gallery .lg-bio__btn--open').forEach(btn => {
		btn.addEventListener('click', function () {
			const card = this.closest('.lg-block__bio');

			removePassive(card);
			openBioCard(card);

			document.querySelectorAll('.lg-block__bio').forEach(otherCard => {
				if (otherCard !== card) {
					closeBioCard(otherCard);
					setCardToPassive(otherCard);
				}
			});
		});
	});

	document.querySelectorAll('.lg-block__bio--gallery .lg-bio__text--link').forEach(link => {
		link.addEventListener('click', function (event) {
			event.stopPropagation();
		});
	});

	document.querySelectorAll('.lg-block__bio--gallery .lg-bio--open').forEach(openArea => {
		openArea.addEventListener('click', function () {
			document.querySelectorAll('.lg-block__bio').forEach(card => {
				removePassive(card);
				closeBioCard(card);
			});
		});
	});
}

document.addEventListener('DOMContentLoaded', initBio);
