<?php
/**
 * Accordion Block
 *
 * @package StrategyBlocks
 *
 * @param array  $attributes  The block's attributes.
 * @param string $content     The block's inner content (unused here).
 * @param object $block       The block object (contains anchor, etc.).
 */

use StrategyBlocks\Utility;
use StrategyBlocks\FontAwesomeSVG;

// Create classes from attributes set on block.
$class_name = 'lg-block lg-block__accordion accordion';
$class_name .= Utility\get_block_style_classes( $attributes );
$class_name .= Utility\get_native_wp_classes( $attributes );
$class_name .= Utility\get_visibility_classes( $attributes );
$class_name .= ! empty( $attributes['enableToggle'] ) ? ' accordion--toggleable' : '';
$animations = Utility\get_animation_data( $attributes );

$id                = ! empty( $attributes['anchor'] ) ? $attributes['anchor'] : 'accordion_' . uniqid();
$icon              = 'plus_minus' === $attributes['icon'] ? 'fa-solid fa-minus' : 'fa-solid fa-chevron-down';
$accordion_items   = $attributes['accordionItems'] ?? [];
$title_tag         = $attributes['titleHtmlTag'] ?? 'h2';

$font_awesome = new FontAwesomeSVG( STRATEGY_BLOCKS_DIST_PATH . 'font-awesome/svgs' );

do_action( 'lg_block_accordion_before' );

?>

<div <?php echo $id ? 'id="' . esc_attr( $id ) . '"' : ''; ?> class="<?php echo esc_attr( $class_name ); ?>" <?php echo ! empty( $animations ) ? 'data-animation="' . esc_attr( $animations ) . '" ' : null; ?>>
	<?php
	foreach ( $accordion_items as $index => $accordion_item ) {
		$accordion_id = $id . '_content_' . $index;
		$accordion_content_id = $id . '_' . $index;
		?>
		<<?php echo esc_attr( $title_tag ); ?> class="accordion__item">
			<button type="button"
				aria-expanded="false"
				class="accordion__trigger"
				aria-controls="<?php echo esc_attr( $accordion_id ); ?>"
				id="<?php echo esc_attr( $accordion_content_id ); ?>">
				<span class="accordion__title">
					<?php echo esc_html( $accordion_item['title'] ); ?>
				</span>
				<span class="accordion__icon">
				<?php
				if ( 0 < substr_count( $icon, 'minus' ) ) {
					// TODO: Need plus/minus icon with animation
					$svg = $font_awesome->get_svg( $icon, [ 'class' => $icon . ' accordion__icon--minus' ] );
					Utility\sanitize_and_output_svg( $svg );
					$svg2 = $font_awesome->get_svg( 'fa-solid fa-plus', [ 'class' => 'fa-solid fa-plus accordion__icon--plus' ] );
					Utility\sanitize_and_output_svg( $svg2 );
				} else {
					$svg = $font_awesome->get_svg( $icon, [ 'class' => $icon . ' accordion__icon--arrow' ] );
					Utility\sanitize_and_output_svg( $svg );
				}
				?>
				</span>
			</button>
		</<?php echo esc_attr( $title_tag ); ?>>
		<div class="accordion__content" id="<?php echo esc_attr( $accordion_id ); ?>" role="region" aria-labelledby="<?php echo esc_attr( $accordion_content_id ); ?>" hidden="">
			<?php Utility\sanitize_and_output_html_content( wpautop( $accordion_item['content'] ) ); ?>
		</div>
	<?php } ?>
</div>

<?php do_action( 'lg_block_accordion_after' ); ?>
