<?php
/**
 * Text Editor Block
 *
 * @package StrategyBlocks
 *
 * @param array  $attributes  The block's attributes.
 * @param string $content     The block's inner content (unused here).
 * @param object $block       The block object (contains anchor, etc.).
 */

use StrategyBlocks\Utility;

$id = ! empty( $attributes['anchor'] ) ? $attributes['anchor'] : '';

// Create classes from attributes set on block.
$class_name = 'lg-block lg-block__content';
$class_name .= Utility\get_block_style_classes( $attributes );
$class_name .= Utility\get_native_wp_classes( $attributes );
$class_name .= Utility\get_visibility_classes( $attributes );
$animations = Utility\get_animation_data( $attributes );

$content = $attributes['content'];

do_action( 'lg_block_text_editor_before' );?>

<?php if ( ! empty( $content ) ) : ?>
	<div <?php echo $id ? 'id="' . esc_attr( $id ) . '"' : ''; ?> class="<?php echo esc_attr( $class_name ); ?>" <?php echo ! empty( $animations ) ? 'data-animation="' . esc_attr( $animations ) . '" ' : null; ?>>
		<?php
		Utility\sanitize_and_output_html_content( wpautop( $content ) );
		?>
	</div>
<?php endif; ?>

<?php do_action( 'lg_block_text_editor_after' ); ?>
