<?php
/**
 * Row Block
 *
 * @package StrategyBlocks
 *
 * @param array  $attributes  The block's attributes.
 * @param string $content     The block's inner content.
 * @param object $block       The block object.
 */

use StrategyBlocks\Utility;

$id = ! empty( $attributes['anchor'] ) ? $attributes['anchor'] : '';
// phpcs:ignore WordPress.NamingConventions.ValidVariableName.UsedPropertyNotSnakeCase
$block_id = isset( $block->clientId ) ? substr( $block->clientId, 0, 8 ) : substr( uniqid(), 0, 8 );
$class_name = "lg-block lg-block__row row lg-block-$block_id";
$class_name .= Utility\get_block_style_classes( $attributes );
$class_name .= Utility\get_native_wp_classes( $attributes );
$class_name .= Utility\get_alignment_and_sizing_classes( $attributes );
$class_name .= Utility\get_visibility_classes( $attributes );
$animations = Utility\get_animation_data( $attributes );

do_action( 'lg_block_row_before' ); ?>
<div class="<?php echo esc_attr( $class_name ); ?>" <?php echo ! empty( $id ) ? 'id="' . esc_attr( $id ) . '" ' : null; ?> <?php echo ! empty( $animations ) ? 'data-animation="' . esc_attr( $animations ) . '"' : ''; ?>>
	<?php echo $content; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
</div>
<?php do_action( 'lg_block_row_after' ); ?>