<?php
/**
 * Pricing List Markup
 *
 * @package StrategyBlocks
 */

use StrategyBlocks\Utility;
use StrategyBlocks\FontAwesomeSVG;

$id = $attributes['anchor'] ?? '';
$columns = $attributes['columns'] ?? [];
$features = $attributes['features'] ?? [];
$pricing = $attributes['pricing'] ?? [];

$class_name = implode(
	' ',
	array_filter(
		[
			'lg-block',
			'lg-block__pricing-list',
			Utility\get_block_style_classes( $attributes ),
			Utility\get_native_wp_classes( $attributes ),
			Utility\get_visibility_classes( $attributes ),
		]
	)
);

$fa = new FontAwesomeSVG( STRATEGY_BLOCKS_DIST_PATH . 'font-awesome/svgs' );
// $svg_btn = $fa->get_svg( 'solid circle-check' );
// $btn_icon_markup = Utility\get_icon_markup( $svg_btn );
$currency_format = $pricing['currencyFormat'] ?? 'us';
$currency = 'custom' === $pricing['currency'] ? $pricing['customCurrency'] : $pricing['currency'];
$period = $pricing['monthly'] ? $pricing['monthPeriod'] : '';
$feature_label_placement = $attributes['featureLabelPlacement'] ?? 'sidebar';
$animations    = Utility\get_animation_data( $attributes );

if ( ! $period ) {
	$period = $pricing['yearly'] ? $pricing['yearPeriod'] : '';
}

do_action( 'lg_block_pricing_list_before' );
?>
<div
	<?php
	if ( $id ) {
		echo 'id="' . esc_attr( $id ) . '"';
	}
	?>
	class="<?php echo esc_attr( $class_name ); ?>"
	<?php
	if ( $animations ) {
		echo 'data-animation="' . esc_attr( $animations ) . '"';
	}
	?>
>
	<div class="pricing-list">
		<?php if ( $pricing['monthly'] && $pricing['yearly'] ) : ?>
			<div class="pricing-toggle">
				<fieldset class="pricing-toggle__container">
					<legend class="screen-reader-text">
						Billing period
					</legend>
					<label>
						<input type="radio" id="yearly" name="period" value="yearly" checked />
						<span>Yearly</span>
					</label>

					<label>
						<input type="radio" id="monthly" name="period" value="monthly" />
						<span>Monthly</span>
					</label>
					<div class="pricing-toggle__background" aria-hidden="true"></div>
				</fieldset>
			</div>
		<?php endif; ?>
		<div class="pricing-list__wrapper">
			<?php if ( 'sidebar' === $feature_label_placement ) : ?>
				<div class="pricing-list__sidebar">
					<div class="pricing-list__cell"></div>
					<?php foreach ( $features as $feature ) : ?>
						<div class="pricing-list__cell"><?php echo esc_html( $feature['title'] ); ?></div>
					<?php endforeach; ?>
				</div>
			<?php endif; ?>

			<div class="pricing-list__body<?php echo 'inline' === $feature_label_placement ? ' pricing-list__body--full' : null; ?>">
				<div class="pricing-list__slider swiper" data-swiper-perview="<?php count( $columns ); ?>">
					<div class="swiper-wrapper">
						<?php foreach ( $columns as $col_index => $column ) : ?>
							<?php
							$price = Utility\format_prices( $column['price'], $currency_format );
							$price_year = isset( $column['priceYear'] ) ? Utility\format_prices( $column['priceYear'], $currency_format ) : 0;
							$col_classes = ! empty( $columns[ $col_index ]['best'] ) ? 'pricing-list__item--best' : '';
							?>
							<div class="swiper-slide pricing-list__item <?php echo esc_attr( $col_classes ); ?>">
								<div class="pricing-list__cell">
									<h3 class="pricing-list__title"><?php echo esc_html( $column['title'] ); ?></h3>
									<?php if ( $pricing['monthly'] && $pricing['yearly'] ) : ?>
										<div class="pricing-list__price">
											<?php if ( $currency ) : ?>
												<span class="pricing-list__price-currency"><?php echo esc_html( $currency ); ?></span>
											<?php endif; ?>
											<span class="pricing-list__price-value">
												<?php if ( $pricing['monthly'] ) : ?>
													<span class="pricing-list__price-monthly"><?php echo wp_kses_post( $price ); ?></span>
												<?php endif; ?>
												<?php if ( $pricing['yearly'] ) : ?>
													<span class="pricing-list__price-yearly <?php echo ! $pricing['monthly'] ? 'pricing-list__price-yearly--visible' : ''; ?>"><?php echo wp_kses_post( $price_year ); ?></span>
												<?php endif; ?>
											</span>

											<?php if ( $period ) : ?>
												<span class="pricing-list__price-period">
													<span class="pricing-list__price-period-monthly"><?php echo esc_html( $pricing['monthly'] ? $pricing['monthPeriod'] : '' ); ?></span>
													<span class="pricing-list__price-period-yearly <?php echo ! $pricing['monthly'] ? 'pricing-list__price-period-yearly--visible' : ''; ?>">
														<?php echo esc_html( $pricing['yearly'] ? $pricing['yearPeriod'] : '' ); ?>
													</span>
												</span>
											<?php endif; ?>
										</div>
									<?php endif; ?>
								</div>

								<?php foreach ( $features as $feature ) : ?>
									<div class="pricing-list__cell pricing-list__result">
										<?php
										$item = $feature['items'][ $col_index ] ?? [];
										$icon_markup = '';
										if ( ! empty( $item['icon'] ) && $fa ) {
											$icon_name = ! empty( $item['included'] ) ? 'check' : 'xmark';
											$svg_raw = $fa->get_svg( 'thin ' . $icon_name );
											$icon_markup = Utility\get_icon_markup( $svg_raw );
											Utility\sanitize_and_output_svg( $icon_markup );
										}
										?>
										<?php if ( 'inline' === $feature_label_placement ) : ?>
											<span class="pricing-list__feature-label">
												<?php echo esc_html( $feature['title'] ); ?>
											</span>
										<?php endif; ?>
										<?php echo esc_html( $item['value'] ?? '' ); ?>
									</div>
								<?php endforeach; ?>

								<div class="pricing-list__cell pricing-list__cell--button">
									<?php
									$is_external = Utility\is_link_external( $column['buttonLink'] );
									$target      = $is_external ? ' target="_blank" rel="noopener noreferrer"' : '';
									?>
									<a
										href="<?php echo esc_url( $column['buttonLink'] ); ?>"
										class="btn btn-primary"
										<?php echo wp_kses_post( $target ); ?>
									>
										<?php // Utility\sanitize_and_output_svg( $btn_icon_markup ); ?>
										<?php echo esc_html( $column['buttonText'] ); ?>
									</a>
								</div>
							</div>
						<?php endforeach; ?>
					</div>

					<?php Utility\render_slider_controls( $fa ); ?>
				</div>
			</div>
		</div>
	</div>
</div>
<?php do_action( 'lg_block_pricing_list_after' ); ?>
