<?php
/**
 * Pricing Block Markup
 *
 * @package StrategyBlocks
 */

use StrategyBlocks\Utility;
use StrategyBlocks\FontAwesomeSVG;

$id       = $attributes['anchor'] ?? '';
$header   = $attributes['header'] ?? [];
$pricing  = $attributes['pricing'] ?? [];
$feature_icon_enabled = $attributes['featureIcons'] ?? false;
$features = $attributes['features'] ?? [];
$footer   = $attributes['footer'] ?? [];
$ribbon   = $attributes['ribbon'] ?? [];
$animations = Utility\get_animation_data( $attributes );

$class_name = implode(
	' ',
	array_filter(
		[
			'lg-block',
			'lg-block__pricing',
			Utility\get_block_style_classes( $attributes ),
			Utility\get_native_wp_classes( $attributes ),
			Utility\get_visibility_classes( $attributes ),
		]
	)
);

if ( $feature_icon_enabled ) {
	$fa = new FontAwesomeSVG( STRATEGY_BLOCKS_DIST_PATH . 'font-awesome/svgs' );
}

$title_tag = $header['tag'] ?? 'h3';
$currency = 'custom' === $pricing['currency'] ? $pricing['customCurrency'] : $pricing['currency'];
$price = $pricing['price'] ?? '0';
$original_price = $pricing['originalPrice'] ?? '';
$currency_format = $pricing['currencyFormat'] ?? 'us';

$price = Utility\format_prices( $price, $currency_format );
$original_price = Utility\format_prices( $original_price, $currency_format );

do_action( 'lg_block_pricing_card_before' );
?>

<div
	<?php echo $id ? 'id="' . esc_attr( $id ) . '"' : ''; ?>
	class="<?php echo esc_attr( $class_name ); ?>"
	<?php echo ! empty( $animations ) ? 'data-animation="' . esc_attr( $animations ) . '"' : ''; ?>
>
	<?php if ( ! empty( $header['imageId'] ) ) : ?>
		<div class="pricing-block__image">
			<?php echo wp_get_attachment_image( $header['imageId'], 'large', false, [ 'loading' => 'lazy' ] ); ?>
		</div>
	<?php endif; ?>
	<?php if ( ! empty( $ribbon['show'] ) ) : ?>
		<div class="pricing-block__ribbon pricing-block__ribbon--<?php echo esc_attr( $ribbon['position'] ?? 'left' ); ?>">
			<div class="pricing-block__ribbon-item">
				<?php echo esc_html( $ribbon['title'] ?? '' ); ?>
			</div>
		</div>
	<?php endif; ?>
	<div class="pricing-block__body">
		<div class="pricing-block__price">
			<?php if ( ! empty( $pricing['sale'] ) && ! empty( $pricing['originalPrice'] ) ) : ?>
				<span class="pricing-block__sale">
					<del>
						<?php if ( $currency ) : ?>
							<?php echo esc_html( $currency ); ?>
						<?php endif; ?>
						<?php echo wp_kses_post( $original_price ); ?>
					</del>
				</span>
			<?php endif; ?>
			<?php if ( $currency ) : ?>
				<span class="pricing-block__currency"><?php echo esc_html( $currency ); ?></span>
			<?php endif; ?>
			<span class="pricing-block__value"><?php echo wp_kses_post( $price ); ?></span>

			<?php if ( $pricing['period'] ) : ?>
				<span class="pricing-block__period"><?php echo esc_html( $pricing['period'] ); ?></span>
			<?php endif; ?>
		</div>

		<div class="pricing-block__header">
			<?php if ( ! empty( $header['title'] ) ) : ?>
				<<?php echo esc_html( $title_tag ); ?> class="pricing-block__title">
				<?php echo esc_html( $header['title'] ); ?>
				</<?php echo esc_html( $title_tag ); ?>>
			<?php endif; ?>
			<?php if ( ! empty( $header['description'] ) ) : ?>
				<p class="pricing-block__description"><?php echo esc_html( $header['description'] ); ?></p>
			<?php endif; ?>
		</div>

		<?php if ( ! empty( $features ) ) : ?>
			<ul class="pricing-block__features">
				<?php foreach ( $features as $feature ) : ?>
					<li class="pricing-block__feature <?php echo esc_attr( $feature['included'] ? 'pricing-block__feature--included' : '' ); ?>">
						<?php
						if ( $feature_icon_enabled && $fa ) :
							$icon_name = $feature['included'] ? 'check' : 'xmark';
							$svg_raw = $fa->get_svg( 'solid ' . $icon_name );

							$icon_markup = preg_replace_callback(
								'/<svg\b([^>]*)>/i',
								function ( $matches ) {
									$existing_attrs = $matches[1];
									$clean_attrs = preg_replace(
										'/\s*(class|role|focusable|aria-[a-z\-]+)=["\'][^"\']*["\']/i',
										'',
										$existing_attrs
									);
									$svg_attrs = ' class="icon-list__icon" aria-hidden="true" focusable="false"';
									return '<svg' . $clean_attrs . $svg_attrs . '>';
								},
								$svg_raw,
								1
							);
							Utility\sanitize_and_output_svg( $icon_markup );
						endif;
						?>
						<span class="pricing-block__feature-text">
							<?php echo esc_html( $feature['text'] ?? '' ); ?>
						</span>
					</li>
				<?php endforeach; ?>
			</ul>
		<?php endif; ?>

		<?php if ( ! empty( $footer['additionalInfo'] ) ) : ?>
			<p class="pricing-block__info"><?php echo esc_html( $footer['additionalInfo'] ); ?></p>
		<?php endif; ?>
	</div>

	<?php if ( ! empty( $footer['buttonText'] ) && ! empty( $footer['buttonLink'] ) ) : ?>
		<?php
			$is_external = $footer['opensInNewTab'] || Utility\is_link_external( $footer['buttonLink'] );
			$target      = $is_external ? ' target="_blank" rel="noopener noreferrer"' : '';
		?>
		<a
			href="<?php echo esc_url( $footer['buttonLink'] ); ?>"
			class="btn btn-primary pricing-block__button"
			<?php echo wp_kses_post( $target ); ?>
		>
			<?php echo esc_html( $footer['buttonText'] ); ?>
		</a>
	<?php endif; ?>
</div>

<?php do_action( 'lg_block_pricing_card_after' ); ?>
