<?php
/**
 * Media Block
 *
 * @package StrategyBlocks
 *
 * @var array    $attributes         Block attributes.
 * @var string   $content            Block content.
 * @var WP_Block $block              Block instance.
 * @var array    $context            Block context.
 */

use StrategyBlocks\Utility;

global $images_loaded;
global $eager_images;

$id = $attributes['anchor'] ?? '';
$class_name = 'lg-block lg-block__media ';

$class_name .= Utility\get_block_style_classes( $attributes );
$class_name .= Utility\get_native_wp_classes( $attributes );
$class_name .= Utility\get_visibility_classes( $attributes );
$animations = Utility\get_animation_data( $attributes );

$link = $attributes['link'] ?? [];
$media_id = $attributes['mediaId'] ?? null;
$show_caption = $attributes['showCaption'] ?? false;
$default_caption = $media_id ? wp_get_attachment_caption( $media_id ) : '';
$caption_text = ! empty( $attributes['caption'] ) ? $attributes['caption'] : $default_caption;
$image_size = $attributes['imageSize'] ?? 'full';
$html_tag = $show_caption && ! empty( $caption_text ) ? 'figure' : 'div';

$placeholder_dimensions = $attributes['placeholderDimensions'] ?? [];
$width = isset( $placeholder_dimensions['width'] ) && ! empty( $placeholder_dimensions['width'] ) ? $placeholder_dimensions['width'] : '600';
$height = isset( $placeholder_dimensions['height'] ) && ! empty( $placeholder_dimensions['height'] ) ? $placeholder_dimensions['height'] : '400';

$placeholder_url = $width && $height ? "https://placehold.co/{$width}x{$height}" : 'https://placehold.co/600x400';

$rendered_media_url = null;
$actual_media_mime = null;

if ( ! empty( $media_id ) ) {
	$actual_media_mime = get_post_mime_type( $media_id );

	// For images, get the specific size if available
	if ( str_starts_with( $actual_media_mime, 'image/' ) ) {
		$image_src = wp_get_attachment_image_src( $media_id, $image_size );
		if ( $image_src ) {
			$rendered_media_url = $image_src[0];
		}
	} else {
		// For audio/video, get the full URL
		$rendered_media_url = wp_get_attachment_url( $media_id );
	}
}

$link_exists = isset( $link['url'] ) && ! empty( $link['url'] );
if ( $link_exists ) :
	$link_url = $link['url'];
	$link_target = ! empty( $link['target'] ) ? $link['target'] : '_self';
	$title = ! empty( $link['title'] ) ? $link['title'] : get_the_title( $media_id );
	$link_title = '_blank' === $link_target ? $title . ' (opens in a new window)' : $title;
endif;

do_action( 'lg_block_media_before' ); ?>

<<?php echo esc_html( $html_tag ); ?> <?php echo ! empty( $id ) ? ' id="' . esc_attr( $id ) . '"' : ''; ?> <?php echo ! empty( $animations ) ? ' data-animation="' . esc_attr( $animations ) . '"' : ''; ?> class="<?php echo esc_attr( $class_name ); ?>">
<?php if ( ! empty( $rendered_media_url ) ) : ?>
	<?php if ( str_starts_with( $actual_media_mime, 'image/' ) ) : ?>
		<?php if ( $link_exists ) : ?><a href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>" class="media__link" title="<?php echo esc_attr( $link_title ); ?>"><?php endif; ?>
		<?php
		if ( 'image/svg+xml' === $actual_media_mime ) {
			$svg = Utility\get_svg_by_url_and_format_svg( $rendered_media_url, 'media__image' );
			Utility\sanitize_and_output_svg( $svg );
		} else {
			$images_loaded++;
			echo wp_get_attachment_image(
				$media_id,
				$image_size,
				false,
				[
					'class' => 'media__image',
					'loading' => $images_loaded <= $eager_images ? 'eager' : 'lazy',
				]
			);
		}
		?>
		<?php if ( $link_exists ) : ?></a><?php endif; ?>
	<?php elseif ( str_starts_with( $actual_media_mime, 'video/' ) ) : ?>
		<video controls class="media__video" width="<?php echo esc_attr( $width ); ?>" height="<?php echo esc_attr( $height ); ?>">
			<source src="<?php echo esc_url( $rendered_media_url ); ?>" type="<?php echo esc_attr( $actual_media_mime ); ?>">
		</video>
	<?php elseif ( str_starts_with( $actual_media_mime, 'audio/' ) ) : ?>
		<audio controls class="media__audio">
			<source src="<?php echo esc_url( $rendered_media_url ); ?>" type="<?php echo esc_attr( $actual_media_mime ); ?>">
		</audio>
	<?php endif; ?>
<?php else : ?>
	<?php if ( $link_exists ) : ?><a href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>" class="media__link" title="<?php echo esc_attr( $link_title ); ?>"><?php endif; ?>
	<img src="<?php echo esc_url( $placeholder_url ); ?>" class="media__image" alt="Placeholder" loading="<?php echo $images_loaded <= $eager_images ? 'eager' : 'lazy'; ?>" />
	<?php if ( $link_exists ) : ?></a><?php endif; ?>
<?php endif; ?>

	<?php if ( $show_caption && ! empty( $caption_text ) ) : ?>
		<figcaption class="media__caption"><?php echo wp_kses_post( $caption_text ); ?></figcaption>
	<?php endif; ?>
</<?php echo esc_html( $html_tag ); ?>>

<?php do_action( 'lg_block_media_after' ); ?>
