<?php
/**
 * Icon List
 *
 * @package StrategyBlocks
 *
 * @param array  $attributes  The block's attributes.
 * @param string $content     The block's inner content (unused here).
 * @param object $block       The block object (contains anchor, etc.).
 */

use StrategyBlocks\Utility;
use StrategyBlocks\FontAwesomeSVG;

$id          = ! empty( $attributes['anchor'] ) ? $attributes['anchor'] : '';
$class_name  = 'lg-block lg-block__icon-list';
$class_name .= Utility\get_block_style_classes( $attributes );
$class_name .= Utility\get_native_wp_classes( $attributes ); // This will handle typography.textAlign
$class_name .= Utility\get_visibility_classes( $attributes );
$animations  = Utility\get_animation_data( $attributes );

$layout      = $attributes['layout'] ?? 'vertical'; // Default to vertical
$list        = $attributes['list'] ?? [];

$icon_list_class = 'icon-list icon-list--' . $layout;
$fa = new FontAwesomeSVG( STRATEGY_BLOCKS_DIST_PATH . 'font-awesome/svgs' );
$icon_markup = '';

do_action( 'lg_block_icon_list_before' );
?>
<div <?php echo ! empty( $id ) ? 'id="' . esc_attr( $id ) . '" ' : null; ?>
	class="<?php echo esc_attr( $class_name ); ?>"
	<?php echo ! empty( $animations ) ? 'data-animation="' . esc_attr( $animations ) . '" ' : null; ?>>
	<ul class="<?php echo esc_attr( $icon_list_class ); ?>">
		<?php foreach ( $list as $item ) : ?>
			<li class="icon-list__item">
				<?php
				if ( ! empty( $item['link']['url'] ) ) :
					$external = Utility\is_link_external( $item['link']['url'] ) || (bool) $item['link']['opensInNewTab'];
					?>
				<a href="<?php echo esc_url( $item['link']['url'] ); ?>" class="icon-list__link"<?php if ( $external ) : ?> target="_blank" rel="noopener noreferrer" title="(opens in a new window)"<?php endif; ?>>
				<?php endif; ?>
				<?php
				if ( 'upload' === $item['icon']['type'] && ! empty( $item['icon']['url'] ) ) {
					$icon_markup = Utility\get_svg_by_url_and_format_svg( $item['icon']['url'], 'icon-list__icon', '1em', '1em' );
				} elseif ( 'library' === $item['icon']['type'] && ! empty( $item['icon']['library'] ) && ! empty( $item['icon']['iconSet'] ) ) {
					$svg_raw = $fa->get_svg( "{$item['icon']['iconSet']} {$item['icon']['library']}" );
					$icon_markup = preg_replace_callback(
						'/<svg\b([^>]*)>/i',
						function ( $matches ) use ( $item ) {
							$existing_attrs = $matches[1];
							$clean_attrs = preg_replace(
								'/\s*(class|role|focusable|aria-[a-z\-]+)=["\'][^"\']*["\']/i',
								'',
								$existing_attrs
							);
							$svg_attrs = ' class="icon-list__icon" aria-hidden="true" focusable="false"';
							return '<svg' . $clean_attrs . $svg_attrs . '>';
						},
						$svg_raw,
						1
					);
				}
				echo '<span class="icon-list__item-icon">';
				if ( $icon_markup ) {
					Utility\sanitize_and_output_svg( $icon_markup );
				}
				echo '</span>';
				?>
				<span class="icon-list__item-text"><?php Utility\sanitize_and_output_html_content( $item['content'] ); ?></span>
				<?php if ( ! empty( $item['link']['url'] ) ) : ?>
					</a>
				<?php endif; ?>
			</li>
		<?php endforeach; ?>
	</ul>
</div>
<?php do_action( 'lg_block_icon_list_after' ); ?>
