<?php
/**
 * Copyright Block
 *
 * @package StrategyBlocks
 */

use StrategyBlocks\Utility;

$id = ! empty( $attributes['anchor'] ) ? $attributes['anchor'] : '';
$class_name = 'lg-block lg-block__copyright';
$class_name .= Utility\get_block_style_classes( $attributes );
$class_name .= Utility\get_native_wp_classes( $attributes );
$class_name .= Utility\get_visibility_classes( $attributes );
$animations = Utility\get_animation_data( $attributes );

$show_backlink = $attributes['showBacklink'] ?? false;
$backlink = $attributes['backlink'] ?? null;

do_action( 'lg_block_copyright_before' );
?>

	<div <?php echo $id ? 'id="' . esc_attr( $id ) . '"' : ''; ?> class="<?php echo esc_attr( $class_name ); ?>" <?php echo ! empty( $animations ) ? 'data-animation="' . esc_attr( $animations ) . '"' : ''; ?>>
		<p class="copyright">
			<?php
			echo esc_html( '&copy; ' . gmdate( 'Y' ) . ' ' . get_bloginfo( 'name' ) . '. All Rights Reserved.' );
			if ( $show_backlink ) {
				echo '<br />';
				if ( ! empty( $backlink['url'] ) ) {
					echo '<a href="' . esc_url( $backlink['url'] ) . '" target="_blank" rel="noreferrer noopener">' . esc_html( $backlink['title'] ?? __( 'Visit site (Opens in a new window)', 'lead-gen' ) ) . '</a>';
				} else {
					echo 'Crafted with ❤ by <a href="https://strategynewmedia.com" target="_blank" rel="noreferrer noopener" title="A Kansas City Marketing Agency (Opens in a new window)">Strategy</a>';
				}
			}
			?>
		</p>
	</div>

<?php do_action( 'lg_block_copyright_after' ); ?>
