<?php
/**
 * PostTypes
 *
 * @package StrategyBlocks
 */

namespace StrategyBlocks;

use StrategyBlocks\Utility;

/**
 * Creates the StrategyBlocks post type and shortcodes to output them.
 */
class PostTypes extends \StrategyBlocks\Module {
	/**
	 * Only register if on an admin page and if fieldmanager plugin is active.
	 *
	 * @return bool
	 */
	public function can_register() {
		return true;
	}

	/**
	 * Register our hooks.
	 *
	 * @return void
	 */
	public function register() {
		add_action( 'init', [ $this, 'register_post_type' ] );
		add_action( 'init', [ $this, 'register_taxonomies' ] );
		add_filter( 'use_block_editor_for_post_type', [ $this, 'disable_gutenberg_by_post_type' ], 10, 2 );
	}

	/**
	 * Register our post types.
	 *
	 * @return void
	 */
	public function register_post_type() {
		// Testimonials
		$labels = array(
			'name'                  => __( 'Testimonials', 'lead-gen' ),
			'singular_name'         => __( 'Testimonial', 'lead-gen' ),
			'menu_name'             => __( 'Testimonials', 'lead-gen' ),
			'name_admin_bar'        => __( 'Testimonials', 'lead-gen' ),
			'add_new'               => __( 'Add Testimonial', 'lead-gen' ),
			'add_new_item'          => __( 'Add New Testimonial', 'lead-gen' ),
			'new_item'              => __( 'New Testimonial', 'lead-gen' ),
			'edit_item'             => __( 'Edit Testimonial', 'lead-gen' ),
			'view_item'             => __( 'View Testimonial', 'lead-gen' ),
			'all_items'             => __( 'All Testimonials', 'lead-gen' ),
			'search_items'          => __( 'Search Testimonials', 'lead-gen' ),
			'parent_item_colon'     => __( 'Parent Testimonial:', 'lead-gen' ),
			'not_found'             => __( 'No Testimonials found.', 'lead-gen' ),
			'not_found_in_trash'    => __( 'No Testimonials found.', 'lead-gen' ),
		);

		$args = [
			'labels'              => $labels,
			'public'              => false,
			'exclude_from_search' => true,
			'publicly_queryable'  => false,
			'show_ui'             => true,
			'show_in_menu'        => true,
			'show_in_nav_menus'   => false,
			'menu_icon'           => 'dashicons-id-alt',
			'query_var'           => false,
			'rewrite'             => false,
			'capability_type'     => 'post',
			'has_archive'         => false,
			'hierarchical'        => false,
			'supports'            => [ 'title', 'editor', 'thumbnail', 'excerpt' ],
			'show_in_rest'        => true,
		];

		register_post_type( 'testimonials', $args );

		// Team Members
		$labels = array(
			'name'                  => __( 'Team Members', 'lead-gen' ),
			'singular_name'         => __( 'Team Member', 'lead-gen' ),
			'menu_name'             => __( 'Team Members', 'lead-gen' ),
			'name_admin_bar'        => __( 'Team Members', 'lead-gen' ),
			'add_new'               => __( 'Add Team Member', 'lead-gen' ),
			'add_new_item'          => __( 'Add New Team Member', 'lead-gen' ),
			'new_item'              => __( 'New Team Member', 'lead-gen' ),
			'edit_item'             => __( 'Edit Team Member', 'lead-gen' ),
			'view_item'             => __( 'View Team Member', 'lead-gen' ),
			'all_items'             => __( 'All Team Members', 'lead-gen' ),
			'search_items'          => __( 'Search Team Members', 'lead-gen' ),
			'parent_item_colon'     => __( 'Parent Team Member', 'lead-gen' ),
			'not_found'             => __( 'No Team Members found.', 'lead-gen' ),
			'not_found_in_trash'    => __( 'No Team Members found.', 'lead-gen' ),
		);

		$args = array(
			'labels'                => $labels,
			'public'                => true,
			'exclude_from_search'   => false,
			'publicly_queryable'    => true,
			'show_ui'               => true,
			'show_in_menu'          => true,
			'show_in_nav_menus'     => false,
			'menu_icon'             => 'dashicons-groups',
			'query_var'             => true,
			'rewrite'               => array( 'slug' => 'team-member' ),
			'capability_type'       => 'post',
			'has_archive'           => false,
			'hierarchical'          => false,
			// 'menu_position'         => 46,
			'supports'              => array( 'title', 'editor', 'thumbnail', 'excerpt' ),
			'show_in_rest'          => true,
		);

		register_post_type( 'team-members', $args );
	}

	/**
	 * Register our taxonomies.
	 *
	 * @return void
	 */
	public function register_taxonomies() {
		register_taxonomy(
			'testimonial-categories',
			array( 'testimonials' ),
			array(
				'hierarchical'   => false,
				'label'          => 'Categories',
				'singular_label' => 'Category',
				'public'                => false,
				'publicly_queryable'    => false,
				'show_ui'               => true,
				'show_in_menu'          => true,
				'show_in_nav_menus'     => false,
				'show_tagcloud'         => false,
				'rewrite'               => false,
				'show_in_rest'          => true,
			)
		);

		register_taxonomy(
			'team-member-categories',
			array( 'team-members' ),
			array(
				'hierarchical'   => false,
				'label'          => 'Categories',
				'singular_label' => 'Category',
				'public'                => false,
				'publicly_queryable'    => false,
				'show_ui'               => true,
				'show_in_menu'          => true,
				'show_in_nav_menus'     => false,
				'show_tagcloud'         => false,
				'rewrite'               => false,
				'show_in_rest'          => true,
			)
		);

		register_taxonomy(
			'media-categories',
			array( 'attachment' ),
			array(
				'hierarchical'      => false,
				'label'             => 'Categories',
				'singular_label'    => 'Category',
				'public'                => false,
				'publicly_queryable'    => false,
				'show_ui'               => true,
				'show_in_menu'          => true,
				'show_in_nav_menus'     => false,
				'show_tagcloud'         => false,
				'rewrite'               => false,
			)
		);
	}

	/**
	 * Disables the Gutenberg editor for specific post types.
	 *
	 * Currently, this function disables Gutenberg for the "testimonials" post type.
	 * For all other post types, the existing Gutenberg filter value is returned.
	 *
	 * @param bool   $gutenberg_filter Whether Gutenberg is enabled for the post type.
	 * @param string $post_type        The name of the current post type being checked.
	 *
	 * @return bool False if the post type is "testimonials", otherwise the original filter value.
	 */
	public function disable_gutenberg_by_post_type( $gutenberg_filter, $post_type ) {
		if ( 'testimonials' === $post_type ) {
			return false;
		}
		return $gutenberg_filter;
	}
}
